/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.jfx;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.BrowserDebugPanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.IExecutePanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.IPageReady;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.jfx.JFXKeyEventDecorater;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.jfx.JFXMouseEventDecorater;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.jfx.JavaBridge;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.sun.javafx.tk.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.SwingUtilities;
import netscape.javascript.JSObject;
import org.apache.log4j.Logger;

public class KDWebViewPanel
extends BrowserDebugPanel
implements IExecutePanel {
    private static final Logger logger = LogUtil.getPackageLogger(KDWebViewPanel.class);
    private static final long serialVersionUID = 3355370816174201447L;
    private transient WebEngine engine;
    private transient WebView webView;
    private JFXPanel jfxPanel;
    private boolean debug;
    private volatile boolean loadingCompleted = false;
    private String sourceURL;
    private transient IPageReady function;
    private transient JavaBridge javaBridge = new JavaBridge();
    private boolean recordJS = false;
    private StringBuilder recordBuffer = new StringBuilder();
    public static boolean DEBUG_MODE = Boolean.parseBoolean(System.getProperty("KDWebViewPanel.debug", "false"));
    private static final String FUNCTIONTEMPLATE = "function %s(%s){return %s(%s);} ";
    private boolean enableDispatchEvent = false;
    private Map<String, Object> functionMap = new HashMap<String, Object>();

    public KDWebViewPanel(String url, IPageReady f, boolean debug, boolean enableEvent) {
        this(url, f, debug, enableEvent, false);
    }

    public KDWebViewPanel(String url, IPageReady f, boolean debug, boolean enableEvent, boolean recordJS) {
        this.sourceURL = url;
        this.debug = debug || DEBUG_MODE;
        this.function = f;
        this.enableDispatchEvent = enableEvent;
        this.recordJS = recordJS;
        this.setDebugURL(url);
        this.jfxPanel = new JFXPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jfxPanel, "Center");
        this.initWebBrowser();
    }

    public KDWebViewPanel(String url, IPageReady f, boolean debug) {
        this(url, f, debug, false);
    }

    public KDWebViewPanel(String url, IPageReady f) {
        this(url, f, false);
    }

    public KDWebViewPanel(String url, boolean debug) {
        this(url, null, debug, false);
    }

    public KDWebViewPanel(String url) {
        this(url, null, false, false);
    }

    protected void initWebBrowser() {
        if (this.debug) {
            super.initComponents();
        }
        Platform.runLater(() -> {
            this.webView = new WebView();
            StackPane root = new StackPane();
            Scene scene = new Scene((Parent)root);
            root.getChildren().add((Object)this.webView);
            this.engine = this.webView.getEngine();
            this.jfxPanel.setScene(scene);
        });
    }

    private void initDocument() {
        JSObject window = (JSObject)this.engine.executeScript("window");
        Object isReady = window.getMember("isReady");
        if (Boolean.TRUE.equals(isReady)) {
            this.loadingCompleted = true;
            if (this.debug) {
                window.setMember("console", this.javaBridge);
            }
            if (null != this.function) {
                this.function.onReady(this);
            }
        }
    }

    @Override
    protected void initComponents() {
        Platform.runLater(() -> {
            this.engine.getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
                if (Worker.State.SUCCEEDED == newValue && !this.loadingCompleted) {
                    this.initDocument();
                }
            });
            ReadOnlyObjectProperty document = this.engine.documentProperty();
            document.addListener((observable, oldValue, newValue) -> {
                if (((ObservableObjectValue)observable).get() != null && !this.loadingCompleted) {
                    this.initDocument();
                }
            });
            if (this.enableDispatchEvent) {
                this.webView.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> SwingUtilities.invokeLater(() -> this.dispatchEvent(new JFXMouseEventDecorater((Component)((Object)this), (MouseEvent)event))));
                this.webView.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> SwingUtilities.invokeLater(() -> this.dispatchEvent(new JFXMouseEventDecorater((Component)((Object)this), (MouseEvent)event))));
                this.webView.addEventHandler(KeyEvent.ANY, event -> SwingUtilities.invokeLater(() -> this.dispatchEvent(new JFXKeyEventDecorater((Component)((Object)this), (KeyEvent)event))));
            }
        });
    }

    public void load(String url) {
        Platform.runLater(() -> {
            if (this.debug) {
                super.execute("start loading url :" + url + '\n');
                this.setDebugURL(url);
            }
            this.engine.load(url);
            this.sourceURL = url;
        });
    }

    public void reload() {
        this.load(this.sourceURL);
    }

    public boolean isEnableDispatchEvent() {
        return this.enableDispatchEvent;
    }

    public void setEnableDispatchEvent(boolean enableDispatchEvent) {
        this.enableDispatchEvent = enableDispatchEvent;
    }

    public WebEngine getEngine() {
        return this.engine;
    }

    public void setFunction(IPageReady function) {
        this.function = function;
    }

    public WebView getWebView() {
        return this.webView;
    }

    public boolean isLoadingCompleted() {
        return this.loadingCompleted;
    }

    @Override
    public void execute(String script) {
        if (!TransferUtils.checkScriptSize(script)) {
            throw new IllegalArgumentException(CtrlEXTMessages.getMLS("jsScriptTooLargeCheckDataSourceConfig", "\u6267\u884cjs\u811a\u672c\u8fc7\u5927\u8bf7\u68c0\u67e5\u56fe\u8868\u53d6\u6570\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002"));
        }
        if (this.debug) {
            if (this.recordJS) {
                super.execute("JSRecorder save script: " + script + "\n");
            } else {
                super.execute("JWebbrowser execute script: " + script + "\n");
            }
        }
        if (this.recordJS) {
            this.recordBuffer.append(script);
        }
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.engineExcute(script);
        } else {
            Platform.runLater(() -> {
                try {
                    this.execute(script);
                }
                catch (Exception e) {
                    logger.error((Object)"err", (Throwable)e);
                }
            });
        }
    }

    public void engineExcute(String script) {
        this.engine.executeScript(script);
    }

    public String getRecordJS() {
        return this.recordBuffer.toString();
    }

    public void resetRecorder() {
        this.recordJS = false;
        this.recordBuffer = new StringBuilder();
    }

    public void setRecordJS(boolean recordJS) {
        this.recordJS = recordJS;
    }

    public boolean isRecordJS() {
        return this.recordJS;
    }

    @Override
    public Object executeResult(String script) {
        if (!TransferUtils.checkScriptSize(script)) {
            throw new IllegalArgumentException(CtrlEXTMessages.getMLS("jsScriptTooLargeCheckDataSourceConfig", "\u6267\u884cjs\u811a\u672c\u8fc7\u5927\u8bf7\u68c0\u67e5\u56fe\u8868\u53d6\u6570\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002"));
        }
        if (this.debug) {
            super.executeResult(script);
        }
        return this.engine.executeScript(script);
    }

    public void removeFunction(String member) {
        this.functionMap.remove(member);
    }

    public void registerFunction(String member, String functionName, Object function, boolean linektoWindow) {
        this.functionMap.put(member, function);
        JSObject window = (JSObject)this.executeResult("window");
        if (this.debug) {
            super.execute("function Name :" + functionName + " attach to window." + member);
        }
        window.setMember(member, function);
        if (linektoWindow) {
            Method[] methods;
            for (Method m : methods = function.getClass().getDeclaredMethods()) {
                if (!m.getName().equals(functionName)) continue;
                StringBuilder parameters = new StringBuilder();
                for (int i = 0; i < m.getParameterCount(); ++i) {
                    parameters.append('p').append(i);
                    if (i >= m.getParameterCount() - 1) continue;
                    parameters.append(',');
                }
                String parString = parameters.toString();
                String functionJS = String.format(FUNCTIONTEMPLATE, functionName, parString, member + "." + functionName, parString);
                this.execute(functionJS);
            }
        }
    }

    static {
        new JFXPanel();
        Platform.setImplicitExit((boolean)false);
    }
}

