/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.calc;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.chart.ChartResultData;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.CategoryScatter;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.ICategory;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.Series;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.calc.AbstractChartKindOfCalc;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class ChartKindOfScatterCalc
extends AbstractChartKindOfCalc {
    private static ChartKindOfScatterCalc calc;

    private ChartKindOfScatterCalc() {
    }

    public static ChartKindOfScatterCalc getInstance() {
        if (calc == null) {
            calc = new ChartKindOfScatterCalc();
        }
        return calc;
    }

    @Override
    public ChartResultData calc(ExtDataSet extDS, DataFromDataset fromDataset) throws SyntaxErrorException {
        ChartResultData result = new ChartResultData();
        List<Series> seriesList = fromDataset.getSeries();
        if (seriesList == null || seriesList.isEmpty()) {
            return result;
        }
        String fieldCategory = fromDataset.getCategory();
        int colIndexGroup = Integer.MIN_VALUE;
        if (!StringUtil.isEmptyString((String)fieldCategory)) {
            colIndexGroup = extDS.getColumnIndexByName(fieldCategory).intValue();
        }
        Series series = seriesList.get(0);
        String seriesType = series.getSeriesNameType();
        List<ICategory> categories = series.getCategories();
        if (categories == null || categories.isEmpty()) {
            return result;
        }
        if ("fieldValue".equals(seriesType)) {
            result = this.calcForFieldValue(categories, extDS, colIndexGroup);
        } else if ("fieldName".equals(seriesType)) {
            result = this.calcForFieldName(categories, extDS, colIndexGroup);
        }
        return result;
    }

    protected ChartResultData calcForFieldValue(List<ICategory> categories, ExtDataSet extDS, int colIndexGroup) throws SyntaxErrorException {
        int lenExtRow = extDS.getDataRows();
        boolean isBubble = false;
        int lenDimen = 3;
        TreeMap mapDimension = new TreeMap();
        CategoryScatter category = (CategoryScatter)categories.get(0);
        String fieldSeriesName = category.getSeriesName();
        int colIndexName = extDS.getColumnIndexByName(fieldSeriesName).intValue();
        String seriesSize = category.getSeriesSize();
        int colIndexSize = 0;
        if (seriesSize != null) {
            isBubble = true;
            colIndexSize = extDS.getColumnIndexByName(seriesSize).intValue();
        }
        String seriesX = category.getSeriesX();
        int colIndexX = extDS.getColumnIndexByName(seriesX).intValue();
        String seriesY = category.getSeriesY();
        int colIndexY = extDS.getColumnIndexByName(seriesY).intValue();
        for (int r = 0; r < lenExtRow; ++r) {
            List<double[]> listDimension;
            Variant vSeriesName;
            String seriesName;
            double[] dimension = new double[lenDimen];
            Variant vX = extDS.field(r, colIndexX);
            Variant vY = extDS.field(r, colIndexY);
            dimension[0] = vX.doubleValue();
            dimension[1] = vY.doubleValue();
            if (isBubble) {
                Variant vSize = extDS.field(r, colIndexSize);
                dimension[2] = vSize.doubleValue();
            }
            if (mapDimension.get(seriesName = String.valueOf((vSeriesName = extDS.field(r, colIndexName)).getValue())) != null) {
                listDimension = (List)mapDimension.get(seriesName);
                listDimension.add(dimension);
                continue;
            }
            listDimension = new ArrayList();
            listDimension.add(dimension);
            mapDimension.put(seriesName, listDimension);
        }
        Set setKey = mapDimension.keySet();
        int lenSeries = setKey.size();
        String[] seriesKeys = new String[lenSeries];
        mapDimension.keySet().toArray(seriesKeys);
        Object[] data = new Object[lenSeries];
        for (int d = 0; d < lenSeries; ++d) {
            List dList = (List)mapDimension.get(seriesKeys[d]);
            double[][] datas = new double[dList.size()][lenDimen];
            dList.toArray((T[])datas);
            data[d] = datas;
        }
        ChartResultData result = new ChartResultData();
        result.setData(data);
        result.setSeries(seriesKeys);
        return result;
    }

    protected ChartResultData calcForFieldName(List<ICategory> categories, ExtDataSet extDS, int colIndexGroup) throws SyntaxErrorException {
        int lenExtRow = extDS.getDataRows();
        boolean isBubble = false;
        int lenDimen = 3;
        int lenSeries = categories.size();
        Object[] data = new Object[lenSeries];
        String[] seriesKeys = new String[lenSeries];
        for (int i = 0; i < lenSeries; ++i) {
            CategoryScatter category = (CategoryScatter)categories.get(i);
            seriesKeys[i] = category.getSeriesName();
            String seriesSize = category.getSeriesSize();
            int colIndexSize = 0;
            if (seriesSize != null) {
                isBubble = true;
                colIndexSize = extDS.getColumnIndexByName(seriesSize).intValue();
            }
            String seriesX = category.getSeriesX();
            int colIndexX = extDS.getColumnIndexByName(seriesX).intValue();
            String seriesY = category.getSeriesY();
            int colIndexY = extDS.getColumnIndexByName(seriesY).intValue();
            double[][] datas = new double[lenExtRow][lenDimen];
            for (int r = 0; r < lenExtRow; ++r) {
                double[] dimension = new double[lenDimen];
                Variant vX = extDS.field(r, colIndexX);
                Variant vY = extDS.field(r, colIndexY);
                dimension[0] = vX.doubleValue();
                dimension[1] = vY.doubleValue();
                if (isBubble) {
                    Variant vSize = extDS.field(r, colIndexSize);
                    dimension[2] = vSize.doubleValue();
                }
                datas[r] = dimension;
            }
            data[i] = datas;
        }
        ChartResultData result = new ChartResultData();
        result.setData(data);
        result.setSeries(seriesKeys);
        return result;
    }
}

