/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.calc;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.chart.ChartResultData;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.Category;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.ICategory;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.Series;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.SummaryType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.calc.AbstractChartKindOfCalc;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ChartSingleSeriesCalc
extends AbstractChartKindOfCalc {
    private static ChartSingleSeriesCalc calc;

    private ChartSingleSeriesCalc() {
    }

    public static ChartSingleSeriesCalc getInstance() {
        if (calc == null) {
            calc = new ChartSingleSeriesCalc();
        }
        return calc;
    }

    @Override
    public ChartResultData calc(ExtDataSet extDS, DataFromDataset fromDataset) throws SyntaxErrorException {
        ChartResultData result = new ChartResultData();
        List<Series> seriesList = fromDataset.getSeries();
        if (seriesList == null || seriesList.isEmpty()) {
            return result;
        }
        String[] groupKeys = null;
        double[][] datas = null;
        Series series = seriesList.get(0);
        String seriesType = series.getSeriesNameType();
        List<ICategory> categories = series.getCategories();
        if (seriesList == null || seriesList.isEmpty()) {
            return result;
        }
        if ("fieldValue".equals(seriesType)) {
            Category category = (Category)categories.get(0);
            String summaryType = category.getSummaryType();
            String seriesName = category.getSeriesName();
            String seriesValue = category.getSeriesValue();
            int colIndexGroup = extDS.getColumnIndexByName(seriesName).intValue();
            SummaryType sType = SummaryType.getTypeByName(summaryType);
            int colIndexValue = extDS.getColumnIndexByName(seriesValue).intValue();
            LinkedHashMap<String, Variant> mapGroup = new LinkedHashMap<String, Variant>();
            HashMap<String, Variant> countGroup = new HashMap<String, Variant>();
            this.calcBySummaryType(mapGroup, countGroup, colIndexGroup, colIndexValue, extDS, sType, null);
            int size = mapGroup.size();
            groupKeys = new String[size];
            datas = this.getData(mapGroup, countGroup, sType, groupKeys);
        } else if ("fieldName".equals(seriesType)) {
            int size = categories.size();
            groupKeys = new String[size];
            datas = new double[1][size];
            for (int j = 0; j < size; ++j) {
                Category category = (Category)categories.get(j);
                String summaryType = category.getSummaryType();
                String seriesName = category.getSeriesName();
                String seriesValue = category.getSeriesValue();
                groupKeys[j] = !StringUtil.isEmptyString((String)seriesValue) ? seriesValue : seriesName;
                int colIndexValue = extDS.getColumnIndexByName(seriesName).intValue();
                SummaryType sType = SummaryType.getTypeByName(summaryType);
                LinkedHashMap<String, Variant> mapGroup = new LinkedHashMap<String, Variant>();
                HashMap<String, Variant> countGroup = new HashMap<String, Variant>();
                String sGroup = seriesName;
                this.calcBySummaryType(mapGroup, countGroup, -1, colIndexValue, extDS, sType, sGroup);
                for (Map.Entry<String, Variant> entry : mapGroup.entrySet()) {
                    if (SummaryType.AVG == sType) {
                        datas[0][j] = entry.getValue().divide(countGroup.get(entry.getKey())).doubleValue();
                        continue;
                    }
                    datas[0][j] = entry.getValue().doubleValue();
                }
            }
        }
        result.setData(datas);
        result.setGroups(groupKeys);
        return result;
    }

    protected void calcBySummaryType(LinkedHashMap<String, Variant> mapGroup, HashMap<String, Variant> countGroup, int colIndexGroup, int colIndexName, ExtDataSet extDS, SummaryType sType, String strGroup) throws SyntaxErrorException {
        String sGroup = null;
        if (strGroup != null) {
            sGroup = strGroup;
        }
        int lenExtRow = extDS.getDataRows();
        block12: for (int r = 0; r < lenExtRow; ++r) {
            if (strGroup == null) {
                Variant vGroup = extDS.field(r, colIndexGroup);
                sGroup = vGroup.toString();
            }
            Variant vSeriesValue = extDS.field(r, colIndexName);
            if (!mapGroup.containsKey(sGroup)) {
                switch (sType) {
                    case AVG: {
                        countGroup.put(sGroup, new Variant(Variant.oneBigDecimal, 10));
                    }
                    case SUM: 
                    case MAX: 
                    case MIN: {
                        mapGroup.put(sGroup, vSeriesValue.getCopy());
                        break;
                    }
                    case COUNT: {
                        mapGroup.put(sGroup, new Variant(Variant.oneBigDecimal, 10));
                    }
                }
                continue;
            }
            switch (sType) {
                case SUM: {
                    mapGroup.get(sGroup).add(vSeriesValue);
                    continue block12;
                }
                case COUNT: {
                    mapGroup.get(sGroup).add(Variant.oneVariant);
                    continue block12;
                }
                case MAX: {
                    if (!mapGroup.get(sGroup).lessThan(vSeriesValue)) continue block12;
                    mapGroup.put(sGroup, vSeriesValue);
                    continue block12;
                }
                case MIN: {
                    if (!vSeriesValue.lessThan(mapGroup.get(sGroup))) continue block12;
                    mapGroup.put(sGroup, vSeriesValue);
                    continue block12;
                }
                case AVG: {
                    mapGroup.get(sGroup).add(vSeriesValue);
                    countGroup.get(sGroup).add(Variant.oneVariant);
                }
            }
        }
    }

    protected double[][] getData(LinkedHashMap<String, Variant> mapGroup, HashMap<String, Variant> countGroup, SummaryType sType, String[] groupKeys) throws SyntaxErrorException {
        int size = mapGroup.size();
        double[][] datas = new double[1][size];
        int count = 0;
        for (Map.Entry<String, Variant> entry : mapGroup.entrySet()) {
            groupKeys[count] = entry.getKey();
            datas[0][count] = SummaryType.AVG == sType ? entry.getValue().divide(countGroup.get(entry.getKey())).doubleValue() : entry.getValue().doubleValue();
            ++count;
        }
        return datas;
    }
}

