/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts;

import com.alibaba.fastjson.JSON;
import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.json.VarSerializer;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.FileUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StreamUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.AbstractChartPanel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.ResovlerHelper;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.Base64;
import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.io.kds.BookToKds;
import com.kingdee.cosmic.ctrl.kds.io.kds.KDSBinaryBook;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.INativeEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.BrowserType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.IExecutePanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.IPageReady;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.util.ChartUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.EChartDisplayPanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.JSEditorDialog;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsRenderType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.function.IChartReadyFunction;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.function.IEChartsClickEventHandler;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.handler.EChartHyperLinkHandler;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.node.CustomJSNodeList;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.node.JSNodeFunction;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferMapper;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.ChartImageUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataInputStream;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataOutputStream;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import com.kingdee.cosmic.ctrl.swing.KDMenuItem;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDPopupMenu;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javax.imageio.ImageIO;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import netscape.javascript.JSObject;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class EChart
extends ChartRectEmbedment
implements INativeEmbedment {
    private static final Logger logger = LogUtil.getPackageLogger(EChart.class);
    private KDPanel container;
    private EChartDisplayPanel displayPanel;
    private boolean save4Snap = false;
    private CustomJSNodeList jsNodeList = new CustomJSNodeList();
    public static boolean DEBUGMODE = Boolean.parseBoolean(System.getProperty("EChartDebugMode", "false"));
    public static boolean DEMOPICMODE = Boolean.parseBoolean(System.getProperty("ext.chart.demopic.mode", "false"));
    private EChart main_echart;
    private String lastExecutedScript;
    private boolean isTransitionChart;
    private EChartFunctionInitializer readyFunctionInitor = new EChartFunctionInitializer();
    public static Rectangle transitionBounds = new Rectangle();
    private Object[] splitArray;
    private EChart src;
    private static final long WAITCHARTINITED_TIME = 4000L;

    public EChart(Sheet sheet) {
        this(sheet, null, null);
    }

    public EChart(Sheet sheet, FlashChartModel model) {
        this(sheet, model, null);
    }

    public EChart(Sheet sheet, FlashChartModel m, IChartReadyFunction f) {
        super(sheet);
        this.model = m;
        this.readyFunctionInitor.addReadyFunction(f);
        this.main_echart = this;
    }

    public void initFunctions(IExecutePanel browser) {
        if (!MiscUtil.isExecutedBook(this._sheet.getBook())) {
            this.displayPanel.getNativeComponent().addMouseListener(new EChartRightMouseClickListener());
        } else {
            this.displayPanel.registerClickHandler(new EChartHyperLinkHandler(ResovlerHelper.getCurrentChartSpreadContext(this)));
        }
    }

    @Override
    public Component getPhysicalUI() {
        if (this.container == null) {
            this.container = new KDPanel((LayoutManager)new BorderLayout());
            if (!SwingUtilities.isEventDispatchThread()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (null == EChart.this.displayPanel) {
                            EChart.this.addDisplayPanel();
                        }
                    }
                };
                SwingUtilities.invokeLater(t);
            } else if (null == this.displayPanel) {
                this.addDisplayPanel();
            }
        }
        return this.container;
    }

    public void resize(int width, int height) {
        this.displayPanel.chartResize(width, height);
    }

    public void addDisplayPanel() {
        EChartDisplayPanel.EChartDisPlayPanelBuidler builder = EChartDisplayPanel.getBuidler();
        this.displayPanel = builder.browserType(BrowserType.WEBVIEW).charReadyFunction(this.readyFunctionInitor).renderType(EChartsRenderType.SVG).panelDebug(DEBUGMODE).pageMode(false).build();
        this.container.add((Component)this.displayPanel.getDisplayPanel(), (Object)"Center");
    }

    @Override
    public void setUIPhysical(boolean physical) {
    }

    public boolean executeAndWait(long time, TimeUnit unit) {
        CountDownLatch latch = new CountDownLatch(1);
        this.executeRefresh();
        Platform.runLater(() -> this.exportToBufferedImage());
        Platform.runLater(() -> latch.countDown());
        try {
            return latch.await(time, unit);
        }
        catch (InterruptedException e) {
            logger.error((Object)"err", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public void paintData(Graphics g) {
        if (this.displayPanel == null) {
            return;
        }
        Color old = g.getColor();
        g.setColor(Color.LIGHT_GRAY);
        g.setColor(old);
        Rectangle bounds = this.getBounds();
        AbstractFusionBean bean = this.model.getBean();
        FusionChartDataNode dataNode = this.model.getDataNode();
        bean.setContainerWidth(bounds.width, dataNode);
        bean.setContainerHeight(bounds.height, dataNode);
        if (!this.displayPanel.isChartInited()) {
            return;
        }
        this.model.getDataNode().enableSnap(this.save4Snap);
        List<String> script = TransferMapper.transfer2ExecuteScript(this.model, !MiscUtil.isExecutedBook(this._sheet.getBook()));
        String lastScript = this.getStr(script);
        if (!script.isEmpty() && !lastScript.equals(this.lastExecutedScript)) {
            this.lastExecutedScript = lastScript;
            this.execute(script);
        }
    }

    @Override
    public void paintFocus(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle bounds = this.getBounds();
        int x = (int)((RectangularShape)bounds).getX();
        int y = (int)((RectangularShape)bounds).getY();
        int w = (int)((RectangularShape)bounds).getWidth();
        int h = (int)((RectangularShape)bounds).getHeight();
        int outArc = 12;
        int innerArc = 18;
        int distance = 6;
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double();
        ((RoundRectangle2D)rr).setRoundRect(x - distance, y - distance, w + 2 * distance, h + 2 * distance, w > outArc * 2 ? (double)outArc : (double)(w / 2), h > outArc * 2 ? (double)outArc : (double)(h / 2));
        RoundRectangle2D.Double innerRR = new RoundRectangle2D.Double();
        ((RoundRectangle2D)innerRR).setRoundRect(x, y, w, h, w > innerArc * 2 ? (double)innerArc : (double)(w / 2), h > innerArc * 2 ? (double)innerArc : (double)(h / 2));
        Graphics2D g2dd = (Graphics2D)g2d.create();
        this.focusArea = new Area(rr);
        this.focusArea.subtract(new Area(innerRR));
        g2dd.setColor(Color.gray);
        g2dd.draw(rr);
        Composite cps = g2d.getComposite();
        g2dd.setComposite(AlphaComposite.getInstance(3, 0.2f));
        g2dd.setColor(Color.cyan);
        g2dd.fill(this.focusArea);
        g2dd.setComposite(cps);
        this.paintTransformButton(g2dd, rr);
        this.paintHotSpot(g2dd, distance, x, y, w, h);
    }

    private void paintHotSpot(Graphics2D g2dd, int distance, int x, int y, int w, int h) {
        g2dd.setColor(Color.black);
        int ptDistance = distance / 2;
        int ptx = x - ptDistance;
        int pty = y - ptDistance;
        int ptx2 = x + w - 1 + ptDistance;
        int pty2 = y + h - 1 + ptDistance;
        g2dd.drawOval(ptx, pty, 1, 1);
        g2dd.drawOval(ptx + ++ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx, pty + ptDistance, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 - ptDistance, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + ptDistance, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + 2 * ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx2, pty, 1, 1);
        g2dd.drawOval(ptx2 - ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx2, pty + ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 + ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 + 2 * ptDistance, 1, 1);
        g2dd.drawOval(ptx2, pty2, 1, 1);
        g2dd.drawOval(ptx2 - ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx2, pty2 - ptDistance, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 - ptDistance, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + ptDistance, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + 2 * ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx, pty2, 1, 1);
        g2dd.drawOval(ptx + ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx, pty2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 + ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 + 2 * ptDistance, 1, 1);
    }

    public void execute(Option p, boolean refresh) {
        if (null == p) {
            return;
        }
        this.displayPanel.execute(p, refresh);
    }

    private void execute(List<String> script) {
        for (String s : script) {
            this.execute(s);
        }
    }

    @Override
    public void execute(String script) {
        this.imageData = null;
        this.displayPanel.execute(script);
    }

    private void paintTransformButton(Graphics2D g2dd, RoundRectangle2D rr) {
        EmbedhLayer layer = this.model.getDataNode().getSheet().getEmbedments(false);
        if (layer != null && layer.selectionSize() > 1) {
            return;
        }
        if (!MiscUtil.isExecutedBook(this.model.getDataNode().getSheet().getBook()) || StringUtil.isEmptyString((String)this.model.getBean().getTransformable_chart())) {
            return;
        }
        int x = (int)rr.getX();
        int y = (int)rr.getY();
        this.transfRect = new Rectangle(x, y - 20, 80, 20);
        g2dd.setComposite(AlphaComposite.getInstance(3, 0.6f));
        g2dd.fillRect(this.transfRect.x, this.transfRect.y, this.transfRect.width, this.transfRect.height);
        g2dd.setColor(Color.black);
        g2dd.setFont(new Font(null, 0, 12));
        g2dd.drawString(CtrlEXTMessages.getMLS("switchChart", "\u5207\u6362\u56fe\u8868"), x + 10, y - 6);
        int centerX = x + 70;
        int startY = y - 13;
        Polygon triangle = new Polygon();
        triangle.addPoint(centerX - 5, startY);
        triangle.addPoint(centerX + 5, startY);
        triangle.addPoint(centerX, startY + 5);
        g2dd.fill(triangle);
    }

    @Override
    protected void loadCustom(byte[] str, boolean create) {
        try {
            byte id;
            KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
            this.model = new FlashChartModel();
            FusionChartDataNode data = new FusionChartDataNode(this._sheet);
            this.model.setDataNode(data);
            String version = is.readString();
            FusionChartDataNode dn = this.model.getDataNode();
            block46: while ((id = is.readByte()) != 0) {
                switch (id) {
                    case 1: {
                        FlashChartType type = FlashChartType.getChartType(is.readString());
                        this.model.setChartType(type);
                        this.model.setBean(AbstractFusionBean.createBean(type));
                        this.model.getBean().setChartType(type);
                        this.model.getBean().setContainerWidth(this.getBounds().width, this.model.getDataNode());
                        this.model.getBean().setContainerHeight(this.getBounds().height, this.model.getDataNode());
                        dn.setChartType(this.model.getChartType());
                        continue block46;
                    }
                    case 2: {
                        dn.setDataFormula(is.readString());
                        continue block46;
                    }
                    case 30: {
                        byte tag;
                        if ("1.1".equals(version)) {
                            dn.setData(JsonUtil.decodeFromString(is.readString(), double[][].class));
                            continue block46;
                        }
                        if (this.laterThan("1.3", version)) {
                            byte dataType = is.readByte();
                            if (dataType == 1) {
                                ArrayList<Object> list = new ArrayList<Object>(8);
                                while ((tag = is.readByte()) != 30) {
                                    if (tag == 2) {
                                        list.add(JsonUtil.decodeFromString(is.readString(), double[][].class));
                                        continue;
                                    }
                                    if (tag == 5) {
                                        list.add(JsonUtil.decodeFromString(is.readString(), double[].class));
                                        continue;
                                    }
                                    if (tag != 6) continue;
                                    list.add(JsonUtil.decodeFromString(is.readString(), Double.class));
                                }
                                dn.setData(list.toArray());
                                continue block46;
                            }
                            if (dataType != 2) continue block46;
                            dn.setData(JsonUtil.decodeFromString(is.readString(), double[][].class));
                            continue block46;
                        }
                        if (!this.laterThan("1.1", version)) continue block46;
                        byte dataType = is.readByte();
                        if (dataType == 1) {
                            dn.setData(JsonUtil.decodeFromString(is.readString(), Object[].class));
                            continue block46;
                        }
                        if (dataType != 2) continue block46;
                        dn.setData(JsonUtil.decodeFromString(is.readString(), double[][].class));
                        continue block46;
                    }
                    case 3: {
                        dn.setGroupFormula(is.readString());
                        continue block46;
                    }
                    case 31: {
                        dn.setGroupKeys(JsonUtil.decodeFromString(is.readString(), String[].class));
                        continue block46;
                    }
                    case 16: {
                        FusionChartDataNode data2 = this.model.getDataNode();
                        data2.setSeriesKeysFormula(is.readString());
                        continue block46;
                    }
                    case 33: {
                        byte tag;
                        if (this.laterThan("1.3", version)) {
                            byte dataType = is.readByte();
                            if (dataType == 1) {
                                ArrayList<Object> list = new ArrayList<Object>(8);
                                while ((tag = is.readByte()) != 33) {
                                    if (tag == 3) {
                                        list.add(JsonUtil.decodeFromString(is.readString(), String[].class));
                                        continue;
                                    }
                                    if (tag != 4) continue;
                                    list.add(JsonUtil.decodeFromString(is.readString(), String.class));
                                }
                                dn.setSerieskeys(list.toArray());
                                continue block46;
                            }
                            if (dataType == 3) {
                                dn.setSerieskeys(JsonUtil.decodeFromString(is.readString(), String[].class));
                                continue block46;
                            }
                            if (dataType != 7) continue block46;
                            dn.setSerieskeys(JsonUtil.decodeFromString(is.readString(), String[][].class));
                            continue block46;
                        }
                        if (this.laterThan("1.2", version)) {
                            byte dataType = is.readByte();
                            if (dataType == 1) {
                                dn.setSerieskeys(JsonUtil.decodeFromString(is.readString(), Object[].class));
                                continue block46;
                            }
                            if (dataType != 3) continue block46;
                            dn.setSerieskeys(JsonUtil.decodeFromString(is.readString(), String[].class));
                            continue block46;
                        }
                        dn.setSerieskeys(JsonUtil.decodeFromString(is.readString(), String[].class));
                        continue block46;
                    }
                    case 37: {
                        dn.setChartShowTypes(JsonUtil.decodeFromString(is.readString(), String[].class));
                        continue block46;
                    }
                    case 38: {
                        dn.setYAxisPosition(JsonUtil.decodeFromString(is.readString(), String[].class));
                        continue block46;
                    }
                    case 9: {
                        dn.setSerialByCol(is.readBoolean());
                        continue block46;
                    }
                    case 11: {
                        dn.setDateFormat(is.readBoolean());
                        continue block46;
                    }
                    case 10: {
                        byte next = is.readByte();
                        dn.setExprTag(is.readLong());
                        next = is.readByte();
                        int i = 0;
                        while (next != 10) {
                            switch (next) {
                                case 12: {
                                    dn.setFormula(is.readString(), i++);
                                    break;
                                }
                                case 13: {
                                    String[] datas = this.readArray(is, is.readInt());
                                    AbstractChartPanel.repairUnSafeChar(datas);
                                    dn.setFormula(datas, i++);
                                    break;
                                }
                                case 14: {
                                    dn.setFormula((String)null, i++);
                                    break;
                                }
                            }
                            next = is.readByte();
                        }
                        continue block46;
                    }
                    case 39: {
                        byte rNext = is.readByte();
                        int j = 0;
                        while (rNext != 39) {
                            if (rNext == 1) {
                                rNext = is.readByte();
                                switch (rNext) {
                                    case 8: {
                                        ArrayList<Variant[][]> list = new ArrayList<Variant[][]>(8);
                                        do {
                                            list.add(JsonUtil.decodeFromString(is.readString(), Variant[][].class));
                                        } while (is.readByte() != 1);
                                        dn.setResult(list.toArray(), j++);
                                        break;
                                    }
                                    case 14: {
                                        dn.setResult(null, j++);
                                        break;
                                    }
                                }
                            }
                            rNext = is.readByte();
                        }
                        continue block46;
                    }
                    case 40: {
                        dn.setDirty(is.readBoolean());
                        continue block46;
                    }
                    case 18: {
                        this.save4Snap = is.readBoolean();
                        continue block46;
                    }
                    case 19: {
                        dn.setColorXML(is.readString());
                        this.model.getBean().getChartColorTemplate().setXmlValue(dn.getColorXML());
                        continue block46;
                    }
                    case 20: {
                        dn.setNumberFormatXML(is.readString());
                        this.model.getBean().getChartNumberFormat().setXmlValue(dn.getNumberFormatXML());
                        continue block46;
                    }
                    case 21: {
                        dn.setXyRestrictionXML(is.readString());
                        continue block46;
                    }
                    case 22: {
                        this.model.getBean().setLastSelectedIndex(is.readInt());
                        continue block46;
                    }
                    case 23: {
                        this.model.getBean().setTransformable_chart(is.readString());
                        continue block46;
                    }
                    case 24: {
                        String dataFrom = is.readString();
                        this.model.setDataFrom(dataFrom);
                        dn.setDataFrom(dataFrom);
                        if (!"dataset".equals(dataFrom)) continue block46;
                        try {
                            IXmlElement element = XmlUtil.loadXmlBytes((byte[])is.readLengthBytes());
                            dn.setFromDataset(ChartUtil.parseXml(element, this.model.getChartType()));
                        }
                        catch (XmlParsingException e) {
                            if (!MiscUtil.shouldLog()) continue block46;
                            MiscUtil.log(e);
                        }
                        continue block46;
                    }
                    case 25: {
                        ETTargets targets = KDSBinaryBook.readTransitionTarget(is, this._sheet, dn, -1);
                        this.model.setExtTargets(targets);
                        continue block46;
                    }
                    case 26: {
                        InnerLinkTargets innerTargets = KDSBinaryBook.readInnerTransitionTarget(is, this._sheet, dn);
                        this.model.setInnerTargets(innerTargets);
                        continue block46;
                    }
                    case 27: {
                        this.jsNodeList = (CustomJSNodeList)JSON.parseObject((String)is.readString(), CustomJSNodeList.class);
                        continue block46;
                    }
                    case 28: {
                        this.model.setChartID(is.readString());
                        continue block46;
                    }
                    case 29: {
                        is.readString();
                        continue block46;
                    }
                    case 5: {
                        is.readString();
                        continue block46;
                    }
                    case 6: {
                        is.readString();
                        continue block46;
                    }
                    case 7: {
                        is.readString();
                        continue block46;
                    }
                    case 8: {
                        is.readInt();
                    }
                    case 17: {
                        is.readString();
                        continue block46;
                    }
                }
            }
            is.close();
            this.model.getBean().setChartName(this.getName());
            this.model.setFrameWorkType(ChartFrameWorkType.ECHART);
        }
        catch (IOException ioe) {
            logger.error((Object)"err", (Throwable)ioe);
        }
    }

    @Override
    protected byte[] saveCustom() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream(bs);
        try {
            String[] yAxisPosition;
            String[] chartShowTypes;
            FusionChartDataNode dn;
            out.writeString("1.4");
            String str = this.model.getChartType().getName();
            if (!StringUtil.isEmptyString((String)str)) {
                out.writeByte(1);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = (dn = this.model.getDataNode()).getDataFormula()))) {
                out.writeByte(2);
                out.writeString(str);
            }
            GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Var.class, (Object)new VarSerializer()).serializeSpecialFloatingPointValues().setPrettyPrinting().disableHtmlEscaping();
            if (dn.getDataWithoutCalc() != null) {
                Object dataWithoutCalc = dn.getDataWithoutCalc();
                out.writeByte(30);
                if (dataWithoutCalc instanceof double[][]) {
                    out.writeByte(2);
                    out.writeString(JsonUtil.encodeToString(gsonBuilder, dataWithoutCalc));
                } else if (dataWithoutCalc instanceof Object[]) {
                    out.writeByte(1);
                    for (Object obj : (Object[])dataWithoutCalc) {
                        if (obj instanceof double[][]) {
                            out.writeByte(2);
                        } else if (obj instanceof double[]) {
                            out.writeByte(5);
                        } else if (obj instanceof Double) {
                            out.writeByte(6);
                        }
                        out.writeString(JsonUtil.encodeToString(gsonBuilder, obj));
                    }
                    out.writeByte(30);
                }
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getGroupFormula()))) {
                out.writeByte(3);
                out.writeString(str);
            }
            if (dn.getGroupKeysWithoutCalc() != null && dn.getGroupKeysWithoutCalc().length > 0) {
                out.writeByte(31);
                out.writeString(JsonUtil.encodeToString(dn.getGroupKeysWithoutCalc()));
            }
            if (!StringUtil.isEmptyString((String)(str = this.model.getDataNode().getSeriesKeysFormula()))) {
                out.writeByte(16);
                out.writeString(str);
            }
            if (dn.getSeriesKeysWithoutCalc() != null) {
                out.writeByte(33);
                Object seriesKeys = dn.getSeriesKeysWithoutCalc();
                if (seriesKeys instanceof String[]) {
                    out.writeByte(3);
                    out.writeString(JsonUtil.encodeToString(dn.getSeriesKeysWithoutCalc()));
                } else if (seriesKeys instanceof String[][]) {
                    out.writeByte(7);
                    out.writeString(JsonUtil.encodeToString(dn.getSeriesKeysWithoutCalc()));
                } else if (seriesKeys instanceof Object[]) {
                    out.writeByte(1);
                    for (Object obj : (Object[])seriesKeys) {
                        if (obj instanceof String[]) {
                            out.writeByte(3);
                        } else if (obj instanceof String) {
                            out.writeByte(4);
                        }
                        out.writeString(JsonUtil.encodeToString(obj));
                    }
                    out.writeByte(33);
                }
            }
            if (dn.getChartShowTypesWithoutCalc() != null && (chartShowTypes = dn.getChartShowTypesWithoutCalc()).length > 0) {
                out.writeByte(37);
                out.writeString(JsonUtil.encodeToString(chartShowTypes));
            }
            if (dn.getYAxisPositionWithoutCalc() != null && (yAxisPosition = dn.getYAxisPositionWithoutCalc()).length > 0) {
                out.writeByte(38);
                out.writeString(JsonUtil.encodeToString(yAxisPosition));
            }
            if (!StringUtil.isEmptyString((String)(str = this.model.getBean().getTransformable_chart()))) {
                out.writeByte(23);
                out.writeString(str);
            }
            if (null != this.jsNodeList && !this.jsNodeList.getJsList().isEmpty()) {
                out.writeByte(27);
                out.writeString(JSON.toJSONString((Object)this.jsNodeList));
            }
            out.writeByte(11);
            out.writeBoolean(dn.getDateFormat());
            out.writeByte(19);
            out.writeString(dn.getColorXML());
            out.writeByte(20);
            out.writeString(dn.getNumberFormatXML());
            out.writeByte(21);
            out.writeString(dn.getXyRestrictionXML());
            out.writeByte(22);
            out.writeInt(this.model.getBean().getLastSelectedIndex());
            out.writeByte(10);
            out.writeByte(15);
            out.writeLong(dn.getExprTag());
            int size = dn.getFormulaSize();
            for (int i = 0; i < size; ++i) {
                Object formulas = dn.getFormula(i);
                if (formulas instanceof String) {
                    out.writeByte(12);
                    out.writeString((String)formulas);
                    continue;
                }
                if (formulas instanceof String[]) {
                    out.writeByte(13);
                    this.writeArray(out, (String[])formulas);
                    continue;
                }
                if (formulas != null) continue;
                out.writeByte(14);
            }
            out.writeByte(10);
            out.writeByte(18);
            out.writeBoolean(this.save4Snap);
            out.writeByte(9);
            out.writeBoolean(dn.isSerialByCol());
            DataFromDataset fromDataset = dn.getFromDataset();
            if (fromDataset != null) {
                out.writeByte(24);
                out.writeString(this.model.getDataFrom());
                if ("dataset".equals(this.model.getDataFrom())) {
                    IXmlElement element = ChartUtil.toXml(fromDataset, this.model.getChartType());
                    byte[] xmlByte = XmlUtil.saveXmlBytes((IXmlElement)element);
                    out.writeLengthBytes(xmlByte);
                }
            }
            ExprContext ctx = this._sheet.getDeps().getExprContext();
            ETTargets targets = this.model.getExtTargets();
            BookToKds.writeTransitionTarget((byte)25, targets, out, ctx, dn);
            InnerLinkTargets innerTargets = this.model.getInnerTargets();
            BookToKds.writeInnerTransitionTarget((byte)26, innerTargets, out, ctx, dn);
            if (this.displayPanel != null && !StringUtil.isEmptyString((String)(str = this.displayPanel.getChartID())) || !StringUtil.isEmptyString((String)(str = this.model.getChartID()))) {
                out.writeByte(28);
                out.writeString(str);
            }
            out.writeByte(39);
            int size2 = dn.getResultSize();
            for (int i = 0; i < size2; ++i) {
                out.writeByte(1);
                Object resultFormal = dn.getResult(i);
                if (resultFormal == null) {
                    out.writeByte(14);
                    continue;
                }
                for (Object obj : (Object[])resultFormal) {
                    if (obj instanceof Variant[][]) {
                        out.writeByte(8);
                    } else if (obj == null) {
                        out.writeByte(14);
                    }
                    out.writeString(JsonUtil.encodeToString(gsonBuilder, obj));
                }
                out.writeByte(1);
            }
            out.writeByte(39);
            out.writeByte(40);
            out.writeBoolean(dn.isDirty());
            out.writeByte(0);
            out.close();
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return bs.toByteArray();
    }

    private boolean laterThan(String preVersion, String currVersion) {
        if (StringUtil.isEmptyString((String)preVersion) || StringUtil.isEmptyString((String)currVersion)) {
            return false;
        }
        return new BigDecimal(currVersion).compareTo(new BigDecimal(preVersion)) > 0;
    }

    private String[] readArray(KDSDataInputStream in, int len) throws IOException {
        String[] arr = new String[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readString();
        }
        return arr;
    }

    private void writeArray(KDSDataOutputStream out, String[] arr) throws IOException {
        if (arr == null) {
            out.writeInt(0);
            return;
        }
        int len = arr.length;
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.writeString(arr[i]);
        }
    }

    @Override
    public boolean setBounds(int x, int y, int w, int h, boolean updateAnchor) {
        EChart.transitionBounds.x = x;
        EChart.transitionBounds.y = y;
        EChart.transitionBounds.width = w;
        EChart.transitionBounds.height = h;
        if (this.splitArray != null) {
            int len = this.splitArray.length / 2;
            for (int i = 0; i < len; ++i) {
                if (this.splitArray[i * 2] == null || this.splitArray[2 * i + 1] == null) continue;
                ((EChart)this.splitArray[2 * i + 1]).setBounds(x, y, w, h, updateAnchor);
                ((EChart)this.splitArray[2 * i + 1]).getPhysicalUI().setBounds(x, y, w, h);
                ((SpreadView)this.splitArray[i * 2]).revalidate();
                ((SpreadView)this.splitArray[i * 2]).doLayout();
            }
        }
        return super.setBounds(x, y, w, h, updateAnchor);
    }

    @Override
    public void split(SpreadView[] splitViews, SpreadContext.PhysicalEmbedXListener listener) {
        if (splitViews == null || this.splitArray != null) {
            return;
        }
        int len = splitViews.length;
        if (this.splitArray == null || this.splitArray.length == 0) {
            this.splitArray = new Object[2 * len];
        }
        Rectangle bounds = this.getBounds();
        for (int i = 0; i < len; ++i) {
            EChart newChart = new EChart(this.getSheet(), this.getModel());
            newChart.main_echart = this;
            newChart.setBounds(bounds);
            Component physicUI = newChart.getPhysicalUI();
            physicUI.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
            if (splitViews[i] == null) continue;
            splitViews[i].add(physicUI);
            splitViews[i].revalidate();
            if (null != listener) {
                if (newChart.getDisplayPanel() == null) {
                    newChart.addDisplayPanel();
                }
                newChart.getNativeComponent().addMouseListener(listener);
                newChart.getNativeComponent().addKeyListener(listener);
            }
            this.splitArray[i * 2] = splitViews[i];
            this.splitArray[i * 2 + 1] = newChart;
        }
    }

    @Override
    public void merge() {
        if (this.splitArray == null) {
            return;
        }
        int len = this.splitArray.length / 2;
        for (int i = 0; i < len; ++i) {
            if (this.splitArray[i * 2] == null || this.splitArray[i * 2 + 1] == null) continue;
            ((SpreadView)this.splitArray[i * 2]).remove(((EChart)this.splitArray[i * 2 + 1]).getPhysicalUI());
            ((SpreadView)this.splitArray[i * 2]).revalidate();
            ((SpreadView)this.splitArray[i * 2]).repaint();
        }
        this.splitArray = null;
    }

    @Override
    public Component getNativeComponent() {
        return this.displayPanel.getNativeComponent();
    }

    @Override
    public void executeRefresh() {
        this.model.getDataNode().setDirty(true);
        this.model.getDataNode().enableSnap(this.save4Snap);
        List<String> script = TransferMapper.transfer2ExecuteScript(this.model, !MiscUtil.isExecutedBook(this._sheet.getBook()));
        if (this.save4Snap) {
            this.model.getDataNode().enableSnap(false);
        }
        this.execute(script);
        this.lastExecutedScript = this.getStr(script);
    }

    private String getStr(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s).append("//--\n");
        }
        return sb.toString();
    }

    @Override
    public BufferedImage exportToBufferedImage() {
        if (this.imageData != null) {
            return this.imageData;
        }
        try {
            for (int count = 0; !this.displayPanel.isChartFinished() || count < 1; ++count) {
                Thread.sleep(4000L);
            }
            Rectangle rect = this.getNativeComponent().getBounds();
            this.imageData = new BufferedImage(rect.width, rect.height, 2);
            Graphics g = this.imageData.getGraphics();
            this.getNativeComponent().paint(g);
            g.dispose();
            if (this.src != null) {
                this.src.setCachedImg(this.imageData);
            }
            return this.imageData;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public BufferedImage getErrorImage() {
        BufferedImage ret = ChartImageUtil.getErrorImage();
        if (ret != null) {
            Rectangle rect = this.getBounds();
            this.setBounds(rect.x, rect.y, ret.getWidth(), ret.getHeight());
        }
        return ret;
    }

    public void setSrc(EChart c) {
        this.src = c;
    }

    public void setTransitionChart(boolean isTransitionChart) {
        this.isTransitionChart = isTransitionChart;
    }

    public boolean isTransitionChart() {
        return this.isTransitionChart;
    }

    public void enableExport4Snap() {
        if (this.save4Snap) {
            return;
        }
        this.save4Snap = true;
        this.model.getDataNode().setDirty(true);
        this.model.getDataNode().enableSnap(true);
        this.lastExecutedScript = this.getStr(TransferMapper.transfer2ExecuteScript(this.model, !MiscUtil.isExecutedBook(this._sheet.getBook())));
    }

    public EChartDisplayPanel getDisplayPanel() {
        return this.displayPanel;
    }

    public void registerClickHandler(IEChartsClickEventHandler handler) {
        this.displayPanel.registerClickHandler(handler);
    }

    public void removeClickHandler(IEChartsClickEventHandler handler) {
        this.displayPanel.removeClickHandler(handler);
    }

    @Override
    public String getLastExecutedScript() {
        if (StringUtil.isEmptyString((String)this.lastExecutedScript)) {
            this.model.getDataNode().enableSnap(true);
            this.lastExecutedScript = this.getStr(TransferMapper.transfer2ExecuteScript(this.model, !MiscUtil.isExecutedBook(this._sheet.getBook())));
            this.model.getDataNode().enableSnap(false);
        }
        return this.lastExecutedScript;
    }

    @Override
    public void destory() {
        if (null != this.displayPanel) {
            this.displayPanel.close();
        }
    }

    @Override
    public String getEmbedId() {
        if (this.displayPanel != null) {
            return this.displayPanel.getChartID();
        }
        return null;
    }

    private class EChartRightMouseClickListener
    extends MouseAdapter {
        private KDPopupMenu popMenu = new KDPopupMenu();

        public EChartRightMouseClickListener() {
            KDMenuItem menuItem = new KDMenuItem(CtrlEXTMessages.getMLS("setChartProperties", "\u8bbe\u7f6e\u56fe\u8868\u5c5e\u6027"));
            menuItem.addActionListener(e -> {
                SpreadContext context = ResovlerHelper.getCurrentChartSpreadContext(EChart.this.main_echart);
                ResovlerHelper.showStepWizzard(context, EChart.this.main_echart, "chartSettings");
            });
            this.popMenu.add((JMenuItem)menuItem);
            if (DEBUGMODE) {
                KDMenuItem jsItem = new KDMenuItem(CtrlEXTMessages.getMLS("setExtendedJs", "\u8bbe\u7f6e\u6269\u5c55JS"));
                jsItem.addActionListener(e -> {
                    KDDialog d = this.createJSEditorDialog(ResovlerHelper.getCurrentChartSpreadContext(EChart.this));
                    d.show();
                });
                this.popMenu.add((JMenuItem)jsItem);
            }
            if (DEMOPICMODE) {
                KDMenuItem picItem = new KDMenuItem(CtrlEXTMessages.getMLS("saveAsImage", "\u53e6\u5b58\u4e3a\u56fe\u7247"));
                picItem.addActionListener(e -> {
                    EChart.this.executeAndWait(10L, TimeUnit.SECONDS);
                    KDFileChooser chooser = new KDFileChooser();
                    Window w = SwingUtilities.getWindowAncestor((Component)((Object)ResovlerHelper.getCurrentChartSpreadContext(EChart.this)));
                    chooser.setSelectedFile(new File(FilenameUtils.normalize((String)(EChart.this.getModel().getChartType().getAlias() + ".png"))));
                    int option = chooser.showSaveDialog((Component)w);
                    if (option == 0) {
                        File f = chooser.getSelectedFile();
                        try {
                            String path = f.getCanonicalPath();
                            if (!path.toLowerCase(Locale.CHINA).endsWith(".png")) {
                                path = path + ".png";
                            }
                            f = FileUtil.createFile((String)path);
                            this.saveImageToFile(f);
                        }
                        catch (Exception e1) {
                            logger.error((Object)"err", (Throwable)e1);
                        }
                    }
                });
                this.popMenu.add((JMenuItem)picItem);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3 && !this.popMenu.isVisible()) {
                this.showMenu(e.getX(), e.getY());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean saveImageToFile(File f) {
            BufferedImage image = EChart.this.exportToBufferedImage();
            FileOutputStream fos = null;
            boolean flag = false;
            try {
                fos = new FileOutputStream(f);
                flag = ImageIO.write((RenderedImage)image, ".png".substring(1), fos);
            }
            catch (IOException e) {
                try {
                    logger.error((Object)"err", (Throwable)e);
                }
                catch (Throwable throwable) {
                    StreamUtil.closeCloseable(fos);
                    throw throwable;
                }
                StreamUtil.closeCloseable((Closeable)fos);
            }
            StreamUtil.closeCloseable((Closeable)fos);
            return flag;
        }

        private KDDialog createJSEditorDialog(SpreadContext context) {
            JSEditorDialog d;
            Window w = SwingUtilities.getWindowAncestor((Component)((Object)context));
            IPageReady ready = p -> {
                JSObject window = JSUtils.getWindow(p);
                window.setMember("jsNode", new JSNodeFunction(EChart.this.jsNodeList, EChart.this.displayPanel));
                StringBuilder sb = new StringBuilder();
                if (!EChart.this.jsNodeList.getJsList().isEmpty()) {
                    EChart.this.jsNodeList.getJsList().forEach(n -> sb.append(n.getJs()));
                } else {
                    sb.append("//please write your js code here.");
                }
                String b64Encode = Base64.encodeBytes((byte[])sb.toString().getBytes(StandardCharsets.UTF_8), (boolean)false);
                p.execute(String.format("var textValue = \"%s\";var b64coder = new KDBase64(); try {textValue = b64coder.decode(textValue);}catch(err){console.error(err.message);} if(editor){editor.setValue(textValue);}", b64Encode));
            };
            String title = CtrlEXTMessages.getMLS("chartJSScriptEditing", "\u56fe\u8868JS\u811a\u672c\u7f16\u8f91");
            if (w instanceof Dialog) {
                d = new JSEditorDialog(ready, (Dialog)w, title, true);
            } else if (w instanceof Frame) {
                d = new JSEditorDialog(ready, (Frame)w, title, true);
            } else {
                d = new JSEditorDialog(ready);
                d.setModal(true);
            }
            d.setLocationRelativeTo(w);
            return d;
        }

        public void showMenu(int x, int y) {
            this.popMenu.show(EChart.this.getNativeComponent(), x, y);
        }
    }

    private class EChartFunctionInitializer
    implements IChartReadyFunction {
        private List<IChartReadyFunction> functions = new ArrayList<IChartReadyFunction>();

        private EChartFunctionInitializer() {
        }

        @Override
        public void onReady(IExecutePanel browser) {
            EChart.this.initFunctions(browser);
            for (IChartReadyFunction f : this.functions) {
                f.onReady(browser);
            }
            EChart.this.executeRefresh();
            EChart.this.jsNodeList.getJsList().forEach(n -> EChart.this.execute(n.getJs()));
        }

        public void addReadyFunction(IChartReadyFunction f) {
            if (null != f) {
                this.functions.add(f);
            }
        }
    }
}

