/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer;

import com.github.abel533.echarts.Option;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.propety.AngularGaugeSynchronizer;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.propety.ChartCaptionSynchronizer;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.propety.CommonPropsSynchronizer;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.propety.GanttPropsSynchronizer;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.propety.TrendlineSynchronizer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.IModelTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.area.Area2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.area.MSArea2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.area.ScrollMSArea2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.area.StackedArea2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.bar.Bar2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.bar.MSBar2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.bar.MSBar3DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.bar.StackedBar2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.bar.StackedBar3DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column.Column2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column.Column3DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column.MSColumn2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column.MSColumn3DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column.MSStackedColumn2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column.ScrollMSColumn2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column.ScrollStackedColumn2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column.StackedColumn2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column.StackedColumn3DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination.Combination2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination.CombinationColumn3DLineBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination.CombinationDY2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination.CombinationDYColumn3DLineBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination.MSStackedCombiDY2DBeanImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination.MSStackedCombiDY3DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination.ScrollCombi2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination.ScrollCombiDY2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.doughnut.Doughnut2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.doughnut.Doughnut3DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.funnel.FunnelBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.gantt.GanttBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.gauge.GaugeBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.line.Line2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.line.MSLine2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.line.ScrollMSLine2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.pie.Pie2DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.pie.Pie3DBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.pyramid.PyramidBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.radar.RadarBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.scatter.BubbleBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.scatter.ScatterBeanTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TransferMapper {
    private static final Logger log = Logger.getLogger(TransferMapper.class);
    private static final Map<FlashChartType, Class<? extends IModelTransfer>> REGISTERMAP = new HashMap<FlashChartType, Class<? extends IModelTransfer>>();

    private TransferMapper() {
    }

    public static final void registerTransfer(FlashChartType type, Class<? extends IModelTransfer> c) {
        REGISTERMAP.put(type, c);
    }

    public static final Class<? extends IModelTransfer> getTransferClass(FlashChartType type) {
        return REGISTERMAP.get(type);
    }

    public static List<String> transfer2ExecuteScript(FlashChartModel model) {
        return TransferMapper.transfer2ExecuteScript(model, false);
    }

    public static IModelTransfer getModelTransfer(FlashChartModel model) throws InstantiationException, IllegalAccessException {
        Class<? extends IModelTransfer> cls = TransferMapper.getTransferClass(model.getChartType());
        IModelTransfer transfer = null;
        if (null != cls) {
            transfer = cls.newInstance();
        }
        return transfer;
    }

    public static List<String> transfer2ExecuteScript(FlashChartModel model, boolean isShowDemoData) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            IModelTransfer transfer = TransferMapper.getModelTransfer(model);
            if (null == transfer) {
                return ret;
            }
            String initScript = null;
            Option option = null;
            String afterScript = null;
            if (isShowDemoData) {
                if (model.getChartType() != model.getBean().getChartType()) {
                    model.getBean().setChartType(model.getChartType());
                }
                if (model.getBean() != null && model.getDataNode() != null) {
                    if (model.getChartType() == FlashChartType.FLASH_CT_DASHBOARD) {
                        new AngularGaugeSynchronizer().loadFromModel(model.getBean(), model.getDataNode());
                    } else if (model.getChartType() == FlashChartType.FLASH_CT_GANTT) {
                        new GanttPropsSynchronizer().loadFromModel(model.getBean(), model.getDataNode());
                    } else {
                        new ChartCaptionSynchronizer().loadFromModel(model.getBean(), model.getDataNode());
                        new TrendlineSynchronizer().loadFromModel(model.getBean(), model.getDataNode());
                        new CommonPropsSynchronizer().loadFromModel(model.getBean(), model.getDataNode());
                    }
                }
                initScript = transfer.initMockScript(model.getBean());
                option = transfer.mockOption(model.getBean());
                afterScript = transfer.afterMockScript(model.getBean());
            } else {
                initScript = transfer.initScript(model.getBean(), model.getDataNode());
                option = transfer.transfer2Opiton(model.getBean(), model.getDataNode());
                if (null != option) {
                    afterScript = transfer.afterScript(model.getBean(), model.getDataNode(), option);
                } else {
                    throw new RuntimeException(CtrlEXTMessages.getMLS("dataError", "\u6570\u636e\u9519\u8bef"));
                }
            }
            if (!StringUtils.isEmpty((String)initScript)) {
                ret.add(initScript);
            }
            if (null != option) {
                String str = option.toString();
                ret.add("var option=" + str + ";");
            }
            if (!StringUtils.isEmpty((String)afterScript)) {
                ret.add(afterScript);
                if (EChart.DEMOPICMODE) {
                    ret.add(JSUtils.DEMO_PIC_MODE_JS);
                }
            }
        }
        catch (Exception e) {
            LogUtil.getLogger(TransferMapper.class).error((Object)(CtrlEXTMessages.getMLS("eChartExecutionError", "EChart\u56fe\u8868\u6267\u884c\u9519\u8bef\uff1a") + e.getMessage()), (Throwable)e);
            ret.clear();
            String errorMsg = e.getMessage() == null || e.getMessage().equals("null") ? "" : e.getMessage();
            ret.add(String.format("var option={title:{text:\"\u56fe\u8868\u53c2\u6570\u9519\u8bef\u65e0\u53ef\u5c55\u793a\u6570\u636e\",subtext:\"%s\",left:\"center\",top:\"center\",textStyle:{fontSize:20,color:'red'},subtextStyle:{fontSize:12}}};myChart.setOption(option, true);", errorMsg));
        }
        return ret;
    }

    static {
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_PIE2D, Pie2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_PIE3D, Pie3DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_COLUMN2D, Column2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_MS_COLUMN2D, MSColumn2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_SCROLL_COLUMN2D, ScrollMSColumn2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_ST_COL2D, StackedColumn2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_SCROLL_ST_COLUMN2D, ScrollStackedColumn2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_COLUMN3D, Column3DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_ST_MS_COL2D, MSStackedColumn2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_BAR2D, Bar2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_MS_BAR2D, MSBar2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_ST_BAR2D, StackedBar2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_LINE2D, Line2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_MS_LINE, MSLine2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_SCROLL_LINE2D, ScrollMSLine2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_AREA2D, Area2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_MS_AREA2D, MSArea2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_SCROLL_AREA2D, ScrollMSArea2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_ST_AREA2D, StackedArea2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_SCATTER, ScatterBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_BUBBLE, BubbleBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_DOUGHNUT2D, Doughnut2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_DOUGHNUT3D, Doughnut3DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_FUNNEL, FunnelBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_PYRAMID, PyramidBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_DASHBOARD, GaugeBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_RADAR, RadarBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_COMBI2D, Combination2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_SCROLL_COMBI2D, ScrollCombi2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_COMBI2D_DY, CombinationDY2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_ST_MS_COL2DLINE_DY, MSStackedCombiDY2DBeanImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_SCROLL_COMBI2D_DY, ScrollCombiDY2DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_ST_BAR3D, StackedBar3DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_MS_COLUMN3D, MSColumn3DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_ST_COL3D, StackedColumn3DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_MS_BAR3D, MSBar3DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_COL3D_LINE, CombinationColumn3DLineBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_COL3D_LINE_DY, CombinationDYColumn3DLineBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_ST_COL3DLINE_DY, MSStackedCombiDY3DBeanTransferImpl.class);
        TransferMapper.registerTransfer(FlashChartType.FLASH_CT_GANTT, GanttBeanTransferImpl.class);
    }
}

