/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer;

import com.github.abel533.echarts.AbstractData;
import com.github.abel533.echarts.Data;
import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.LineType;
import com.github.abel533.echarts.code.SeriesType;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Scatter;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.FileUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.DataLabelUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.PatternNode;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.util.FusionChartXmlBuilder;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.CtrlFormatUtilities;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.chart.AbstractType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;

public class TransferUtils {
    private static final Logger logger = LogUtil.getPackageLogger(TransferUtils.class);
    private static Map<String, String> fontNameMapper = new HashMap<String, String>();
    private static final String COLORSTOPSFORMAT = "{offset: 1, color: '%s'},{offset: 0, color: '%s'},{offset: 1, color: '%s'}";
    public static final int STATISTIC_MAX = 0;
    public static final int STATISTIC_MIN = 1;
    public static final int STATISTIC_TOTAL = 2;
    public static final int STATISTIC_AVAGE = 3;

    private TransferUtils() {
    }

    public static String getNumberFormatString(Map<String, String> numberFormatMap) {
        DecimalFormat format = new DecimalFormat();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(numberFormatMap.get("decimalSeparator").charAt(0));
        symbols.setGroupingSeparator(numberFormatMap.get("thousandSeparator").charAt(0));
        if (Boolean.parseBoolean(numberFormatMap.get("percent"))) {
            symbols.setPercent('%');
        }
        format.setDecimalFormatSymbols(symbols);
        format.setGroupingUsed(Boolean.parseBoolean(numberFormatMap.get("formatNumber")));
        return format.toPattern();
    }

    public static String toCSSRGBAString(Color color) {
        StringBuilder builder = new StringBuilder("rgba(");
        builder.append(color.getRed()).append(',').append(color.getGreen()).append(',').append(color.getBlue()).append(',');
        double a = (double)color.getAlpha() / 255.0;
        String aStr = a + "";
        if (aStr.length() > 4) {
            aStr = aStr.substring(0, 4);
        }
        builder.append(aStr).append(')');
        return builder.toString();
    }

    public static final double stackValue(double[][] data, int col, int row) {
        double d = 0.0;
        for (int i = 0; i <= row; ++i) {
            d += data[i][col];
        }
        return d;
    }

    public static final double stackValueGroupByNeg(double[][] data, int col, int row, boolean isNeg) {
        if (isNeg) {
            return TransferUtils.stackNegValue(data, col, row);
        }
        return TransferUtils.stackPosValue(data, col, row);
    }

    private static double stackNegValue(double[][] data, int col, int row) {
        double d = 0.0;
        for (int i = 0; i <= row; ++i) {
            double v = data[i][col];
            if (!(v < 0.0)) continue;
            d += v;
        }
        return d;
    }

    private static double stackPosValue(double[][] data, int col, int row) {
        double d = 0.0;
        for (int i = 0; i <= row; ++i) {
            double v = data[i][col];
            if (!(v > 0.0)) continue;
            d += v;
        }
        return d;
    }

    public static final int countSeries(String[] serials, String name) {
        int ret = 0;
        for (String s : serials) {
            if (!name.equals(s)) continue;
            ++ret;
        }
        return ret;
    }

    public static String getColorStop(Color color, int alpha) {
        return String.format(COLORSTOPSFORMAT, TransferUtils.toCSSRGBAString(color), TransferUtils.toCSSRGBAString(new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha)), TransferUtils.toCSSRGBAString(new Color(color.getRed())));
    }

    public static String buildColorStops(String colorStop, String pre, int count, int right, int down, int left, int up, int colorLength) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            int index = i % colorLength;
            builder.append(String.format(colorStop, pre, i, right, down, left, up, index, index, index, index));
        }
        return builder.toString();
    }

    public static String buildColorStops(String pre, int count, int right, int down, int left, int up, int colorLength) {
        return TransferUtils.buildColorStops("var colorStop%s%d = new echarts.graphic.LinearGradient(%d, %d, %d, %d, [{offset:0, color:colors[%d]},{offset:0.5, color:colors75c[%d]},{offset:0.5, color:colors7c[%d]},{offset:1, color:colors[%d]}]);", pre, count, right, down, left, up, colorLength);
    }

    public static String buildGradualChangeColorStops(String pre, int count, int right, int down, int left, int up) {
        return TransferUtils.buildColorStops("var colorStop%s%d = new echarts.graphic.LinearGradient(%d, %d, %d, %d, [{offset:0, color:'#393939'},{offset:0.5, color:colors75c[%d]},{offset:0.5, color:colors75c[%d]},{offset:1, color:colors[%d]}]);", pre, count, right, down, left, up, count);
    }

    public static String buildColorStopNames(String name, String pre, int count) {
        StringBuilder builder = new StringBuilder();
        builder.append("var ").append(name).append("=[");
        for (int i = 0; i < count; ++i) {
            int index = i % count;
            builder.append(String.format("colorStop%s%d", pre, index));
            if (i >= count - 1) continue;
            builder.append(',');
        }
        builder.append("];");
        return builder.toString();
    }

    public static final void fillData(Variant[][] data, boolean isSeriesByCol, Series serie, int index) {
        if (!isSeriesByCol) {
            Variant[] v = data[index];
            for (int j = 0; j < v.length; ++j) {
                serie.data().add(v[j].getValue());
            }
        } else {
            for (int j = 0; j < data.length; ++j) {
                Variant[] v = data[j];
                serie.data().add(v[index].getValue());
            }
        }
    }

    public static void fillData(Object[] dataValues, int i, Series serie) {
        block6: {
            block7: {
                block5: {
                    if (!(dataValues[i] instanceof Variant[][])) break block5;
                    Variant[][] data = (Variant[][])dataValues[i];
                    for (int j = 0; j < data.length; ++j) {
                        for (int d = 0; d < data[j].length; ++d) {
                            Variant v = data[j][d];
                            serie.data().add(v.getValue());
                        }
                    }
                    break block6;
                }
                if (!(dataValues[i] instanceof double[][])) break block7;
                double[][] data = (double[][])dataValues[i];
                for (int j = 0; j < data.length; ++j) {
                    for (int d = 0; d < data[j].length; ++d) {
                        serie.data().add(data[j][d]);
                    }
                }
                break block6;
            }
            if (!(dataValues[i] instanceof double[])) break block6;
            double[] data = (double[])dataValues[i];
            for (int j = 0; j < data.length; ++j) {
                serie.data().add(data[j]);
            }
        }
    }

    public static final void fillData(Object dataValues, boolean isSeriesByCol, Series serie, int index) {
        if (dataValues instanceof Variant[][]) {
            TransferUtils.fillData((Variant[][])dataValues, isSeriesByCol, serie, index);
        } else if (dataValues instanceof double[][]) {
            TransferUtils.fillData((double[][])dataValues, isSeriesByCol, serie, index);
        } else if (dataValues instanceof double[]) {
            double[] values = (double[])dataValues;
            for (int i = 0; i < values.length; ++i) {
                serie.data().add(values[i]);
            }
        }
    }

    public static final void fillData(double[][] data, boolean isSeriesByCol, Series serie, int index) {
        if (!isSeriesByCol) {
            double[] v = data[index];
            for (int j = 0; j < v.length; ++j) {
                serie.data().add(v[j]);
            }
        } else {
            for (int j = 0; j < data.length; ++j) {
                double[] v = data[j];
                serie.data().add(v[index]);
            }
        }
    }

    public static final List<Object> stackValue(List<List<Object>> data, int row) {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.addAll((Collection)data.get(row));
        for (int i = row - 1; i >= 0; --i) {
            for (int j = 0; j < ret.size(); ++j) {
                double value;
                BigDecimal object = null;
                object = data.get(i).get(j) instanceof BigDecimal ? (BigDecimal)data.get(i).get(j) : (Double.isNaN(value = ((Double)data.get(i).get(j)).doubleValue()) ? BigDecimal.ZERO : BigDecimal.valueOf(value));
                Object r = ret.remove(0);
                BigDecimal source = null;
                source = r instanceof BigDecimal ? (BigDecimal)r : (Double.isNaN((Double)r) ? BigDecimal.ZERO : BigDecimal.valueOf((Double)r));
                if (source.compareTo(BigDecimal.ZERO) >= 0) {
                    if (object.compareTo(BigDecimal.ZERO) >= 0) {
                        source = source.add(object);
                    }
                } else if (object.compareTo(BigDecimal.ZERO) < 0) {
                    source = source.add(object);
                }
                ret.add(source);
            }
        }
        return ret;
    }

    public static final double calOffset(int serialSize, int index, double gap) {
        double h = 100.0;
        return (double)index * h + (double)index * gap - 0.5 * (double)serialSize * h + 0.5 * h - 0.5 * (double)serialSize * gap + 0.5 * gap;
    }

    public static final double calOffset(int serialSize, int index) {
        return TransferUtils.calOffset(serialSize, index, 20.0);
    }

    public static final double calSize(int serialSize, double gap) {
        return 100.0 / ((double)serialSize + (double)(serialSize - 1) * gap / 100.0);
    }

    public static final double calSizeOffset(int total, int visibleSerialSize, double gap) {
        return (100.0 - (double)(total - visibleSerialSize) * 5.0) / ((double)visibleSerialSize + (double)(visibleSerialSize - 1) * gap / 100.0);
    }

    public static final double getMax(double[][] numbers) {
        return TransferUtils.getStatistic(numbers)[0];
    }

    public static final double getMin(double[][] numbers) {
        return TransferUtils.getStatistic(numbers)[1];
    }

    public static final double getMax(double[][] numbers, int col) {
        return TransferUtils.getStatistic(numbers, col)[0];
    }

    public static final double getMin(double[][] numbers, int col) {
        return TransferUtils.getStatistic(numbers, col)[1];
    }

    public static final double[] getStatistic(double[][] numbers, int col) {
        double[] statistic = new double[4];
        double max = numbers[0][0];
        double min = numbers[0][0];
        double total = 0.0;
        for (int i = 0; i < numbers.length; ++i) {
            max = Math.max(max, numbers[i][col]);
            min = Math.min(min, numbers[i][col]);
            total += numbers[i][col];
        }
        statistic[0] = max;
        statistic[1] = min;
        statistic[2] = total;
        statistic[3] = total / (double)numbers.length;
        return statistic;
    }

    public static final double[] getStatistic(double[] numbers) {
        double[] statistic = new double[4];
        double max = numbers[0];
        double min = numbers[0];
        double total = 0.0;
        for (int i = 0; i < numbers.length; ++i) {
            max = Math.max(max, numbers[i]);
            min = Math.min(min, numbers[i]);
            total += numbers[i];
        }
        statistic[0] = max;
        statistic[1] = min;
        statistic[2] = total;
        statistic[3] = total / (double)numbers.length;
        return statistic;
    }

    public static void main(String[] args) {
        double[] numbers = new double[]{2.3, 56.6, 112.5, 0.36, 69.87, 568.5, 98.31};
        System.out.println(TransferUtils.getStatistic(numbers)[0]);
        DoubleSummaryStatistics sc = Stream.of(2.3, 56.6, 112.5, 0.36, 69.87, 568.5, 98.31).collect(Collectors.summarizingDouble(x -> x));
        System.out.println(sc.getMax());
    }

    public static final double getStackedMaxValue(double[][] numbers) {
        if (null == numbers || numbers.length == 0) {
            return 0.0;
        }
        double[][] statics = new double[2][numbers[0].length];
        double max = 0.0;
        for (int i = 0; i < numbers.length; ++i) {
            for (int j = 0; j < numbers[i].length; ++j) {
                double d = numbers[i][j];
                if (Double.isNaN(d)) continue;
                if (d >= 0.0) {
                    statics[0][j] = statics[0][j] + numbers[i][j];
                } else if (d < 0.0) {
                    statics[1][j] = statics[1][j] + numbers[i][j];
                }
                max = Math.max(max, statics[0][j]);
                max = Math.max(max, statics[1][j]);
            }
        }
        return max;
    }

    public static final double getStackedMinValue(double[][] numbers) {
        if (null == numbers || numbers.length == 0) {
            return 0.0;
        }
        double[][] statics = new double[2][numbers[0].length];
        double min = 0.0;
        for (int i = 0; i < numbers.length; ++i) {
            for (int j = 0; j < numbers[i].length; ++j) {
                double d = numbers[i][j];
                if (Double.isNaN(d)) continue;
                if (d >= 0.0) {
                    statics[0][j] = statics[0][j] + numbers[i][j];
                } else if (d < 0.0) {
                    statics[1][j] = statics[1][j] + numbers[i][j];
                }
                min = Math.min(min, statics[0][j]);
                min = Math.min(min, statics[1][j]);
            }
        }
        return min;
    }

    public static final double getMaxValue4SingleArray(double[][] numbers) {
        if (null == numbers || numbers.length == 0) {
            return 0.0;
        }
        double max = 0.0;
        double temp = 0.0;
        for (int i = 0; i < numbers.length; ++i) {
            for (int j = 0; j < numbers[i].length; ++j) {
                temp += numbers[i][j];
            }
            max = Math.max(max, temp);
            temp = 0.0;
        }
        return max;
    }

    public static final double[] getStatistic(double[][] numbers) {
        return TransferUtils.getStatistic(numbers, 0, -1, 0, -1);
    }

    public static final double[] getStatistic(double[][] numbers, int startRow, int endRow, int startCol, int endCol) {
        double[] statics = new double[4];
        double max = numbers[0][0];
        double min = numbers[0][0];
        double total = 0.0;
        int sr = startRow;
        int er = endRow;
        if (startRow < 0) {
            sr = 0;
        }
        if (endRow < 0) {
            er = numbers.length;
        }
        for (int i = sr; i < er; ++i) {
            int sc = startCol;
            int ec = endCol;
            if (startCol < 0) {
                sc = 0;
            }
            if (endCol < 0) {
                ec = numbers[i].length;
            }
            for (int j = sc; j < ec; ++j) {
                max = Math.max(max, numbers[i][j]);
                min = Math.min(min, numbers[i][j]);
                total += numbers[i][j];
            }
        }
        statics[0] = max;
        statics[1] = min;
        statics[2] = total;
        statics[3] = total / (double)numbers.length;
        return statics;
    }

    public static double ceil(double number) {
        boolean negative = number < 0.0;
        double absNumber = Math.abs(number);
        int bit = 0;
        if (!negative && number < 10.0) {
            return number;
        }
        while (absNumber > 10.0) {
            absNumber /= 10.0;
            ++bit;
        }
        if (negative) {
            return 0.0 - Math.ceil(absNumber) * Math.pow(10.0, bit);
        }
        return Math.ceil(absNumber) * Math.pow(10.0, bit);
    }

    public static int getSeriesMaxDataLength(List<Series> series) {
        int result = series.get(0).data().size();
        for (Series s : series) {
            result = Math.max(result, s.data().size());
        }
        return result;
    }

    public static String getFormatFunctionString(String pattern) {
        return String.format("function(se){var nf = new NumberFormatter();return nf.formatNumber(se.data.value,{format:'%s', locale:'cn'});}", pattern);
    }

    public static void setAxisLabelFormatter(List<Axis> axisList, String[] formatters, AxisType axisType) {
        for (int i = 0; i < axisList.size(); ++i) {
            Axis axis = axisList.get(i);
            if (axis.getType() != axisType) continue;
            axis.axisLabel().formatter((Object)formatters[i % formatters.length]);
        }
    }

    public static boolean is3DChart(Option p) {
        if (null != p.getSeries()) {
            for (Series s : p.getSeries()) {
                if (s.getType() != SeriesType.pictorialBar) continue;
                return true;
            }
        }
        return false;
    }

    public static void setAxisLabelInterval(List<Axis> axisList, int interval, AxisType axisType) {
        for (Axis axis : axisList) {
            if (axis.getType() != axisType) continue;
            axis.axisLabel().interval((Object)interval);
        }
    }

    public static void setAxisLabelRotate(List<Axis> axisList, Integer rotate, AxisType axisType) {
        for (Axis axis : axisList) {
            if (axis.getType() != axisType) continue;
            axis.axisLabel().rotate(rotate);
        }
    }

    public static void setAxisFormatter(List<Axis> axisList, String formatter, AxisType axisType) {
        for (Axis axis : axisList) {
            if (axis.getType() != axisType) continue;
            axis.axisLabel().formatter((Object)new Var(formatter));
        }
    }

    public static void setAxisFormatter(List<Axis> axisList, String formatter, AxisType axisType, int condition) {
        for (Axis axis : axisList) {
            if (axis.getType() != axisType || null == axis.getData() || axis.getData().size() > condition) continue;
            axis.axisLabel().formatter((Object)new Var(formatter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceAsString(Class<?> cls, String resourceName, Charset chartSet) {
        InputStream in = cls.getResourceAsStream(resourceName);
        if (null != in) {
            try {
                String string = new String(FileUtil.loadStream2byte((InputStream)in), chartSet);
                return string;
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)"err", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static String getBigNumberFormat(PatternNode node, String template, boolean left, String tenThoudsandSign, String millionSign, String billionSign) {
        return TransferUtils.getBigNumberFormat(node, template, "", left, tenThoudsandSign, millionSign, billionSign);
    }

    public static String getBigNumberFormat(PatternNode node, String template, String templateFormater, boolean left, String tenThoudsandSign, String millionSign, String billionSign) {
        String suffix = "";
        String prefix = "";
        if (!StringUtil.isEmptyString((String)node.getPrefix())) {
            prefix = node.getPrefix();
        }
        if (left) {
            String temp = node.getSuffix();
            if (!StringUtil.isEmptyString((String)temp)) {
                suffix = temp;
            }
        } else if (!StringUtil.isEmptyString((String)node.getrSuffix())) {
            suffix = node.getrSuffix();
        }
        return String.format(template, tenThoudsandSign, millionSign, billionSign, prefix, suffix, templateFormater);
    }

    public static boolean isStackedSeries(Series<?> s) {
        return (s.getType() == SeriesType.bar || s.getType() == SeriesType.line) && null != s.getStack();
    }

    public static String parserFormatterSymbol(String formatter, PatternNode n) {
        return formatter.replace("{a}", "param.seriesName").replace("{c}", "formattedNumber");
    }

    public static Double getInterval(Chart chart) {
        Double r = null;
        if (!StringUtil.isEmptyString((String)chart.yScaleUnit)) {
            try {
                r = Double.parseDouble(chart.yScaleUnit);
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        return r;
    }

    public static String getENFontName(String fontName) {
        return fontNameMapper.get(fontName);
    }

    public static boolean isBelowZero(Object o) {
        if (o instanceof Integer) {
            return (Integer)o < 0;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).compareTo(BigDecimal.ZERO) < 0;
        }
        if (o instanceof Double) {
            return (Double)o < 0.0;
        }
        return false;
    }

    public static void setTrendLineValue(AbstractData data, String script, String ... args) {
        data.data().add(new Var(String.format(script, args)));
    }

    public static void configreVerticalLine(Chart chart, Scatter sc, int value) {
        if ("1".equals(chart.showCategrotiesVerticalLine)) {
            sc.markLine().data().add(new Var(String.format("{label:{show:true,formatter:'{c}',position:'start'},itemStyle:{color:'#000'},xAxis:%d}", value)));
            sc.markLine().lineStyle().opacity(Double.valueOf(0.5));
            sc.markLine().lineStyle().type(LineType.solid);
            sc.markLine().tooltip().show(Boolean.FALSE);
            sc.markLine().symbol((Object)"none");
        }
    }

    public static Double getDataMax(FusionChartDataNode dataNode, String position) {
        return TransferUtils.getDataMax(dataNode, position, 0, -1, 0, -1);
    }

    public static Double getDataMax(FusionChartDataNode dataNode, String position, int startRow, int endRow, int startCol, int endCol) {
        Object sdata = dataNode.getData();
        double[][] initData = null;
        if (sdata instanceof double[][]) {
            initData = (double[][])sdata;
        } else if (sdata instanceof Object[]) {
            sdata = ((Object[])sdata)[0];
            initData = (double[][])sdata;
        }
        ArrayList<double[][]> tempData = new ArrayList<double[][]>();
        if (null != initData) {
            tempData.add(initData);
        }
        AbstractType chartType = dataNode.getChartType();
        double max = 0.0;
        Double stackMaxValue = 0.0;
        if (TransferUtils.isCombinationType(chartType)) {
            String[] yAxisPosition;
            Object[] types;
            int i;
            Object dataValues;
            tempData.clear();
            if ("cell".equals(dataNode.getDataFrom())) {
                dataValues = (double[][])dataNode.getData();
                tempData.add((double[][])dataValues);
            } else {
                dataValues = (Object[])dataNode.getData();
                Object[] types2 = (Object[])dataNode.getSeriesKeysWithoutCalc();
                for (i = 0; i < types2.length; ++i) {
                    if (!(dataValues[i] instanceof double[][])) continue;
                    tempData.add((double[][])dataValues[i]);
                }
            }
            if (TransferUtils.isStackedDoubleYType(chartType)) {
                if ("cell".equals(dataNode.getDataFrom())) {
                    double[][] datas = (double[][])tempData.get(0);
                    Object[] types3 = (Object[])dataNode.getSeriesKeysWithoutCalc();
                    String[] yAxisPosition2 = dataNode.getYAxisPositionWithoutCalc();
                    int index = 0;
                    for (int i2 = 0; i2 < types3.length; ++i2) {
                        Object type = types3[i2];
                        if (!(type instanceof Object[]) || !TransferUtils.isAxisEqual(position, yAxisPosition2[i2])) continue;
                        int len = ((Object[])type).length;
                        double[][] newDatas = new double[len][];
                        for (int j = 0; j < len; ++j) {
                            newDatas[j] = datas[index];
                            ++index;
                        }
                        stackMaxValue = Math.max(stackMaxValue, TransferUtils.getStackedMaxValue(newDatas));
                    }
                } else {
                    types = (Object[])dataNode.getSeriesKeysWithoutCalc();
                    yAxisPosition = dataNode.getYAxisPositionWithoutCalc();
                    for (i = 0; i < types.length; ++i) {
                        if (!TransferUtils.isAxisEqual(position, yAxisPosition[i])) continue;
                        stackMaxValue = Math.max(stackMaxValue, TransferUtils.getStackedMaxValue((double[][])tempData.get(i)));
                    }
                }
                if (stackMaxValue > 0.0) {
                    return stackMaxValue;
                }
            } else if (DataLabelUtil.isDoubleYChart((FlashChartType)chartType)) {
                if ("cell".equals(dataNode.getDataFrom())) {
                    String[] yAxisPosition3 = dataNode.getYAxisPositionWithoutCalc();
                    double[][] datas = (double[][])tempData.get(0);
                    double[][] newDatas = new double[datas.length][];
                    for (int i3 = 0; i3 < datas.length; ++i3) {
                        newDatas[i3] = !TransferUtils.isAxisEqual(position, yAxisPosition3[i3]) ? new double[0] : datas[i3];
                    }
                    tempData.clear();
                    tempData.add(newDatas);
                } else {
                    types = (Object[])dataNode.getSeriesKeysWithoutCalc();
                    yAxisPosition = dataNode.getYAxisPositionWithoutCalc();
                    ArrayList data = new ArrayList(tempData.size());
                    for (int i4 = 0; i4 < types.length; ++i4) {
                        if (!TransferUtils.isAxisEqual(position, yAxisPosition[i4])) continue;
                        data.add(tempData.get(i4));
                    }
                    tempData = data;
                }
            }
        } else if (TransferUtils.isStackedType(chartType)) {
            double[][] data = (double[][])sdata;
            stackMaxValue = TransferUtils.getStackedMaxValue(data);
        }
        for (int n = 0; n < tempData.size(); ++n) {
            double[][] data = (double[][])tempData.get(n);
            int sr = startRow;
            int er = endRow;
            if (startRow < 0) {
                sr = 0;
            }
            if (endRow <= 0) {
                er = data.length;
            }
            for (int i = sr; i < er; ++i) {
                int sc = startCol;
                int ec = endCol;
                if (startCol < 0) {
                    sc = 0;
                }
                if (endCol <= 0) {
                    ec = data[i].length;
                }
                for (int j = sc; j < ec; ++j) {
                    if (Double.isNaN(data[i][j])) continue;
                    max = Math.max(data[i][j], max);
                }
            }
        }
        if (null != stackMaxValue) {
            return Math.max(stackMaxValue, max);
        }
        return max;
    }

    public static boolean isAxisEqual(String yAxisPosition, String axis) {
        if ("left".equals(yAxisPosition)) {
            return CtrlEXTMessages.getMLS("normal2", "\u6b63\u5e38").equals(axis) || "left".equals(axis);
        }
        return CtrlEXTMessages.getMLS("rightAxis", "\u53f3\u8f74").equals(axis) || "right".equals(axis);
    }

    public static boolean isCombinationType(AbstractType chartType) {
        return chartType == FlashChartType.FLASH_CT_COMBI2D || chartType == FlashChartType.FLASH_CT_COMBI3D || chartType == FlashChartType.FLASH_CT_COL3D_LINE || chartType == FlashChartType.FLASH_CT_COMBI2D_DY || chartType == FlashChartType.FLASH_CT_COL3D_LINE_DY || chartType == FlashChartType.FLASH_CT_SCROLL_COMBI2D || chartType == FlashChartType.FLASH_CT_SCROLL_COMBI2D_DY || chartType == FlashChartType.FLASH_CT_ST_MS_COL2DLINE_DY || chartType == FlashChartType.FLASH_CT_ST_COL3DLINE_DY;
    }

    public static boolean isStackedType(AbstractType chartType) {
        return chartType == FlashChartType.FLASH_CT_ST_AREA2D || chartType == FlashChartType.FLASH_CT_ST_BAR2D || chartType == FlashChartType.FLASH_CT_ST_BAR3D || chartType == FlashChartType.FLASH_CT_ST_COL2D || chartType == FlashChartType.FLASH_CT_ST_COL3D || chartType == FlashChartType.FLASH_CT_ST_MS_COL2D || chartType == FlashChartType.FLASH_CT_SCROLL_ST_COLUMN2D;
    }

    public static boolean isStackedDoubleYType(AbstractType chartType) {
        return chartType == FlashChartType.FLASH_CT_ST_MS_COL2DLINE_DY || chartType == FlashChartType.FLASH_CT_ST_COL3DLINE_DY;
    }

    public static Double getDataMin(FusionChartDataNode dataNode) {
        return TransferUtils.getDataMin(dataNode, 0, -1, 0, -1);
    }

    public static Double getDataMin(FusionChartDataNode dataNode, int startRow, int endRow, int startCol, int endCol) {
        double min = 0.0;
        Object sdata = dataNode.getData();
        double[][] data = null;
        if (sdata instanceof double[][]) {
            data = (double[][])sdata;
        } else if (sdata instanceof Object[]) {
            sdata = ((Object[])sdata)[0];
            data = (double[][])sdata;
        }
        Double stackMinValue = 0.0;
        AbstractType chartType = dataNode.getChartType();
        if (TransferUtils.isCombinationType(chartType)) {
            String[] yAxisPosition;
            Object[] types;
            int i;
            Object dataValues;
            ArrayList<double[][]> tempData = new ArrayList<double[][]>();
            if ("cell".equals(dataNode.getDataFrom())) {
                dataValues = (double[][])dataNode.getData();
                tempData.add((double[][])dataValues);
            } else {
                dataValues = (Object[])dataNode.getData();
                Object[] types2 = (Object[])dataNode.getSeriesKeysWithoutCalc();
                for (i = 0; i < types2.length; ++i) {
                    if (!(dataValues[i] instanceof double[][])) continue;
                    tempData.add((double[][])dataValues[i]);
                }
            }
            if (TransferUtils.isStackedDoubleYType(chartType)) {
                if ("cell".equals(dataNode.getDataFrom())) {
                    double[][] datas = (double[][])tempData.get(0);
                    Object[] types3 = (Object[])dataNode.getSeriesKeysWithoutCalc();
                    String[] yAxisPosition2 = dataNode.getYAxisPositionWithoutCalc();
                    int index = 0;
                    for (int i2 = 0; i2 < types3.length; ++i2) {
                        Object type = types3[i2];
                        if (!(type instanceof Object[])) continue;
                        int len = ((Object[])type).length;
                        double[][] newDatas = new double[len][];
                        for (int j = 0; j < len; ++j) {
                            newDatas[j] = datas[index];
                            ++index;
                        }
                        if (CtrlEXTMessages.getMLS("rightAxis", "\u53f3\u8f74").equals(yAxisPosition2[i2]) || "right".equals(yAxisPosition2[i2])) continue;
                        stackMinValue = Math.min(stackMinValue, TransferUtils.getStackedMaxValue(newDatas));
                    }
                } else {
                    types = (Object[])dataNode.getSeriesKeysWithoutCalc();
                    yAxisPosition = dataNode.getYAxisPositionWithoutCalc();
                    for (i = 0; i < types.length; ++i) {
                        if (CtrlEXTMessages.getMLS("rightAxis", "\u53f3\u8f74").equals(yAxisPosition[i]) || "right".equals(yAxisPosition[i])) continue;
                        stackMinValue = Math.min(stackMinValue, TransferUtils.getStackedMaxValue((double[][])tempData.get(i)));
                    }
                }
                if (stackMinValue < 0.0) {
                    return stackMinValue;
                }
            } else if (DataLabelUtil.isDoubleYChart((FlashChartType)chartType)) {
                if ("cell".equals(dataNode.getDataFrom())) {
                    String[] yAxisPosition3 = dataNode.getYAxisPositionWithoutCalc();
                    double[][] datas = (double[][])tempData.get(0);
                    double[][] newDatas = new double[datas.length][];
                    for (int i3 = 0; i3 < datas.length; ++i3) {
                        newDatas[i3] = CtrlEXTMessages.getMLS("rightAxis", "\u53f3\u8f74").equals(yAxisPosition3[i3]) || "right".equals(yAxisPosition3[i3]) ? new double[0] : datas[i3];
                    }
                    tempData.clear();
                    tempData.add(newDatas);
                } else {
                    types = (Object[])dataNode.getSeriesKeysWithoutCalc();
                    yAxisPosition = dataNode.getYAxisPositionWithoutCalc();
                    ArrayList d = new ArrayList(tempData.size());
                    for (int i4 = 0; i4 < types.length; ++i4) {
                        if (CtrlEXTMessages.getMLS("rightAxis", "\u53f3\u8f74").equals(yAxisPosition[i4]) || "right".equals(yAxisPosition[i4])) continue;
                        d.add(tempData.get(i4));
                    }
                    tempData = d;
                }
            }
            for (int n = 0; n < tempData.size(); ++n) {
                double[][] d = (double[][])tempData.get(n);
                int sr = startRow;
                int er = endRow;
                if (startRow < 0) {
                    sr = 0;
                }
                if (endRow <= 0) {
                    er = d.length;
                }
                for (int i5 = sr; i5 < er; ++i5) {
                    int sc = startCol;
                    int ec = endCol;
                    if (startCol < 0) {
                        sc = 0;
                    }
                    if (endCol <= 0) {
                        ec = d[i5].length;
                    }
                    for (int j = sc; j < ec; ++j) {
                        if (Double.isNaN(d[i5][j])) continue;
                        min = Math.min(d[i5][j], min);
                    }
                }
            }
            if (null != stackMinValue) {
                return Math.min(stackMinValue, min);
            }
        } else if (TransferUtils.isStackedType(chartType)) {
            double[][] d = (double[][])sdata;
            stackMinValue = TransferUtils.getStackedMinValue(d);
        }
        if (null == data) {
            return null;
        }
        int sr = startRow;
        int er = endRow;
        if (startRow < 0) {
            sr = 0;
        }
        if (endRow <= 0) {
            er = data.length;
        }
        for (int i = sr; i < er; ++i) {
            int sc = startCol;
            int ec = endCol;
            if (startCol < 0) {
                sc = 0;
            }
            if (endCol <= 0) {
                ec = data[i].length;
            }
            for (int j = sc; j < ec; ++j) {
                if (Double.isNaN(data[i][j])) continue;
                min = Math.min(data[i][j], min);
            }
        }
        if (null != stackMinValue) {
            return Math.min(stackMinValue, min);
        }
        return min;
    }

    public static double[][] convertVariantToDouble(Variant[][] variant) {
        if (null == variant || variant.length == 0) {
            return new double[0][];
        }
        double[][] d = new double[variant.length][];
        try {
            for (int i = 0; i < variant.length; ++i) {
                d[i] = new double[variant[i].length];
                for (int j = 0; j < variant[i].length; ++j) {
                    d[i][j] = variant[i][j].getValue() instanceof Double ? ((Double)variant[i][j].getValue()).doubleValue() : variant[i][j].toBigDecimal().doubleValue();
                }
            }
        }
        catch (SyntaxErrorException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return d;
    }

    public static double[][] toDoubleValues(Object[] values) {
        if (values[0] instanceof double[][]) {
            return (double[][])values[0];
        }
        if (values[0] instanceof Variant[][]) {
            return TransferUtils.convertVariantToDouble((Variant[][])values[0]);
        }
        return new double[0][];
    }

    public static Double getMax(String a, String b) {
        Double d1 = TransferUtils.parseDouble(a);
        Double d2 = TransferUtils.parseDouble(b);
        if (null == d1) {
            return d2;
        }
        if (null == d2) {
            return d1;
        }
        return Math.max(d1, d2);
    }

    public static Double parseDouble(String b) {
        Double r = null;
        if (null != b && !"null".equalsIgnoreCase(b)) {
            try {
                r = Double.parseDouble(b);
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        return r;
    }

    public static Double getMin(String a, String b) {
        Double d1 = TransferUtils.parseDouble(a);
        Double d2 = TransferUtils.parseDouble(b);
        if (null == d1) {
            return d2;
        }
        if (null == d2) {
            return d1;
        }
        return Math.min(d1, d2);
    }

    public static boolean isEmptyStringArray(String[] strs) {
        if (null == strs || strs.length == 0) {
            return true;
        }
        for (String s : strs) {
            if (StringUtil.isEmptyString((String)s)) continue;
            return false;
        }
        return true;
    }

    public static String getExecuteStr(Option p, boolean refresh) {
        if (null == p) {
            return "";
        }
        StringBuilder builder = new StringBuilder("var option =");
        builder.append(p.toString());
        builder.append(';');
        builder.append("myChart.setOption(option,").append(refresh).append(");");
        return builder.toString();
    }

    public static boolean checkScriptSize(String script) {
        return null == script || script.length() <= 204800;
    }

    public static boolean isLineType(String type) {
        return FusionChartXmlBuilder.getLineRenderDisplay().equals(type) || "line".equals(type);
    }

    public static boolean isAreaType(String type) {
        return FusionChartXmlBuilder.getAreaRenderDisplay().equals(type) || "Area".toLowerCase(Locale.ENGLISH).equals(type);
    }

    public static boolean isColumnType(String type) {
        return FusionChartXmlBuilder.getColumnRenderDisplay().equals(type) || "Column".toLowerCase(Locale.ENGLISH).equals(type);
    }

    public static void rewriteYAxis(Option p) {
        List list = p.getyAxis();
        if (list.isEmpty()) {
            return;
        }
        Double minValue = TransferUtils.parseDouble(String.valueOf(((Axis)list.get(0)).getMin()));
        if (minValue == null) {
            return;
        }
        for (int j = 0; j < p.series().size(); ++j) {
            if (j % 2 == 0) continue;
            Series pic = (Series)p.series().get(j);
            Double max = 0.0;
            for (int i = 0; i < pic.getData().size(); ++i) {
                Object old = pic.getData().get(i);
                if (old instanceof Data) {
                    return;
                }
                Double picValue = TransferUtils.parseDouble(String.valueOf(old));
                if (picValue != null && picValue <= minValue) {
                    pic.getData().set(i, 0.0);
                    continue;
                }
                if (picValue == null) {
                    picValue = max;
                }
                max = picValue > max ? picValue : max;
            }
            String[] symbolSize = (String[])pic.getSymbolSize();
            if (max == 0.0) continue;
            symbolSize[1] = String.valueOf((max - minValue) / max * 15.0 + "%");
        }
    }

    public static double[] getStackedDiamondProportion(double[][] numbers) {
        int i;
        double[] totalLines = new double[numbers[0].length];
        double[] minPorportion = new double[numbers.length];
        for (i = 0; i < numbers.length; ++i) {
            int j = 0;
            while (j < numbers[i].length) {
                double value = Double.isNaN(numbers[i][j]) ? 0.0 : numbers[i][j];
                int n = j++;
                totalLines[n] = totalLines[n] + Math.abs(value);
            }
        }
        for (i = 0; i < numbers.length; ++i) {
            double min = 0.0;
            for (int j = 0; j < totalLines.length; ++j) {
                double a = 0.0;
                if (!ArrayUtil.isEqual((Double)totalLines[j], (Double)0.0)) {
                    double value = Double.isNaN(numbers[i][j]) ? 0.0 : numbers[i][j];
                    a = Math.abs(value) / totalLines[j];
                }
                if (ArrayUtil.isEqual((Double)min, (Double)0.0)) {
                    min = a;
                }
                min = Math.min(min, a);
            }
            minPorportion[i] = min;
        }
        return minPorportion;
    }

    static {
        for (Font f : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            fontNameMapper.put(f.getFamily(CtrlFormatUtilities.getFormatLocale()), f.getFamily(Locale.ENGLISH));
        }
    }
}

