/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls;

import com.github.abel533.echarts.AbstractData;
import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.code.LineType;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.SeriesType;
import com.github.abel533.echarts.code.Symbol;
import com.github.abel533.echarts.data.Data;
import com.github.abel533.echarts.data.SeriesData;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.PictorialBar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.DataLabelUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColor1ComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColorComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.NullValueDisplayModeEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.column.StackedMSColumn2DBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl.DefaultCombinationSeriesBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.ConfigurableAbstractTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAxisTransfer<B extends AbstractFusionBean>
extends ConfigurableAbstractTransferImpl<B> {
    private boolean yValueAxis = false;
    private boolean xValueAxis = false;
    protected String[] groups = null;
    protected Object[] dataValues = null;
    protected Object[] seriesNames = null;
    protected String[] types = null;
    protected String[] yAxis = null;
    protected String[] series = null;
    protected boolean isSeriesByCol;

    public AbstractAxisTransfer(EChartsType type, String desc) {
        super(type, desc);
    }

    public void setyValueAxis(boolean y) {
        this.yValueAxis = y;
    }

    public boolean isyValueAxis() {
        return this.yValueAxis;
    }

    public boolean isxValueAxis() {
        return this.xValueAxis;
    }

    public void setxValueAxis(boolean x) {
        this.xValueAxis = x;
    }

    @Override
    public String initScript(B bean, FusionChartDataNode data) {
        String s = super.initScript(bean, data);
        StringBuilder sb = new StringBuilder();
        sb.append(JSUtils.XAXIS_AXISLABEL_FORMATTER_FUNCTION).append(JSUtils.YAXIS_AXISLABEL_FORMATTER_FUNCTION);
        s = sb.insert(0, s).toString();
        if (ChartFillColorComboBoxEditor.getGradient().equals(((AbstractFusionBean)bean).getChart().plotGradientColor)) {
            s = s + EChartUtils.getPlotGradientColor(this.isyValueAxis(), this.isxValueAxis(), this.getColorList());
        }
        if (bean instanceof DefaultCombinationSeriesBean || bean instanceof StackedMSColumn2DBean) {
            if ("cell".equals(data.getDataFrom())) {
                if (data.getDataWithoutCalc() != null) {
                    this.groups = data.getGroupKeysWithoutCalc();
                    this.dataValues = (Object[])data.getDataWithoutCalc();
                    this.types = data.getChartShowTypesWithoutCalc();
                    if (data.getSeriesKeysWithoutCalc() instanceof String[][]) {
                        this.seriesNames = (String[][])data.getSeriesKeysWithoutCalc();
                    } else if (data.getSeriesKeysWithoutCalc() instanceof String[]) {
                        this.seriesNames = (String[])data.getSeriesKeysWithoutCalc();
                    }
                    this.yAxis = data.getYAxisPositionWithoutCalc();
                    this.isSeriesByCol = data.isSerialByCol();
                    data.setDirty(false);
                } else {
                    boolean isFillNullWithZero = data.isFillNullWithZero();
                    this.groups = ChartDataTransferUtil.parseStrings(data, data.getGroupFormula(), FusionChartDataNode.COMBINATION_CHART_GROUP_FORMULA);
                    this.dataValues = (Object[])data.getData(FusionChartDataNode.COMBINATION_CHART_DATA_FORMULA);
                    this.types = ChartDataTransferUtil.parseValue2StringArray(data.getData(FusionChartDataNode.COMBINATION_CHART_SERIES_TYPE));
                    String[] seriesFormulas = (String[])data.getFormula(FusionChartDataNode.COMBINATION_CHART_SERIES_FORMULA);
                    if (null != seriesFormulas && !TransferUtils.isEmptyStringArray(seriesFormulas)) {
                        this.seriesNames = ChartDataTransferUtil.parseStrings(data, seriesFormulas);
                    }
                    this.yAxis = ChartDataTransferUtil.parseValue2StringArray(data.getData(FusionChartDataNode.COMBINATION_CHART_PARENTYAXIS));
                    this.isSeriesByCol = data.isSerialByCol();
                    if (this.dataValues != null) {
                        Object[] datas = new Object[this.dataValues.length];
                        if (this.isSeriesByCol) {
                            for (int i = 0; i < this.dataValues.length; ++i) {
                                datas[i] = ChartDataTransferUtil.povitDoubles((Variant[][])this.dataValues[i]);
                            }
                            this.dataValues = (Object[])ChartDataTransferUtil.parseValue2Double(datas, isFillNullWithZero);
                            data.setData(this.dataValues);
                        } else {
                            this.dataValues = (Object[])ChartDataTransferUtil.parseValue2Double(datas, isFillNullWithZero);
                            data.setData(this.dataValues);
                        }
                    }
                    data.setChartShowTypes(this.types);
                    data.setSerieskeys(this.seriesNames);
                    data.setGroupKeys(this.groups);
                    data.setYAxisPosition(this.yAxis);
                    data.setDirty(false);
                }
                Object[] seriesNamesObject = (Object[])data.getData(FusionChartDataNode.COMBINATION_CHART_SERIES_NAMES);
                this.series = ChartDataTransferUtil.parseValue2StringArray(seriesNamesObject);
            } else {
                this.groups = data.getGroupKeys();
                this.dataValues = (Object[])data.getData();
                this.seriesNames = (Object[])data.getSeriesKeys();
                this.types = data.getChartShowTypes();
                this.yAxis = data.getYAxisPostion();
                if (null != this.seriesNames) {
                    this.series = new String[this.seriesNames.length];
                    for (int i = 0; i < this.series.length; ++i) {
                        this.series[i] = "";
                    }
                }
            }
            if (this.groups == null || this.groups.length == 0) {
                throw new RuntimeException(CtrlEXTMessages.getMLS("categoryEmpty", "\u5206\u7c7b\u4e3a\u7a7a"));
            }
            return s;
        }
        this.groups = data.getGroupKeys();
        this.dataValues = (Object[])data.getData();
        this.seriesNames = (Object[])data.getSeriesKeys();
        this.types = data.getChartShowTypes();
        this.yAxis = data.getYAxisPostion();
        if (null != this.seriesNames) {
            this.series = new String[this.seriesNames.length];
            for (int i = 0; i < this.series.length; ++i) {
                this.series[i] = "";
            }
        }
        return s;
    }

    protected void configureSeriesFillet(Option p, Chart chart) {
        boolean is3DChart = TransferUtils.is3DChart(p);
        for (int i = 0; i < p.getSeries().size(); ++i) {
            SeriesData bar;
            int j;
            List data;
            Series s = (Series)p.getSeries().get(i);
            if (s.getType() != SeriesType.bar || !"1".equals(chart.useRoundEdges)) continue;
            if (this.isxValueAxis() && !is3DChart) {
                if (ChartFillColor1ComboBoxEditor.getHetero().equals(chart.plotGradientColor)) {
                    data = s.data();
                    for (j = 0; j < data.size(); ++j) {
                        if (!(data.get(j) instanceof SeriesData)) continue;
                        bar = (SeriesData)data.get(j);
                        bar.itemStyle().normal().color(bar.itemStyle().color());
                        if ((Double)bar.getValue() > 0.0) {
                            bar.itemStyle().normal().barBorderRadius((Object)new Integer[]{0, 10, 10, 0});
                            continue;
                        }
                        bar.itemStyle().normal().barBorderRadius((Object)new Integer[]{10, 0, 0, 10});
                    }
                    continue;
                }
                s.itemStyle().normal().barBorderRadius((Object)new Integer[]{0, 10, 10, 0});
                continue;
            }
            if (!this.isyValueAxis() || is3DChart) continue;
            if (ChartFillColor1ComboBoxEditor.getHetero().equals(chart.plotGradientColor)) {
                data = s.data();
                for (j = 0; j < data.size(); ++j) {
                    if (!(data.get(j) instanceof SeriesData)) continue;
                    bar = (SeriesData)data.get(j);
                    bar.itemStyle().normal().color(bar.itemStyle().color());
                    if ((Double)bar.getValue() > 0.0) {
                        bar.itemStyle().normal().barBorderRadius((Object)new Integer[]{10, 10, 0, 0});
                        continue;
                    }
                    bar.itemStyle().normal().barBorderRadius((Object)new Integer[]{0, 0, 10, 10});
                }
                continue;
            }
            s.itemStyle().normal().barBorderRadius((Object)new Integer[]{10, 10, 0, 0});
        }
    }

    @Override
    protected void configureNumberFormat(Option p, Chart chart, FusionChartDataNode data) {
        super.configureNumberFormat(p, chart, data);
        this.setAxisLabelDisplayMode(p, chart.labelDisplay);
    }

    protected void configureSeries(Option p, Chart chart) {
        String zeroPointMode = chart.connectNullData == null ? "" : chart.connectNullData;
        for (int i = 0; i < p.getSeries().size(); ++i) {
            Series s = (Series)p.getSeries().get(i);
            if (s.getType() != SeriesType.line) continue;
            Line line = (Line)s;
            line.setShowSymbol(Boolean.TRUE);
            if ("0".equals(chart.drawAnchors) && null == line.getAreaStyle()) {
                line.symbol(Symbol.none);
            }
            if ("1".equals(chart.smoothCurve)) {
                line.smooth(Boolean.valueOf(true));
            }
            ArrayList<Object> filterList = new ArrayList<Object>();
            for (int j = 0; j < line.getData().size(); ++j) {
                Object d = line.getData().get(j);
                if (null == d || d.equals(Double.NaN)) {
                    if (NullValueDisplayModeEditor.getZero().equals(zeroPointMode)) {
                        filterList.add(0);
                        continue;
                    }
                    if (NullValueDisplayModeEditor.getSpace().equals(zeroPointMode)) {
                        filterList.add("-");
                        continue;
                    }
                    filterList.add(null);
                    line.setConnectNulls(Boolean.TRUE);
                    continue;
                }
                filterList.add(d);
            }
            line.setData(filterList);
        }
    }

    @Override
    public String afterScript(B b, FusionChartDataNode data, Option p) {
        Chart chart = ((AbstractFusionBean)b).getChart();
        this.configureScaleMark(p, chart);
        this.configureSeries(p, chart);
        this.configureSeriesFillet(p, chart);
        this.configureDataNode(p, chart);
        this.configureValueAxis(p, chart, data);
        this.configureTrendLine(data, p);
        return super.afterScript(b, data, p);
    }

    protected void configureTrendLineValue(Option p, String colorStr, String trendLineMin, String trendLineMax, String showMarkLineValue) {
        List series = p.getSeries();
        if ("1".equals(showMarkLineValue)) {
            ((Series)series.get(0)).markPoint().symbol((Object)"pin");
            ((Series)series.get(0)).markPoint().symbolSize((Object)1);
            ((Series)series.get(0)).markPoint().tooltip().formatter((Object)"{c}");
            ((Series)series.get(0)).markPoint().label().color(colorStr);
            if (this.isxValueAxis()) {
                if (Double.parseDouble(trendLineMin) < Double.parseDouble(trendLineMax)) {
                    TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markPoint(), "{value:'%s', coord:[%s,%s], symbolOffset:[%s,%s]},{value:'%s', coord:[%s,%s], symbolOffset:[%s,%s]}", trendLineMin, trendLineMin, "0", "-15", "-11", trendLineMax, trendLineMax, TransferUtils.getSeriesMaxDataLength(series) - 1 + "", "15", "15");
                } else {
                    TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markPoint(), "{value:'%s', coord:[%s,%s], symbolOffset:[%s,%s]},{value:'%s', coord:[%s,%s], symbolOffset:[%s,%s]}", trendLineMin, trendLineMin, "0", "15", "-11", trendLineMax, trendLineMax, TransferUtils.getSeriesMaxDataLength(series) - 1 + "", "-15", "15");
                }
            } else if (this.isyValueAxis()) {
                if (Double.parseDouble(trendLineMin) < Double.parseDouble(trendLineMax)) {
                    TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markPoint(), "{value:'%s', coord:[%s,%s], symbolOffset:[%s,%s]},{value:'%s', coord:[%s,%s], symbolOffset:[%s,%s]}", trendLineMin, "0", trendLineMin, "15", "15", trendLineMax, TransferUtils.getSeriesMaxDataLength(series) - 1 + "", trendLineMax, "-15", "-11");
                } else {
                    TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markPoint(), "{value:'%s', coord:[%s,%s], symbolOffset:[%s,%s]},{value:'%s', coord:[%s,%s], symbolOffset:[%s,%s]}", trendLineMin, "0", trendLineMin, "15", "-11", trendLineMax, TransferUtils.getSeriesMaxDataLength(series) - 1 + "", trendLineMax, "-15", "15");
                }
            }
        }
    }

    protected void configreTrendAsLine(Option p, String labelOnRight, String isDotted, String nameStr, String colorStr, String trendLineMin, String trendLineMax) {
        List series = p.getSeries();
        ((Series)series.get(0)).markLine().label().position((Object)"start");
        ((Series)series.get(0)).markLine().label().color(colorStr);
        ((Series)series.get(0)).markLine().symbol((Object)"none");
        ((Series)series.get(0)).markLine().tooltip().formatter((Object)"{b}");
        ((Series)series.get(0)).markLine().itemStyle().color((Object)colorStr);
        if (this.isxValueAxis()) {
            TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markLine(), "[{name:'%s', coord:[%s,%s]},{coord:[%s,%s]}]", nameStr, trendLineMin, "0", trendLineMax, TransferUtils.getSeriesMaxDataLength(series) - 1 + "");
        } else if (this.isyValueAxis()) {
            TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markLine(), "[{name:'%s', coord:[%s,%s]},{coord:[%s,%s]}]", nameStr, "0", trendLineMin, TransferUtils.getSeriesMaxDataLength(series) - 1 + "", trendLineMax);
        }
        if (!"1".equals(isDotted)) {
            ((Series)series.get(0)).markLine().lineStyle().type(LineType.solid);
        } else {
            ((Series)series.get(0)).markLine().lineStyle().type(LineType.dotted);
        }
        if ("1".equals(labelOnRight)) {
            ((Series)series.get(0)).markLine().label().position((Object)"end");
        }
    }

    protected void configureDataNode(Option p, Chart chart) {
        boolean is3DChart = TransferUtils.is3DChart(p);
        int i = 0;
        int seriesCount = is3DChart ? p.getSeries().size() / 2 : p.getSeries().size();
        for (int j = 0; j < p.getSeries().size(); ++j) {
            Series s = (Series)p.getSeries().get(j);
            ArrayList<Object> r = new ArrayList<Object>();
            for (int n = 0; n < s.getData().size(); ++n) {
                Object d = s.getData().get(n);
                if (TransferUtils.isBelowZero(d)) {
                    Data sData = new Data();
                    sData.setValue(d);
                    if (!is3DChart && s.getType() == SeriesType.bar && "1".equals(chart.useRoundEdges)) {
                        this.setBlowZeroDataRoundEdges(sData, this.xValueAxis, j, n);
                    }
                    if (s.getType() == SeriesType.pictorialBar && "diamond".equals(s.getSymbol())) {
                        this.setPictorialBarPostion(s, sData, this.xValueAxis);
                    }
                    if (null == s.getLabel() && "1".equals(chart.showValues) && (!is3DChart || s.getType() != SeriesType.pictorialBar)) {
                        this.setBelowZeroDataShowNumberPostion(TransferUtils.isStackedSeries(s) || is3DChart, sData, this.xValueAxis, this.yValueAxis);
                    }
                    if (ChartFillColorComboBoxEditor.getGradient().equals(chart.plotGradientColor)) {
                        sData.itemStyle().normal().color((Object)new Var("plotGradientColorsB[" + i % seriesCount + ']'));
                    }
                    r.add(sData);
                    continue;
                }
                r.add(d);
            }
            s.setData(r);
            if (null == s.getLabel() && "1".equals(chart.showValues) && (!is3DChart || s.getType() != SeriesType.pictorialBar)) {
                if (s instanceof Line) {
                    s.symbol(Symbol.emptyCircle);
                }
                this.setShowNumberPostion(is3DChart || TransferUtils.isStackedSeries(s), s, this.xValueAxis, this.yValueAxis);
            }
            if (s.getType() == SeriesType.pictorialBar) continue;
            ++i;
        }
    }

    protected void setBelowZeroDataShowNumberPostion(boolean forceInside, Data d, boolean x, boolean y) {
        d.label().show(Boolean.TRUE);
        if (forceInside) {
            d.label().normal().position(Position.inside);
        } else if (x) {
            d.label().normal().position(Position.left);
        } else if (y) {
            d.label().normal().position(Position.bottom);
        }
    }

    protected void setShowNumberPostion(boolean forceInside, Series<?> s, boolean x, boolean y) {
        s.label().normal().show(Boolean.TRUE);
        if (forceInside) {
            s.label().normal().position(Position.inside);
        } else if (x) {
            s.label().normal().position(Position.right);
        } else if (y) {
            s.label().normal().position(Position.top);
        } else {
            s.label().normal().position(Position.inside);
        }
    }

    protected void setBlowZeroDataRoundEdges(Data d, boolean x, int seriesIndex, int dataIndex) {
        if (x) {
            d.itemStyle().normal().barBorderRadius((Object)new Integer[]{10, 0, 0, 10});
        } else {
            d.itemStyle().normal().barBorderRadius((Object)new Integer[]{0, 0, 10, 10});
        }
    }

    protected void setPictorialBarPostion(Series<?> s, Data d, boolean x) {
        Object[] offObjects = s.getSymbolOffset();
        if (x) {
            d.symbolOffset((Object)"-50%", offObjects[1]);
        } else {
            d.symbolOffset(offObjects[0], (Object)"50%");
        }
    }

    protected void configureValueAxis(Option p, Chart chart, FusionChartDataNode data) {
        Object[] trendLine = (Object[])data.getFormula(FusionChartDataNode.TRENDLINES);
        String trendLineMin = null;
        String trendLineMax = null;
        if (null != trendLine) {
            trendLineMin = (String)trendLine[6];
            trendLineMax = (String)trendLine[7];
        }
        if (this.yValueAxis) {
            this.configureValueAxisXY(chart, data, trendLineMin, trendLineMax, p.getyAxis(), false);
        }
        if (this.xValueAxis) {
            if (this.yValueAxis) {
                this.configureValueAxisXY(chart, data, null, null, p.getxAxis(), true);
            } else {
                this.configureValueAxisXY(chart, data, trendLineMin, trendLineMax, p.getxAxis(), false);
            }
        }
    }

    protected void configureValueAxisXY(Chart chart, FusionChartDataNode data, String trendLineMin, String trendLineMax, List<Axis> axis, boolean isX) {
        Object[] values;
        String temp = null;
        if (null != trendLineMin && null != trendLineMax && Double.parseDouble(trendLineMin) > Double.parseDouble(trendLineMax)) {
            temp = trendLineMin;
            trendLineMin = trendLineMax;
            trendLineMax = temp;
        }
        if ((values = (Object[])data.getData(FusionChartDataNode.XY_MAX_MIN)) == null || values.length == 0) {
            return;
        }
        if (!axis.isEmpty()) {
            Double interval;
            String position;
            Axis ax = axis.get(0);
            Variant[][] vt = (Variant[][])values[2];
            String string = position = ax.getPosition() == null ? "left" : ((Position)ax.getPosition()).name();
            if (DataLabelUtil.isDoubleYChart((FlashChartType)data.getChartType()) && TransferUtils.isAxisEqual(position, "right")) {
                vt = (Variant[][])values[0];
            }
            Double dataMax = TransferUtils.getDataMax(data, position);
            if (vt != null && vt.length > 0 && vt[0][0].isNumber()) {
                String value = vt[0][0].getValue().toString();
                Double max = TransferUtils.getMax(value, trendLineMax);
                if (null != max) {
                    ax.setMax((Object)max);
                }
            } else if (null != trendLineMax && !isX) {
                if (null != dataMax && Double.parseDouble(trendLineMax) > dataMax) {
                    double m = TransferUtils.ceil(Double.parseDouble(trendLineMax));
                    ax.setMax((Object)m);
                }
            } else if (null != dataMax) {
                // empty if block
            }
            vt = (Variant[][])values[3];
            if (DataLabelUtil.isDoubleYChart((FlashChartType)data.getChartType()) && TransferUtils.isAxisEqual(position, "right")) {
                vt = (Variant[][])values[1];
            }
            Double dataMin = TransferUtils.getDataMin(data);
            if (vt != null && vt.length > 0 && vt[0][0].isNumber()) {
                String value = vt[0][0].getValue().toString();
                Double min = TransferUtils.getMin(value, trendLineMin);
                if (null != min) {
                    ax.setMin((Object)min);
                }
            } else if (null != trendLineMin) {
                if (null != dataMin && Double.parseDouble(trendLineMin) < dataMin) {
                    ax.setMin((Object)trendLineMin);
                }
            } else if (null != dataMin) {
                // empty if block
            }
            if ("0".equals(chart.showYAxisValues2)) {
                ax.axisLabel().show(Boolean.FALSE);
            }
            if (null != (interval = TransferUtils.getInterval(chart))) {
                ax.setInterval((Object)interval);
            }
            if (axis.size() > 1) {
                Axis otherAxis = axis.get(1);
                position = otherAxis.getPosition() == null ? "left" : ((Position)otherAxis.getPosition()).name();
                Variant[][] vtMax = (Variant[][])values[0];
                Variant[][] vtMin = (Variant[][])values[1];
                if (DataLabelUtil.isDoubleYChart((FlashChartType)data.getChartType()) && TransferUtils.isAxisEqual(position, "left")) {
                    vtMax = (Variant[][])values[2];
                    vtMin = (Variant[][])values[3];
                }
                if (vtMax != null && vtMax.length > 0 && vtMax[0][0].isNumber()) {
                    double max = Double.parseDouble(vtMax[0][0].getValue().toString());
                    otherAxis.setMax((Object)max);
                }
                if (vtMin != null && vtMin.length > 0 && vtMin[0][0].isNumber()) {
                    double min = Double.parseDouble(vtMin[0][0].getValue().toString());
                    otherAxis.setMin((Object)min);
                }
                if ("0".equals(chart.showYAxisValues2)) {
                    otherAxis.axisLabel().show(Boolean.FALSE);
                }
            }
        }
    }

    protected void configureScaleMark(Option p, Chart chart) {
        List axis = new ArrayList();
        if (this.yValueAxis) {
            axis = p.getyAxis();
        } else if (this.xValueAxis) {
            axis = p.getxAxis();
        }
        if (null != axis && !axis.isEmpty()) {
            for (Axis s : axis) {
                s.splitArea().show(Boolean.TRUE);
                s.splitLine().lineStyle().opacity(Double.valueOf(StringUtil.isEmptyString((String)chart.divLineAlpha) ? 0.5 : Double.parseDouble(chart.divLineAlpha) / 100.0));
                s.splitArea().areaStyle().opacity(Double.valueOf(StringUtil.isEmptyString((String)chart.canvasBgAlpha) ? 0.0 : Double.parseDouble(chart.canvasBgAlpha) / 100.0));
            }
        }
    }

    protected void configureTrendLine(FusionChartDataNode data, Option p) {
        block8: {
            Object[] trendLine = (Object[])data.getFormula(FusionChartDataNode.TRENDLINES);
            List series = p.getSeries();
            if (null == trendLine || null == series || series.isEmpty()) break block8;
            String onTop = (String)trendLine[0];
            String labelOnRight = (String)trendLine[1];
            String isArea = (String)trendLine[2];
            String isDotted = (String)trendLine[3];
            if ("TRENDLINE - Null - VALUE".equals(trendLine[4])) {
                trendLine[4] = "";
            }
            String nameStr = (String)trendLine[4];
            String colorStr = (String)trendLine[5];
            String trendLineMin = (String)trendLine[6];
            String trendLineMax = (String)trendLine[7];
            String showMarkLineValue = (String)trendLine[8];
            if ("1".equals(isArea)) {
                this.configMarkArea(p, nameStr, colorStr, trendLineMin, trendLineMax);
            } else {
                this.configreTrendAsLine(p, labelOnRight, isDotted, nameStr, colorStr, trendLineMin, trendLineMax);
            }
            this.configureTrendLineValue(p, colorStr, trendLineMin, trendLineMax, showMarkLineValue);
            if ("1".equals(onTop)) {
                for (Series s : series) {
                    if (!"1".equals(isArea)) continue;
                    s.setZ(Integer.valueOf(0));
                }
            } else {
                for (Series s : series) {
                    if (s instanceof PictorialBar || s instanceof Line) {
                        s.setZ(Integer.valueOf(2));
                        continue;
                    }
                    s.setZ(Integer.valueOf(1));
                }
            }
        }
    }

    private void configMarkArea(Option p, String nameStr, String colorStr, String trendLineMin, String trendLineMax) {
        List series = p.getSeries();
        ((Series)series.get(0)).markArea().itemStyle().color((Object)colorStr);
        ((Series)series.get(0)).markArea().tooltip().formatter((Object)"{b}");
        ((Series)series.get(0)).markArea().label().color(colorStr);
        if (SeriesType.scatter.toString().equals(((Series)series.get(0)).getType().toString())) {
            TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markArea(), "[{name:'%s', coord:[%s,%s]},{coord:[%s,%s]}]", nameStr, "0", trendLineMin, ((Axis)p.getxAxis().get(0)).getMax() + "", trendLineMax);
        } else if (this.isxValueAxis()) {
            TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markArea(), "[{name:'%s', coord:[%s,%s]},{coord:[%s,%s]}]", nameStr, trendLineMin, "0", trendLineMax, TransferUtils.getSeriesMaxDataLength(series) - 1 + "");
        } else if (this.isyValueAxis()) {
            TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markArea(), "[{name:'%s', coord:[%s,%s]},{coord:[%s,%s]}]", nameStr, "0", trendLineMin, TransferUtils.getSeriesMaxDataLength(series) - 1 + "", trendLineMax);
        }
    }
}

