/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.Orient;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.Symbol;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.code.X;
import com.github.abel533.echarts.code.Y;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.PictorialBar;
import com.github.abel533.echarts.series.RadarSeries;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.util.ColorUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColorComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.LegendPositionComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.lang.reflect.Array;
import java.util.List;

public abstract class ConfigurableAbstractTransferImpl<B extends AbstractFusionBean>
extends AbstractTransferImpl<B> {
    public ConfigurableAbstractTransferImpl(EChartsType type, String desc) {
        super(type, desc);
    }

    @Override
    public Option transfer2Opiton(B b, FusionChartDataNode d) {
        Option p = super.transfer2Opiton(b, d);
        Chart chart = ((AbstractFusionBean)b).getChart();
        this.configureBase(b, p, chart);
        this.configureGridBorder(p, chart);
        this.configureLegend(p, chart);
        return p;
    }

    protected void configureBase(B b, Option p, Chart chart) {
        p.color((Object)new Var("colors"));
        p.textStyle().fontFamily(chart.baseFont);
        int baseFontSize = ChartDataTransferUtil.parseInteger(chart.baseFontSize == null ? "12" : chart.baseFontSize);
        p.textStyle().fontSize(Integer.valueOf(baseFontSize));
        p.title().left(EChartUtils.transformTextAlign(chart.captionAlign));
        int totalFontWidth = ((AbstractFusionBean)b).getChartWidth();
        int fontSize = ChartDataTransferUtil.parseInteger(chart.captionFontSize == null ? "24" : chart.captionFontSize);
        int count = totalFontWidth / fontSize;
        String text = chart.caption;
        text = this.getNewlineStr(text, count);
        int subFontSize = ChartDataTransferUtil.parseInteger(chart.subCaptionFontSize == null ? "16" : chart.subCaptionFontSize);
        String subText = chart.subCaption;
        int subCount = totalFontWidth / subFontSize;
        subText = this.getNewlineStr(subText, subCount);
        p.title().setText(text);
        p.title().textStyle().setFontSize(Integer.valueOf(fontSize));
        p.title().textStyle().setFontFamily(chart.captionFontName);
        p.title().textStyle().setColor(ColorUtil.colorToHexStr((Color)EChartUtils.transformColor(chart.captionColor).getColorValue()));
        p.title().subtext(subText);
        p.title().subtextStyle().setFontSize(Integer.valueOf(subFontSize));
        p.title().subtextStyle().setFontFamily(chart.subCaptionFontName);
        p.title().subtextStyle().setColor(ColorUtil.colorToHexStr((Color)EChartUtils.transformColor(chart.subCaptionColor).getColorValue()));
        String baseFont = chart.baseFont;
        p.textStyle().fontSize(Integer.valueOf(baseFontSize));
        p.textStyle().fontFamily(baseFont);
        p.setBackgroundColor((Object)chart.bgColor[0]);
        p.grid().left((Object)chart.chartLeftMargin);
        p.grid().right((Object)chart.chartRightMargin);
        p.grid().top((Object)String.valueOf(EChartUtils.getChartTopMargin(chart)));
        p.grid().bottom((Object)chart.chartBottomMargin);
        p.grid().containLabel(Boolean.valueOf(true));
        if ("1".equals(chart.showLabels)) {
            p.tooltip().trigger(Trigger.item);
            p.tooltip().textStyle().fontFamily(baseFont);
            p.tooltip().textStyle().fontSize(Integer.valueOf(baseFontSize));
        }
    }

    public String getNewlineStr(String text, int count) {
        if (!StringUtils.isEmpty((String)text)) {
            StringBuilder sb = new StringBuilder();
            count = count == 0 ? 1 : count;
            int row = text.length() / count;
            for (int i = 0; i <= row; ++i) {
                if (text.length() == count || i == row) {
                    sb.append(text.substring(i * count, text.length()));
                    continue;
                }
                sb.append(text.substring(i * count, (i + 1) * count)).append('\n');
            }
            return sb.toString();
        }
        return null;
    }

    protected void configureGridBorder(Option p, Chart chart) {
        if ("1".equals(chart.canvasBorderAlpha)) {
            p.grid().show(Boolean.TRUE);
            p.grid().borderColor("rgb(0, 0, 0)");
            if (!StringUtil.isEmptyString((String)chart.canvasBorderThickness)) {
                p.grid().show(Boolean.TRUE);
                p.grid().shadowColor("rgb(0, 0, 0)");
                p.grid().borderWidth(ChartDataTransferUtil.parseInteger(chart.canvasBorderThickness));
            }
        }
    }

    protected void configureLegend(Option p, Chart chart) {
        if ("1".equals(chart.showLegend)) {
            p.legend();
            if ("left".equals(chart.legendPosition)) {
                p.legend().left(X.left);
                p.legend().orient(Orient.vertical);
                p.legend().y((Object)X.center);
            } else if ("right".equals(chart.legendPosition)) {
                p.legend().orient(Orient.vertical);
                p.legend().y((Object)X.center);
                p.legend().right((Object)X.right);
                p.grid().right((Object)(Double.parseDouble(chart.chartRightMargin) + 60.0));
            } else if ("bottom".equals(chart.legendPosition)) {
                p.legend().bottom((Object)Y.bottom);
                p.legend().x(X.center);
                p.legend().bottom((Object)"10");
                p.grid().bottom((Object)(Double.parseDouble(chart.chartBottomMargin) + 20.0));
            } else if ("top".equals(chart.legendPosition)) {
                p.legend().x(X.center);
                p.legend().top(Y.top);
            }
        }
    }

    @Override
    public String afterScript(B b, FusionChartDataNode data, Option p) {
        Chart chart = ((AbstractFusionBean)b).getChart();
        this.configureAxisFont(b, p, data);
        this.configureTooltipFormatter(data, p);
        this.configurePlotGradientColor(p, chart);
        this.configureGridColor(p, chart);
        this.configureNumberFormat(p, chart, data);
        this.configureBorder(p, chart);
        if (!this.checkSeriesSize(p.getSeries())) {
            throw new IllegalArgumentException(String.format("series exceed %d limits.", 50));
        }
        if (!this.checkDataSize(p.getSeries())) {
            throw new IllegalArgumentException(String.format("serie's data exceeds %d limits.", 100));
        }
        return super.afterScript(b, data, p);
    }

    protected boolean checkSeriesSize(List<Series> series) {
        if (null != series) {
            return series.size() < 50;
        }
        return true;
    }

    protected boolean checkDataSize(List<Series> series) {
        if (null != series) {
            for (Series s : series) {
                if (null == s.getData() || s.getData().size() <= 100) continue;
                return false;
            }
        }
        return true;
    }

    protected void configureBorder(Option p, Chart chart) {
        for (int i = 0; i < p.getSeries().size(); ++i) {
            Series s = (Series)p.getSeries().get(i);
            if (!"1".equals(chart.showPlotBorder)) continue;
            String color = chart.borderColor == null ? "#000000" : ColorUtil.colorToHexStr((Color)EChartUtils.transformColor(chart.borderColor).getColorValue());
            Integer width = null;
            if (!StringUtil.isEmptyString((String)chart.borderThickness)) {
                width = ChartDataTransferUtil.parseInteger(chart.borderThickness);
            }
            if (s instanceof Line) {
                s.symbol(Symbol.emptyCircle);
                if (null == ((Line)s).getAreaStyle()) continue;
                ((Line)s).lineStyle().color((Object)color);
                ((Line)s).lineStyle().width(width);
                continue;
            }
            if (s instanceof RadarSeries) {
                ((RadarSeries)s).lineStyle().color((Object)color);
                ((RadarSeries)s).lineStyle().width(width);
                continue;
            }
            if (s instanceof PictorialBar) {
                boolean cont = false;
                List data = s.data();
                if (data != null) {
                    for (int j = 0; j < data.size(); ++j) {
                        if (!(data.get(j) instanceof Double) || (Double)data.get(j) != 0.0) continue;
                        cont = true;
                    }
                }
                if (cont) continue;
                s.itemStyle().normal().setBorderColor(color);
                s.itemStyle().normal().borderWidth(width);
                continue;
            }
            s.itemStyle().normal().setBorderColor(color);
            s.itemStyle().normal().borderWidth(width);
        }
    }

    protected void configureGridColor(Option p, Chart chart) {
        if ("1".equals(chart.canvasBorderAlpha) && null != p.getGrid()) {
            p.grid().show(Boolean.TRUE);
        }
    }

    protected void configurePlotGradientColor(Option p, Chart chart) {
        if (ChartFillColorComboBoxEditor.getGradient().equals(chart.plotGradientColor)) {
            p.color((Object)new Var("plotGradientColors"));
        }
    }

    protected void configureTooltipFormatter(FusionChartDataNode data, Option p) {
        if (null != p.getTooltip()) {
            Object formatter = p.getTooltip().formatter();
            Var f = null;
            f = null != p.getRadar() ? JSUtils.getRadarTooltipNumberFormatFunctionVar(true, formatter) : (Trigger.axis == p.getTooltip().getTrigger() ? JSUtils.getTooltipFormatterVar(true, true, true, formatter) : JSUtils.getTooltipFormatterVar(true, true, false, formatter));
            if (null != f && !StringUtil.isEmptyString((String)f.getStr())) {
                p.getTooltip().formatter((Object)f);
            }
        }
    }

    protected void configureAxisFont(B b, Option p, FusionChartDataNode data) {
        Chart chart = ((AbstractFusionBean)b).getChart();
        if (null != p.getxAxis()) {
            for (Axis s : p.getxAxis()) {
                s.axisLabel().textStyle().fontFamily(chart.baseFont);
                s.axisLabel().textStyle().fontSize(ChartDataTransferUtil.parseInteger(chart.baseFontSize));
            }
        }
        if (null != p.getyAxis()) {
            for (Axis s : p.getyAxis()) {
                s.axisLabel().textStyle().fontFamily(chart.baseFont);
                s.axisLabel().textStyle().fontSize(ChartDataTransferUtil.parseInteger(chart.baseFontSize));
            }
        }
    }

    protected void configureNumberFormat(Option p, Chart chart, FusionChartDataNode data) {
        this.setValueAxisLabelFormatter(p.getxAxis());
        this.setValueAxisLabelFormatter(p.getyAxis());
        this.setSeriesNumberFormat(p, chart);
    }

    protected void setSeriesNumberFormat(Option p, Chart chart) {
        if ("1".equals(chart.showValues) && null != p.getSeries()) {
            for (Series s : p.getSeries()) {
                Var leftFormat = null;
                Var rightFormat = null;
                if (null != s.getLabel() && null != s.getLabel().getNormal()) {
                    Object templateFormatter = s.getLabel().getNormal().formatter();
                    leftFormat = JSUtils.getSeriesNumberFormatFunctionVar(true, templateFormatter);
                    rightFormat = JSUtils.getSeriesNumberFormatFunctionVar(false, templateFormatter);
                } else {
                    leftFormat = JSUtils.getSeriesNumberFormatFunctionVar(true, null);
                    rightFormat = JSUtils.getSeriesNumberFormatFunctionVar(false, null);
                }
                this.setSeriesFormat(s, leftFormat, rightFormat);
                s.label().normal().color((Object)"#000");
            }
        }
    }

    protected void setSeriesFormat(Series<?> s, Var leftFormat, Var rightFormat) {
        if (null != s.getYAxisIndex() && 1 == s.getYAxisIndex() && !StringUtil.isEmptyString((String)rightFormat.getStr())) {
            s.label().normal().formatter((Object)rightFormat);
        } else if (!StringUtil.isEmptyString((String)leftFormat.getStr())) {
            s.label().normal().formatter((Object)leftFormat);
        }
    }

    protected void setAxisLabelDisplayMode(Option p, String type) {
        if (null != p.getxAxis() && !p.getxAxis().isEmpty()) {
            List axisList = p.getxAxis();
            if ("stagger".equals(type)) {
                TransferUtils.setAxisLabelFormatter(axisList, new String[]{"function(value, index){ if(index % 2 == 0) {return '\n' + value;} return value;}"}, AxisType.category);
                TransferUtils.setAxisLabelInterval(axisList, 0, AxisType.category);
            } else if ("rotate".equals(type)) {
                TransferUtils.setAxisLabelRotate(axisList, 45, AxisType.category);
            } else {
                TransferUtils.setAxisFormatter(axisList, "xAxisAxislabelFormatter", AxisType.category, 25);
            }
        }
        if (null != p.getyAxis() && !p.getyAxis().isEmpty()) {
            List yaxisList = p.getyAxis();
            if ("stagger".equals(type)) {
                TransferUtils.setAxisLabelFormatter(yaxisList, new String[]{"function(value, index){ if(index % 2 == 0) {return '\n' + value;} return value;}"}, AxisType.category);
                TransferUtils.setAxisLabelInterval(yaxisList, 0, AxisType.category);
            } else if ("rotate".equals(type)) {
                TransferUtils.setAxisLabelRotate(yaxisList, 45, AxisType.category);
            } else {
                TransferUtils.setAxisFormatter(yaxisList, "yAxisAxislabelFormatter", AxisType.category, 25);
            }
        }
    }

    protected void setValueAxisLabelFormatter(List<Axis> axis) {
        if (null != axis) {
            for (Axis a : axis) {
                Var f;
                if (a.getType() != AxisType.value) continue;
                Object formatter = null;
                if (null != a.getAxisLabel()) {
                    formatter = a.getAxisLabel().getFormatter();
                }
                if (StringUtil.isEmptyString((String)(f = JSUtils.getValueAxisNumberFormatFunctionVar(Position.right != a.getPosition(), formatter)).getStr())) continue;
                a.axisLabel().formatter((Object)f);
            }
        }
    }

    @Override
    public Option mockOption(B bean) {
        Option p = super.mockOption(bean);
        p.color((Object)new Var("colors"));
        p.backgroundColor((Object)ColorUtil.colorToHexStr((Color)((AbstractFusionBean)bean).getChart_bgColor().getColorValue()));
        p.textStyle().fontFamily(((AbstractFusionBean)bean).getChartBaseFontName());
        p.textStyle().setFontSize(((AbstractFusionBean)bean).getChartBaseFontSize().getIntegerValue());
        p.title().left(EChartUtils.transformTextAlign(((AbstractFusionBean)bean).getChartTitleAlign()));
        p.title().text(((AbstractFusionBean)bean).getChartTitle());
        p.title().textStyle().setFontSize(((AbstractFusionBean)bean).getChartTitleFontSize().getIntegerValue());
        p.title().textStyle().setFontFamily(((AbstractFusionBean)bean).getChartTitleFontName());
        p.title().textStyle().setColor(ColorUtil.colorToHexStr((Color)((AbstractFusionBean)bean).getChartTitleColor().getColorValue()));
        p.title().subtext(((AbstractFusionBean)bean).getChartDeputyTitle());
        p.title().subtextStyle().setFontSize(((AbstractFusionBean)bean).getChartDeputyTitleFontSize().getIntegerValue());
        p.title().subtextStyle().setFontFamily(((AbstractFusionBean)bean).getChartDeputyTitleFontName());
        p.title().subtextStyle().setColor(ColorUtil.colorToHexStr((Color)((AbstractFusionBean)bean).getChartDeputyTitleColor().getColorValue()));
        p.grid().left((Object)((AbstractFusionBean)bean).getChart_chartLeftMargin());
        p.grid().top((Object)EChartUtils.getChartTopMargin(bean));
        p.grid().right((Object)((AbstractFusionBean)bean).getChart_chartRightMargin());
        p.grid().bottom((Object)((AbstractFusionBean)bean).getChart_chartBottomMargin());
        p.grid().containLabel(Boolean.valueOf(true));
        this.configureLegend(p, ((AbstractFusionBean)bean).getChart());
        if (((AbstractFusionBean)bean).getChart_showLegend().getBooleanValue().booleanValue()) {
            if (LegendPositionComboBoxEditor.getRight().equals(((AbstractFusionBean)bean).getChart_legendPosition())) {
                p.legend().right((Object)X.right);
                p.legend().y((Object)X.center);
                p.grid().right((Object)(Double.parseDouble(((AbstractFusionBean)bean).getChart_chartRightMargin()) + 60.0));
            } else if (LegendPositionComboBoxEditor.getDown().equals(((AbstractFusionBean)bean).getChart_legendPosition())) {
                p.legend().x(X.center);
                p.legend().bottom((Object)"10");
                p.grid().bottom((Object)(Double.parseDouble(((AbstractFusionBean)bean).getChart_chartBottomMargin()) + 20.0));
            }
        } else {
            p.legend().show(Boolean.valueOf(false));
        }
        if (((AbstractFusionBean)bean).getChart_showLabels().getBooleanValue().booleanValue()) {
            p.tooltip().trigger(Trigger.item);
            p.tooltip().textStyle().fontFamily(((AbstractFusionBean)bean).getChartBaseFontName());
            p.tooltip().textStyle().setFontSize(((AbstractFusionBean)bean).getChartBaseFontSize().getIntegerValue());
            p.legend().textStyle().fontFamily(((AbstractFusionBean)bean).getChartBaseFontName());
            p.legend().textStyle().setFontSize(((AbstractFusionBean)bean).getChartBaseFontSize().getIntegerValue());
        }
        return p;
    }

    public String[] getChartCaptions(FusionChartDataNode dataNode) {
        String[] chartCaptions = null;
        Object obj = dataNode.getData(FusionChartDataNode.CHART_CAPTION);
        if (obj != null) {
            int len = Array.getLength(obj);
            chartCaptions = new String[len];
            for (int i = 0; i < len; ++i) {
                Variant[][] val = (Variant[][])Array.get(obj, i);
                if (val == null) continue;
                chartCaptions[i] = val[0][0].getValue() == null ? "" : val[0][0].getValue().toString();
            }
        }
        return chartCaptions;
    }
}

