/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColorComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.column.MSColumn2DBean;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractColumnTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;

public class MSColumn2DBeanTransferImpl
extends AbstractColumnTransfer<MSColumn2DBean> {
    public MSColumn2DBeanTransferImpl() {
        super(EChartsType.BAR, CtrlEXTMessages.getMLS("multiSeriesColumnChart2D", "\u591a\u7cfb\u52172D\u67f1\u5f62\u56fe"));
    }

    @Override
    public String initScript(MSColumn2DBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        double[][] data = (double[][])dataNode.getData();
        EChartUtils.checkChartDataIsNull((Object[])data, dataNode.getGroupKeys(), (String[])dataNode.getSeriesKeys());
        return s;
    }

    @Override
    public Option transfer2Opiton(MSColumn2DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        String[] labels = dataNode.getGroupKeys();
        double[][] data = (double[][])dataNode.getData();
        Object[] series = (String[])dataNode.getSeriesKeys();
        if (null != p.getLegend()) {
            p.legend().data(series);
        }
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.nameTextStyle().width(Integer.valueOf(35));
        valueAxis.name(bean.getChart().yScaleUnit);
        p.yAxis().add(valueAxis);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String label : labels) {
            caxis.data().add(label);
        }
        for (int i = 0; i < data.length; ++i) {
            Bar bar = new Bar();
            bar.name((String)series[i]);
            for (int j = 0; j < data[i].length; ++j) {
                bar.data().add(data[i][j]);
            }
            p.series().add(bar);
        }
        p.xAxis().add(caxis);
        return p;
    }

    @Override
    public Option mockOption(MSColumn2DBean bean) {
        Option p = super.mockOption(bean);
        EChartUtils.configPlotGradientColor(bean, p);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        CategoryAxis caxis = new CategoryAxis();
        caxis.setData(Arrays.asList("Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"));
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis().add(yAxis);
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().axisPointer().type(PointerType.shadow);
        p.legend().data(Arrays.asList(CtrlEXTMessages.getMLS("year2020", "2020\u5e74"), CtrlEXTMessages.getMLS("year2021", "2021\u5e74")));
        Bar bar1 = new Bar();
        bar1.name(CtrlEXTMessages.getMLS("year2020", "2020\u5e74"));
        bar1.setData(Arrays.asList(120, 200, 150, 80, 70, 110, 130));
        EChartUtils.configShowValue(bean, (Series)bar1);
        EChartUtils.configTrendline(bean, (Series)bar1);
        EChartUtils.configAngleRound(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)bar1);
        Bar bar2 = new Bar();
        bar2.name(CtrlEXTMessages.getMLS("year2021", "2021\u5e74"));
        bar2.setData(Arrays.asList(50, 120, 200, 30, 120, 60, 150));
        EChartUtils.configShowValue(bean, (Series)bar2);
        EChartUtils.configAngleRound(bean, (Series)bar2);
        EChartUtils.configPlotBorder(bean, (Series)bar2);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar2);
        p.series().add(bar1);
        p.series().add(bar2);
        EChartUtils.configMaxMinValue(bean, p, 200.0, 0.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String initMockScript(MSColumn2DBean bean) {
        if (ChartFillColorComboBoxEditor.getGradient().equals(bean.getChart_plotGradientColor())) {
            return super.initMockScript(bean) + EChartUtils.getPlotGradientColor(this.isyValueAxis(), this.isxValueAxis(), this.getColorList());
        }
        return super.initMockScript(bean);
    }
}

