/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.Series;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColorComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.combination.MSCombi2DBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractColumnTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.ArrayList;
import java.util.List;

public class Combination2DBeanTransferImpl
extends AbstractColumnTransfer<MSCombi2DBean> {
    public Combination2DBeanTransferImpl() {
        super(EChartsType.BAR, CtrlEXTMessages.getMLS("comboChart2D", "2D\u7ec4\u5408\u56fe"));
    }

    @Override
    public Option transfer2Opiton(MSCombi2DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        List asList = Arrays.asList((Object[])this.seriesNames);
        Chart chart = bean.getChart();
        if (null != p.getLegend()) {
            p.legend().data(asList);
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String group : this.groups) {
            caxis.data().add(group);
        }
        int tLen = this.types.length;
        ArrayList<Bar> list = new ArrayList<Bar>(tLen);
        for (int i = 0; i < tLen; ++i) {
            Bar serie = new Bar();
            serie.z(Integer.valueOf(1));
            if (TransferUtils.isLineType(this.types[i])) {
                serie = new Line();
            } else if (TransferUtils.isAreaType(this.types[i])) {
                serie = new Line();
                ((Line)serie).areaStyle();
            }
            String name = asList.get(i).toString();
            serie.name(name);
            list.add(serie);
            TransferUtils.fillData(this.dataValues, i, (Series)serie);
        }
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.name(bean.getChart().yScaleUnit);
        p.yAxis().add(valueAxis);
        p.xAxis().add(caxis);
        p.series().addAll(list);
        return p;
    }

    @Override
    public String initMockScript(MSCombi2DBean bean) {
        if (ChartFillColorComboBoxEditor.getGradient().equals(bean.getChart_plotGradientColor())) {
            return super.initMockScript(bean) + EChartUtils.getPlotGradientColor(this.isyValueAxis(), this.isxValueAxis(), this.getColorList());
        }
        return super.initMockScript(bean);
    }

    @Override
    public Option mockOption(MSCombi2DBean bean) {
        Option p = super.mockOption(bean);
        EChartUtils.configPlotGradientColor(bean, p);
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().axisPointer().type(PointerType.shadow);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        p.legend().data(new Object[]{CtrlEXTMessages.getMLS("year2021", "2021\u5e74"), CtrlEXTMessages.getMLS("year2020", "2020\u5e74")});
        CategoryAxis yAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        yAxis.axisLabel().textStyle().fontFamily(bean.getChartBaseFontName());
        yAxis.axisLabel().textStyle().setFontSize(bean.getChartBaseFontSize().getIntegerValue());
        CategoryAxis caxis = new CategoryAxis();
        caxis.type(AxisType.category);
        caxis.data(new Object[]{CtrlEXTMessages.getMLS("shenzhen", "\u6df1\u5733"), CtrlEXTMessages.getMLS("foshan", "\u4f5b\u5c71"), CtrlEXTMessages.getMLS("dongguan", "\u4e1c\u839e"), CtrlEXTMessages.getMLS("guangzhou", "\u5e7f\u5dde")});
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis(new Axis[]{caxis});
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis().add(yAxis);
        Bar bar = new Bar();
        bar.name(CtrlEXTMessages.getMLS("year2021", "2021\u5e74"));
        bar.data(new Object[]{26927.09, 10751.02, 9482.5, 23628.6});
        EChartUtils.configShowValue(bean, (Series)bar);
        EChartUtils.configTrendline(bean, (Series)bar);
        EChartUtils.configAngleRound(bean, (Series)bar);
        EChartUtils.configPlotBorder(bean, (Series)bar);
        p.series().add(bar);
        Line line = new Line();
        line.name(CtrlEXTMessages.getMLS("year2020", "2020\u5e74"));
        line.z(Integer.valueOf(4));
        line.data(new Object[]{23927.09, 9751.02, 8492.5, 18628.6});
        EChartUtils.configShowValue(bean, (Series)line);
        EChartUtils.configPlotBorder(bean, (Series)line);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)line);
        p.series().add(line);
        EChartUtils.configMaxMinValue(bean, p, 26927.09, 0.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }
}

