/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.Symbol;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.PictorialBar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.combination.StackedColumn3DLineDYBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.util.FusionChartXmlBuilder;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractStackedTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class MSStackedCombiDY3DBeanTransferImpl
extends AbstractStackedTransfer<StackedColumn3DLineDYBean> {
    private List<Series<Bar>> otherSeries = new ArrayList<Series<Bar>>();
    private List<Series> barSeries = new ArrayList<Series>();
    private List<Axis> yList = new ArrayList<Axis>();

    public MSStackedCombiDY3DBeanTransferImpl() {
        super(EChartsType.BAR, CtrlEXTMessages.getMLS("dualY3DStackedColumnWithLineComboChart", "\u53ccy3d\u5806\u79ef\u67f1\u5f62\u52a0\u6298\u7ebf\u7ec4\u5408\u56fe\uff0c\u4f7f\u75282d\u5806\u79ef\u56fe\u6a21\u62df3d\u6548\u679c\u5916\u52a0\u6298\u7ebf\u56fe\u3002"));
    }

    @Override
    public String initScript(StackedColumn3DLineDYBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        HashMap<String, Integer> yAxisMap = new HashMap<String, Integer>();
        int count = 0;
        for (int n = 0; n < this.yAxis.length; ++n) {
            String chartYAxis = FusionChartXmlBuilder.getChartYAxis(this.yAxis[n]);
            if (null != yAxisMap.get(chartYAxis)) continue;
            ValueAxis valueAxis = new ValueAxis();
            valueAxis.type(AxisType.value);
            valueAxis.axisLabel().show(Boolean.TRUE);
            if (null != chartYAxis) {
                valueAxis.setPosition((Object)Position.right);
            }
            this.yList.add((Axis)valueAxis);
            yAxisMap.put(chartYAxis, count);
            ++count;
        }
        int dex = 0;
        Chart chart = bean.getChart();
        for (int i = 0; i < this.seriesNames.length; ++i) {
            Object[] ns = (Object[])this.seriesNames[i];
            if (ns == null || ns.length == 0 || ns[0] == null) {
                ns = null;
            }
            int l = null == ns ? 1 : ns.length;
            for (int d = 0; d < l; ++d) {
                Bar serie = new Bar();
                serie.z(Integer.valueOf(1));
                boolean createBar = true;
                if (TransferUtils.isColumnType(this.types[i])) {
                    serie.stack(this.groups[i]);
                } else if (TransferUtils.isLineType(this.types[i])) {
                    serie = new Line();
                    this.otherSeries.add((Series<Bar>)serie);
                    createBar = false;
                } else if (TransferUtils.isAreaType(this.types[i])) {
                    serie = new Line();
                    ((Line)serie).areaStyle();
                    this.otherSeries.add((Series<Bar>)serie);
                    createBar = false;
                }
                String[] names = (String[])this.seriesNames[i];
                String name = "";
                name = null != names && names[0] != null ? names[d] : this.series[i];
                serie.name(name);
                String chartYAxis = FusionChartXmlBuilder.getChartYAxis(this.yAxis[i]);
                Integer index = (Integer)yAxisMap.get(chartYAxis);
                if (null != index) {
                    serie.yAxisIndex(index);
                }
                if (createBar) {
                    this.barSeries.add((Series)serie);
                }
                if ("cell".equals(dataNode.getDataFrom())) {
                    TransferUtils.fillData(this.dataValues[dex++], this.isSeriesByCol, (Series)serie, d);
                    continue;
                }
                TransferUtils.fillData(this.dataValues[i], this.isSeriesByCol, (Series)serie, d);
            }
        }
        return s + this.buildColorStopsLeft(this.barSeries.size(), bean.initColors().size());
    }

    @Override
    public Option transfer2Opiton(StackedColumn3DLineDYBean bean, FusionChartDataNode dataNode) {
        double[] proportion;
        Option p = super.transfer2Opiton(bean, dataNode);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        Chart chart = bean.getChart();
        if (null != p.getLegend()) {
            for (int i = 0; i < this.seriesNames.length; ++i) {
                String[] s = (String[])this.seriesNames[i];
                if (null != s && s[0] != null) {
                    for (int j = 0; j < s.length; ++j) {
                        p.legend().data().add(s[j]);
                    }
                    continue;
                }
                p.legend().data().add(this.series[i]);
            }
        }
        if (null == this.groups) {
            return null;
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String group : this.groups) {
            caxis.data().add(group);
        }
        int barSerieSize = this.barSeries.size();
        ArrayList<List<Object>> barDataList = new ArrayList<List<Object>>(barSerieSize);
        ArrayList<Object> seriesList = new ArrayList<Object>(barSerieSize);
        if (this.dataValues instanceof double[][]) {
            proportion = TransferUtils.getStackedDiamondProportion((double[][])this.dataValues);
        } else {
            double[][] numbers = TransferUtils.toDoubleValues(this.dataValues);
            if (numbers.length == 0) {
                throw new RuntimeException(CtrlEXTMessages.getMLS("datasetDataError", "\u6570\u636e\u96c6\u6570\u636e\u9519\u8bef"));
            }
            proportion = TransferUtils.getStackedDiamondProportion(numbers);
        }
        for (int i = 0; i < barSerieSize; ++i) {
            Series bar = this.barSeries.get(i);
            bar.z(Integer.valueOf(1));
            seriesList.add(bar);
            bar.itemStyle().normal().color((Object)("function(){return colorStop" + i + " ;}"));
            PictorialBar p2 = new PictorialBar();
            p2.z(Integer.valueOf(2));
            p2.name(bar.name());
            p2.symbol((Object)"diamond");
            p2.symbolOffset((Object)0, (Object)"-50%");
            p2.symbolSize((Object)new String[]{"100%", proportion[i] * 30.0 + "%"});
            int colorIndex = i % this.getColorList().size();
            p2.itemStyle().normal().color((Object)("function(index){return colors[" + colorIndex + "];}"));
            p2.setSymbolPosition((Object)"end");
            barDataList.add(bar.getData());
            p2.setData(TransferUtils.stackValue(barDataList, i));
            p2.setYAxisIndex(bar.getYAxisIndex());
            seriesList.add(p2);
        }
        seriesList.addAll(this.otherSeries);
        p.yAxis(this.yList);
        p.xAxis().add(caxis);
        p.series().addAll(seriesList);
        return p;
    }

    @Override
    public String initMockScript(StackedColumn3DLineDYBean bean) {
        return super.initMockScript(bean) + this.buildColorStopsLeft(5, bean.initColors().size());
    }

    @Override
    public Option mockOption(StackedColumn3DLineDYBean bean) {
        Option p = super.mockOption(bean);
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().axisPointer().type(PointerType.shadow);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        p.legend().data(Arrays.asList(CtrlEXTMessages.getMLS("guangdong", "\u5e7f\u4e1c"), CtrlEXTMessages.getMLS("shenzhen", "\u6df1\u5733"), CtrlEXTMessages.getMLS("nanchang", "\u5357\u660c"), CtrlEXTMessages.getMLS("shanghai", "\u4e0a\u6d77"), CtrlEXTMessages.getMLS("beijing", "\u5317\u4eac"), CtrlEXTMessages.getMLS("KEY_AVERAGE", "\u5e73\u5747\u503c")));
        p.legend().itemGap(Integer.valueOf(1));
        CategoryAxis caxis = new CategoryAxis();
        caxis.type(AxisType.category);
        caxis.data(new Object[]{CtrlEXTMessages.getMLS("apple", "\u82f9\u679c"), CtrlEXTMessages.getMLS("banana", "\u9999\u8549"), CtrlEXTMessages.getMLS("pear", "\u68a8")});
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        CategoryAxis yYAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        yYAxis.type(AxisType.value);
        yAxis.axisLabel().interval((Object)"auto");
        yYAxis.axisLabel().interval((Object)"auto");
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        EChartUtils.configAxisLucency(bean, (Axis)yYAxis, false);
        p.yAxis().add(yAxis);
        Var axisNumberFormatFunctionVar = JSUtils.getValueAxisNumberFormatFunctionVar(false, null);
        yYAxis.axisLabel().formatter((Object)axisNumberFormatFunctionVar);
        EChartUtils.configRightAxisMaxMinValue(bean, (Axis)yYAxis);
        p.yAxis().add(yYAxis);
        Bar bar = new Bar();
        bar.name(CtrlEXTMessages.getMLS("guangdong", "\u5e7f\u4e1c"));
        bar.yAxisIndex(Integer.valueOf(0));
        bar.stack(CtrlEXTMessages.getMLS("pear", "\u68a8"));
        bar.itemStyle().normal().color((Object)new Var("function(){return colorStop0;}"));
        bar.data(new Object[]{152, 214, 645});
        EChartUtils.configShowValue(bean, (Series)bar);
        EChartUtils.configTrendline(bean, (Series)bar);
        EChartUtils.configPlotBorder(bean, (Series)bar);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar);
        p.series().add(bar);
        PictorialBar pbar = new PictorialBar();
        pbar.yAxisIndex(Integer.valueOf(0));
        pbar.itemStyle().normal().color((Object)new Var("colors[0]"));
        pbar.tooltip().trigger(Trigger.none);
        pbar.symbol(Symbol.diamond);
        pbar.symbolSize(Arrays.asList("100.0%%", "15"));
        pbar.symbolOffset((Object)"0.0%", (Object)"-50%");
        pbar.setSymbolPosition((Object)"end");
        pbar.data(new Object[]{152.0, 214.0, 645.0});
        EChartUtils.configPlotBorder(bean, (Series)pbar);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar);
        p.series().add(pbar);
        bar = new Bar();
        bar.name(CtrlEXTMessages.getMLS("shenzhen", "\u6df1\u5733"));
        bar.yAxisIndex(Integer.valueOf(0));
        bar.stack(CtrlEXTMessages.getMLS("pear", "\u68a8"));
        bar.itemStyle().normal().color((Object)new Var("function(){return colorStop1;}"));
        bar.data(new Object[]{121.0, 220.0, 415.0});
        EChartUtils.configShowValue(bean, (Series)bar);
        EChartUtils.configPlotBorder(bean, (Series)bar);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar);
        p.series().add(bar);
        pbar = new PictorialBar();
        pbar.yAxisIndex(Integer.valueOf(0));
        pbar.itemStyle().normal().color((Object)new Var("colors[1]"));
        pbar.tooltip().trigger(Trigger.none);
        pbar.symbol(Symbol.diamond);
        pbar.symbolSize(Arrays.asList("100%", "15"));
        pbar.symbolOffset((Object)"0.0%", (Object)"-50%");
        pbar.setSymbolPosition((Object)"end");
        pbar.data(new Object[]{273.0, 434.0, 1060.0});
        EChartUtils.configPlotBorder(bean, (Series)pbar);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar);
        p.series().add(pbar);
        bar = new Bar();
        bar.name(CtrlEXTMessages.getMLS("nanchang", "\u5357\u660c"));
        bar.yAxisIndex(Integer.valueOf(0));
        bar.stack(CtrlEXTMessages.getMLS("pear", "\u68a8"));
        bar.itemStyle().normal().color((Object)new Var("function(){return colorStop2;}"));
        bar.data(new Object[]{102.0, 124.0, 253.0});
        EChartUtils.configShowValue(bean, (Series)bar);
        EChartUtils.configPlotBorder(bean, (Series)bar);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar);
        p.series().add(bar);
        pbar = new PictorialBar();
        pbar.yAxisIndex(Integer.valueOf(0));
        pbar.itemStyle().normal().color((Object)new Var("colors[2]"));
        pbar.tooltip().trigger(Trigger.none);
        pbar.symbol(Symbol.diamond);
        pbar.symbolSize(Arrays.asList("100%", "15"));
        pbar.symbolOffset((Object)"0.0%", (Object)"-50%");
        pbar.setSymbolPosition((Object)"end");
        pbar.data(new Object[]{375.0, 558.0, 1313.0});
        EChartUtils.configPlotBorder(bean, (Series)pbar);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar);
        p.series().add(pbar);
        bar = new Bar();
        bar.name(CtrlEXTMessages.getMLS("shanghai", "\u4e0a\u6d77"));
        bar.yAxisIndex(Integer.valueOf(0));
        bar.stack(CtrlEXTMessages.getMLS("pear", "\u68a8"));
        bar.itemStyle().normal().color((Object)new Var("function(){return colorStop3;}"));
        bar.data(new Object[]{154.0, 125.0, 326.0});
        EChartUtils.configShowValue(bean, (Series)bar);
        EChartUtils.configPlotBorder(bean, (Series)bar);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar);
        p.series().add(bar);
        pbar = new PictorialBar();
        pbar.yAxisIndex(Integer.valueOf(0));
        pbar.itemStyle().normal().color((Object)new Var("colors[3]"));
        pbar.tooltip().trigger(Trigger.none);
        pbar.symbol(Symbol.diamond);
        pbar.symbolSize(Arrays.asList("100%", "15"));
        pbar.symbolOffset((Object)"0.0%", (Object)"-50%");
        pbar.setSymbolPosition((Object)"end");
        pbar.data(new Object[]{529.0, 683.0, 1639.0});
        EChartUtils.configPlotBorder(bean, (Series)pbar);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar);
        p.series().add(pbar);
        bar = new Bar();
        bar.name(CtrlEXTMessages.getMLS("beijing", "\u5317\u4eac"));
        bar.yAxisIndex(Integer.valueOf(0));
        bar.stack(CtrlEXTMessages.getMLS("pear", "\u68a8"));
        bar.itemStyle().normal().color((Object)new Var("function(){return colorStop4;}"));
        bar.data(new Object[]{125.0, 145.0, 541.0});
        EChartUtils.configShowValue(bean, (Series)bar);
        EChartUtils.configPlotBorder(bean, (Series)bar);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar);
        p.series().add(bar);
        pbar = new PictorialBar();
        pbar.yAxisIndex(Integer.valueOf(0));
        pbar.itemStyle().normal().color((Object)new Var("colors[4]"));
        pbar.tooltip().trigger(Trigger.none);
        pbar.symbol(Symbol.diamond);
        pbar.symbolSize(Arrays.asList("100%", "15"));
        pbar.symbolOffset((Object)"0.0%", (Object)"-50%");
        pbar.setSymbolPosition((Object)"end");
        pbar.data(new Object[]{654.0, 828.0, 2180.0});
        EChartUtils.configPlotBorder(bean, (Series)pbar);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar);
        p.series().add(pbar);
        Line line = new Line();
        line.name(CtrlEXTMessages.getMLS("KEY_ClassifiedStatistics_FunctionName3", "\u5e73\u5747\u503c"));
        line.stack(CtrlEXTMessages.getMLS("pear", "\u68a8"));
        line.yAxisIndex(Integer.valueOf(1));
        line.data(new Object[]{130.8, 165.6, 436});
        EChartUtils.configShowValue(bean, (Series)line);
        EChartUtils.configPlotBorder(bean, (Series)line);
        bar.symbol(Symbol.emptyCircle);
        bar.label().normal().color((Object)"#000");
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)line);
        p.series().add(line);
        EChartUtils.configMaxMinValue(bean, p, 2180.0, 0.0);
        EChartUtils.hideDrawRB(bean, p, 2180.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String afterMockScript(StackedColumn3DLineDYBean bean) {
        return super.afterMockScript(bean) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }

    @Override
    public String afterScript(StackedColumn3DLineDYBean b, FusionChartDataNode data, Option p) {
        return super.afterScript(b, data, p) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }
}

