/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination;

import com.github.abel533.echarts.DataZoom;
import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.DataZoomType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColorComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.combination.ScrollCombiDY2DBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.util.FusionChartXmlBuilder;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractSrollableTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ScrollCombiDY2DBeanTransferImpl
extends AbstractSrollableTransfer<ScrollCombiDY2DBean> {
    public ScrollCombiDY2DBeanTransferImpl() {
        super(EChartsType.BAR, CtrlEXTMessages.getMLS("scrollDualYAxisComboChart2D", "\u53ccY\u8f74\u5e26\u6eda\u52a8\u6761\u76842D\u7ec4\u5408\u56fe"));
        this.setyValueAxis(true);
        this.setXScrollable(true);
    }

    @Override
    public Option transfer2Opiton(ScrollCombiDY2DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        List asList = com.kingdee.bos.util.backport.Arrays.asList((Object[])this.seriesNames);
        if (null != p.getLegend()) {
            p.legend().data(asList);
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String group : this.groups) {
            caxis.data().add(group);
        }
        int tLen = this.types.length;
        ArrayList<Bar> serieList = new ArrayList<Bar>(tLen);
        ArrayList<ValueAxis> yList = new ArrayList<ValueAxis>();
        HashMap<String, Integer> yAxisMap = new HashMap<String, Integer>();
        int count = 0;
        Chart chart = bean.getChart();
        for (int n = 0; n < this.yAxis.length; ++n) {
            String chartYAxis = FusionChartXmlBuilder.getChartYAxis(this.yAxis[n]);
            if (null != yAxisMap.get(chartYAxis)) continue;
            ValueAxis valueAxis = new ValueAxis();
            valueAxis.type(AxisType.value);
            valueAxis.axisLabel().show(Boolean.TRUE);
            if (null != chartYAxis) {
                valueAxis.setPosition((Object)Position.right);
            }
            yList.add(valueAxis);
            yAxisMap.put(chartYAxis, count);
            ++count;
        }
        for (int i = 0; i < tLen; ++i) {
            Bar serie = new Bar();
            serie.z(Integer.valueOf(1));
            if (TransferUtils.isLineType(this.types[i])) {
                serie = new Line();
            } else if (TransferUtils.isAreaType(this.types[i])) {
                serie = new Line();
                ((Line)serie).areaStyle();
            }
            String name = asList.get(i).toString();
            serie.name(name);
            String chartYAxis = FusionChartXmlBuilder.getChartYAxis(this.yAxis[i]);
            Integer index = (Integer)yAxisMap.get(chartYAxis);
            if (null != index) {
                serie.yAxisIndex(index);
            }
            serieList.add(serie);
            TransferUtils.fillData(this.dataValues, i, (Series)serie);
        }
        p.yAxis(yList);
        p.xAxis().add(caxis);
        p.series().addAll(serieList);
        return p;
    }

    @Override
    public String initMockScript(ScrollCombiDY2DBean bean) {
        if (ChartFillColorComboBoxEditor.getGradient().equals(bean.getChart_plotGradientColor())) {
            return super.initMockScript(bean) + EChartUtils.getPlotGradientColor(this.isyValueAxis(), this.isxValueAxis(), this.getColorList());
        }
        return super.initMockScript(bean);
    }

    @Override
    public Option mockOption(ScrollCombiDY2DBean bean) {
        Option p = super.mockOption(bean);
        EChartUtils.configPlotGradientColor(bean, p);
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().axisPointer().type(PointerType.shadow);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        p.legend().data(Arrays.asList(CtrlEXTMessages.getMLS("shipmentQuantity", "\u51fa\u8d27\u6570"), CtrlEXTMessages.getMLS("inventoryQuantity", "\u5e93\u5b58\u6570"), CtrlEXTMessages.getMLS("timeliness", "\u53ca\u65f6\u7387")));
        DataZoom szoom = new DataZoom();
        szoom.type(DataZoomType.slider);
        szoom.handleSize(Integer.valueOf(0));
        szoom.xAxisIndex((Object)0);
        szoom.start(Integer.valueOf(0));
        szoom.end(Integer.valueOf(60));
        szoom.show(Boolean.valueOf(true));
        szoom.height(Integer.valueOf(15));
        DataZoom izoom = new DataZoom();
        izoom.type(DataZoomType.inside);
        izoom.xAxisIndex((Object)0);
        izoom.start(Integer.valueOf(0));
        izoom.end(Integer.valueOf(60));
        izoom.show(Boolean.valueOf(true));
        p.dataZoom().add(szoom);
        p.dataZoom().add(izoom);
        CategoryAxis caxis = new CategoryAxis();
        caxis.type(AxisType.category);
        caxis.data(new Object[]{"2022.1", "2022.2", "2022.3", "2022.4", "2022.5", "2022.6", "2022.7", "2022.8"});
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        CategoryAxis yYAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        yYAxis.type(AxisType.value);
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        EChartUtils.configAxisLucency(bean, (Axis)yYAxis, false);
        p.yAxis().add(yAxis);
        Var axisNumberFormatFunctionVar = JSUtils.getValueAxisNumberFormatFunctionVar(false, null);
        yYAxis.axisLabel().formatter((Object)axisNumberFormatFunctionVar);
        EChartUtils.configRightAxisMaxMinValue(bean, (Axis)yYAxis);
        p.yAxis().add(yYAxis);
        Bar bar = new Bar();
        bar.yAxisIndex(Integer.valueOf(0));
        bar.name(CtrlEXTMessages.getMLS("shipmentQuantity", "\u51fa\u8d27\u6570"));
        bar.data(new Object[]{502, 324, 452, 625, 754, 684, 897, 1420});
        EChartUtils.configShowValue(bean, (Series)bar);
        EChartUtils.configAngleRound(bean, (Series)bar);
        EChartUtils.configTrendline(bean, (Series)bar);
        EChartUtils.configPlotBorder(bean, (Series)bar);
        p.series().add(bar);
        Line line1 = new Line();
        line1.yAxisIndex(Integer.valueOf(0));
        line1.name(CtrlEXTMessages.getMLS("inventoryQuantity", "\u5e93\u5b58\u6570"));
        line1.data(new Object[]{1452, 1784, 1698, 1741, 1223, 1456, 2501, 1784});
        EChartUtils.configShowValue(bean, (Series)line1);
        EChartUtils.configPlotBorder(bean, (Series)line1);
        EChartUtils.configTrendLineOnTop(bean, (Series)line1);
        p.series().add(line1);
        Line line2 = new Line();
        line2.yAxisIndex(Integer.valueOf(1));
        line2.name(CtrlEXTMessages.getMLS("timeliness", "\u53ca\u65f6\u7387"));
        line2.data(new Object[]{87.63, 88.25, 90.21, 91.26, 88.23, 94.23, 95.12, 91.36});
        EChartUtils.configShowValue(bean, (Series)line2);
        EChartUtils.configPlotBorder(bean, (Series)line2);
        EChartUtils.configTrendLineOnTop(bean, (Series)line2);
        p.series().add(line2);
        EChartUtils.configMaxMinValue(bean, p, 2501.0, 0.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }
}

