/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.gauge;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.code.SeriesType;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.data.PieData;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Gauge;
import com.github.abel533.echarts.style.TextStyle;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.angulargauge.AngularGaugeFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractSmoothTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;

public class GaugeBeanTransferImpl
extends AbstractSmoothTransfer<AngularGaugeFusionBean> {
    private int min;
    private int max;
    private double[][] data;
    private int splitNumber;

    public GaugeBeanTransferImpl() {
        super(EChartsType.GAUGE, CtrlEXTMessages.getMLS("gauge", "\u91cf\u8868"));
        this.setSetPosition(true);
    }

    @Override
    public String initScript(AngularGaugeFusionBean bean, FusionChartDataNode d) {
        String s = super.initScript(bean, d);
        this.data = (double[][])d.getData();
        if (null == this.data || this.data.length == 0) {
            throw new RuntimeException(CtrlEXTMessages.getMLS("dataAreaEmpty", "\u6570\u636e\u533a\u57df\u4e3a\u7a7a"));
        }
        String colorJS = "var lineColors=[[0.1, colors[0]],[0.2, colors[1 % colors.length]],[0.4, colors[2 % colors.length]],[0.6, colors[3 % colors.length]],[0.8, colors[4 % colors.length]],[1, colors[5 % colors.length]]];";
        Arrays.sort(this.data[0]);
        this.max = (int)Math.ceil(this.data[0][this.data[0].length - 1]);
        this.splitNumber = this.data[0].length;
        if (this.splitNumber > 10) {
            this.splitNumber = 10;
        }
        int total = this.max - this.min;
        while (total % this.splitNumber != 0 && this.splitNumber < 10) {
            ++this.splitNumber;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("var lineColors=[");
        double f = 1.0 / (double)this.splitNumber;
        for (int i = 0; i < this.splitNumber; ++i) {
            builder.append(String.format("[%d * %f, colors[%d %% colors.length]]", i + 1, f, i));
            if (i >= this.splitNumber - 1) continue;
            builder.append(',');
        }
        builder.append("];");
        colorJS = builder.toString();
        return s + colorJS;
    }

    @Override
    public Option transfer2Opiton(AngularGaugeFusionBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        Arrays.sort(this.data[0]);
        this.max = (int)Math.ceil(this.data[0][this.data[0].length - 1]);
        this.min = (int)Math.ceil(this.data[0][0]);
        p.tooltip().setFormatter((Object)"{b} {c}");
        p.tooltip().trigger(Trigger.item);
        Chart chart = bean.getChart();
        String[] chartCaptions = super.getChartCaptions(dataNode);
        Gauge gauge = new Gauge();
        gauge.min(Integer.valueOf(this.min));
        gauge.max(Integer.valueOf(this.max));
        TextStyle ts = new TextStyle();
        ts.fontSize(Integer.valueOf(20));
        gauge.radius((Object)"85%");
        gauge.setStartAngle(ChartDataTransferUtil.parseInteger(chart.gaugeStartAngle));
        gauge.setEndAngle(ChartDataTransferUtil.parseInteger(chart.gaugeEndAngle));
        gauge.axisLabel().show(bean.getShowSeparatorTick().getBooleanValue());
        gauge.axisLabel().formatter((Object)JSUtils.getNumberFormatFunctionVar(false));
        int innerRadius = ChartDataTransferUtil.parseInteger(chartCaptions[2]);
        gauge.axisLine().lineStyle().width(Integer.valueOf(100 - innerRadius));
        gauge.pointer().width((Object)ChartDataTransferUtil.parseInteger(chart.pivotRadius));
        gauge.detail().setTextStyle(ts);
        gauge.detail().formatter(JSUtils.getNumberValueFormatFunctionVar().getStr());
        gauge.detail().offsetCenter((Object)new String[]{"0", "50%"});
        gauge.axisLine().lineStyle().color((Object)new Var("lineColors"));
        Object pointData = dataNode.getData(FusionChartDataNode.DASHBOARD_CHART_NEEDLE_FORMULA);
        Object pointLabel = dataNode.getData(FusionChartDataNode.DASHBOARD_CHART_NEEDLE_GROUP_FORMULA);
        if (pointData == null) {
            throw new RuntimeException(CtrlEXTMessages.getMLS("pointerDataAreaEmpty", "\u6307\u9488\u6570\u636e\u533a\u57df\u4e3a\u7a7a"));
        }
        if (pointLabel == null) {
            throw new RuntimeException(CtrlEXTMessages.getMLS("pointerCategoryAreaEmpty", "\u6307\u9488\u5206\u7c7b\u533a\u57df\u4e3a\u7a7a"));
        }
        Variant[][] needleValues = (Variant[][])Array.get(pointData, 0);
        Variant[][] needleNames = (Variant[][])Array.get(pointLabel, 0);
        ArrayList<PieData> list = new ArrayList<PieData>();
        gauge.splitLine().show(Boolean.valueOf("1".equals(chartCaptions[24])));
        gauge.splitLine().lineStyle().color((Object)"#fff");
        if ("1".equals(chartCaptions[25])) {
            gauge.axisTick().show(Boolean.TRUE);
            gauge.axisTick().length(Integer.valueOf(15));
            gauge.axisTick().lineStyle().color((Object)"#FFF");
            gauge.axisTick().distance(Integer.valueOf(innerRadius - 100));
        } else {
            gauge.axisTick().show(Boolean.FALSE);
        }
        gauge.splitNumber(Integer.valueOf(this.splitNumber));
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < needleValues[i].length; ++j) {
                int length = i * this.data.length + j;
                String name = "";
                if (length <= needleNames[i].length - 1 && "1".equals(chartCaptions[22])) {
                    name = needleNames[i][length].getValue().toString();
                }
                PieData pieData = new PieData(name, needleValues[i][j].getValue());
                list.add(pieData);
            }
        }
        gauge.setData(list);
        p.series().add(gauge);
        return p;
    }

    @Override
    public String initMockScript(AngularGaugeFusionBean bean) {
        StringBuilder builder = new StringBuilder();
        builder.append("var lineColors=[");
        double f = 0.125;
        for (int i = 0; i < 8; ++i) {
            builder.append(String.format("[%d * %f, colors[%d %% colors.length]]", i + 1, f, i));
            if (i >= 7) continue;
            builder.append(',');
        }
        builder.append("];");
        builder.insert(0, super.initMockScript(bean));
        return builder.toString();
    }

    @Override
    public Option mockOption(AngularGaugeFusionBean bean) {
        Option p = super.mockOption(bean);
        Gauge gauge = new Gauge();
        gauge.radius((Object)(bean.getGaugeInnerRadius().getIntegerValue() + "%"));
        gauge.startAngle(bean.getGaugeStartAngle().getIntegerValue());
        gauge.endAngle(bean.getGaugeEndAngle().getIntegerValue());
        gauge.min(Integer.valueOf(0));
        gauge.max(Integer.valueOf(240));
        gauge.splitNumber(Integer.valueOf(8));
        gauge.axisLine().lineStyle().color((Object)new Var("lineColors"));
        gauge.axisLabel().show(bean.getShowSeparatorTick().getBooleanValue());
        gauge.axisLabel().formatter((Object)JSUtils.getNumberFormatFunctionVar(false).getStr());
        gauge.splitLine().show(bean.getShowMajorTick().getBooleanValue());
        gauge.axisTick().show(bean.getShowMinorTick().getBooleanValue());
        gauge.axisTick().length(Integer.valueOf(15));
        gauge.pointer().width((Object)bean.getPivotRadius().getIntegerValue());
        gauge.detail().offsetCenter(Arrays.asList("0", "50%"));
        gauge.detail().textStyle().fontSize(Integer.valueOf(20));
        gauge.type(SeriesType.gauge);
        String title = bean.getShowGroupLabel().getBooleanValue() != false ? CtrlEXTMessages.getMLS("speed", "\u901f\u5ea6") : "";
        PieData vData = new PieData(title, (Object)120);
        gauge.data(new Object[]{vData});
        gauge.detail().formatter(JSUtils.getNumberValueFormatFunctionVar().getStr());
        p.series().add(gauge);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, false, "{b} {c}");
        p.tooltip().formatter((Object)tooltipFormatter);
        return p;
    }

    @Override
    public String afterScript(AngularGaugeFusionBean bean, FusionChartDataNode data, Option p) {
        Chart chart = bean.getChart();
        chart.chartTopMargin = String.valueOf(EChartUtils.getChartTopMargin(bean));
        return super.afterScript(bean, data, p);
    }

    @Override
    public String afterMockScript(AngularGaugeFusionBean bean) {
        String s = JSUtils.getPositionJS(String.valueOf(EChartUtils.getChartTopMargin(bean)), bean.getChart_chartLeftMargin(), bean.getChart_chartBottomMargin(), bean.getChart_chartRightMargin());
        return s + JSUtils.RESIZE_ADJUSTPOSITION_FUNCTION + JSUtils.ADJUSTPOSITION_FUNCTION + "myChart.setOption(option, true);" + JSUtils.SERIES_NUMBERFORMATFUNCTION;
    }
}

