/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.line;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.line.MSLine2DBean;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractLineTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;

public class MSLine2DBeanTransferImpl
extends AbstractLineTransfer<MSLine2DBean> {
    public MSLine2DBeanTransferImpl() {
        super(EChartsType.LINE, CtrlEXTMessages.getMLS("multiSeriesLineChart2D", "\u591a\u7cfb\u52172D\u6298\u7ebf\u56fe"));
    }

    @Override
    public String initScript(MSLine2DBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        double[][] data = (double[][])dataNode.getData();
        EChartUtils.checkChartDataIsNull((Object[])data, dataNode.getGroupKeys(), (String[])dataNode.getSeriesKeys());
        return s;
    }

    @Override
    public Option transfer2Opiton(MSLine2DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        String[] labels = dataNode.getGroupKeys();
        double[][] data = (double[][])dataNode.getData();
        Object[] series = (String[])dataNode.getSeriesKeys();
        if (null != p.getLegend()) {
            p.legend().data(series);
        }
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.name(bean.getChart().yScaleUnit);
        p.yAxis().add(valueAxis);
        CategoryAxis caxis = new CategoryAxis();
        for (String label : labels) {
            caxis.data().add(label);
        }
        for (int i = 0; i < data.length; ++i) {
            Line bar = new Line();
            bar.name((String)series[i]);
            for (int j = 0; j < data[i].length; ++j) {
                bar.data().add(data[i][j]);
            }
            p.series().add(bar);
        }
        p.xAxis().add(caxis);
        return p;
    }

    @Override
    public Option mockOption(MSLine2DBean bean) {
        Option p = super.mockOption(bean);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        CategoryAxis caxis = new CategoryAxis();
        caxis.setData(Arrays.asList("Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"));
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis().add(yAxis);
        p.legend().data(Arrays.asList(CtrlEXTMessages.getMLS("year2020", "2020\u5e74"), CtrlEXTMessages.getMLS("year2021", "2021\u5e74")));
        Line line1 = new Line();
        line1.name(CtrlEXTMessages.getMLS("year2020", "2020\u5e74"));
        line1.setData(Arrays.asList(150, 230, 224, 218, 135, 147, 260));
        EChartUtils.configShowValue(bean, (Series)line1);
        EChartUtils.configTrendline(bean, (Series)line1);
        Line line2 = new Line();
        line2.name(CtrlEXTMessages.getMLS("year2021", "2021\u5e74"));
        line2.setData(Arrays.asList(100, 150, 250, 200, 180, 120, 200));
        EChartUtils.configShowValue(bean, (Series)line2);
        EChartUtils.configTrendLineOnTop(bean, (Series)line2);
        p.series().add(line1);
        p.series().add(line2);
        EChartUtils.configMaxMinValue(bean, p, 260.0, 0.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }
}

