/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.code.LineType;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.SeriesType;
import com.github.abel533.echarts.code.Symbol;
import com.github.abel533.echarts.code.X;
import com.github.abel533.echarts.data.SeriesData;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.MarkArea;
import com.github.abel533.echarts.series.MarkLine;
import com.github.abel533.echarts.series.MarkPoint;
import com.github.abel533.echarts.series.RadarSeries;
import com.github.abel533.echarts.series.Series;
import com.github.abel533.echarts.style.itemstyle.Normal;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.ColorUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.ColorVFPair;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColorComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartTitlePositionComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartTrendLineTypeComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.LegendPositionComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.NumberStyleComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.SortEnum;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.TextScaleComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.TrendLineXLabelPositionComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.TrendLineYLabelPositionComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.PatternNode;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl.DefaultSingleSeriesBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChartType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class EChartUtils {
    private static final Logger log = Logger.getLogger(EChartUtils.class);

    public static Double getChartTopMargin(AbstractFusionBean bean) {
        double topMargin = Double.parseDouble(bean.getChart_chartTopMargin());
        Chart chart = bean.getChart();
        if (!StringUtil.isEmptyString((String)bean.getChartTitle()) || !StringUtil.isEmptyString((String)chart.caption)) {
            topMargin += (double)bean.getChartTitleFontSize().getIntegerValue().intValue();
        }
        if (!StringUtil.isEmptyString((String)bean.getChartDeputyTitle()) || !StringUtil.isEmptyString((String)chart.subCaption)) {
            topMargin += (double)bean.getChartDeputyTitleFontSize().getIntegerValue().intValue();
        }
        return topMargin;
    }

    public static Double getChartRightMargin(AbstractFusionBean bean) {
        double rightMargin = Double.parseDouble(bean.getChart_chartRightMargin());
        if (bean.getChart_showLegend().getBooleanValue().booleanValue() && LegendPositionComboBoxEditor.getRight().equals(bean.getChart_legendPosition())) {
            rightMargin += 10.0;
        }
        return rightMargin;
    }

    public static Double getChartBottomMargin(AbstractFusionBean bean) {
        double bottomMargin = Double.parseDouble(bean.getChart_chartBottomMargin());
        if (bean.getChart_showLegend().getBooleanValue().booleanValue() && LegendPositionComboBoxEditor.getDown().equals(bean.getChart_legendPosition())) {
            bottomMargin += 10.0;
        }
        return bottomMargin;
    }

    public static Double getChartTopMargin(Chart chart) {
        double topMargin = Double.parseDouble(chart.chartTopMargin);
        if (!StringUtil.isEmptyString((String)chart.caption)) {
            topMargin += Double.parseDouble(chart.captionFontSize == null ? "24" : chart.captionFontSize);
        }
        if (!StringUtil.isEmptyString((String)chart.subCaption)) {
            topMargin += Double.parseDouble(chart.subCaptionFontSize == null ? "16" : chart.captionFontSize);
        }
        return topMargin;
    }

    public static String getFormatter(boolean showValue, String showType) {
        String formatter = "{d}%";
        if (showValue) {
            if (NumberStyleComboBoxEditor.getShowTypePercent().equals(showType)) {
                formatter = "{d}%";
            } else if (NumberStyleComboBoxEditor.getShowTypeNumber().equals(showType)) {
                formatter = "{c}";
            } else if (NumberStyleComboBoxEditor.getShowTypeBoth().equals(showType)) {
                formatter = "{c} {d}%";
            } else if (NumberStyleComboBoxEditor.getShowTypeLablePercent().equals(showType)) {
                formatter = "{b} {d}%";
            }
        } else {
            formatter = "{b}";
        }
        return formatter;
    }

    public static Series configTrendline(AbstractFusionBean bean, Series bar) {
        String xMinValue;
        String xMaxValue;
        String trendlineStartValue = bean.getTrendlineStartValue();
        String trendlineEndValue = bean.getTrendlineEndValue();
        int size = bar.data().size() - 1;
        if (EChartUtils.isDoubleYChart(bean.getChartType())) {
            xMaxValue = String.valueOf(size);
            xMinValue = "0";
        } else {
            xMaxValue = bean.getChartXStartValue() == null ? String.valueOf(size) : bean.getChartXStartValue();
            String string = xMinValue = bean.getChartXEndValue() == null ? "0" : bean.getChartXEndValue();
        }
        if (bean.getChartXStartValue() == null && bean.getChartType() == FlashChartType.FLASH_CT_BUBBLE) {
            xMaxValue = "35";
        }
        if (bean.getChartXEndValue() == null && bean.getChartType() == FlashChartType.FLASH_CT_BUBBLE) {
            xMinValue = "0";
        }
        if (bean.getChartXStartValue() == null && bean.getChartType() == FlashChartType.FLASH_CT_SCATTER) {
            xMaxValue = "15";
        }
        if (bean.getChartXEndValue() == null && bean.getChartType() == FlashChartType.FLASH_CT_SCATTER) {
            xMinValue = "0";
        }
        if (trendlineStartValue != null && trendlineEndValue != null) {
            String color = ColorUtil.colorToHexStr((Color)bean.getTrendlineColor().getColorValue());
            if (bean.getTrendlineTrendzone().getBooleanValue().booleanValue()) {
                String value;
                MarkArea markArea = bar.markArea();
                markArea.itemStyle().color((Object)color);
                markArea.label().color(color);
                markArea.label().show(Boolean.valueOf(true));
                markArea.tooltip().formatter((Object)"{b}");
                String string = value = bean.getTrendlineDisplayValue() == null ? "" : bean.getTrendlineDisplayValue();
                if (EChartUtils.isKindofBarChart(bean)) {
                    markArea.data(new Object[]{new Var("[{name:'" + value + "',coord:[" + trendlineStartValue + ", " + xMinValue + "]},{coord:[" + trendlineEndValue + ", " + xMaxValue + "]}]")});
                } else {
                    markArea.data(new Object[]{new Var("[{name:'" + value + "',coord:[" + xMinValue + ", " + trendlineStartValue + "]},{coord:[" + xMaxValue + ", " + trendlineEndValue + "]}]")});
                }
            } else {
                String value;
                MarkLine markLine = bar.markLine();
                markLine.lineStyle().opacity(Double.valueOf(0.5));
                markLine.itemStyle().color((Object)color);
                markLine.label().color(color);
                markLine.label().position(Position.start);
                markLine.tooltip().formatter((Object)"{b}");
                String string = value = bean.getTrendlineDisplayValue() == null ? "" : bean.getTrendlineDisplayValue();
                if (EChartUtils.isKindofBarChart(bean)) {
                    markLine.data(new Object[]{new Var("[{name:'" + value + "',coord:[" + trendlineStartValue + ", " + xMinValue + "],symbol: 'none'},{coord:[" + trendlineEndValue + ", " + xMaxValue + "], symbol: 'none'}]")});
                } else {
                    markLine.data(new Object[]{new Var("[{name:'" + value + "',coord:[" + xMinValue + ", " + trendlineStartValue + "],symbol: 'none'},{coord:[" + xMaxValue + ", " + trendlineEndValue + "], symbol: 'none'}]")});
                }
                if (ChartTrendLineTypeComboBoxEditor.getFullLine().equals(bean.getTrendlineDashed())) {
                    markLine.lineStyle().type(LineType.solid);
                } else {
                    markLine.lineStyle().type(LineType.dotted);
                }
            }
            if (bean.getTrendlineOnTop().getBooleanValue().booleanValue()) {
                bar.z(Integer.valueOf(0));
            } else {
                bar.z(Integer.valueOf(1));
            }
            if (EChartUtils.isTrendlineLabelPostionRight(bean.getTrendlineDisplayRight())) {
                bar.markLine().label().position(Position.end);
            }
            MarkPoint markPoint = bar.markPoint();
            markPoint.symbol((Object)"pin");
            markPoint.symbolSize((Object)1);
            markPoint.label().color(color);
            if (bean.getShowTrendLineValue().getBooleanValue().booleanValue()) {
                if (EChartUtils.isKindofBarChart(bean)) {
                    markPoint.data(new Object[]{new Var("{value:'" + trendlineStartValue + "',coord:[" + trendlineStartValue + ", " + xMinValue + "], symbolOffset:[-15,-15]},{value:'" + trendlineEndValue + "',coord:[" + trendlineEndValue + "," + xMaxValue + "], symbolOffset:[15,15]}")});
                } else {
                    markPoint.data(new Object[]{new Var("{value:'" + trendlineStartValue + "',coord:[" + xMinValue + ", " + trendlineStartValue + "], symbolOffset:[15,15]},{value:'" + trendlineEndValue + "',coord:[" + xMaxValue + ", " + trendlineEndValue + "], symbolOffset:[-15,-15]}")});
                }
            }
        }
        return bar;
    }

    public static void configTrendLineOnTop(AbstractFusionBean bean, Series bar) {
        if (bean.getTrendlineOnTop().getBooleanValue().booleanValue() && bean.getTrendlineTrendzone().getBooleanValue().booleanValue()) {
            bar.z(Integer.valueOf(0));
        } else {
            bar.z(Integer.valueOf(1));
        }
    }

    public static void configRhombusTrendLineOnTop(AbstractFusionBean bean, Series pbar) {
        if (bean.getTrendlineOnTop().getBooleanValue().booleanValue() && bean.getTrendlineTrendzone().getBooleanValue().booleanValue()) {
            pbar.z(Integer.valueOf(0));
        } else {
            pbar.z(Integer.valueOf(2));
        }
    }

    public static Axis configAxisText(AbstractFusionBean bean, Axis caxis) {
        if (TextScaleComboBoxEditor.getXAxsisTextStyleSlant().equals(bean.getTextScale())) {
            caxis.axisLabel().rotate(Integer.valueOf(45));
        } else if (TextScaleComboBoxEditor.getXAxsisTextStyleStagger().equals(bean.getTextScale())) {
            caxis.axisLabel().formatter((Object)"function(value, index){ if(index % 2 == 0) {return '\n' + value;} return value;}");
        }
        caxis.axisLabel().textStyle().fontFamily(bean.getChartBaseFontName());
        caxis.axisLabel().textStyle().setFontSize(bean.getChartBaseFontSize().getIntegerValue());
        return caxis;
    }

    public static Axis configAxisLucency(AbstractFusionBean bean, Axis axis, boolean isLeftAxis) {
        axis.splitLine().lineStyle().opacity(Double.valueOf((double)bean.getChart_divLineAlpha().getIntegerValue().intValue() / 100.0));
        axis.splitArea().show(Boolean.valueOf(true));
        axis.splitArea().areaStyle().opacity(Double.valueOf((double)bean.getChart_alternateHGridAlpha().getIntegerValue().intValue() / 100.0));
        if (isLeftAxis) {
            axis.name(bean.getChartYScaleUnit());
        } else {
            axis.name(bean.getChart_xUnitText());
        }
        if (!bean.getChart_showYAxisValues().getBooleanValue().booleanValue()) {
            axis.axisLabel().show(Boolean.valueOf(false));
        }
        Var axisNumberFormatFunctionVar = EChartUtils.isKindofBarChart(bean) ? JSUtils.getValueAxisNumberFormatFunctionVar(false, null) : JSUtils.getValueAxisNumberFormatFunctionVar(true, null);
        axis.axisLabel().formatter((Object)axisNumberFormatFunctionVar);
        axis.axisLabel().textStyle().fontFamily(bean.getChartBaseFontName());
        axis.axisLabel().textStyle().setFontSize(bean.getChartBaseFontSize().getIntegerValue());
        return axis;
    }

    public static Series configShowValue(AbstractFusionBean bean, Series bar) {
        if ((bar instanceof Line || bar instanceof RadarSeries) && !bean.getChart_drawAnchors().getBooleanValue().booleanValue()) {
            bar.symbol(Symbol.none);
        }
        if (bar instanceof Line && bean.getChart_smoothCurve().getBooleanValue().booleanValue()) {
            ((Line)bar).smooth(Boolean.valueOf(true));
        }
        if (bean.getChart_showValues().getBooleanValue().booleanValue()) {
            bar.label().normal().show(Boolean.valueOf(true));
            bar.symbol(Symbol.emptyCircle);
            bar.label().normal().color((Object)"#000");
            Var format = JSUtils.getSeriesNumberFormatFunctionVar(true, "");
            bar.label().normal().formatter((Object)format);
            if (EChartUtils.isKindofBarChart(bean)) {
                if (!EChartUtils.isKindof3DOrSTChart(bean)) {
                    bar.label().normal().position(Position.right);
                }
            } else if (!EChartUtils.isKindof3DOrSTChart(bean)) {
                bar.label().normal().position(Position.top);
            }
        } else {
            bar.label().normal().show(Boolean.valueOf(false));
        }
        return bar;
    }

    public static Series configAngleRound(AbstractFusionBean bean, Series bar) {
        Normal normal = bar.itemStyle().normal();
        if (bean.getChart_useRoundEdges().getBooleanValue().booleanValue()) {
            if (EChartUtils.isKindofBarChart(bean)) {
                normal.setBarBorderRadius(Arrays.asList(0, 10, 10, 0));
            } else {
                normal.setBarBorderRadius(Arrays.asList(10, 10, 0, 0));
            }
        }
        bar.itemStyle().normal(normal);
        return bar;
    }

    public static Series configPlotBorder(AbstractFusionBean bean, Series bar) {
        int width;
        Normal normal = bar.itemStyle().getNormal();
        String color = bean.getChart_borderColor() == null ? "#000000" : ColorUtil.colorToHexStr((Color)bean.getChart_borderColor().getColorValue());
        int n = width = bean.getChart_borderThickness() == null ? 1 : bean.getChart_borderThickness().getIntegerValue();
        if (bar instanceof RadarSeries) {
            if (!bean.getChart_showPlotBorder().getBooleanValue().booleanValue()) {
                RadarSeries series = (RadarSeries)bar;
                series.lineStyle().width(Integer.valueOf(0));
            } else {
                RadarSeries series = (RadarSeries)bar;
                series.lineStyle().color((Object)color);
                series.lineStyle().width(Integer.valueOf(width));
            }
            return bar;
        }
        if (bean.getChart_showPlotBorder().getBooleanValue().booleanValue()) {
            if (normal == null) {
                normal = new Normal();
            }
            if (bar instanceof Line) {
                bar.symbol(Symbol.emptyCircle);
                if (null != ((Line)bar).getAreaStyle()) {
                    ((Line)bar).lineStyle().color((Object)color);
                    ((Line)bar).lineStyle().width(Integer.valueOf(width));
                }
            } else {
                normal.setBorderColor(color);
                normal.borderWidth(Integer.valueOf(width));
            }
            bar.itemStyle().setNormal(normal);
        }
        return bar;
    }

    public static Series configPlotBorder(Chart chart, Series bar) {
        Normal normal = bar.itemStyle().getNormal();
        if (bar instanceof RadarSeries) {
            if ("1".equals(chart.showPlotBorder)) {
                RadarSeries series = (RadarSeries)bar;
                series.lineStyle().width(Integer.valueOf(0));
            }
            return bar;
        }
        if ("1".equals(chart.showPlotBorder)) {
            if (normal == null) {
                normal = new Normal();
            }
            normal.setBorderColor(chart.borderColor == null ? "#000000" : ColorUtil.colorToHexStr((Color)EChartUtils.transformColor(chart.borderColor).getColorValue()));
            normal.borderWidth(Integer.valueOf(chart.borderThickness == null ? 1 : Integer.parseInt(chart.borderThickness)));
            if (bar instanceof Line) {
                bar.symbol(Symbol.emptyCircle);
            }
            bar.itemStyle().setNormal(normal);
        }
        return bar;
    }

    public static Option configBorder(AbstractFusionBean bean, Option p) {
        if (bean.getChart_canvasBorderAlpha().getBooleanValue().booleanValue()) {
            p.grid().show(Boolean.valueOf(true));
            p.grid().borderColor("#000");
            p.grid().borderWidth(bean.getChart_canvasBorderThickness().getIntegerValue());
        }
        return p;
    }

    public static Option configMaxMinValue(AbstractFusionBean bean, Option p, Double max, Double min) {
        double maxValue = 0.0;
        double minValue = 0.0;
        if (bean.getChartYEndValue() != null) {
            minValue = Double.parseDouble(bean.getChartYEndValue());
            min = minValue;
        }
        if (bean.getChartYStartValue() != null) {
            maxValue = Double.parseDouble(bean.getChartYStartValue());
            max = maxValue;
        }
        if (bean.getTrendlineStartValue() != null && bean.getTrendlineEndValue() != null) {
            double startValue = Double.parseDouble(bean.getTrendlineStartValue());
            double endValue = Double.parseDouble(bean.getTrendlineEndValue());
            maxValue = Math.max(Math.max(startValue, endValue), maxValue);
            minValue = Math.min(Math.min(startValue, endValue), minValue);
        }
        if (max <= maxValue) {
            if (((Axis)p.yAxis().get(0)).data().size() == 0) {
                ((Axis)p.yAxis().get(0)).max(Double.valueOf(maxValue));
            } else {
                ((Axis)p.xAxis().get(0)).max(Double.valueOf(maxValue));
            }
        }
        if (minValue <= min) {
            if (((Axis)p.yAxis().get(0)).data().size() == 0) {
                ((Axis)p.yAxis().get(0)).min(Double.valueOf(minValue));
            } else {
                ((Axis)p.xAxis().get(0)).min(Double.valueOf(minValue));
            }
        }
        return p;
    }

    public static void configRightAxisMaxMinValue(AbstractFusionBean bean, Axis axis) {
        axis.max((Object)bean.getChartXStartValue());
        axis.min((Object)bean.getChartXEndValue());
    }

    public static Option configSort(DefaultSingleSeriesBean bean, Option p) {
        if (SortEnum.NORMAL == bean.getSortType()) {
            return p;
        }
        List arr = new ArrayList(8);
        arr = ((Axis)p.yAxis().get(0)).data().size() == 0 ? ((Axis)p.xAxis().get(0)).data() : ((Axis)p.yAxis().get(0)).data();
        List data = ((Series)p.series().get(0)).data();
        ArrayList oldData = new ArrayList(8);
        EChartUtils.addAll(oldData, new Object[data.size()]);
        Collections.copy(oldData, data);
        if (SortEnum.ASC == bean.getSortType()) {
            if (data.get(0) instanceof SeriesData) {
                data.sort((o1, o2) -> Double.compare(Math.abs(new Double(((SeriesData)o1).getValue().toString())), Math.abs(new Double(((SeriesData)o2).getValue().toString()))));
            } else {
                data.sort((o1, o2) -> Double.compare(Math.abs(new Double(o1.toString())), Math.abs(new Double(o2.toString()))));
            }
        } else if (SortEnum.DESC == bean.getSortType()) {
            if (data.get(0) instanceof SeriesData) {
                data.sort((o1, o2) -> Double.compare(Math.abs(new Double(((SeriesData)o2).getValue().toString())), Math.abs(new Double(((SeriesData)o1).getValue().toString()))));
            } else {
                data.sort((o1, o2) -> Double.compare(Math.abs(new Double(o2.toString())), Math.abs(new Double(o1.toString()))));
            }
        }
        ArrayList oldArr = new ArrayList(8);
        EChartUtils.addAll(oldArr, new Object[arr.size()]);
        Collections.copy(oldArr, arr);
        for (int i = 0; i < data.size(); ++i) {
            arr.set(i, oldArr.get(oldData.indexOf(data.get(i))));
        }
        if (EChartUtils.isKindof3DOrSTChart(bean) && p.series().size() > 1) {
            ((Series)p.series().get(1)).setData(data);
        }
        return p;
    }

    public static void addAll(Collection collection, Object[] elements) {
        int size = elements.length;
        for (int i = 0; i < size; ++i) {
            collection.add(elements[i]);
        }
    }

    public static String getNumberFormatAndTipsFormat(AbstractFusionBean bean) {
        PatternNode node = NumberFormatTemplateEditor.parsePattern(bean.getDataLabelFormat() == null ? bean.getChartNumberFormat().getXmlValue() : bean.getDataLabelFormat().getXmlValue(), null, null);
        String prefix = node.getPrefix();
        String suffix = node.getSuffix();
        String rSuffix = node.getrSuffix();
        String optionJS = String.format("var formatterOption ={format:'%s',overrideGroupSep:'%s',overrideDecSep:'%s',overrideNegSign:'%s',isPercentage:%b,locale:'cn'};", node.getPatternWithoutPS(), Character.valueOf(node.getThousandSeparator()), Character.valueOf(node.getDecimalSeparator()), Character.valueOf('-'), node.isPercentNumber()) + "var prefix = \"" + prefix + "\";var suffix = \"" + suffix + "\";var rSuffix = \"" + rSuffix + "\";";
        node = NumberFormatTemplateEditor.parsePattern(bean.getChartNumberFormat().getXmlValue(), bean.getNumberPrefix(), bean.getChart_numberSuffix());
        String optionValueJS = String.format("var formatterValueOption ={format:'%s',overrideGroupSep:'%s',overrideDecSep:'%s',overrideNegSign:'%s',isPercentage:%b,prefix:'%s',suffix:'%s',locale:'cn'};", node.getPatternWithoutPS(), Character.valueOf(node.getThousandSeparator()), Character.valueOf(node.getDecimalSeparator()), Character.valueOf('-'), node.isPercentNumber(), node.getPrefix(), node.getSuffix());
        node = NumberFormatTemplateEditor.parsePattern(bean.getYAxisFormat() == null ? bean.getChartNumberFormat().getXmlValue() : bean.getYAxisFormat().getXmlValue(), null, null);
        String optionYAxisJS = String.format("var formatterYAxisOption ={format:'%s',overrideGroupSep:'%s',overrideDecSep:'%s',overrideNegSign:'%s',isPercentage:%b,prefix:'%s',suffix:'%s',locale:'cn'};", node.getPatternWithoutPS(), Character.valueOf(node.getThousandSeparator()), Character.valueOf(node.getDecimalSeparator()), Character.valueOf('-'), node.isPercentNumber(), node.getPrefix(), node.getSuffix());
        node = NumberFormatTemplateEditor.parsePattern(bean.getXAxisFormat() == null ? bean.getChartNumberFormat().getXmlValue() : bean.getXAxisFormat().getXmlValue(), null, null);
        String optionXAxisJS = String.format("var formatterXAxisOption ={format:'%s',overrideGroupSep:'%s',overrideDecSep:'%s',overrideNegSign:'%s',isPercentage:%b,prefix:'%s',suffix:'%s',locale:'cn'};", node.getPatternWithoutPS(), Character.valueOf(node.getThousandSeparator()), Character.valueOf(node.getDecimalSeparator()), Character.valueOf('-'), node.isPercentNumber(), node.getPrefix(), node.getSuffix());
        return JSUtils.NUMBERFORMATFUNCTION_TEMPLATE + JSUtils.SERIES_NUMBERFORMATFUNCTION + optionJS + optionValueJS + optionYAxisJS + optionXAxisJS + JSUtils.TOOLTIPS_NUMBERFORMATFUNCTION + JSUtils.VALUEAXIS_NUMBERFORMATFUNCTION;
    }

    public static Option hideDrawRB(AbstractFusionBean bean, Option p, double max) {
        max = EChartUtils.isKindofBarChart(bean) ? (((Axis)p.xAxis().get(0)).max() == null ? max : (Double)((Axis)p.xAxis().get(0)).max()) : (((Axis)p.yAxis().get(0)).max() == null ? max : (Double)((Axis)p.yAxis().get(0)).max());
        for (int i = 0; i < p.series().size(); ++i) {
            Series series = (Series)p.series().get(i);
            if (!SeriesType.pictorialBar.equals((Object)series.type())) continue;
            List data = series.data();
            for (int d = 0; d < data.size(); ++d) {
                if (!((Double)data.get(d) > max)) continue;
                data.set(d, max);
            }
        }
        return p;
    }

    public static String getPlotGradientColor(boolean isY, boolean isX, List<Color> colorList) {
        String colorStopStr = "";
        String colorStopStrBlowZero = "";
        if (isY) {
            colorStopStr = TransferUtils.buildGradualChangeColorStops("G", colorList.size(), 0, 1, 0, 0);
            colorStopStrBlowZero = TransferUtils.buildGradualChangeColorStops("B", colorList.size(), 0, 0, 0, 1);
        } else if (isX) {
            colorStopStr = TransferUtils.buildGradualChangeColorStops("G", colorList.size(), 0, 0, 1, 0);
            colorStopStrBlowZero = TransferUtils.buildGradualChangeColorStops("B", colorList.size(), 1, 0, 0, 0);
        }
        return colorStopStr + colorStopStrBlowZero + TransferUtils.buildColorStopNames("plotGradientColorsB", "B", colorList.size()) + TransferUtils.buildColorStopNames("plotGradientColors", "G", colorList.size());
    }

    public static void configPlotGradientColor(AbstractFusionBean bean, Option p) {
        if (ChartFillColorComboBoxEditor.getGradient().equals(bean.getChart_plotGradientColor())) {
            p.color((Object)new Var("plotGradientColors"));
        }
    }

    public static boolean isKindof3DOrSTChart(AbstractFusionBean bean) {
        return bean.getChartType() == FlashChartType.FLASH_CT_COLUMN3D || bean.getChartType() == FlashChartType.FLASH_CT_MS_COLUMN3D || bean.getChartType() == FlashChartType.FLASH_CT_ST_COL3D || bean.getChartType() == FlashChartType.FLASH_CT_ST_BAR3D || bean.getChartType() == FlashChartType.FLASH_CT_MS_BAR3D || bean.getChartType() == FlashChartType.FLASH_CT_COMBI3D || bean.getChartType() == FlashChartType.FLASH_CT_COL3D_LINE_DY || bean.getChartType() == FlashChartType.FLASH_CT_COL3D_LINE || bean.getChartType() == FlashChartType.FLASH_CT_ST_COL3DLINE_DY || bean.getChartType() == FlashChartType.FLASH_CT_ST_AREA2D || bean.getChartType() == FlashChartType.FLASH_CT_ST_BAR2D || bean.getChartType() == FlashChartType.FLASH_CT_ST_COL2D || bean.getChartType() == FlashChartType.FLASH_CT_ST_MS_COL2D || bean.getChartType() == FlashChartType.FLASH_CT_ST_MS_COL2DLINE_DY || bean.getChartType() == FlashChartType.FLASH_CT_SCROLL_ST_COLUMN2D;
    }

    public static boolean isKindofBarChart(AbstractFusionBean bean) {
        return bean.getChartType() == FlashChartType.FLASH_CT_BAR2D || bean.getChartType() == FlashChartType.FLASH_CT_ST_BAR2D || bean.getChartType() == FlashChartType.FLASH_CT_MS_BAR3D || bean.getChartType() == FlashChartType.FLASH_CT_ST_BAR3D || bean.getChartType() == FlashChartType.FLASH_CT_MS_BAR2D;
    }

    public static X transformTextAlign(String align) {
        if (ChartTitlePositionComboBoxEditor.getRight().equals(align)) {
            return X.right;
        }
        if (ChartTitlePositionComboBoxEditor.getLeft().equals(align)) {
            return X.left;
        }
        return X.center;
    }

    public static ColorVFPair transformColor(String color) {
        if (StringUtil.isEmptyString((String)color)) {
            return new ColorVFPair(new Color(0, 0, 0, 0), null);
        }
        String[] colorItems = color.split(";");
        if (colorItems.length > 3) {
            return new ColorVFPair(new Color(Integer.parseInt(colorItems[0]), Integer.parseInt(colorItems[1]), Integer.parseInt(colorItems[2]), Integer.parseInt(colorItems[3])), null);
        }
        return new ColorVFPair(new Color(Integer.parseInt(colorItems[0]), Integer.parseInt(colorItems[1]), Integer.parseInt(colorItems[2]), 255), null);
    }

    public static boolean hasHeteroChart(AbstractFusionBean bean) {
        return bean.getChartType() == FlashChartType.FLASH_CT_BAR2D || bean.getChartType() == FlashChartType.FLASH_CT_COLUMN2D;
    }

    public static boolean isDoubleYChart(FlashChartType chartType) {
        return chartType == FlashChartType.FLASH_CT_COMBI2D_DY || chartType == FlashChartType.FLASH_CT_COL3D_LINE_DY || chartType == FlashChartType.FLASH_CT_ST_COL3DLINE_DY || chartType == FlashChartType.FLASH_CT_ST_MS_COL2DLINE_DY || chartType == FlashChartType.FLASH_CT_SCROLL_COMBI2D_DY || chartType == QingChartType.QING_CT_COMBINA || chartType == QingChartType.QING_CT_MS_COMBINA;
    }

    public static boolean isTrendlineLabelPostionRight(String str) {
        return TrendLineYLabelPositionComboBoxEditor.getRight().equals(str) || TrendLineXLabelPositionComboBoxEditor.getTop().equals(str);
    }

    public static void checkChartDataIsNull(Object[] data, Object[] labels) {
        if (data == null || data.length == 0) {
            throw new RuntimeException(CtrlEXTMessages.getMLS("dataEmpty", "\u6570\u636e\u4e3a\u7a7a"));
        }
        if (labels == null || labels.length == 0) {
            throw new RuntimeException(CtrlEXTMessages.getMLS("categoryEmpty", "\u5206\u7c7b\u4e3a\u7a7a"));
        }
    }

    public static void checkChartDataIsNull(Object[] data, Object[] labels, Object[] series) {
        if (data == null || data.length == 0) {
            throw new RuntimeException(CtrlEXTMessages.getMLS("dataEmpty", "\u6570\u636e\u4e3a\u7a7a"));
        }
        if (labels == null || labels.length == 0) {
            throw new RuntimeException(CtrlEXTMessages.getMLS("categoryEmpty", "\u5206\u7c7b\u4e3a\u7a7a"));
        }
        if (series == null || series.length == 0) {
            throw new RuntimeException(CtrlEXTMessages.getMLS("seriesEmpty", "\u7cfb\u5217\u4e3a\u7a7a"));
        }
    }
}

