/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart;

import com.kingdee.cosmic.ctrl.common.util.ReflectUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.NullValueDisplayModeEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.color.ColorTemplateEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.chart.AbstractType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.chart.ChartDataNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;

public class FusionChartDataNode
extends ChartDataNode
implements Cloneable {
    private Sheet sheet;
    private boolean hasHour = false;
    public static int TRENDLINES = 0;
    public static int STYLES = 1;
    public static int CHART_CAPTION = 2;
    public static int GANTT_TASK_NAME = 3;
    public static int GANTT_TASK_START = 4;
    public static int GANTT_TASK_END = 5;
    public static int GANTT_TASK_START_PLAN = 6;
    public static int GANTT_TASK_END_PLAN = 7;
    public static int GANTT_TASK_FORMERID = 8;
    public static int GANTT_TASK_PARENTID = 9;
    public static int GANTT_TASK_WORKLOAD = 10;
    public static int GANTT_FINISHED_PERCENT = 11;
    public static int XY_X = 12;
    public static int XY_Y = 13;
    public static int XY_Z = 14;
    public static int GANTT_TASK_ID = 15;
    public static int GANTT_TITLE_GROUP = 16;
    public static int NullCellType = 17;
    public static int HideCellType = 18;
    public static int GroupRule = 19;
    public static int XY_Group = 20;
    public static int XY_Series = 21;
    public static int XY_DISTANCE = 22;
    public static int HYPERLINKPROPERTIES = 23;
    public static int FUSIONCHARTDATANODE_ID = 24;
    public static int CHART_ID = 25;
    public static int HYPERLINKDEFINE = 26;
    public static int COMBINATION_CHART_SERIES_TYPE = 27;
    public static int COMBINATION_CHART_SERIES_FORMULA = 28;
    public static int COMBINATION_CHART_DATA_FORMULA = 29;
    public static int COMBINATION_CHART_GROUP_FORMULA = 30;
    public static int COMBINATION_CHART_SERIES_NAMES = 31;
    public static int COMBINATION_CHART_PARENTYAXIS = 32;
    public static int COMBINATION_CHART_RIGHT_YAXIS_SETTINGS = 33;
    public static int GANTT_CHART_CAPTION = 34;
    public static int DASHBOARD_CHART_NEEDLE_FORMULA = 35;
    public static int DASHBOARD_CHART_NEEDLE_GROUP_FORMULA = 36;
    public static int XY_MAX_MIN = 37;
    private Object[] Formula_Array = new Object[64];
    private Object[] Result_Array = new Object[64];
    private boolean dirty = true;
    private String colorXML = ColorTemplateEditor.getSystemQingchartsTemplate();
    private String numberFormatXML = NumberFormatTemplateEditor.getCommonFormatXML();
    private String xyRestrictionXML = "<?xml version='1.0' encoding='gbk'?><template><x type='max' value=''/><x type='min' value=''/><y type='max' value=''/><y type='min' value=''/></template>";
    private int _angle;
    public static final String EXT_EXECUTED = "EXT_EXECUTED";

    public FusionChartDataNode(Sheet sheet) {
        super(sheet);
        this.setSerialByCol(true);
        this.sheet = sheet;
        this.setFormula("1:1:1", HYPERLINKPROPERTIES);
    }

    public void setFormula(String formula, int flag) {
        this.setFormula((Object)formula, flag);
    }

    public void clearFormula(int flag) {
        if (flag >= this.Formula_Array.length) {
            return;
        }
        this.Formula_Array[flag] = null;
    }

    public void setFormula(String[] fixArr, int flag) {
        this.setFormula((Object)fixArr, flag);
    }

    private void setFormula(Object formula, int flag) {
        if (flag >= this.Formula_Array.length) {
            Object[] dest1 = new Object[flag * 2];
            Object[] dest2 = new Object[flag * 2];
            System.arraycopy(this.Formula_Array, 0, dest1, 0, this.Formula_Array.length);
            System.arraycopy(this.Result_Array, 0, dest2, 0, this.Result_Array.length);
            this.Formula_Array = dest1;
            this.Result_Array = dest2;
        }
        if (formula == null) {
            this.Formula_Array[flag] = null;
            return;
        }
        if (formula.getClass().isArray()) {
            int size = Array.getLength(formula);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < size; ++i) {
                Expr expr = this.parseFormula((String)Array.get(formula, i));
                if (expr != null && !expr.isSyntaxError()) {
                    list.add(expr);
                    continue;
                }
                list.add(Array.get(formula, i));
            }
            Object[] arr = new Object[size];
            list.toArray(arr);
            this.Formula_Array[flag] = arr;
        } else {
            Expr expr = this.parseFormula((String)formula);
            this.Formula_Array[flag] = expr != null && !expr.isSyntaxError() ? expr : formula;
        }
    }

    public void setResult(Object formula, int flag) {
        if (flag >= this.Result_Array.length) {
            Object[] dest1 = new Object[flag * 2];
            System.arraycopy(this.Result_Array, 0, dest1, 0, this.Result_Array.length);
            this.Result_Array = dest1;
        }
        if (formula == null) {
            this.Result_Array[flag] = null;
            return;
        }
        if (formula.getClass().isArray()) {
            int size = Array.getLength(formula);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < size; ++i) {
                list.add(Array.get(formula, i));
            }
            Object[] arr = new Object[size];
            list.toArray(arr);
            this.Result_Array[flag] = arr;
        } else {
            this.Result_Array[flag] = formula;
        }
    }

    public Object getFormula(int flag) {
        String[] ret = null;
        int formulaLen = this.Formula_Array.length;
        if (flag >= formulaLen || this.Formula_Array[flag] == null) {
            return null;
        }
        if (this.Formula_Array[flag].getClass().isArray()) {
            int size = Array.getLength(this.Formula_Array[flag]);
            ExprContext ctx = this.sheet.getDeps().getExprContext();
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < size; ++i) {
                Object formula = Array.get(this.Formula_Array[flag], i);
                if (formula instanceof Expr) {
                    formula = ((Expr)formula).decode(ctx, this);
                }
                list.add(formula);
            }
            String[] arr = new String[size];
            list.toArray(arr);
            ret = arr;
        } else {
            String[] formula = this.Formula_Array[flag];
            if (formula instanceof Expr) {
                formula = ((Expr)formula).decode(this.sheet.getDeps().getExprContext(), this);
            }
            ret = formula;
        }
        return ret;
    }

    public Object getResult(int flag) {
        int formulaLen = this.Result_Array.length;
        if (flag >= formulaLen || this.Result_Array[flag] == null) {
            return null;
        }
        return this.Result_Array[flag];
    }

    private void calc() {
        if (!this.dirty) {
            return;
        }
        ArrayList<Variant[][]> buffer = new ArrayList<Variant[][]>();
        int formulaLength = this.Formula_Array.length;
        for (int i = 0; i < formulaLength; ++i) {
            if (this.Formula_Array[i] == null) continue;
            if (this.Formula_Array[i].getClass().isArray()) {
                int len = Array.getLength(this.Formula_Array[i]);
                for (int j = 0; j < len; ++j) {
                    Object formula = Array.get(this.Formula_Array[i], j);
                    formula = formula instanceof Expr ? this.calcExpr(this, (Expr)formula, i) : new Variant[][]{{new Variant(formula)}};
                    buffer.add((Variant[][])formula);
                }
                this.Result_Array[i] = buffer.toArray();
                buffer.clear();
                continue;
            }
            if (this.Formula_Array[i] instanceof Expr) {
                this.Result_Array[i] = new Object[]{this.calcExpr(this, (Expr)this.Formula_Array[i], i)};
                continue;
            }
            if (StringUtil.isEmptyString((String)this.Formula_Array[i].toString())) continue;
            this.Result_Array[i] = new Object[]{new Variant[][]{{new Variant(this.Formula_Array[i])}}};
        }
        this.dirty = false;
    }

    public Object getData(int flag) {
        this.calc();
        return this.Result_Array[flag];
    }

    public int getFormulaSize() {
        return this.Formula_Array.length;
    }

    public int getResultSize() {
        return this.Result_Array.length;
    }

    public void setDateFormat(boolean hasHour) {
        this.hasHour = hasHour;
    }

    public boolean getDateFormat() {
        return this.hasHour;
    }

    public void setSingleDatasetFormula(String formula) {
        super.setDataFormula(formula);
    }

    public long getExprTag() {
        return 0L;
    }

    public long setExprTag(long tag) {
        return 0L;
    }

    @Override
    public void setAngle(int angle) {
        this._angle = angle;
    }

    @Override
    public int getAngle() {
        return this._angle;
    }

    public Object clone() {
        int i;
        FusionChartDataNode node = new FusionChartDataNode(this.sheet);
        Field[] f = node.getClass().getDeclaredFields();
        Field[] f1 = this.getClass().getDeclaredFields();
        int len = f.length;
        for (i = 0; i < len; ++i) {
            ReflectUtil.makeAccessible((Field)f[i]);
            ReflectUtil.makeAccessible((Field)f1[i]);
            try {
                Object obj = f1[i].get(this);
                if (obj != null && obj.getClass().isArray()) {
                    int arrLen = Array.getLength(obj);
                    Object[] newArray = new Object[arrLen];
                    for (int j = arrLen - 1; j >= 0; --j) {
                        Object[] thr = Array.get(obj, j);
                        if (thr != null && thr.getClass().isArray()) {
                            int thrLen = Array.getLength(thr);
                            Object[] thrArray = new Object[thrLen];
                            for (int k = thrLen - 1; k >= 0; --k) {
                                Array.set(thrArray, k, Array.get(thr, k));
                            }
                            thr = thrArray;
                        }
                        Array.set(newArray, j, thr);
                    }
                    f[i].set(node, newArray);
                    continue;
                }
                f[i].set(node, obj);
                continue;
            }
            catch (SecurityException se) {
                if (!MiscUtil.shouldLog()) continue;
                MiscUtil.log(se);
                continue;
            }
            catch (IllegalArgumentException iae) {
                if (!MiscUtil.shouldLog()) continue;
                MiscUtil.log(iae);
                continue;
            }
            catch (IllegalAccessException laae) {
                if (!MiscUtil.shouldLog()) continue;
                MiscUtil.log(laae);
            }
        }
        f = node.getClass().getSuperclass().getDeclaredFields();
        f1 = this.getClass().getSuperclass().getDeclaredFields();
        len = f.length;
        for (i = 0; i < len; ++i) {
            try {
                ReflectUtil.makeAccessible((Field)f[i]);
                ReflectUtil.makeAccessible((Field)f1[i]);
                f[i].set(node, f1[i].get(this));
                continue;
            }
            catch (SecurityException se) {
                if (!MiscUtil.shouldLog()) continue;
                MiscUtil.log(se);
                continue;
            }
            catch (IllegalArgumentException iae) {
                if (!MiscUtil.shouldLog()) continue;
                MiscUtil.log(iae);
                continue;
            }
            catch (IllegalAccessException laae) {
                if (!MiscUtil.shouldLog()) continue;
                MiscUtil.log(laae);
            }
        }
        return node;
    }

    public Variant[][] calcExpr(FusionChartDataNode fusionNode, String formula, int flag) {
        if (StringUtil.isEmptyString((String)formula)) {
            return null;
        }
        return this.calcExpr(fusionNode, this.parseFormula(formula), flag);
    }

    private Variant[][] calcExpr(FusionChartDataNode fusionNode, Expr expr, int flag) {
        Sheet sheet = fusionNode.getSheet();
        ExprContext ctx = sheet.getDeps().getExprContext();
        ICalculable calcOwner = this.getCalcOwner(expr);
        Object ret = null;
        if (calcOwner != null) {
            Variant var;
            Object value;
            ExtProps ep;
            ExtDataSetManager dm = sheet.getBook().getDataSetManager();
            dm.resetCurrent();
            if (calcOwner instanceof Cell && (ep = ((Cell)calcOwner).getExtProps(false)) != null) {
                ep.setCurrentGroup();
            }
            dm.resumeCurrent();
            ctx.pushExprOwner(calcOwner);
            Expr extExpr = sheet.getExtExpr(sheet.getDeps(), expr, calcOwner);
            if (extExpr != null) {
                expr = extExpr;
            }
            if ((value = (var = expr.execute(ctx, calcOwner)).getValue()) instanceof CellBlockNode) {
                CellBlockNode block = (CellBlockNode)value;
                sheet = block.getSheet();
                int r2 = block.getRow2() + 1;
                int c = block.getCol();
                int c2 = block.getCol2() + 1;
                int r = block.getRow();
                ret = new Variant[r2 - r][c2 - c];
                for (int i = 0; i < r2 - r; ++i) {
                    for (int j = 0; j < c2 - c; ++j) {
                        Cell cell = sheet.getCell(r + i, c + j, false);
                        ret[i][j] = new com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant();
                        if (cell != null) {
                            Variant v = cell.getValue();
                            if (v != null && !v.isNull()) {
                                ret[i][j].setObject(v.getValue(), v.getVt());
                                ((com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant)ret[i][j]).setText(cell.getText());
                                continue;
                            }
                            ret[i][j] = Variant.nullVariant;
                            continue;
                        }
                        ret[i][j] = Variant.nullVariant;
                    }
                }
            } else if (value instanceof Variant[]) {
                Variant[] array = (Variant[])value;
                int len = array.length;
                if (len > 0) {
                    CellBlock block;
                    Variant first = array[0];
                    Object value1 = first.getValue();
                    ret = new Variant[len][];
                    if (first.isReferences() && value1 instanceof CellBlockNode) {
                        int i;
                        ArrayList<Variant[]> list = new ArrayList<Variant[]>();
                        for (i = 0; i < len; ++i) {
                            first = array[i];
                            block = (CellBlock)first.getValue();
                            int height = block.getHeight();
                            int width = block.getWidth();
                            Variant[] r = FusionChartDataNode.getVariantArrayFromBlock(block, sheet, fusionNode.isSerialByCol());
                            for (int j = 0; j < width; ++j) {
                                Variant[] temp = new Variant[height];
                                for (int k = 0; k < height; ++k) {
                                    temp[k] = k + j * height < r.length ? r[k + j * height] : Variant.nullVariant;
                                }
                                list.add(temp);
                            }
                        }
                        ret = new Variant[list.size()][];
                        for (i = 0; i < list.size(); ++i) {
                            ret[i] = (Variant[])list.get(i);
                        }
                    } else if (first.isArray() && ((Variant[])value1)[0].getValue() instanceof CellBlockNode) {
                        ArrayList<Variant> buffer = new ArrayList<Variant>();
                        ret = new Variant[len][];
                        for (int i = 0; i < len; ++i) {
                            first = array[i];
                            value1 = first.getValue();
                            Variant[] varBlocks = (Variant[])value1;
                            int len1 = varBlocks.length;
                            for (int j = 0; j < len1; ++j) {
                                block = (CellBlock)varBlocks[j].getValue();
                                Variant[] v = FusionChartDataNode.getVariantArrayFromBlock2(block, sheet, fusionNode.isSerialByCol());
                                int len2 = v.length;
                                for (int k = 0; k < len2; ++k) {
                                    buffer.add(v[k]);
                                }
                            }
                            ret[i] = new Variant[buffer.size()];
                            buffer.toArray(ret[i]);
                            buffer.clear();
                        }
                    } else if (!first.isObject()) {
                        for (int i = 0; i < len; ++i) {
                            ret[i] = new Variant[]{array[i]};
                        }
                    }
                }
                if (ret != null) {
                    if (flag == COMBINATION_CHART_GROUP_FORMULA || flag == XY_Series) {
                        ArrayList<Variant> arr = new ArrayList<Variant>(((Variant[][])ret).length);
                        for (int i = 0; i < ((Variant[][])ret).length; ++i) {
                            arr.addAll(Arrays.asList(ret[i]));
                        }
                        int length = arr.size();
                        ret = new Variant[length][1];
                        for (int i = 0; i < length; ++i) {
                            ret[i] = new Variant[]{(Variant)arr.get(i)};
                        }
                    }
                    int row = ((Variant[][])ret).length;
                    int col = ret[0].length;
                    Variant[][] temp = new Variant[col][row];
                    for (int i = 0; i < row; ++i) {
                        for (int j = 0; j < col; ++j) {
                            temp[j][i] = ret[i][j];
                        }
                    }
                    ret = temp;
                }
            } else {
                ret = value instanceof Variant[][] ? (Variant[][])value : (value instanceof SyntaxErrorException ? new Variant[][]{{new Variant(expr.decode(ctx, calcOwner))}} : new Variant[][]{{new Variant(value)}});
            }
            ctx.popExprOwner();
        }
        return ret;
    }

    private static Variant[] getVariantArrayFromBlock(CellBlock block, Sheet sheet, boolean isSeriesByCol) {
        int r2 = block.getRow2() + 1;
        int c = block.getCol();
        int c2 = block.getCol2() + 1;
        int r = block.getRow();
        ArrayList<com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant> list = new ArrayList<com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant>();
        for (int i = 0; i < r2 - r; ++i) {
            for (int j = 0; j < c2 - c; ++j) {
                Cell cell = sheet.getCell(i + r, c + j, true);
                com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant add = new com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant();
                Variant v = cell.getValue();
                if (v != null) {
                    add.setText(cell.getText());
                    add.setObject(v.getValue(), v.getVt());
                }
                list.add(add);
            }
        }
        Variant[] ret = new Variant[list.size()];
        list.toArray(ret);
        return ret;
    }

    private static Variant[] getVariantArrayFromBlock2(CellBlock block, Sheet sheet, boolean isSeriesByCol) {
        int r2 = block.getRow2() + 1;
        int c = block.getCol();
        int c2 = block.getCol2() + 1;
        int r = block.getRow();
        ArrayList<com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant> list = new ArrayList<com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant>();
        for (int i = 0; i < r2 - r; ++i) {
            for (int j = 0; j < c2 - c; ++j) {
                Cell cell = sheet.getCell(i + r, c + j, true);
                com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant add = new com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant();
                Variant v = cell.getValue();
                if (v != null) {
                    add.setText(cell.getText());
                    add.setObject(v.getValue(), v.getVt());
                }
                list.add(add);
            }
        }
        Variant[] ret = new Variant[list.size()];
        list.toArray(ret);
        return ret;
    }

    @Override
    public boolean isDirty() {
        boolean ret;
        boolean bl = ret = this.sheet.getBook().getUserObject(EXT_EXECUTED) == null;
        if (ret) {
            return false;
        }
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        super.setDirty(dirty);
    }

    public void enableSnap(boolean snap) {
        this.enableSnap = snap;
    }

    @Override
    public boolean isFillNullWithZero() {
        boolean result = true;
        AbstractType chartType = this.getChartType();
        Object obj = this.getData(CHART_CAPTION);
        if (obj != null) {
            String str;
            Variant[][] val;
            if (chartType instanceof QingChartType) {
                String str2;
                Variant[][] val2;
                if (Array.getLength(obj) >= 53 && (val2 = (Variant[][])Array.get(obj, 52)) != null && ((str2 = val2[0][0].toString()) == null || str2.equals("0"))) {
                    result = false;
                }
            } else if (Array.getLength(obj) >= 43 && (val = (Variant[][])Array.get(obj, 42)) != null && (str = val[0][0].toString()) != null && str.length() > 0) {
                result = NullValueDisplayModeEditor.getZero().equals(val[0][0].toString());
            }
        }
        return result;
    }

    public String getConnectNullData(String defaultValue) {
        String str;
        Variant[][] val;
        String result = defaultValue;
        Object obj = this.getData(CHART_CAPTION);
        if (obj != null && Array.getLength(obj) >= 43 && (val = (Variant[][])Array.get(obj, 42)) != null && (str = val[0][0].toString()) != null && str.length() > 0) {
            result = val[0][0].toString();
        }
        return result;
    }

    public String getColorXML() {
        return this.colorXML;
    }

    public void setColorXML(String colorXML) {
        this.colorXML = colorXML;
    }

    public String getNumberFormatXML() {
        return this.numberFormatXML;
    }

    public void setNumberFormatXML(String numberFormatXML) {
        this.numberFormatXML = numberFormatXML;
    }

    public String getXyRestrictionXML() {
        return this.xyRestrictionXML;
    }

    public void setXyRestrictionXML(String xyRestrictionXML) {
        this.xyRestrictionXML = xyRestrictionXML;
    }
}

