/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.display;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExecutorUtil;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExportUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.cosmic.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.cosmic.ctrl.kdf.export.ExportManager;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.kds.io.kds.BookToKDSBook;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.display.FlashChartDisplayDialog;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.display.FlashChartDisplayThread;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.cosmic.ctrl.kds.nio.BookDataWrapper;
import java.io.IOException;

public class FlashChartDisplayResolver {
    private Book _book;
    String _path;
    ExportManager _manager;
    BookDataWrapper _wrapper;
    public boolean isDisp = true;
    private boolean _isOpen = true;
    public static final String EXPORT_EXCEL_2003 = "EXPORT_EXCEL_2003";
    public static final String EXPORT_EXCEL_2007 = "EXPORT_EXCEL_2007";
    private String _exportType = "EXPORT_EXCEL_2007";

    private static String getFlashThreadGroup() {
        return CtrlEXTMessages.getMLS("advancedChartExportThreadGroup", "\u9ad8\u7ea7\u56fe\u8868\u5bfc\u51fa\u7ebf\u7a0b\u7ec4");
    }

    public FlashChartDisplayResolver(Book book) {
        this._book = book;
    }

    public void setExportType(String typeName) {
        this._exportType = typeName;
    }

    public void export(String path, ExportManager em, BookDataWrapper wrapper, boolean isOpen) {
        this._path = path;
        this._manager = em;
        this._wrapper = wrapper;
        this._isOpen = isOpen;
        Thread first = this.buildDisplayThread();
        if (first != null) {
            first.start();
        } else {
            block14: {
                if (EXPORT_EXCEL_2007.equals(this._exportType)) {
                    try {
                        SXSSFExportWrapper exporter = new SXSSFExportWrapper((AbstractDataWrapper)wrapper);
                        exporter.write(path);
                        this.openFile();
                    }
                    catch (Exception ex) {
                        if (MiscUtil.shouldLog()) {
                            MiscUtil.log(ex);
                        }
                        break block14;
                    }
                }
                try {
                    Book dstBook = null;
                    int sheetCount = this._book.getSheetCount();
                    for (int sh = 0; sh < sheetCount; ++sh) {
                        Sheet sheet = this._book.getSheet(sh);
                        if (!SheetBaseMath.isSecuritySheet(sheet)) continue;
                        if (dstBook == null) {
                            dstBook = BookIOUtil.unpack(BookIOUtil.pack(this._book));
                            dstBook.setCalculate(false);
                        }
                        ExecutorUtil.calcDisplayValue(sheet, dstBook.getSheet(sh));
                        AlgorithmUtil.delHideRowsAndCols(sheet.getSecHidedRows(), sheet.getSecHidedCols(), dstBook.getSheet(sh));
                    }
                    int layerSize = 0;
                    for (int i = 0; i < sheetCount && dstBook != null; ++i) {
                        EmbedhLayer layer = dstBook.getSheet(i).getEmbedments(false);
                        if (layer == null) continue;
                        layerSize = layer.size();
                        layer.selectAllEmbeds();
                        layer.removeSelectedEmbeds();
                        for (int j = 0; j < layerSize; ++j) {
                            layer.addEmbed(this._book.getSheet(i).getEmbedments(false).getEmbed(i));
                        }
                    }
                    if (dstBook == null) {
                        dstBook = this._book;
                    }
                    String[] sheetNames = new String[sheetCount];
                    for (int sh = 0; sh < sheetCount; ++sh) {
                        sheetNames[sh] = dstBook.getSheet(sh).getSheetName();
                    }
                    KDSBook kdsbook = BookToKDSBook.traslate(dstBook, sheetNames);
                    ExportUtil.removeHideSheet(dstBook, kdsbook);
                    em.exportToExcel(kdsbook, path);
                    this.openFile();
                }
                catch (Exception e1) {
                    if (!MiscUtil.shouldLog()) break block14;
                    MiscUtil.log(e1);
                }
            }
            this.isDisp = false;
        }
    }

    public void export(String path, ExportManager em, BookDataWrapper wrapper) {
        this.export(path, em, wrapper, true);
    }

    public Thread buildDisplayThread() {
        FlashChartDisplayDialog dialog = new FlashChartDisplayDialog();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        ThreadGroup tg = new ThreadGroup(FlashChartDisplayResolver.getFlashThreadGroup());
        Book book = this._book;
        FlashChartDisplayThread last = null;
        FlashChartDisplayThread first = null;
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = book.getSheet(i);
            EmbedhLayer layer = sheet.getEmbedments(false);
            if (layer == null) continue;
            int lsize = layer.size();
            for (int j = 0; j < lsize; ++j) {
                EmbedObject eo = layer.getEmbed(j);
                if (!(eo instanceof ChartRectEmbedment) || ((ChartRectEmbedment)eo).getCachedImg() != null) continue;
                last = first == null ? (first = new FlashChartDisplayThread(dialog, tg, eo.getName(), (ChartRectEmbedment)eo, null, this, this._exportType, true)) : new FlashChartDisplayThread(dialog, tg, eo.getName(), (ChartRectEmbedment)eo, last, this, this._exportType, true);
            }
        }
        return first;
    }

    public Thread buildDisplayThread(ChartRectEmbedment chart) {
        FlashChartDisplayDialog dialog = new FlashChartDisplayDialog();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        ThreadGroup tg = new ThreadGroup(FlashChartDisplayResolver.getFlashThreadGroup());
        FlashChartDisplayThread first = null;
        first = new FlashChartDisplayThread(dialog, tg, chart.getName(), chart, null, this, this._exportType, false);
        return first;
    }

    void openFile() {
        block3: {
            if (this._isOpen) {
                try {
                    KDTMenuManager.openFileInExcel((String)this._path);
                }
                catch (IOException e) {
                    if (!MiscUtil.shouldLog()) break block3;
                    MiscUtil.log(e);
                }
            }
        }
    }
}

