/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.display;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.cosmic.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kds.io.kds.BookToKDSBook;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.display.FlashChartDisplayDialog;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.display.FlashChartDisplayResolver;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.AlgorithmUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FlashChartDisplayThread
extends Thread {
    private static final Logger logger = LogUtil.getPackageLogger(FlashChartDisplayThread.class);
    private ChartRectEmbedment _fc;
    private FlashChartDisplayDialog _displayDialog;
    private FlashChartDisplayThread _next;
    private String _exportType;
    private volatile boolean _layoutCompleted = false;
    private volatile boolean _executeCompleted = false;
    private Container physicalUIParent;
    private FlashChartDisplayResolver _xlet;
    private boolean _forExport;

    public FlashChartDisplayThread(FlashChartDisplayDialog displayDialog, ThreadGroup tg, String name, ChartRectEmbedment fc, FlashChartDisplayThread last, FlashChartDisplayResolver xlet, String exportType, boolean forExport) {
        super(tg, name);
        this._forExport = forExport;
        this._xlet = xlet;
        if (last != null) {
            last._next = this;
        }
        this._displayDialog = displayDialog;
        this._exportType = exportType;
        this._fc = fc;
    }

    @Override
    public void run() {
        if (this._forExport) {
            this._displayDialog.setTitle(CtrlEXTMessages.getMLS("exportingAdvancedChart", "\u6b63\u5728\u5bfc\u51fa\u9ad8\u7ea7\u56fe\u8868:") + this._fc.getSheet().getSheetName() + this.getName());
        } else {
            this._displayDialog.setTitle(CtrlEXTMessages.getMLS("processingAdvancedChart", "\u6b63\u5728\u5904\u7406\u9ad8\u7ea7\u56fe\u8868:") + this._fc.getSheet().getSheetName() + this.getName());
        }
        final Component physicalUI = this._fc.getPhysicalUI();
        Rectangle a = physicalUI.getBounds();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (physicalUI.getParent() != null) {
                    FlashChartDisplayThread.this.physicalUIParent = physicalUI.getParent();
                    physicalUI.getParent().remove(physicalUI);
                    System.out.println("remove phisicalUI from parent sheet name is:" + FlashChartDisplayThread.this._fc.getSheet().getSheetName() + "\u3011chart name is:" + FlashChartDisplayThread.this._fc.getName());
                }
                Container c = FlashChartDisplayThread.this._displayDialog.getContentPane();
                c.removeAll();
                c.add(physicalUI);
                Dimension graphSize = new Dimension(((FlashChartDisplayThread)FlashChartDisplayThread.this)._fc.getBounds().width, ((FlashChartDisplayThread)FlashChartDisplayThread.this)._fc.getBounds().height);
                FlashChartDisplayThread.this._displayDialog.setSize(graphSize);
                FlashChartDisplayThread.this._displayDialog.setLocationRelativeTo(null);
                FlashChartDisplayThread.this._layoutCompleted = true;
            }
        });
        while (!this._layoutCompleted) {
            Thread.yield();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (FlashChartDisplayThread.this._fc instanceof FlashChart) {
                                String dataXml = ((FlashChart)FlashChartDisplayThread.this._fc).getXml();
                                dataXml = dataXml.replace("<chart ", "<chart animation='0' ");
                                FlashChartDisplayThread.this._fc.execute(dataXml);
                            } else if (FlashChartDisplayThread.this._fc instanceof QingChart) {
                                ((QingChart)FlashChartDisplayThread.this._fc).executeAndWait(30L, TimeUnit.SECONDS);
                            }
                        }
                        catch (Exception ex) {
                            LogUtil.getLogger(this.getClass()).error((Object)"export image error", (Throwable)ex);
                        }
                        FlashChartDisplayThread.this._executeCompleted = true;
                    }
                });
            }
        });
        while (!this._executeCompleted) {
            Thread.yield();
        }
        this.sleep(3);
        if (null != this.physicalUIParent) {
            this._displayDialog.getRootPane().remove(physicalUI);
            physicalUI.setBounds(a);
            this.physicalUIParent.add(physicalUI);
        }
        this._fc.exportToBufferedImage();
        if (this._next != null) {
            this._next.start();
        } else if (this._forExport) {
            if ("EXPORT_EXCEL_2007".equals(this._exportType)) {
                this.exportToXlsx(this._fc.getSheet().getBook());
            } else {
                this.exportToXls(this._fc.getSheet().getBook());
            }
            this._displayDialog.dispose();
            this._xlet.isDisp = false;
        } else {
            this._displayDialog.dispose();
            this._xlet.isDisp = false;
        }
    }

    private void exportToXlsx(Book book) {
        block2: {
            try {
                SXSSFExportWrapper exporter = new SXSSFExportWrapper((AbstractDataWrapper)this._xlet._wrapper);
                exporter.write(this._xlet._path);
                this._xlet.openFile();
            }
            catch (Exception ex) {
                if (!MiscUtil.shouldLog()) break block2;
                MiscUtil.log(ex);
            }
        }
    }

    private void exportToXls(Book book) {
        block5: {
            try {
                int sheetCount = book.getSheetCount();
                for (int sh = 0; sh < sheetCount; ++sh) {
                    Sheet sheet = book.getSheet(sh);
                    if (!SheetBaseMath.isSecuritySheet(sheet)) continue;
                    Sheet.ICellsIterator iter = book.getSheet(sh).getCellsIterator(0, 0, 1048575, 65535, false, true);
                    while (iter.hasNext()) {
                        iter.next().calcFormulaProps(book.getSheet(sh).getDeps().getExprContext());
                    }
                    AlgorithmUtil.delHideRowsAndCols(sheet.getSecHidedRows(), sheet.getSecHidedCols(), book.getSheet(sh));
                }
                String[] sheetNames = new String[sheetCount];
                for (int sh = 0; sh < sheetCount; ++sh) {
                    sheetNames[sh] = book.getSheet(sh).getSheetName();
                }
                FlashChartDisplayDialog.GLOBAL_INVISIBLE = true;
                KDSBook kdsbook = BookToKDSBook.traslate(book, sheetNames);
                FlashChartDisplayDialog.GLOBAL_INVISIBLE = false;
                this._xlet._manager.exportToExcel(kdsbook, this._xlet._path);
                this._xlet.openFile();
            }
            catch (Exception e1) {
                FlashChartDisplayDialog.GLOBAL_INVISIBLE = false;
                if (!MiscUtil.shouldLog()) break block5;
                MiscUtil.log(e1);
            }
        }
    }

    public void sleep(int sec) {
        try {
            Thread.sleep(sec * 1000);
        }
        catch (InterruptedException e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }
}

