/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.image;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.FontUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.immit.IExtCallback;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.HotSpot;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.RectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.RectEmbedmentCopier;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.DynamicAccessImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbedImageType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbededImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.IImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ImageFullPath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredImageResult;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredPathImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.StaticURLImageModel;
import com.kingdee.cosmic.ctrl.kds.model.util.ExtURL;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataInputStream;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataOutputStream;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.UUID;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import sun.awt.image.ToolkitImage;

public class EmbedImage
extends RectEmbedment
implements ImageObserver {
    private static final Logger logger = Logger.getLogger(EmbedImage.class);
    private IImageModel _model;
    private static final Color _color = new Color(77, 115, 153);
    private EmbedImageType _type;
    private BufferedImage _eclipse;
    private BufferedImage _rectangle;
    private Cell _cllPos;
    static final byte ID_End = 0;
    static final byte ID_ImgeURL = 1;
    static final byte ID_ImageType = 2;
    static final byte ID_Image_Data_Length = 3;
    static final byte ID_Image_Data = 4;
    static final byte ID_Image_Dragable = 5;
    static final byte ID_Dync_Image_Data_Length = 6;
    static final byte ID_Dync_Image_Data = 7;
    static final byte ID_Referred_Image_UId = 8;
    static final byte ID_Referred_Image_FileName = 9;
    static final byte ID_Referred_Image_FullPath = 10;
    private static Color dark = new Color(148, 148, 148);
    private static Color light = new Color(243, 243, 243);
    private static Color outline = new Color(43, 43, 43);
    private static BufferedImage noImage;
    private boolean aborted;
    private boolean dragedEnable = false;

    public EmbedImage(Sheet sheet, IImageModel model) {
        super(sheet);
        this._model = model;
        if (this.getType() == EmbedImageType.Static_Embed_Image || this.getType() == EmbedImageType.Referred_Image || this.getType() == EmbedImageType.Referred_Path_Image) {
            this.dragedEnable = true;
        }
    }

    public EmbedImage(Sheet sheet) {
        this(sheet, null);
    }

    public void setDragedEnable(boolean draged) {
        this.dragedEnable = draged;
    }

    public boolean isDragEnable() {
        if (this.getType() != EmbedImageType.Static_Embed_Image && this.getType() != EmbedImageType.Referred_Image && this.getType() != EmbedImageType.Referred_Path_Image) {
            return this.dragedEnable;
        }
        this.dragedEnable = true;
        return true;
    }

    @Override
    public void paintData(Graphics g) {
        Image image;
        Graphics2D g2d;
        block6: {
            g2d = (Graphics2D)g;
            if (this._model == null) {
                return;
            }
            image = null;
            try {
                image = this._model.getImage();
            }
            catch (IOException e) {
                if (!MiscUtil.shouldLog()) break block6;
                MiscUtil.log(4, CtrlEXTMessages.getMLS("importFileException", "\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a"));
                MiscUtil.log(e);
            }
        }
        Rectangle rect = this.getBounds();
        if (image == null) {
            if (rect.height == Integer.MAX_VALUE && rect.width == Integer.MAX_VALUE) {
                rect.height = 100;
                rect.width = 100;
                this.setBounds(rect);
            }
            this.drawNoImage(g2d, rect);
            return;
        }
        if (rect.height == Integer.MAX_VALUE && rect.width == Integer.MAX_VALUE) {
            rect.width = image.getWidth(null);
            rect.height = image.getHeight(null);
            this.setBounds(rect);
        }
        this.aborted = false;
        this.preLoadImage(SwingUtilities.isEventDispatchThread());
        g2d.drawImage(image, rect.x, rect.y, rect.width, rect.height, this);
    }

    public IImageModel getModel() {
        return this._model;
    }

    private void drawNoImage(Graphics2D g2d, Rectangle rect) {
        g2d.setColor(Color.WHITE);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.fillRect(rect.x, rect.y, rect.width, rect.height);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(rect.x, rect.y, rect.width, rect.height);
        if (noImage == null) {
            noImage = this.getNoImageAvailableImage();
        }
        g2d.drawImage(noImage, rect.x, rect.y, rect.width, rect.height, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getNoImageAvailableImage() {
        Font f;
        FontRenderContext frc;
        Graphics2D g2;
        BufferedImage bufferedImage;
        Rectangle rect;
        block26: {
            String[] fontnames3;
            rect = this.getBounds();
            bufferedImage = new BufferedImage(rect.width, rect.height / 2, 2);
            g2 = (Graphics2D)bufferedImage.getGraphics();
            frc = g2.getFontRenderContext();
            f = null;
            try (FileInputStream fileInputStream = new FileInputStream(new File(FilenameUtils.normalize((String)(System.getProperty("eas.properties.dir") + File.separator + CtrlEXTMessages.getMLS("fontFile", "\u5fae\u8f6f\u96c5\u9ed1.ttc")))));){
                f = Font.createFont(0, fileInputStream);
                f = f.deriveFont(1, (float)rect.width / 5.0f);
            }
            catch (FileNotFoundException fontnames2) {
                if (f != null) break block26;
                fontnames3 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                for (int i = 0; i < fontnames3.length; ++i) {
                    if (!FontUtil.isChineseDrawable((Font)new Font(fontnames3[i], 0, 12))) continue;
                    f = new Font(fontnames3[i], 1, rect.width / 5);
                    break;
                }
            }
            catch (FontFormatException fontnames3) {
                if (f != null) break block26;
                fontnames3 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                for (int i = 0; i < fontnames3.length; ++i) {
                    if (!FontUtil.isChineseDrawable((Font)new Font(fontnames3[i], 0, 12))) continue;
                    f = new Font(fontnames3[i], 1, rect.width / 5);
                    break;
                }
            }
            catch (IOException fontnames4) {
                if (f != null) break block26;
                fontnames3 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                for (int i = 0; i < fontnames3.length; ++i) {
                    if (!FontUtil.isChineseDrawable((Font)new Font(fontnames3[i], 0, 12))) continue;
                    f = new Font(fontnames3[i], 1, rect.width / 5);
                    break;
                }
            }
            finally {
                if (f == null) {
                    fontnames3 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                    for (int i = 0; i < fontnames3.length; ++i) {
                        if (!FontUtil.isChineseDrawable((Font)new Font(fontnames3[i], 0, 12))) continue;
                        f = new Font(fontnames3[i], 1, rect.width / 5);
                        break;
                    }
                }
            }
        }
        String s = CtrlEXTMessages.getMLS("imageNotFound2", "\u627e\u4e0d\u5230\u56fe\u7247");
        TextLayout tl = new TextLayout(s, f, frc);
        AffineTransform transform = new AffineTransform();
        transform.setToTranslation(0.0, rect.height / 2);
        Shape shape = tl.getOutline(transform);
        Rectangle r = shape.getBounds();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        GradientPaint p = new GradientPaint(r.x, r.y, outline, r.x, r.y + r.height, light);
        g2.setPaint(p);
        g2.fill(shape);
        g2.setColor(dark);
        g2.draw(shape);
        g2.setClip(shape);
        bufferedImage = this.createReflection(bufferedImage);
        int x = rect.width - r.width / 2 + rect.x;
        int y = rect.height - r.height / 2 + rect.y;
        g2.drawImage((Image)bufferedImage, x - 2, y - 2, null);
        g2.dispose();
        return bufferedImage;
    }

    private BufferedImage createReflection(BufferedImage image) {
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(image.getWidth(), height * 2, 2);
        Graphics2D g2 = result.createGraphics();
        g2.drawImage((Image)image, 0, 0, null);
        g2.scale(1.0, -1.0);
        g2.drawImage((Image)image, 0, -height - height, null);
        g2.scale(1.0, -1.0);
        g2.translate(0, height);
        GradientPaint mask = new GradientPaint(0.0f, 0.0f, new Color(1.0f, 1.0f, 1.0f, 0.5f), 0.0f, height / 2, new Color(1.0f, 1.0f, 1.0f, 0.0f));
        g2.setPaint(mask);
        g2.setComposite(AlphaComposite.DstIn);
        g2.fillRect(0, 0, image.getWidth(), height);
        g2.dispose();
        return result;
    }

    @Override
    public void paintFocus(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(_color);
        g2d.setStroke(new BasicStroke(1.0f));
        Rectangle rect = this.getBounds();
        g2d.drawRect(rect.x, rect.y, rect.width, rect.height);
        if (!this.isDragEnable()) {
            return;
        }
        this.initHotspot();
        HotSpot[] hotspots = this.getHotSpots();
        for (int i = 0; i < hotspots.length; ++i) {
            HotSpot hotSpot = hotspots[i];
            if (hotSpot.getType() <= 4) {
                g2d.drawImage((Image)this._eclipse, hotSpot.getX() - 4, hotSpot.getY() - 4, null);
                continue;
            }
            g2d.drawImage((Image)this._rectangle, hotSpot.getX() - 3, hotSpot.getY() - 3, null);
        }
    }

    private void initHotspot() {
        Graphics2D g2d;
        if (this._eclipse != null && this._rectangle != null) {
            return;
        }
        Color dark = new Color(202, 234, 237);
        Color light = new Color(246, 255, 255);
        if (this._eclipse == null) {
            this._eclipse = new BufferedImage(9, 9, 2);
            g2d = this._eclipse.createGraphics();
            Color lineColor = new Color(119, 126, 135);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GradientPaint p = new GradientPaint(0.0f, 0.0f, light, 8.0f, 8.0f, dark);
            Ellipse2D.Double s = new Ellipse2D.Double(0.0, 0.0, 8.0, 8.0);
            g2d.setPaint(p);
            g2d.setColor(light);
            g2d.fill(s);
            g2d.setColor(lineColor);
            g2d.draw(s);
            g2d.dispose();
        }
        if (this._rectangle == null) {
            this._rectangle = new BufferedImage(7, 7, 2);
            g2d = this._rectangle.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GradientPaint p = new GradientPaint(0.0f, 0.0f, light, 6.0f, 6.0f, dark);
            Rectangle2D.Double s = new Rectangle2D.Double(0.0, 0.0, 6.0, 6.0);
            g2d.setColor(light);
            g2d.setPaint(p);
            g2d.fill(s);
            g2d.setColor(_color);
            g2d.draw(s);
            g2d.dispose();
        }
    }

    @Override
    protected byte[] saveCustom() {
        EmbedImageType type = this.getType();
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream(bs);
        try {
            out.writeString("1.0");
            if (type == EmbedImageType.Embeded_Image) {
                byte[] data;
                String str = "Embeded_Image";
                out.writeByte(2);
                out.writeString(str);
                EmbededImageModel model = (EmbededImageModel)this._model;
                if (model != null && (data = model.getImageData()) != null) {
                    out.writeByte(3);
                    out.writeInt(data.length);
                    out.writeByte(4);
                    out.write(data);
                    out.writeByte(5);
                    out.writeBoolean(this.dragedEnable);
                }
            } else if (type == EmbedImageType.Dynamic_Embed_Image) {
                byte[] data;
                String str = "Dynamic_Embed_Image";
                out.writeByte(2);
                out.writeString(str);
                DynamicAccessImageModel model = (DynamicAccessImageModel)this._model;
                if (model != null && (data = model.getImageData()) != null) {
                    out.writeByte(6);
                    out.writeInt(data.length);
                    out.writeByte(7);
                    out.write(data);
                }
            } else if (type == EmbedImageType.Referred_Image) {
                String str = "Referred_Image";
                out.writeByte(2);
                out.writeString(str);
                ReferredImageModel model = (ReferredImageModel)this._model;
                if (model != null) {
                    out.writeByte(8);
                    String embedUid = model.getEmbedUid();
                    out.writeString(embedUid);
                    out.writeByte(9);
                    String fileName = model.getFileName();
                    out.writeString(fileName);
                    out.writeByte(5);
                    out.writeBoolean(this.dragedEnable);
                }
            } else if (type == EmbedImageType.Referred_Path_Image) {
                String str = "Referred_Path_Image";
                out.writeByte(2);
                out.writeString(str);
                ReferredPathImageModel model = (ReferredPathImageModel)this._model;
                if (model != null) {
                    out.writeByte(10);
                    ImageFullPath imageFullPath = model.getImageFullPath();
                    String strImageFullPath = imageFullPath.parseToString();
                    out.writeString(strImageFullPath);
                    out.writeByte(5);
                    out.writeBoolean(this.dragedEnable);
                }
            } else {
                URL url;
                StaticURLImageModel model = (StaticURLImageModel)this._model;
                String str = "Static_Embed_Image";
                out.writeByte(2);
                out.writeString(str);
                if (model != null && (url = model.getUrl()) != null) {
                    str = url.toString();
                    out.writeByte(1);
                    out.writeString(str);
                    out.writeByte(5);
                    out.writeBoolean(this.dragedEnable);
                }
            }
            out.writeByte(0);
            out.close();
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return bs.toByteArray();
    }

    @Override
    protected void loadCustom(byte[] str, boolean create) {
        block24: {
            if (str == null || str.length == 0) {
                return;
            }
            try {
                KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
                String ver = is.readString();
                if (ver.equals("1.0")) {
                    byte id;
                    block10: while ((id = is.readByte()) != 0) {
                        switch (id) {
                            case 2: {
                                String type = is.readString().trim();
                                if (type == null) break block10;
                                if ("Static_Embed_Image".equals(type)) {
                                    this._model = new StaticURLImageModel();
                                    continue block10;
                                }
                                if ("Embeded_Image".equals(type)) {
                                    this._model = new EmbededImageModel();
                                    continue block10;
                                }
                                if ("Dynamic_Embed_Image".equals(type)) {
                                    this._model = new DynamicAccessImageModel();
                                    continue block10;
                                }
                                if ("Referred_Image".equals(type)) {
                                    this._model = new ReferredImageModel();
                                    continue block10;
                                }
                                if (!"Referred_Path_Image".equals(type)) continue block10;
                                this._model = new ReferredPathImageModel();
                                continue block10;
                            }
                            case 1: {
                                this._model = ExtURL.parseModel(is.readString());
                                is.readByte();
                                this.setDragedEnable(is.readBoolean());
                                break block10;
                            }
                            case 3: {
                                int length = is.readInt();
                                if (length > 0) {
                                    byte[] data = new byte[length];
                                    is.readByte();
                                    is.read(data);
                                    ((EmbededImageModel)this._model).setImageData(data);
                                }
                                is.readByte();
                                this.setDragedEnable(is.readBoolean());
                                break block10;
                            }
                            case 6: {
                                int length = is.readInt();
                                if (length <= 0) break block10;
                                byte[] data = new byte[length];
                                is.readByte();
                                is.read(data);
                                ((DynamicAccessImageModel)this._model).setImageData(data);
                                break block10;
                            }
                            case 8: {
                                String embedUid = is.readString();
                                ((ReferredImageModel)this._model).setEmbedUid(embedUid);
                                is.readByte();
                                String fileName = is.readString();
                                ((ReferredImageModel)this._model).setFileName(fileName);
                                ReferredImageResult referredImageResult = null;
                                IExtCallback extCallback = KDExt.threadExtCallback.get();
                                if (extCallback != null) {
                                    String reportId;
                                    if (!StringUtil.isEmptyString((String)embedUid) && (referredImageResult = extCallback.loadImageByUid(reportId = extCallback.getReportId(), embedUid)) != null) {
                                        ((ReferredImageModel)this._model).setImageData(referredImageResult.getImageData());
                                        ((ReferredImageModel)this._model).setFileName(referredImageResult.getImageFileName());
                                    }
                                    if (referredImageResult == null && (referredImageResult = extCallback.loadImageByFileName(fileName)) != null) {
                                        ((ReferredImageModel)this._model).setImageData(referredImageResult.getImageData());
                                        ((ReferredImageModel)this._model).setFileName(referredImageResult.getImageFileName());
                                    }
                                }
                                is.readByte();
                                this.setDragedEnable(is.readBoolean());
                                break block10;
                            }
                            case 10: {
                                ReferredImageResult referredImageResult;
                                IExtCallback extCallback;
                                String strImageFullPath = is.readString();
                                if (!StringUtil.isEmptyString((String)strImageFullPath)) {
                                    ImageFullPath imageFullPath = new ImageFullPath();
                                    imageFullPath.fromString(strImageFullPath);
                                    ((ReferredPathImageModel)this._model).setImageFullPath(imageFullPath);
                                }
                                if ((extCallback = KDExt.threadExtCallback.get()) != null && !StringUtil.isEmptyString((String)strImageFullPath) && (referredImageResult = extCallback.loadImageByFullPath(strImageFullPath)) != null) {
                                    ((ReferredPathImageModel)this._model).setImageData(referredImageResult.getImageData());
                                }
                                is.readByte();
                                this.setDragedEnable(is.readBoolean());
                                break block10;
                            }
                        }
                    }
                }
                is.close();
            }
            catch (IOException ioe) {
                if (!MiscUtil.shouldLog()) break block24;
                MiscUtil.log(ioe);
            }
        }
        if (this._model instanceof ReferredImageModel && create) {
            ((ReferredImageModel)this._model).setEmbedUid(UUID.randomUUID().toString());
        }
    }

    public EmbedImageType getType() {
        if (this._model != null) {
            if (this._model instanceof DynamicAccessImageModel) {
                this._type = EmbedImageType.Dynamic_Embed_Image;
                return this._type;
            }
            if (this._model instanceof StaticURLImageModel) {
                this._type = EmbedImageType.Static_Embed_Image;
                return this._type;
            }
            if (this._model instanceof EmbededImageModel) {
                this._type = EmbedImageType.Embeded_Image;
                return this._type;
            }
            if (this._model instanceof ReferredImageModel) {
                this._type = EmbedImageType.Referred_Image;
                return this._type;
            }
            if (this._model instanceof ReferredPathImageModel) {
                this._type = EmbedImageType.Referred_Path_Image;
                return this._type;
            }
        }
        return null;
    }

    public Image getImage() throws IOException {
        return this._model.getImage();
    }

    public void _placeImageAt(Cell cllPos) {
        this._cllPos = cllPos;
    }

    public Cell getCellPosition() {
        return this._cllPos;
    }

    public void _revalidate() {
        if (this._cllPos != null) {
            this.setBounds(SheetBaseMath.getActualCellRect(this._sheet, this._cllPos.getRow(), this._cllPos.getCol(), false));
        }
    }

    public void setModel(IImageModel newModel) {
        this._model = newModel;
        noImage = null;
    }

    public void preLoadImage(boolean flag) {
        if (!flag) {
            return;
        }
        Image image = null;
        try {
            image = this._model.getImage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (image instanceof ToolkitImage) {
            try {
                for (int index = 0; index < 1000; ++index) {
                    image.getClass().getMethod("preload", ImageObserver.class).invoke((Object)image, new Object[]{null});
                }
            }
            catch (Throwable th) {
                logger.error((Object)"err", th);
            }
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if (this.aborted || (infoflags & 0x80) != 0) {
            this.aborted = true;
            return !true;
        }
        if ((infoflags & 0x20) != 0) {
            this._sheet.getBook().fireBookPropertyChange(this.getBounds(), null, "Region_Repaint");
            return false;
        }
        if (!this._sheet.getEmbedments(false).isVisibleInView(this)) {
            img.flush();
            return false;
        }
        if ((infoflags & 0x10) != 0) {
            this._sheet.getBook().fireBookPropertyChange(this.getBounds(), null, "Region_Repaint");
        }
        return true;
    }

    public void copy(EmbedImage src) {
        RectEmbedmentCopier.copy(this, src);
        this.loadCustom(src.saveCustom(), true);
    }
}

