/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.image;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.pic.ImageUtils;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.util.IOUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.AbstractImageModel;
import com.kingdee.cosmic.ctrl.kds.util.CloseUtil;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class StaticURLImageModel
extends AbstractImageModel {
    private URL _url;

    public StaticURLImageModel() {
    }

    public StaticURLImageModel(URL url) {
        this._url = url;
    }

    @Override
    public Image getImage() throws IOException {
        if (this._url == null) {
            return null;
        }
        Image image = null;
        if (this.contain(this._url)) {
            image = (Image)this.get(this._url);
            return image;
        }
        if (ImageUtils.checkURL(this._url)) {
            if (this._url.getProtocol().equals("file")) {
                short time = 10;
                image = CtrlSwingUtilities.readImgFromFile((String)this._url.toString().substring(6), (short)time);
            } else {
                ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
                ImageInputStream ciis = ImageIO.createImageInputStream(this._url.openStream());
                reader.setInput(ciis, false);
                int noi = reader.getNumImages(true);
                image = noi > 1 ? Toolkit.getDefaultToolkit().createImage(this._url) : ImageIO.read(this._url);
            }
            this.loadEnsured(image);
        } else {
            image = null;
        }
        this.add(this._url, image);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getImageData() throws IOException {
        byte[] byArray;
        if (this._url == null || !ImageUtils.checkURL(this._url)) {
            return null;
        }
        InputStream in = null;
        ByteArrayOutputStream baos = null;
        try {
            URLConnection urlConnection = this._url.openConnection();
            in = urlConnection.getInputStream();
            baos = new ByteArrayOutputStream();
            IOUtil.copy(in, baos);
            byArray = baos.toByteArray();
        }
        catch (Exception e) {
            byte[] byArray2;
            try {
                byArray2 = null;
            }
            catch (Throwable throwable) {
                CloseUtil.close(in, baos);
                throw throwable;
            }
            CloseUtil.close(in, baos);
            return byArray2;
        }
        CloseUtil.close(in, baos);
        return byArray;
    }

    @Override
    public void dispose() {
        this.discard(this._url);
    }

    public void setUrl(URL imageUrl) {
        this._url = imageUrl;
    }

    public URL getUrl() {
        return this._url;
    }

    public String toString() {
        return "";
    }
}

