/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.area.AreaChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.area.PSTAreaChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.area.STAreaChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.bar.BarChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.bar.MSBarChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.bar.PBarChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.bar.PSTBarChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.bar.STBarChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.column.ColumnChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.column.MSColumnChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.column.PColumnChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.column.PSTColumnChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.column.STColumnChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.combina.CombinaChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.combina.MSCombinaChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.dial.DialChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.funnel.FunnelChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.line.LineChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.line.MSLineChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.pie.PRingPieChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.pie.PieChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.pie.RingPieChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.pie.RosePieChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.radar.MSRadarChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.radar.RadarChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.scatter.ScatterChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.scatter.ScatterPlotChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.sunburst.MSSunBurstChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.tree.MSRectTreeChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.tree.RectTreeChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.waterfall.WaterFallChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.IQingChartTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.area.AreaTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.area.PSTAreaTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.area.STAreaTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.bar.BarTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.bar.MSBarTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.bar.PBarTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.bar.PSTBarTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.bar.STBarTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.column.ColumnTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.column.MSColumnTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.column.PColumnTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.column.PSTColumnTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.column.STColumnTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.combina.CombinaTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.combina.MSCombinaTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.dial.DialTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.funnel.FunnelTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.line.LineTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.line.MSLineTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.pie.PRingPieTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.pie.PieTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.pie.RingPieTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.pie.RosePieTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.radar.MSRadarTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.radar.RadarTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.scatter.ScatterPlotTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.scatter.ScatterTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.sunburst.MSSunBurstTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.tree.MSRectTreeTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.tree.RectTreeTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.waterfall.WaterFallTransferImpl;
import java.util.HashMap;
import java.util.Map;

public class QingChartFactory {
    private static final Map<FlashChartType, Class<? extends AbstractQingChart>> qingChartImpl = new HashMap<FlashChartType, Class<? extends AbstractQingChart>>(8);
    private static final Map<FlashChartType, Class<? extends IQingChartTransfer>> transferImpl = new HashMap<FlashChartType, Class<? extends IQingChartTransfer>>(8);

    private QingChartFactory() {
    }

    public static void registerChartImpl(FlashChartType type, Class<? extends AbstractQingChart> clazz) {
        qingChartImpl.put(type, clazz);
    }

    public static void registerTransferImpl(FlashChartType type, Class<? extends IQingChartTransfer> clazz) {
        transferImpl.put(type, clazz);
    }

    public static AbstractQingChart getQingChart(FlashChartType chartType) {
        Class<? extends AbstractQingChart> clazz = qingChartImpl.get(chartType);
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LogUtil.getLogger(QingChartFactory.class).error((Object)"getQingChart() error", (Throwable)e);
            return null;
        }
    }

    public static IQingChartTransfer getTransferImpl(FlashChartType chartType) {
        Class<? extends IQingChartTransfer> clazz = transferImpl.get(chartType);
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LogUtil.getLogger(QingChartFactory.class).error((Object)"getTransferImpl() error", (Throwable)e);
            return null;
        }
    }

    static {
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_PIE, PieChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_PIE, PieTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_COLUMN, ColumnChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_COLUMN, ColumnTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_P_COLUMN, PColumnChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_P_COLUMN, PColumnTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_MSCOLUMN, MSColumnChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_MSCOLUMN, MSColumnTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_BAR, BarChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_BAR, BarTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_MSBAR, MSBarChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_MSBAR, MSBarTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_ST_BAR, STBarChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_ST_BAR, STBarTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_PST_BAR, PSTBarChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_PST_BAR, PSTBarTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_LINE, LineChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_LINE, LineTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_MSLINE, MSLineChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_MSLINE, MSLineTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_AREA, AreaChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_AREA, AreaTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_ST_AREA, STAreaChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_ST_AREA, STAreaTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_PST_AREA, PSTAreaChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_PST_AREA, PSTAreaTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_RING_PIE, RingPieChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_RING_PIE, RingPieTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_PRING_PIE, PRingPieChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_PRING_PIE, PRingPieTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_ROSE_PIE, RosePieChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_ROSE_PIE, RosePieTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_ST_COLUMN, STColumnChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_ST_COLUMN, STColumnTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_FUNNEL, FunnelChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_FUNNEL, FunnelTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_DIAL, DialChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_DIAL, DialTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_SCATTER, ScatterChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_SCATTER, ScatterTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_COMBINA, CombinaChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_COMBINA, CombinaTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_MS_COMBINA, MSCombinaChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_MS_COMBINA, MSCombinaTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_SCATTER_PLOT, ScatterPlotChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_SCATTER_PLOT, ScatterPlotTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_PST_COLUMN, PSTColumnChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_PST_COLUMN, PSTColumnTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_P_BAR, PBarChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_P_BAR, PBarTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_WATERFALL, WaterFallChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_WATERFALL, WaterFallTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_MSRADAR, MSRadarChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_MSRADAR, MSRadarTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_RADAR, RadarChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_RADAR, RadarTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_RECTTREE, RectTreeChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_RECTTREE, RectTreeTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_MSRECTTREE, MSRectTreeChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_MSRECTTREE, MSRectTreeTransferImpl.class);
        QingChartFactory.registerChartImpl(QingChartType.QING_CT_MSSUNBURST, MSSunBurstChart.class);
        QingChartFactory.registerTransferImpl(QingChartType.QING_CT_MSSUNBURST, MSSunBurstTransferImpl.class);
    }
}

