/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.image.QingChartImageLocation;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class QingChartType
extends FlashChartType {
    private static final Map<String, QingChartType> typeMap = new HashMap<String, QingChartType>(8);
    public static final QingChartType QING_CT_PIE = new QingChartType("QPie", "pie", null);
    public static final QingChartType QING_CT_ROSE_PIE = new QingChartType("QRosePie", "rosePie", null);
    public static final QingChartType QING_CT_COLUMN = new QingChartType("QColumn", "column", null);
    public static final QingChartType QING_CT_MSCOLUMN = new QingChartType("QMSColumn", "mscolumn", null);
    public static final QingChartType QING_CT_ST_COLUMN = new QingChartType("QSTColumn", "stcolumn", null);
    public static final QingChartType QING_CT_PST_COLUMN = new QingChartType("QPSTColumn", "pstcolumn", null);
    public static final QingChartType QING_CT_P_COLUMN = new QingChartType("QPColumn", "pcolumn", null);
    public static final QingChartType QING_CT_LINE = new QingChartType("QLine", "line", null);
    public static final QingChartType QING_CT_MSLINE = new QingChartType("QMSLine", "msline", null);
    public static final QingChartType QING_CT_AREA = new QingChartType("QArea", "area", null);
    public static final QingChartType QING_CT_ST_AREA = new QingChartType("QSTArea", "starea", null);
    public static final QingChartType QING_CT_PST_AREA = new QingChartType("QPSTArea", "pstarea", null);
    public static final QingChartType QING_CT_RING_PIE = new QingChartType("QRingPie", "ringPie", null);
    public static final QingChartType QING_CT_PRING_PIE = new QingChartType("QPRingPie", "pringPie", null);
    public static final QingChartType QING_CT_FUNNEL = new QingChartType("QFunnel", "funnel", null);
    public static final QingChartType QING_CT_DIAL = new QingChartType("QDial", "dial", null);
    public static final QingChartType QING_CT_SCATTER_PLOT = new QingChartType("QScatterPlot", "scatterPlot", null);
    public static final QingChartType QING_CT_SCATTER = new QingChartType("QScatter", "scatter", null);
    public static final QingChartType QING_CT_COMBINA = new QingChartType("QCombina", "combina", null);
    public static final QingChartType QING_CT_MS_COMBINA = new QingChartType("QMSCombina", "mscombina", null);
    public static final QingChartType QING_CT_BAR = new QingChartType("QBar", "bar", null);
    public static final QingChartType QING_CT_MSBAR = new QingChartType("QMSBar", "msbar", null);
    public static final QingChartType QING_CT_ST_BAR = new QingChartType("QSTBar", "stbar", null);
    public static final QingChartType QING_CT_PST_BAR = new QingChartType("QPSTBar", "pstbar", null);
    public static final QingChartType QING_CT_P_BAR = new QingChartType("QPBar", "pbar", null);
    public static final QingChartType QING_CT_WATERFALL = new QingChartType("QWaterFall", "waterfall", null);
    public static final QingChartType QING_CT_RADAR = new QingChartType("QRadar", "radar", null);
    public static final QingChartType QING_CT_MSRADAR = new QingChartType("QMSRadar", "msradar", null);
    public static final QingChartType QING_CT_RECTTREE = new QingChartType("QRectTree", "recttree", null);
    public static final QingChartType QING_CT_MSRECTTREE = new QingChartType("QMSRectTree", "msrecttree", null);
    public static final QingChartType QING_CT_MSSUNBURST = new QingChartType("QMSSunburst", "mssunburst", null);

    private QingChartType(String name, String alias, String swf) {
        super(name, alias, swf);
        this.addType(this);
    }

    private void addType(QingChartType chartType) {
        typeMap.put(chartType.getName(), chartType);
    }

    public static QingChartType getType(String name) {
        return typeMap.get(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BufferedImage getImage() {
        String alias = this.getAlias();
        String pngName = alias + ".png";
        try (InputStream inputStream = QingChartImageLocation.class.getResourceAsStream(pngName);){
            BufferedImage bufferedImage = ImageIO.read(Objects.requireNonNull(inputStream));
            return bufferedImage;
        }
        catch (Exception e) {
            Logger.getLogger(QingChartType.class).error((Object)CtrlEXTMessages.getMLS("loadingChartExampleImageFailed", "\u52a0\u8f7d\u56fe\u8868\u793a\u4f8b\u56fe\u7247\u5931\u8d25\uff01"), (Throwable)e);
            return null;
        }
    }

    public static String getNameByAlias(String alias) {
        String lowerAlias;
        switch (lowerAlias = alias.toLowerCase()) {
            case "pie": {
                return QING_CT_PIE.getName();
            }
            case "rosepie": {
                return QING_CT_ROSE_PIE.getName();
            }
            case "column": {
                return QING_CT_COLUMN.getName();
            }
            case "mscolumn": {
                return QING_CT_MSCOLUMN.getName();
            }
            case "stcolumn": {
                return QING_CT_ST_COLUMN.getName();
            }
            case "pstcolumn": {
                return QING_CT_PST_COLUMN.getName();
            }
            case "pcolumn": {
                return QING_CT_P_COLUMN.getName();
            }
            case "line": {
                return QING_CT_LINE.getName();
            }
            case "msline": {
                return QING_CT_MSLINE.getName();
            }
            case "area": {
                return QING_CT_AREA.getName();
            }
            case "starea": {
                return QING_CT_ST_AREA.getName();
            }
            case "pstarea": {
                return QING_CT_PST_AREA.getName();
            }
            case "ringpie": {
                return QING_CT_RING_PIE.getName();
            }
            case "pringpie": {
                return QING_CT_PRING_PIE.getName();
            }
            case "funnel": {
                return QING_CT_FUNNEL.getName();
            }
            case "dial": {
                return QING_CT_DIAL.getName();
            }
            case "scatterplot": {
                return QING_CT_SCATTER_PLOT.getName();
            }
            case "scatter": {
                return QING_CT_SCATTER.getName();
            }
            case "combina": {
                return QING_CT_COMBINA.getName();
            }
            case "mscombina": {
                return QING_CT_MS_COMBINA.getName();
            }
            case "bar": {
                return QING_CT_BAR.getName();
            }
            case "msbar": {
                return QING_CT_MSBAR.getName();
            }
            case "stbar": {
                return QING_CT_ST_BAR.getName();
            }
            case "pstbar": {
                return QING_CT_PST_BAR.getName();
            }
            case "pbar": {
                return QING_CT_P_BAR.getName();
            }
            case "waterfall": {
                return QING_CT_WATERFALL.getName();
            }
            case "radar": {
                return QING_CT_RADAR.getName();
            }
            case "msradar": {
                return QING_CT_MSRADAR.getName();
            }
            case "recttree": {
                return QING_CT_RECTTREE.getName();
            }
            case "msrecttree": {
                return QING_CT_MSRECTTREE.getName();
            }
            case "mssunburst": {
                return QING_CT_MSSUNBURST.getName();
            }
        }
        return alias;
    }
}

