/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.column;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.column.AbstractColumnChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.json.JsonLocation;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.SingleSeriesChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.sort.ISortChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.sort.SortSingleChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.nio.charset.StandardCharsets;

public class ColumnChart
extends AbstractColumnChart {
    private ISortChart sortChart;

    @Override
    public AbstractNormalChartModel createChartModel() {
        SingleSeriesChartModel chartModel = new SingleSeriesChartModel();
        this.setChartModel(chartModel);
        return chartModel;
    }

    @Override
    public AbstractNormalChartModel loadDemoData() {
        this.sortChart = new SortSingleChart();
        String columnJson = QingTransferUtil.getResourceAsString(JsonLocation.class, "column.json", StandardCharsets.UTF_8);
        JsonUtil.CustomJsonParser jsonParser = new JsonUtil.CustomJsonParser();
        jsonParser.addCustomDecoder(AbstractNormalChartModel.INode.class, new AbstractNormalChartModel.INode.JsonDecoder());
        return JsonUtil.decodeFromString(jsonParser, columnJson, SingleSeriesChartModel.class);
    }

    @Override
    protected void configDemoCustomStyle(FlashChartModel model) {
        super.configDemoCustomStyle(model);
        this.sortChart.sortChart(model, this.chartModel);
        this.collectLegend();
        Chart chart = model.getBean().getChart();
        this.configureDataName(chart.seriesName);
        this.addStyle(QingStyle.Y_RULERSCALE, chart);
        this.addStyle(QingStyle.Y_AXIS_NUMBER_FORMAT, chart);
        this.addStyle(QingStyle.Y_RULERSTART, chart);
    }
}

