/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.pie;

import com.kingdee.cosmic.ctrl.common.LanguageManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.json.JsonLocation;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.DiscreteColorConfirmer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.Legends;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.SingleSeriesChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.sort.ISortChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.sort.SortSingleChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class SimilarPieChart
extends AbstractQingChart {
    private Legends.DiscreteColorLegend legend;
    private ISortChart sortChart;

    @Override
    public AbstractNormalChartModel loadDemoData() {
        this.sortChart = new SortSingleChart();
        String pieJson = QingTransferUtil.getResourceAsString(JsonLocation.class, "pie.json", StandardCharsets.UTF_8);
        JsonUtil.CustomJsonParser jsonParser = new JsonUtil.CustomJsonParser();
        jsonParser.addCustomDecoder(AbstractNormalChartModel.INode.class, new AbstractNormalChartModel.INode.JsonDecoder());
        return JsonUtil.decodeFromString(jsonParser, pieJson, SingleSeriesChartModel.class);
    }

    @Override
    public void configDemoCustomStyle(FlashChartModel model) {
        super.configDemoCustomStyle(model);
        this.sortChart.sortChart(model, this.chartModel);
        this.collectLegend();
        this.topToN(model);
        Chart chart = model.getBean().getChart();
        if (chart.showLabels == null) {
            chart.showLabels = "1";
        }
        this.addStyle(QingStyle.SHOW_LEGEND, chart);
        this.addStyle(QingStyle.SHOW_DATALABEL, chart);
        this.addStyle(QingStyle.DATALABEL_FORMAT, chart);
        this.addStyle(QingStyle.DATALABEL_TYPE, chart);
        this.addStyle(QingStyle.SHOW_NEGATIVE, chart);
        this.configureTypeTitle(chart.categoryTitle);
        this.configureDataName(chart.seriesName);
    }

    protected void topToN(FlashChartModel model) {
        Chart chart = model.getBean().getChart();
        int topN = ChartDataTransferUtil.calcTopN(chart.chartTopN);
        List<AbstractNormalChartModel.INode> nodes = this.chartModel.getSeries().get(0).getNodes();
        if (nodes.size() <= topN) {
            return;
        }
        AbstractNormalChartModel.Node node = (AbstractNormalChartModel.Node)nodes.get(topN);
        List<AbstractNormalChartModel.Category> categories = this.chartModel.getCategories();
        int value = Integer.parseInt(node.getValue());
        for (int i = nodes.size() - 1; i > topN; --i) {
            value += Integer.parseInt(((AbstractNormalChartModel.Node)nodes.get(i)).getValue());
            nodes.remove(i);
            categories.remove(i);
        }
        node.setValue(String.valueOf(value));
        node.setText(String.valueOf(value));
        this.formatNodeNumber(model, node);
        if (categories.size() > topN) {
            categories.get(topN).setLabel(LanguageManager.getLangMessage((String)"others", QingChart.class, (String)"\u5176\u5b83"));
        }
        this.collectLegend();
    }

    @Override
    public AbstractNormalChartModel createChartModel() {
        SingleSeriesChartModel chartModel = new SingleSeriesChartModel();
        this.setChartModel(chartModel);
        return chartModel;
    }

    @Override
    public void collectLegend() {
        int colorsNum = this.colors.size();
        this.colorConfirmer = new DiscreteColorConfirmer(this.colors.toArray(new String[0]), Integer.MAX_VALUE);
        for (int i = 0; i < this.chartModel.getCategories().size(); ++i) {
            AbstractNormalChartModel.Category category = this.chartModel.getCategories().get(i);
            category.setOrderingValue(i);
            category.setColor((String)this.colors.get(i % colorsNum));
            this.colorConfirmer.getColor(category, category.getLabel());
        }
        this.setLegend(this.colorConfirmer.createLegend());
    }

    public Legends.DiscreteColorLegend getLegend() {
        return this.legend;
    }

    public void setLegend(Legends.DiscreteColorLegend legend) {
        this.legend = legend;
    }
}

