/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.waterfall;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.json.JsonLocation;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.waterfall.AbstractWaterFallChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.SingleSeriesChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.waterfall.WaterFallTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.nio.charset.StandardCharsets;

public class WaterFallChart
extends AbstractWaterFallChart {
    @Override
    public AbstractNormalChartModel loadDemoData() {
        String waterFallJson = QingTransferUtil.getResourceAsString(JsonLocation.class, "waterfall.json", StandardCharsets.UTF_8);
        JsonUtil.CustomJsonParser jsonParser = new JsonUtil.CustomJsonParser();
        jsonParser.addCustomDecoder(AbstractNormalChartModel.INode.class, new AbstractNormalChartModel.INode.JsonDecoder());
        return JsonUtil.decodeFromString(jsonParser, waterFallJson, SingleSeriesChartModel.class);
    }

    @Override
    public AbstractNormalChartModel createChartModel() {
        SingleSeriesChartModel chartModel = new SingleSeriesChartModel();
        this.setChartModel(chartModel);
        return chartModel;
    }

    @Override
    protected void configDemoCustomStyle(FlashChartModel model) {
        super.configDemoCustomStyle(model);
        Chart chart = model.getBean().getChart();
        this.sortByTypeSingle(model);
        this.configureDataName(chart.seriesName);
        this.addStyle(QingStyle.SHOW_DATALABEL, chart);
        this.addStyle(QingStyle.DATALABEL_FORMAT, chart);
    }

    private void sortByTypeSingle(FlashChartModel model) {
        Chart chart = model.getBean().getChart();
        int topN = ChartDataTransferUtil.calcTopN(chart.chartTopN);
        int negativeTopN = ChartDataTransferUtil.calcTopN(chart.chartNegativeTopN);
        WaterFallTransferImpl.sortByNameWaterFall(this.chartModel, chart, topN, negativeTopN, this.colors, model.getBean());
        this.collectLegend();
    }
}

