/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.function;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.ChartLinkRequestHandler;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.exec.ChartInnerLinkExec;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.ChartDataItemInfo;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.function.IQingChartClickEventHandler;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.function.QingChartsClickEvent;
import com.kingdee.cosmic.ctrl.swing.KDMenuItem;
import javax.swing.JPopupMenu;

public class QingChartHyperLinkHandler
implements IQingChartClickEventHandler {
    private SpreadContext context;

    public QingChartHyperLinkHandler(SpreadContext ctx) {
        this.context = ctx;
    }

    @Override
    public void onClick(QingChartsClickEvent e) {
        if (this.context == null) {
            return;
        }
        ChartDataItemInfo dataItemInfo = new ChartDataItemInfo();
        if (e.getCategoryValue() != null) {
            dataItemInfo.setCategoryName(e.getCategoryValue());
            dataItemInfo.setMultiCategory(true);
        } else {
            dataItemInfo.setCategoryName(e.getName());
        }
        dataItemInfo.setSeriesName(e.getSeriesName());
        if (e.getValue() instanceof JSONArray) {
            JSONArray v = (JSONArray)e.getValue();
            dataItemInfo.setSeriesValue(v.get(0).toString());
        } else {
            dataItemInfo.setSeriesValue(e.getValue() == null ? "" : e.getValue().toString());
        }
        Sheet sheet = this.context.getBook().getActiveSheet();
        EmbedhLayer layer = sheet.getEmbedments(false);
        if (layer == null) {
            return;
        }
        EmbedObject embed = null;
        for (int i = 0; i < layer.size(); ++i) {
            EmbedObject embedObject = layer.getEmbed(i);
            if (!(embedObject instanceof QingChart) || !((QingChart)embedObject).getEmbedId().equals(e.getQingChartID())) continue;
            embed = embedObject;
            break;
        }
        if (embed == null) {
            return;
        }
        QingChart qChart = (QingChart)embed;
        JPopupMenu popMenu = ChartLinkRequestHandler.getChartLinkPopMenu(qChart, this.context, dataItemInfo);
        if (popMenu != null) {
            int count = popMenu.getComponentCount();
            if (count == 1) {
                ((KDMenuItem)popMenu.getComponent(0)).doClick();
            } else if (count > 1) {
                popMenu.setVisible(!popMenu.isVisible());
            }
        } else {
            ChartInnerLinkExec innerLinkExec = (ChartInnerLinkExec)this.context.getHyperLinkHandler().getLinkExec("fsChartInner:");
            if (innerLinkExec != null) {
                innerLinkExec.setDataItemInfo(dataItemInfo);
                innerLinkExec.setChartModel(qChart.getModel());
                innerLinkExec.execute(null);
            }
        }
    }
}

