/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart;

import com.kingdee.cosmic.ctrl.common.LanguageManager;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.Legends;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiscreteColorConfirmer {
    private String[] _palette;
    private List<AbstractChartModel.IOrderingSupported> _itemList = new ArrayList<AbstractChartModel.IOrderingSupported>();
    private Map<Object, String> _colorMap = new HashMap<Object, String>();
    private Map<Object, String> _textMap = new HashMap<Object, String>();
    private String _title;
    private int _topN;
    private boolean _isLegendLonelyIgnored;

    public DiscreteColorConfirmer(String[] colors, int topN) {
        this._palette = colors;
        this._topN = topN;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        return this._title;
    }

    public String getColor(AbstractChartModel.IOrderingSupported object, String text) {
        Object value = object.getOrderingValue();
        String color = this._colorMap.get(value);
        if (color == null) {
            this._itemList.add(object);
            int paletteIndex = this._colorMap.size() % this._palette.length;
            color = this._palette[paletteIndex];
            this._colorMap.put(value, color);
            this._textMap.put(value, text);
        }
        return color;
    }

    public void setLegendLonelyIgnored(boolean isLonelyIgnored) {
        this._isLegendLonelyIgnored = isLonelyIgnored;
    }

    public boolean isLegendIgnored() {
        return this._isLegendLonelyIgnored && this._itemList.size() < 2;
    }

    public Legends.DiscreteColorLegend createLegend() {
        int displayCount;
        Legends.DiscreteColorLegend legend = new Legends.DiscreteColorLegend();
        int count = this._itemList.size();
        int othersCount = count - (displayCount = Math.min(count, this._topN));
        if (othersCount == 1) {
            othersCount = 0;
            displayCount = count;
        }
        for (int i = 0; i < displayCount; ++i) {
            AbstractChartModel.IOrderingSupported item = this._itemList.get(i);
            Object key = item.getOrderingValue();
            String color = this._colorMap.get(key);
            String text = this._textMap.get(key);
            legend.add(color, text);
        }
        legend.setOthersCount(othersCount);
        String othersText = null;
        if (othersCount > 0) {
            othersText = LanguageManager.getLangMessage((String)"itemsAndSoOn", QingChart.class, (String)"\u5176\u5b83#1\u9879");
            othersText = othersText.replace("#1", String.valueOf(othersCount));
        }
        legend.setOthersInfo(othersText);
        return legend;
    }

    public Legends.DiscreteColorLegend createProcessRingLegend(ArrayList<String> seriesList) {
        Legends.DiscreteColorLegend legend = new Legends.DiscreteColorLegend();
        int count = this._itemList.size();
        for (int i = 0; i < count; ++i) {
            AbstractNormalChartModel.Series item = (AbstractNormalChartModel.Series)this._itemList.get(i);
            Object key = item.getOrderingValue();
            String color = this._colorMap.get(key);
            long value = Math.round(Double.parseDouble(((AbstractNormalChartModel.Node)item.getNodes().get(0)).getValue()));
            String text = String.valueOf(value);
            legend.add(color, text, seriesList.get(i));
        }
        return legend;
    }

    public String getRectTreeColor(AbstractChartModel.IOrderingSupported object, String text) {
        Object value = object.getOrderingValue();
        String color = this._colorMap.get(value);
        if (color == null) {
            this._itemList.add(object);
            this._colorMap.put(value, ((AbstractNormalChartModel.TreeChartNode)object).getColor());
            this._textMap.put(value, text);
        }
        return color;
    }
}

