/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart;

import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import java.math.BigDecimal;

public class Scope {
    private BigDecimal _min;
    private BigDecimal _max;
    private boolean _isZeroAppeared;
    private BigDecimal _positiveLargest;
    private BigDecimal _positiveLeast;
    private BigDecimal _negativeLeast;
    private BigDecimal _negativeLargest;

    public void join(BigDecimal value) {
        if (value != null) {
            this._max = this._max == null ? value : this._max.max(value);
            this._min = this._min == null ? value : this._min.min(value);
            int compared = value.compareTo(BigDecimal.ZERO);
            if (compared > 0) {
                this._positiveLargest = this._positiveLargest == null ? value : this._positiveLargest.max(value);
                this._positiveLeast = this._positiveLeast == null ? value : this._positiveLeast.min(value);
            } else if (compared < 0) {
                this._negativeLeast = this._negativeLeast == null ? value : this._negativeLeast.max(value);
                this._negativeLargest = this._negativeLargest == null ? value : this._negativeLargest.min(value);
            } else {
                this._isZeroAppeared = true;
            }
        }
    }

    public BigDecimal getMax() {
        return this._max == null ? BigDecimal.ZERO : this._max;
    }

    public BigDecimal getMin() {
        return this._min == null ? BigDecimal.ZERO : this._min;
    }

    public void makeRulerScale(AbstractNormalChartModel.AxisValueScope axisValueScope) {
        BigDecimal absLargest;
        if (this._positiveLargest == null && this._negativeLargest == null) {
            return;
        }
        BigDecimal bigDecimal = this._positiveLargest == null ? this._negativeLargest.negate() : (absLargest = this._negativeLargest == null ? this._positiveLargest : this._positiveLargest.max(this._negativeLargest.negate()));
        BigDecimal absLeast = this._positiveLeast == null ? this._negativeLeast.negate() : (this._negativeLeast == null ? this._positiveLeast : this._positiveLeast.min(this._negativeLeast.negate()));
        double largest = absLargest.doubleValue();
        double least = absLeast.doubleValue();
        boolean isOnlyOneValue = absLargest.compareTo(absLeast) == 0;
        this.makeScaleForLog(axisValueScope, largest, least, isOnlyOneValue);
        if (!(isOnlyOneValue || this._positiveLargest != null && this._negativeLargest != null)) {
            this.makeCuttableFootForLinear(axisValueScope, largest, least);
        }
        axisValueScope.setMax(this._max.toString());
        axisValueScope.setMin(this._min.toString());
    }

    private void makeScaleForLog(AbstractNormalChartModel.AxisValueScope axisValueScope, double absLargest, double absLeast, boolean isOnlyOneValue) {
        double logMin;
        double logMax;
        int logOffset;
        double logLargest = Math.log10(absLargest);
        double logLeast = Math.log10(absLeast);
        int logLargestUp = (int)Math.ceil(logLargest);
        int logLeastDown = (int)Math.floor(logLeast);
        boolean isSuggestLog = absLargest / absLeast > 20.0;
        int n = logOffset = logLeastDown < 0 ? -logLeastDown : 0;
        if (this._negativeLargest == null) {
            logMax = logLargestUp + logOffset;
            logMin = 0.0;
        } else if (this._positiveLargest == null) {
            logMax = 0.0;
            logMin = -(logLargestUp + logOffset);
        } else {
            logMax = Math.log10(this._positiveLargest.doubleValue()) + (double)logOffset;
            logMin = -(Math.log10(this._negativeLargest.negate().doubleValue()) + (double)logOffset);
        }
        axisValueScope.setLogParam(logMin, logMax, logOffset);
        axisValueScope.setSuggestUseLog(isSuggestLog);
        if (!(isOnlyOneValue || this._positiveLargest != null && this._negativeLargest != null)) {
            this.makeCuttableFootForLog(axisValueScope, logLargest, logLeast, logOffset);
        }
    }

    private void makeCuttableFootForLog(AbstractNormalChartModel.AxisValueScope axisValueScope, double logLargest, double logLeast, int logOffset) {
        double absLargest = logLargest + (double)logOffset;
        double absLeast = logLeast + (double)logOffset;
        Double cuttable = this.calculateCuttableFoot(absLargest, absLeast);
        axisValueScope.setCuttableForLog(cuttable == null ? null : Integer.valueOf(Math.max(0, cuttable.intValue() - 1)));
    }

    private void makeCuttableFootForLinear(AbstractNormalChartModel.AxisValueScope axisValueScope, double absLargest, double absLeast) {
        axisValueScope.setCuttableForLinear(this.calculateCuttableFoot(absLargest, absLeast));
    }

    private Double calculateCuttableFoot(double absLargest, double absLeast) {
        if (!this._isZeroAppeared) {
            double tooNearRatio = 0.6;
            double notTooFarRatio = 0.2;
            double ratio = absLeast / absLargest;
            if (ratio > tooNearRatio) {
                return (absLeast - notTooFarRatio * absLargest) / (1.0 - notTooFarRatio);
            }
        }
        return null;
    }
}

