/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.calculator;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.TrendlineValueComboBoxEditor;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.format.NumberFormater;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.calculator.AvgCalculator;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.calculator.ConstCalculator;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.calculator.MedianCalculator;
import java.math.BigDecimal;

public abstract class AbstractCalculator {
    protected Refline refline;

    public AbstractCalculator(Refline refline) {
        this.refline = refline;
    }

    public abstract void joinCalc(BigDecimal var1);

    public abstract BigDecimal doCalc();

    public abstract AbstractNormalChartModel.PaintableLine getLine();

    public static AbstractCalculator create(Refline refline) {
        if (TrendlineValueComboBoxEditor.getAvg().equalsIgnoreCase(refline.getValue())) {
            return new AvgCalculator(refline);
        }
        if (TrendlineValueComboBoxEditor.getMedian().equalsIgnoreCase(refline.getValue())) {
            return new MedianCalculator(refline);
        }
        return new ConstCalculator(refline);
    }

    protected final String format(BigDecimal value) {
        NumberFormater formater = new NumberFormater();
        formater.setFormatString(this.refline.format);
        return formater.format(value);
    }

    public static class Refline {
        private String value;
        private String label;
        private String format;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }
}

