/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.calculator;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.calculator.AbstractCalculator;
import java.math.BigDecimal;

public class AvgCalculator
extends AbstractCalculator {
    private BigDecimal _total;
    private int _count;

    public AvgCalculator(AbstractCalculator.Refline refline) {
        super(refline);
    }

    @Override
    public void joinCalc(BigDecimal value) {
        this._total = this._total == null ? value : this._total.add(value);
        ++this._count;
    }

    @Override
    public BigDecimal doCalc() {
        if (this._total == null || this._count == 0) {
            return null;
        }
        int scale = Math.min(15, Math.max(8, this._total.scale()));
        return this._total.divide(BigDecimal.valueOf(this._count), scale, 4);
    }

    @Override
    public AbstractNormalChartModel.PaintableLine getLine() {
        BigDecimal value = this.doCalc();
        if (value == null) {
            return null;
        }
        AbstractNormalChartModel.PaintableLine paintableLine = new AbstractNormalChartModel.PaintableLine();
        paintableLine.setLineValue(value.toString());
        if (StringUtil.isEmptyString((String)this.refline.getLabel())) {
            paintableLine.setLabel(null);
        } else {
            paintableLine.setLabel(this.refline.getLabel());
        }
        paintableLine.setTipsTitle(CtrlEXTMessages.getMLS("KEY_ClassifiedStatistics_FunctionName3", "\u5e73\u5747\u503c"));
        paintableLine.setTipsText(this.format(value));
        return paintableLine;
    }

    public void reductionCountByNumber(int nul) {
        if (this._count == 0) {
            return;
        }
        this._count /= nul;
    }
}

