/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.ColorUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ArcDegreeComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.DataLabelComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.DataLabelTypeComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.PanStyleComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.PercentageCeilingComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ProcessDataLabelTypeComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.RulerScaleComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ShowFunnelLadderComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ShowFunnelRatioByComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ShowLaberComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ShowNegativeComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.XRulerStartComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.YRulerStartComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Trendlines;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import java.awt.Color;

public enum QingStyle {
    BACKGROUND{

        @Override
        public String transfer(Chart chart) {
            String bgColor = chart.bgColor[0];
            if (!bgColor.startsWith("#")) {
                return "#" + bgColor;
            }
            return bgColor;
        }

        @Override
        public String key() {
            return "background";
        }
    }
    ,
    SHOW_LEGEND{

        @Override
        public String transfer(Chart chart) {
            if (!"1".equals(chart.showLegend) && chart.showLegend != null) {
                return "NON";
            }
            if ("right".equals(chart.legendPosition)) {
                return "RIGHT";
            }
            return "BOTTOM";
        }

        @Override
        public String key() {
            return "showLegend";
        }
    }
    ,
    CHART_LEFT_MARGIN{

        @Override
        public String transfer(Chart chart) {
            return chart.chartLeftMargin;
        }

        @Override
        public String key() {
            return "leftMargin";
        }
    }
    ,
    CHART_RIGHT_MARGIN{

        @Override
        public String transfer(Chart chart) {
            return chart.chartRightMargin;
        }

        @Override
        public String key() {
            return "rightMargin";
        }
    }
    ,
    CHART_TOP_MARGIN{

        @Override
        public String transfer(Chart chart) {
            double top = Double.parseDouble(chart.chartTopMargin);
            if (!StringUtil.isEmptyString((String)chart.caption) && !StringUtil.isEmptyString((String)chart.subCaption)) {
                return String.valueOf(top + Double.parseDouble(chart.captionFontSize) + Double.parseDouble(chart.subCaptionFontSize));
            }
            if (!StringUtil.isEmptyString((String)chart.caption)) {
                return String.valueOf(top + Double.parseDouble(chart.captionFontSize));
            }
            if (!StringUtil.isEmptyString((String)chart.subCaption)) {
                return String.valueOf(top + Double.parseDouble(chart.subCaptionFontSize));
            }
            return chart.chartTopMargin;
        }

        @Override
        public String key() {
            return "topMargin";
        }
    }
    ,
    CHART_BOTTOM_MARGIN{

        @Override
        public String transfer(Chart chart) {
            return chart.chartBottomMargin;
        }

        @Override
        public String key() {
            return "bottomMargin";
        }
    }
    ,
    BORDER_ALPHA{

        @Override
        public String transfer(Chart chart) {
            return chart.borderAlpha;
        }

        @Override
        public String key() {
            return "borderAlpha";
        }
    }
    ,
    SHOW_DATALABEL{

        @Override
        public String transfer(Chart chart) {
            return chart.showLabels;
        }

        @Override
        public String key() {
            return "showDataLabel";
        }
    }
    ,
    DATALABEL_FORMAT{

        @Override
        public String transfer(Chart chart) {
            return QingTransferUtil.XMLtoQingNumFormat(chart.dataLabelFormat == null ? NumberFormatTemplateEditor.getCommonFormatXML() : chart.dataLabelFormat);
        }

        @Override
        public String key() {
            return "dataLabelFormat";
        }
    }
    ,
    DATALABEL{

        @Override
        public String transfer(Chart chart) {
            if (DataLabelComboBoxEditor.getBar().equals(chart.combinaDataLabel)) {
                return "0x10";
            }
            if (DataLabelComboBoxEditor.getLine().equals(chart.combinaDataLabel)) {
                return "0x01";
            }
            if (DataLabelComboBoxEditor.getBarLine().equals(chart.combinaDataLabel)) {
                return "0x11";
            }
            return "0";
        }

        @Override
        public String key() {
            return "dataLabelType";
        }
    }
    ,
    Y_RULERSCALE{

        @Override
        public String transfer(Chart chart) {
            if (RulerScaleComboBoxEditor.getRulerScaleAuto().equals(chart.chart_rulerScale)) {
                return "AUTO";
            }
            if (RulerScaleComboBoxEditor.getRulerScaleLog().equals(chart.chart_rulerScale)) {
                return "LOG";
            }
            return "LINEAR";
        }

        @Override
        public String key() {
            return "rulerScale";
        }
    }
    ,
    SECOND_RULERSCALE{

        @Override
        public String transfer(Chart chart) {
            if (RulerScaleComboBoxEditor.getRulerScaleAuto().equals(chart.chart_sRulerScale)) {
                return "AUTO";
            }
            if (RulerScaleComboBoxEditor.getRulerScaleLog().equals(chart.chart_sRulerScale)) {
                return "LOG";
            }
            return "LINEAR";
        }

        @Override
        public String key() {
            return "sRulerScale";
        }
    }
    ,
    Y_RULERSTART{

        @Override
        public String transfer(Chart chart) {
            if (YRulerStartComboBoxEditor.getNonZero().equals(chart.chart_yRulerStart)) {
                return "NONZERO";
            }
            return "ZERO";
        }

        @Override
        public String key() {
            return "yRulerStart";
        }
    }
    ,
    Y_UNITTEXT{

        @Override
        public String transfer(Chart chart) {
            return chart.chart_yUnitText;
        }

        @Override
        public String key() {
            return "yUnitText";
        }
    }
    ,
    X_RULERSTART{

        @Override
        public String transfer(Chart chart) {
            if (XRulerStartComboBoxEditor.getNonZero().equals(chart.chart_xRulerStart)) {
                return "NONZERO";
            }
            return "ZERO";
        }

        @Override
        public String key() {
            return "xRulerStart";
        }
    }
    ,
    X_UNITTEXT{

        @Override
        public String transfer(Chart chart) {
            return chart.chart_xUnitText;
        }

        @Override
        public String key() {
            return "xUnitText";
        }
    }
    ,
    NUMBER_FORMAT{

        @Override
        public String transfer(Chart chart) {
            return QingTransferUtil.toQingNumFormat(chart);
        }

        @Override
        public String key() {
            return "numberFormat";
        }
    }
    ,
    Y_AXIS_NUMBER_FORMAT{

        @Override
        public String transfer(Chart chart) {
            if (StringUtil.isEmptyString((String)chart.yAxisFormat)) {
                return QingTransferUtil.toQingNumFormat(chart);
            }
            return QingTransferUtil.XMLtoQingNumFormat(chart.yAxisFormat);
        }

        @Override
        public String key() {
            return "yNumberAxisFormat";
        }
    }
    ,
    X_AXIS_NUMBER_FORMAT{

        @Override
        public String transfer(Chart chart) {
            if (StringUtil.isEmptyString((String)chart.xAxisFormat)) {
                return QingTransferUtil.toQingNumFormat(chart);
            }
            return QingTransferUtil.XMLtoQingNumFormat(chart.xAxisFormat);
        }

        @Override
        public String key() {
            return "xNumberAxisFormat";
        }
    }
    ,
    REFLINE_COLOR{

        @Override
        public String transfer(Chart chart) {
            Trendlines trendlines = chart.trendlines;
            if (trendlines != null && trendlines.lines != null && trendlines.lines.length > 0) {
                return trendlines.lines[0].color + "80";
            }
            if (chart.trendlineYValue != null) {
                return chart.trendlineColor + "80";
            }
            return null;
        }

        @Override
        public String key() {
            return "reflineColor";
        }
    }
    ,
    REFLINE_TIPS_COLOR{

        @Override
        public String transfer(Chart chart) {
            Trendlines trendlines = chart.trendlines;
            if (trendlines != null && trendlines.lines != null && trendlines.lines.length > 0) {
                return trendlines.lines[0].color + "80";
            }
            if (chart.trendlineYValue != null) {
                return chart.trendlineColor + "80";
            }
            return null;
        }

        @Override
        public String key() {
            return "reflineTipsColor";
        }
    }
    ,
    REFLINE_COLOR_HOVER{

        @Override
        public String transfer(Chart chart) {
            Trendlines trendlines = chart.trendlines;
            if (trendlines != null && trendlines.lines != null && trendlines.lines.length > 0) {
                return trendlines.lines[0].color;
            }
            if (chart.trendlineYValue != null) {
                return chart.trendlineColor;
            }
            return null;
        }

        @Override
        public String key() {
            return "reflineColorHover";
        }
    }
    ,
    DATALABEL_TYPE{

        @Override
        public String transfer(Chart chart) {
            if (DataLabelTypeComboBoxEditor.getNumber().equals(chart.dataLabelType)) {
                return String.valueOf(2);
            }
            if (DataLabelTypeComboBoxEditor.getPercent().equals(chart.dataLabelType)) {
                return String.valueOf(4);
            }
            if (DataLabelTypeComboBoxEditor.getNameNumber().equals(chart.dataLabelType)) {
                return String.valueOf(3);
            }
            if (DataLabelTypeComboBoxEditor.getNamePercent().equals(chart.dataLabelType)) {
                return String.valueOf(5);
            }
            if (DataLabelTypeComboBoxEditor.getNumberPercent().equals(chart.dataLabelType)) {
                return String.valueOf(6);
            }
            return String.valueOf(1);
        }

        @Override
        public String key() {
            return "dataLabelType";
        }
    }
    ,
    SHOW_NEGATIVE{

        @Override
        public String transfer(Chart chart) {
            String negative = chart.chartShowNegative;
            if (ShowNegativeComboBoxEditor.getIgnore().equals(negative)) {
                return "ignored";
            }
            if (ShowNegativeComboBoxEditor.getAbs().equals(negative)) {
                return "abs";
            }
            return null;
        }

        @Override
        public String key() {
            return "showNegative";
        }
    }
    ,
    SMOOTH_CURVE{

        @Override
        public String transfer(Chart chart) {
            return chart.smoothCurve;
        }

        @Override
        public String key() {
            return "smoothCurve";
        }
    }
    ,
    ZERO_INSTEAD_NULL{

        @Override
        public String transfer(Chart chart) {
            return chart.zeroInsteadNull;
        }

        @Override
        public String key() {
            return "zeroInsteadNull";
        }
    }
    ,
    SHOW_VALUES{

        @Override
        public String transfer(Chart chart) {
            return chart.showValues;
        }

        @Override
        public String key() {
            return "showValues";
        }
    }
    ,
    DATA_ANCHORS{

        @Override
        public String transfer(Chart chart) {
            return chart.drawAnchors;
        }

        @Override
        public String key() {
            return "dataAnchors";
        }
    }
    ,
    RING_CENTER_COLOR{

        @Override
        public String transfer(Chart chart) {
            String color = null;
            if (chart.ringCenterColor != null) {
                String[] colorItems = chart.ringCenterColor.split(";");
                color = colorItems.length > 3 ? "rgba(" + colorItems[0] + "," + colorItems[1] + "," + colorItems[2] + "," + colorItems[3] + ")" : "rgba(" + colorItems[0] + "," + colorItems[1] + "," + colorItems[2] + "," + 255 + ")";
            }
            return color;
        }

        @Override
        public String key() {
            return "ringCenterColor";
        }
    }
    ,
    DATA_LABEL_OVERLAPPABLE{

        @Override
        public String transfer(Chart chart) {
            return chart.dataLabelOverlappable == null ? "0" : chart.dataLabelOverlappable;
        }

        @Override
        public String key() {
            return "dataLabelOverlappable";
        }
    }
    ,
    AVERAGE_ANGLE{

        @Override
        public String transfer(Chart chart) {
            return chart.averageAngle == null ? "0" : chart.averageAngle;
        }

        @Override
        public String key() {
            return "averageAngle";
        }
    }
    ,
    FUNNEL_LADDER{

        @Override
        public String transfer(Chart chart) {
            String funnelLadder = chart.funnelLadder;
            if (ShowFunnelLadderComboBoxEditor.getActual().equals(funnelLadder)) {
                return "0";
            }
            if (ShowFunnelLadderComboBoxEditor.getPerfect().equals(funnelLadder)) {
                return "1";
            }
            return "1";
        }

        @Override
        public String key() {
            return "funnelLadder";
        }
    }
    ,
    LABEL_NAME{

        @Override
        public String transfer(Chart chart) {
            String labelName = chart.labelName;
            if (ShowLaberComboBoxEditor.getLeft().equals(labelName)) {
                return "1";
            }
            if (ShowLaberComboBoxEditor.getCenter().equals(labelName)) {
                return "2";
            }
            if (ShowLaberComboBoxEditor.getRight().equals(labelName)) {
                return "3";
            }
            if (CtrlEXTMessages.getMLS("KEY_HIDE", "\u9690\u85cf").equals(labelName)) {
                return "0";
            }
            return "1";
        }

        @Override
        public String key() {
            return "labelName";
        }
    }
    ,
    LABEL_VALUE{

        @Override
        public String transfer(Chart chart) {
            String labelValue = chart.labelValue;
            if (ShowLaberComboBoxEditor.getLeft().equals(labelValue)) {
                return "1";
            }
            if (ShowLaberComboBoxEditor.getCenter().equals(labelValue)) {
                return "2";
            }
            if (ShowLaberComboBoxEditor.getRight().equals(labelValue)) {
                return "3";
            }
            if (CtrlEXTMessages.getMLS("KEY_HIDE", "\u9690\u85cf").equals(labelValue)) {
                return "0";
            }
            return "0";
        }

        @Override
        public String key() {
            return "labelValue";
        }
    }
    ,
    LABEL_PERCENT{

        @Override
        public String transfer(Chart chart) {
            String labelPercent = chart.labelPercent;
            if (ShowLaberComboBoxEditor.getLeft().equals(labelPercent)) {
                return "1";
            }
            if (ShowLaberComboBoxEditor.getCenter().equals(labelPercent)) {
                return "2";
            }
            if (ShowLaberComboBoxEditor.getRight().equals(labelPercent)) {
                return "3";
            }
            if (ShowLaberComboBoxEditor.getHide().equals(labelPercent)) {
                return "0";
            }
            return "3";
        }

        @Override
        public String key() {
            return "labelPercent";
        }
    }
    ,
    RATIO_BY{

        @Override
        public String transfer(Chart chart) {
            String ratioBy = chart.ratioBy;
            if (ShowFunnelRatioByComboBoxEditor.getStep().equals(ratioBy)) {
                return "step";
            }
            if (ShowFunnelRatioByComboBoxEditor.getStart().equals(ratioBy)) {
                return "start";
            }
            if (ShowFunnelRatioByComboBoxEditor.getTotal().equals(ratioBy)) {
                return "total";
            }
            return "total";
        }

        @Override
        public String key() {
            return "ratioBy";
        }
    }
    ,
    RATIO_FORMAT{

        @Override
        public String transfer(Chart chart) {
            return QingTransferUtil.XMLtoQingNumFormat(chart.ratioFormat == null ? NumberFormatTemplateEditor.getPercentCommonFormatXML() : chart.ratioFormat);
        }

        @Override
        public String key() {
            return "ratioFormat";
        }
    }
    ,
    ARC_DEGREE{

        @Override
        public String transfer(Chart chart) {
            String arcDegree = chart.arcDegree;
            if (ArcDegreeComboBoxEditor.getArcSemiCircle().equals(arcDegree)) {
                return "240";
            }
            if (ArcDegreeComboBoxEditor.getArcQuasi_Circle().equals(arcDegree)) {
                return "180";
            }
            return "240";
        }

        @Override
        public String key() {
            return "arcDegree";
        }
    }
    ,
    PAN_STYLE{

        @Override
        public String transfer(Chart chart) {
            String panStyle = chart.panStyle;
            if (PanStyleComboBoxEditor.getPanStyleTrack().equals(panStyle)) {
                return "withTrack";
            }
            if (PanStyleComboBoxEditor.getPabStyleMark().equals(panStyle)) {
                return "onlyMark";
            }
            return "withTrack";
        }

        @Override
        public String key() {
            return "panStyle";
        }
    }
    ,
    SHOW_RULER_MARK_LABEL{

        @Override
        public String transfer(Chart chart) {
            return chart.showRulerMarkLabel == null ? "1" : chart.showRulerMarkLabel;
        }

        @Override
        public String key() {
            return "showRulerMarkLabel";
        }
    }
    ,
    POINTER_NAME{

        @Override
        public String transfer(Chart chart) {
            return chart.categoryTitle == null ? CtrlEXTMessages.getMLS("category", "\u5206\u7c7b") : chart.categoryTitle;
        }

        @Override
        public String key() {
            return "pointerName";
        }
    }
    ,
    NUMERAL_FORMAT{

        @Override
        public String transfer(Chart chart) {
            return QingTransferUtil.XMLtoQingNumFormat(chart.numeralFormat == null ? NumberFormatTemplateEditor.getNumberFormatXML() : chart.numeralFormat);
        }

        @Override
        public String key() {
            return "numeralFormat";
        }
    }
    ,
    OVERLAP_SHRINKING_RATIO{

        @Override
        public String transfer(Chart chart) {
            return chart.overlapShrinkingRatio;
        }

        @Override
        public String key() {
            return "overlapShrinkingRatio";
        }
    }
    ,
    PROCESS_LABEL_TYPE{

        @Override
        public String transfer(Chart chart) {
            if (ProcessDataLabelTypeComboBoxEditor.getNumber().equals(chart.processDataLabelType)) {
                return String.valueOf(1);
            }
            if (ProcessDataLabelTypeComboBoxEditor.getPercent().equals(chart.processDataLabelType)) {
                return String.valueOf(2);
            }
            return String.valueOf(3);
        }

        @Override
        public String key() {
            return "processDataLabelType";
        }
    }
    ,
    PERCENTAGE_DIGIT{

        @Override
        public String transfer(Chart chart) {
            return chart.percentageDigit == null ? "0" : chart.percentageDigit;
        }

        @Override
        public String key() {
            return "percentageDigit";
        }
    }
    ,
    PERCENTAGE_CEILING{

        @Override
        public String transfer(Chart chart) {
            if (PercentageCeilingComboBoxEditor.getUp100().equals(chart.percentageCeiling)) {
                return "0";
            }
            return "1";
        }

        @Override
        public String key() {
            return "percentageCeiling";
        }
    }
    ,
    LABEL_DESC{

        @Override
        public String transfer(Chart chart) {
            return chart.labelDesc == null ? CtrlEXTMessages.getMLS("conversionRate", "\u5b8c\u6210\u7387") : chart.labelDesc;
        }

        @Override
        public String key() {
            return "labelDesc";
        }
    }
    ,
    CHART_TITLE_COLOR{

        @Override
        public String transfer(Chart chart) {
            return chart.captionColor == null ? "#000000" : ColorUtil.colorToHexStr((Color)EChartUtils.transformColor(chart.captionColor).getColorValue());
        }

        @Override
        public String key() {
            return "chartTitleColor";
        }
    }
    ,
    CHART_DEPUTY_TITLE_COLOR{

        @Override
        public String transfer(Chart chart) {
            return chart.subCaptionColor == null ? "#000000" : ColorUtil.colorToHexStr((Color)EChartUtils.transformColor(chart.subCaptionColor).getColorValue());
        }

        @Override
        public String key() {
            return "chartDeputyTitleColor";
        }
    }
    ,
    FILL_COLOR{

        @Override
        public String transfer(Chart chart) {
            return chart.fillColor == null ? "1" : chart.fillColor;
        }

        @Override
        public String key() {
            return "fillColor";
        }
    };


    public abstract String transfer(Chart var1);

    public abstract String key();
}

