/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.combina;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.MultiSeriesQingChartTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import java.util.ArrayList;

public class SimilarCombinaTransferImpl
extends MultiSeriesQingChartTransfer {
    protected int lineLen;

    @Override
    public AbstractQingChart process(FlashChartModel model) {
        AbstractQingChart qingChart = super.process(model);
        this.configureAxisFeature();
        qingChart.collectLegend();
        return qingChart;
    }

    @Override
    protected void collectSeries() {
        Object[] data = this.getSeriesData();
        String[] seriesKeys = this.getSeriesKeys();
        ArrayList<AbstractNormalChartModel.Series> seriesList = new ArrayList<AbstractNormalChartModel.Series>(8);
        for (int i = 0; i < data.length; ++i) {
            double[][] seriesData = (double[][])data[i];
            this.collectSingleSeries(seriesData, i, seriesKeys, seriesList, seriesKeys.length);
        }
        int size = seriesList.size();
        for (int i = size - 1; i >= size - this.lineLen; --i) {
            ((AbstractNormalChartModel.Series)seriesList.get(i)).setAxisIndex(1);
        }
        this.chartModel.setSeries(seriesList);
    }

    @Override
    protected String[] getGroupKeys() {
        if ("cell".equals(this.dataNode.getDataFrom())) {
            if (this.dataNode.getGroupKeysWithoutCalc() != null) {
                return this.dataNode.getGroupKeysWithoutCalc();
            }
            String[] groupKeys = this.getCellGroupKeys();
            this.dataNode.setGroupKeys(groupKeys);
            return groupKeys;
        }
        return super.getGroupKeys();
    }

    protected String[] getCellGroupKeys() {
        Variant[][] data = (Variant[][])((Object[])this.dataNode.getData(FusionChartDataNode.COMBINATION_CHART_GROUP_FORMULA))[0];
        ArrayList<String> ret = new ArrayList<String>();
        int row = data.length;
        for (int i = 0; i < row; ++i) {
            int col = data[i].length;
            for (int j = 0; j < col; ++j) {
                if (data[i][j] instanceof com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant) {
                    ret.add(((com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant)data[i][j]).getText());
                    continue;
                }
                ret.add(data[i][j].toString());
            }
        }
        String[] groups = new String[ret.size()];
        ret.toArray(groups);
        return groups;
    }

    protected String[] getCellSeriesKeys() {
        Object[] data = (Object[])this.dataNode.getData(FusionChartDataNode.COMBINATION_CHART_SERIES_NAMES);
        ArrayList arrayList = new ArrayList(8);
        for (int i = 0; i < data.length; ++i) {
            Variant[][] variants = (Variant[][])data[i];
            arrayList.addAll(ChartDataTransferUtil.parseValue2String(variants));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    protected String[] getSeriesKeys() {
        if ("cell".equals(this.dataNode.getDataFrom())) {
            if (this.dataNode.getSeriesKeysWithoutCalc() != null) {
                return (String[])this.dataNode.getSeriesKeysWithoutCalc();
            }
            String[] seriesKeys = this.getCellSeriesKeys();
            this.dataNode.setSerieskeys(seriesKeys);
            return seriesKeys;
        }
        return null;
    }

    @Override
    protected Object[] getSeriesData() {
        if ("cell".equals(this.dataNode.getDataFrom())) {
            double[][] datas;
            if (this.dataNode.getDataWithoutCalc() != null) {
                Object[] dataWithoutCalc = (Object[])this.dataNode.getDataWithoutCalc();
                Object[] d = (Object[])this.dataNode.getData(FusionChartDataNode.COMBINATION_CHART_DATA_FORMULA);
                this.lineLen = d.length - 1;
                return dataWithoutCalc;
            }
            boolean isFillNullWithZero = this.dataNode.isFillNullWithZero();
            Object[] d = (Object[])this.dataNode.getData(FusionChartDataNode.COMBINATION_CHART_DATA_FORMULA);
            this.lineLen = d.length - 1;
            Object[] data = new Object[d.length];
            if (this.dataNode.isSerialByCol()) {
                for (int i = 0; i < d.length; ++i) {
                    data[i] = ChartDataTransferUtil.povitDoubles((Variant[][])d[i]);
                }
                datas = ChartDataTransferUtil.parseValue2Double(data, isFillNullWithZero);
            } else {
                datas = ChartDataTransferUtil.parseValue2Double(d, isFillNullWithZero);
            }
            Object[] oData = new Object[]{datas};
            this.dataNode.setData(oData);
            return oData;
        }
        Object[] d = (Object[])this.dataNode.getData();
        int len = 0;
        int dataLen = 0;
        this.lineLen = 0;
        for (int i = 0; i < d.length; ++i) {
            double[][] datas = (double[][])d[i];
            if (datas.length == 0 || datas[0].length == 0) {
                return new Object[0];
            }
            if (i != 0) {
                this.lineLen += datas.length;
            }
            len += datas.length;
            dataLen = datas[0].length;
        }
        double[][] seriesDatas = new double[len][dataLen];
        int index = 0;
        for (int k = 0; k < d.length; ++k) {
            double[][] doubles = (double[][])d[k];
            for (int i = 0; i < doubles.length; ++i) {
                for (int j = 0; j < dataLen; ++j) {
                    seriesDatas[index][j] = doubles[i][j];
                }
                ++index;
            }
        }
        return new Object[]{seriesDatas};
    }

    @Override
    protected void checkChartData() {
        if ("cell".equals(this.dataNode.getDataFrom())) {
            Object[] data = (Object[])this.dataNode.getData(FusionChartDataNode.COMBINATION_CHART_DATA_FORMULA);
            if (data == null) {
                throw new RuntimeException(CtrlEXTMessages.getMLS("dataEmpty", "\u6570\u636e\u4e3a\u7a7a"));
            }
            boolean showTips = true;
            for (int i = 0; i < data.length; ++i) {
                Variant[][] seriesData = (Variant[][])data[i];
                for (int j = 0; j < seriesData.length; ++j) {
                    if (seriesData[j].length == 1 && (seriesData[j][0].getValue() == null || StringUtil.isEmptyString((String)seriesData[j][0].getValue().toString()))) continue;
                    showTips = false;
                }
            }
            if (showTips) {
                this.addEmptyTips();
            }
        } else if ("dataset".equals(this.dataNode.getDataFrom())) {
            Object[] data = (Object[])this.dataNode.getData();
            if (data == null) {
                throw new RuntimeException(CtrlEXTMessages.getMLS("dataEmpty", "\u6570\u636e\u4e3a\u7a7a"));
            }
            for (int i = 0; i < data.length; ++i) {
                double[][] seriesData = (double[][])data[i];
                if (seriesData.length != 0 && seriesData[0].length != 0) continue;
                this.addEmptyTips();
            }
        }
    }

    @Override
    protected boolean fillColorToCategory() {
        return true;
    }

    @Override
    protected void personalizedStyle() {
        super.personalizedStyle();
        this.qingChart.addStyle(QingStyle.X_AXIS_NUMBER_FORMAT, this.chart);
        this.qingChart.addStyle(QingStyle.SECOND_RULERSCALE, this.chart);
        this.qingChart.addStyle(QingStyle.SHOW_LEGEND, this.chart);
        this.qingChart.addStyle(QingStyle.DATALABEL, this.chart);
        this.qingChart.addStyle(QingStyle.DATALABEL_FORMAT, this.chart);
        this.qingChart.addStyle(QingStyle.REFLINE_COLOR, this.chart);
        this.qingChart.addStyle(QingStyle.REFLINE_COLOR_HOVER, this.chart);
        this.qingChart.addStyle(QingStyle.REFLINE_TIPS_COLOR, this.chart);
        this.qingChart.addStyle(QingStyle.SMOOTH_CURVE, this.chart);
        this.qingChart.addStyle(QingStyle.DATA_ANCHORS, this.chart);
        this.qingChart.addStyle(QingStyle.Y_AXIS_NUMBER_FORMAT, this.chart);
        this.qingChart.addStyle(QingStyle.NUMERAL_FORMAT, this.chart);
    }
}

