/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.radar;

import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.radar.MSRadarChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.MultiSeriesQingChartTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import java.util.ArrayList;

public class MSRadarTransferImpl
extends MultiSeriesQingChartTransfer {
    @Override
    public void prepare(FlashChartModel model) {
        super.prepare(model);
        this.qingChart = new MSRadarChart();
        this.qingChart.setColors(this.colors);
        this.chartModel = this.qingChart.createChartModel();
    }

    @Override
    public AbstractQingChart process(FlashChartModel model) {
        this.checkChartData();
        this.collectCategories();
        this.collectSeries();
        this.qingChart.collectLegend();
        return this.qingChart;
    }

    @Override
    protected boolean fillColorToCategory() {
        return true;
    }

    @Override
    public void personalizedStyle() {
        super.personalizedStyle();
        this.qingChart.addStyle(QingStyle.SHOW_DATALABEL, this.chart);
        this.qingChart.addStyle(QingStyle.SHOW_LEGEND, this.chart);
        this.qingChart.addStyle(QingStyle.FILL_COLOR, this.chart);
        this.qingChart.addStyle(QingStyle.SHOW_RULER_MARK_LABEL, this.chart);
        this.qingChart.addStyle(QingStyle.NUMERAL_FORMAT, this.chart);
    }

    @Override
    protected void collectSeries() {
        Object[] data = this.getSeriesData();
        String[] seriesKeys = this.getSeriesKeys();
        ArrayList<AbstractNormalChartModel.Series> seriesList = new ArrayList<AbstractNormalChartModel.Series>(8);
        for (int i = 0; i < data.length; ++i) {
            double[][] seriesData = (double[][])data[i];
            for (int j = 0; j < seriesData.length; ++j) {
                AbstractNormalChartModel.Series series = new AbstractNormalChartModel.Series();
                series.setName(seriesKeys[j]);
                series.setSeriesFieldValueText(seriesKeys[j], seriesKeys[j]);
                ArrayList<AbstractNormalChartModel.INode> arrNode = new ArrayList<AbstractNormalChartModel.INode>(8);
                for (int k = 0; k < seriesData[0].length; ++k) {
                    String value = String.valueOf(seriesData[j][k]);
                    AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
                    if (value.equalsIgnoreCase("NaN")) {
                        value = "0";
                    }
                    node.setValue(value);
                    node.setText(value);
                    this.formatNodeNumber(node);
                    arrNode.add(node);
                }
                series.setColor((String)this.colors.get((i * seriesData.length + j) % this.colors.size()));
                series.setNodes(arrNode);
                series.setAxisIndex(i);
                series.setFormatString(QingTransferUtil.toQingNumFormat(this.chart));
                seriesList.add(series);
            }
        }
        this.chartModel.setSeries(seriesList);
    }

    @Override
    protected void collectCategories() {
        String[] groupKeys = this.getGroupKeys();
        ArrayList<AbstractNormalChartModel.Category> categoryList = new ArrayList<AbstractNormalChartModel.Category>(groupKeys.length);
        for (int i = 0; i < groupKeys.length; ++i) {
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            if (this.fillColorToCategory()) {
                category.setColor((String)this.colors.get(i % this.colors.size()));
            }
            category.setLabel(this.formatValue(groupKeys[i]));
            categoryList.add(category);
        }
        this.chartModel.setCategoryTitle(this.chart.categoryTitle);
        this.chartModel.setCategories(categoryList);
    }
}

