/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.tree;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ShowNegativeComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.SortEnum;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.TreeChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.MultiSeriesQingChartTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.waterfall.WaterFallTransferImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class MSTreeTransferImpl
extends MultiSeriesQingChartTransfer {
    @Override
    public void prepare(FlashChartModel model) {
        super.prepare(model);
    }

    @Override
    public void personalizedStyle() {
        super.personalizedStyle();
        this.qingChart.addStyle(QingStyle.SHOW_DATALABEL, this.chart);
        this.qingChart.addStyle(QingStyle.SHOW_NEGATIVE, this.chart);
        this.qingChart.addStyle(QingStyle.SHOW_LEGEND, this.chart);
    }

    public AbstractNormalChartModel collectRoot(AbstractNormalChartModel chartModel, TreeChartModel treeChartModel, List<String> colors) {
        int j;
        int i;
        List<AbstractNormalChartModel.Series> series = chartModel.getSeries();
        List<AbstractNormalChartModel.Category> categories = chartModel.getCategories();
        AbstractNormalChartModel.TreeChartNode treeRoot = new AbstractNormalChartModel.TreeChartNode();
        ArrayList<AbstractNormalChartModel.TreeChartNode> treeChildrenList = new ArrayList<AbstractNormalChartModel.TreeChartNode>(series.size());
        HashMap<String, AbstractNormalChartModel.Series> seriesMap = new HashMap<String, AbstractNormalChartModel.Series>(8);
        HashSet<String> seriesSet = new HashSet<String>(8);
        for (i = 0; i < series.size(); ++i) {
            AbstractNormalChartModel.Series seriesKey = series.get(i);
            String seriesKeyName = seriesKey.getName();
            if (seriesKeyName == null) {
                seriesKey.setName("");
            }
            if (seriesMap.containsKey(seriesKeyName)) {
                AbstractNormalChartModel.Series oriSeries = (AbstractNormalChartModel.Series)seriesMap.get(seriesKeyName);
                List<AbstractNormalChartModel.INode> nodes = oriSeries.getNodes();
                List<AbstractNormalChartModel.INode> newNodes = seriesKey.getNodes();
                for (j = 0; j < nodes.size(); ++j) {
                    AbstractNormalChartModel.Node oriNode = (AbstractNormalChartModel.Node)nodes.get(j);
                    AbstractNormalChartModel.Node newNode = (AbstractNormalChartModel.Node)newNodes.get(j);
                    oriNode.setValue(Double.parseDouble(newNode.getValue()) + Double.parseDouble(oriNode.getValue()) + "");
                    oriNode.setText(oriNode.getValue());
                }
                continue;
            }
            seriesMap.put(seriesKeyName, seriesKey);
        }
        for (i = 0; i < series.size(); ++i) {
            AbstractNormalChartModel.TreeChartNode childrenRoot = new AbstractNormalChartModel.TreeChartNode();
            AbstractNormalChartModel.Series seriesKey = series.get(i);
            if (seriesSet.contains(seriesKey.getName())) continue;
            seriesSet.add(seriesKey.getName());
            childrenRoot.setLabel(seriesKey.getName());
            childrenRoot.setColor(colors.get(i % colors.size()));
            List<AbstractNormalChartModel.INode> arrNode = seriesKey.getNodes();
            arrNode = WaterFallTransferImpl.getSeriesOrigin(arrNode);
            ArrayList<AbstractNormalChartModel.Node> arrSortNode = new ArrayList<AbstractNormalChartModel.Node>(8);
            for (int k = 0; k < arrNode.size(); ++k) {
                arrSortNode.add((AbstractNormalChartModel.Node)arrNode.get(k));
            }
            if (!this.isModulus(this.chart.chartShowNegative)) {
                arrSortNode.sort((o1, o2) -> o2.getOrigin().compareTo(o1.getOrigin()));
            } else {
                arrSortNode.sort((o1, o2) -> o2.getOrigin().abs().compareTo(o1.getOrigin().abs()));
            }
            ArrayList<AbstractNormalChartModel.TreeChartNode> childrenList = new ArrayList<AbstractNormalChartModel.TreeChartNode>(arrNode.size());
            for (j = 0; j < arrSortNode.size(); ++j) {
                AbstractNormalChartModel.TreeChartNode treeNode = new AbstractNormalChartModel.TreeChartNode();
                AbstractNormalChartModel.Node node = (AbstractNormalChartModel.Node)arrSortNode.get(j);
                AbstractNormalChartModel.Category category = categories.get(arrNode.indexOf(arrSortNode.get(j)));
                if ("0".equals(node.getValue()) || "0.0".equals(node.getValue())) continue;
                treeNode.setLabel(category.getLabel());
                treeNode.setSize(node.getValue());
                childrenList.add(treeNode);
            }
            if (childrenList.size() == 0) continue;
            childrenRoot.setChildren(childrenList);
            treeChildrenList.add(childrenRoot);
        }
        if (treeChildrenList.size() != 0) {
            treeRoot.setChildren(treeChildrenList);
        }
        treeChartModel.setRoot(treeRoot);
        return treeChartModel;
    }

    @Override
    protected boolean fillColorToCategory() {
        return true;
    }

    public boolean isModulus(String modulus) {
        return ShowNegativeComboBoxEditor.getAbs().equals(modulus);
    }

    public void sortMSTree() {
        List<AbstractNormalChartModel.Series> seriesList = this.chartModel.getSeries();
        ArrayList<AbstractNormalChartModel.Series> newSeriesList = new ArrayList<AbstractNormalChartModel.Series>(seriesList.size());
        double[][] oData = (double[][])ChartDataTransferUtil.converToData(this.chartModel.getSeries())[0];
        List<String> seriesKeyList = Arrays.asList(this.getSeriesKeys());
        List<String> groups = QingTransferUtil.sortedMSTreeByMeasure(oData, SortEnum.DESC, seriesKeyList, this.isModulus(this.chart.chartShowNegative));
        int size = seriesList.size();
        HashSet<Integer> set = new HashSet<Integer>(size);
        for (int i = 0; i < groups.size(); ++i) {
            String key = groups.get(i);
            for (int j = 0; j < size; ++j) {
                AbstractNormalChartModel.Series series = seriesList.get(j);
                if (key != series.getName() || set.contains(j)) continue;
                newSeriesList.add(series);
                set.add(j);
            }
        }
        this.chartModel.setSeries(newSeriesList);
    }
}

