/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.waterfall;

import com.kingdee.cosmic.ctrl.common.LanguageManager;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ShowFunnelSortByComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ShowNegativeWaterFallComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.bar.BarChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.SingleSeriesQingChartTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;

public class WaterFallTransferImpl
extends SingleSeriesQingChartTransfer {
    @Override
    public void prepare(FlashChartModel model) {
        super.prepare(model);
        this.qingChart = new BarChart();
        this.qingChart.setColors(this.colors);
        this.chartModel = this.qingChart.createChartModel();
    }

    @Override
    public AbstractQingChart process(FlashChartModel model) {
        this.checkChartData();
        this.collectCategories();
        this.collectScopes();
        this.collectSeries();
        return this.qingChart;
    }

    @Override
    protected boolean fillColorToCategory() {
        return false;
    }

    @Override
    public void personalizedStyle() {
        super.personalizedStyle();
        this.qingChart.addStyle(QingStyle.Y_UNITTEXT, this.chart);
        this.qingChart.addStyle(QingStyle.Y_AXIS_NUMBER_FORMAT, this.chart);
        this.qingChart.addStyle(QingStyle.SHOW_DATALABEL, this.chart);
        this.qingChart.addStyle(QingStyle.DATALABEL_FORMAT, this.chart);
        this.qingChart.addStyle(QingStyle.DATA_LABEL_OVERLAPPABLE, this.chart);
        this.qingChart.addStyle("chartSum", this.chart.showSum);
    }

    @Override
    protected void collectSeries() {
        Object[] data = this.getSeriesData();
        String[] seriesKeys = this.getSeriesKeys();
        ArrayList<AbstractNormalChartModel.Series> seriesList = new ArrayList<AbstractNormalChartModel.Series>(8);
        for (int i = 0; i < data.length; ++i) {
            double[][] seriesData = (double[][])data[i];
            AbstractNormalChartModel.Series series = new AbstractNormalChartModel.Series();
            series.setName(seriesKeys[0]);
            series.setSeriesFieldValueText(seriesKeys[0], seriesKeys[0]);
            ArrayList<AbstractNormalChartModel.INode> arrNode = new ArrayList<AbstractNormalChartModel.INode>(8);
            for (int k = 0; k < seriesData[0].length; ++k) {
                String value = String.valueOf(seriesData[0][k]);
                AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
                if (value.equalsIgnoreCase("NaN")) {
                    value = "0";
                }
                node.setValue(value);
                node.setText(value);
                this.formatNodeNumber(node);
                arrNode.add(node);
            }
            series.setColor((String)this.colors.get(i % this.colors.size()));
            series.setNodes(arrNode);
            series.setAxisIndex(i);
            series.setFormatString(QingTransferUtil.toQingNumFormat(this.chart));
            seriesList.add(series);
        }
        this.chartModel.setSeries(seriesList);
    }

    @Override
    protected void collectCategories() {
        String[] groupKeys = this.getGroupKeys();
        ArrayList<AbstractNormalChartModel.Category> categoryList = new ArrayList<AbstractNormalChartModel.Category>(groupKeys.length);
        for (int i = 0; i < groupKeys.length; ++i) {
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            if (this.fillColorToCategory()) {
                category.setColor((String)this.colors.get(i % this.colors.size()));
            }
            category.setLabel(this.formatValue(groupKeys[i]));
            categoryList.add(category);
        }
        this.chartModel.setCategoryTitle(this.chart.categoryTitle);
        this.chartModel.setCategories(categoryList);
    }

    @Override
    public void after() {
        super.after();
        this.applySort();
    }

    private void applySort() {
        int topN = this.calcTopN();
        int negativeTopN = this.calcNeagtiveTopN();
        WaterFallTransferImpl.sortByNameWaterFall(this.chartModel, this.chart, topN, negativeTopN, this.qingChart.getColors(), this.bean);
    }

    protected void collectScopes() {
        Object[] data = this.getSeriesData();
        ArrayList<AbstractNormalChartModel.AxisValueScope> scopeList = new ArrayList<AbstractNormalChartModel.AxisValueScope>(8);
        for (int i = 0; i < data.length; ++i) {
            int j;
            double[][] scopesData = (double[][])data[i];
            double[] scopes = new double[scopesData[i].length];
            ArrayList<Double> arrSortNode = new ArrayList<Double>(8);
            ArrayList<Double> negativeArrSortNode = new ArrayList<Double>(8);
            for (int m = 0; m < scopesData[0].length; ++m) {
                if (scopesData[0][m] < 0.0) {
                    negativeArrSortNode.add(scopesData[0][m]);
                    continue;
                }
                arrSortNode.add(scopesData[0][m]);
            }
            if (negativeArrSortNode.isEmpty() || arrSortNode.isEmpty()) {
                return;
            }
            double maxValue = !arrSortNode.isEmpty() ? ((Double)arrSortNode.get(0)).doubleValue() : ((Double)negativeArrSortNode.get(0)).doubleValue();
            double totoalMax = 0.0;
            double minValue = !negativeArrSortNode.isEmpty() ? ((Double)negativeArrSortNode.get(0)).doubleValue() : ((Double)arrSortNode.get(0)).doubleValue();
            double totalMin = 0.0;
            for (j = 0; j < arrSortNode.size(); ++j) {
                Double d = (Double)arrSortNode.get(j);
                if (Double.isNaN(d)) {
                    d = 0.0;
                }
                if (!((totoalMax += d.doubleValue()) > maxValue)) continue;
                maxValue = totoalMax;
            }
            for (j = 0; j < negativeArrSortNode.size(); ++j) {
                if (!((totalMin += ((Double)negativeArrSortNode.get(j)).doubleValue()) < minValue)) continue;
                minValue = totalMin;
            }
            Arrays.sort(scopes);
            for (j = 0; j < scopes.length; ++j) {
                AbstractNormalChartModel.AxisValueScope scope = new AbstractNormalChartModel.AxisValueScope();
                scope.setMin(String.valueOf(totalMin));
                scope.setMax(String.valueOf(maxValue));
                scope.setColor((String)this.colors.get((i * scopesData.length + j) % this.colors.size()));
                scopeList.add(scope);
            }
        }
        this.chartModel.setScopes(scopeList);
    }

    @Override
    protected int calcTopN() {
        return ChartDataTransferUtil.calcTopN(this.chart.chartTopN);
    }

    @Override
    protected int calcNeagtiveTopN() {
        return ChartDataTransferUtil.calcTopN(this.chart.chartNegativeTopN);
    }

    public static AbstractNormalChartModel sortByNameWaterFall(AbstractNormalChartModel chartModel, Chart chart, int topN, int negativeTopN, List<String> colors, AbstractFusionBean bean) {
        List<AbstractNormalChartModel.Series> series = chartModel.getSeries();
        List<AbstractNormalChartModel.Category> categories = chartModel.getCategories();
        List<AbstractNormalChartModel.INode> arrNode = series.get(0).getNodes();
        WaterFallTransferImpl.getSeriesOrigin(arrNode);
        ArrayList<AbstractNormalChartModel.INode> arrNodeTotal = new ArrayList<AbstractNormalChartModel.INode>(8);
        ArrayList<AbstractNormalChartModel.INode> arrTopNodeTotal = new ArrayList<AbstractNormalChartModel.INode>(8);
        ArrayList<AbstractNormalChartModel.Node> arrSortNode = new ArrayList<AbstractNormalChartModel.Node>(8);
        ArrayList<AbstractNormalChartModel.Node> arrNegativeSortNode = new ArrayList<AbstractNormalChartModel.Node>(8);
        ArrayList<AbstractNormalChartModel.Node> arrTopNode = new ArrayList<AbstractNormalChartModel.Node>(arrSortNode.size());
        ArrayList<AbstractNormalChartModel.Node> arrNegativeTopNode = new ArrayList<AbstractNormalChartModel.Node>(arrNegativeSortNode.size());
        ArrayList<AbstractNormalChartModel.Node> arrTopOrNegativeTopNode = new ArrayList<AbstractNormalChartModel.Node>(arrSortNode.size() + arrNegativeSortNode.size());
        if (ShowFunnelSortByComboBoxEditor.getMeasure().equals(chart.funnelSortBy) || chart.funnelSortBy == null) {
            for (int i = 0; i < arrNode.size(); ++i) {
                if (((AbstractNormalChartModel.Node)arrNode.get(i)).getOrigin().compareTo(new BigDecimal("0")) < 0) {
                    arrNegativeSortNode.add((AbstractNormalChartModel.Node)arrNode.get(i));
                    continue;
                }
                arrSortNode.add((AbstractNormalChartModel.Node)arrNode.get(i));
            }
            ArrayList sortNode = new ArrayList(arrSortNode.size());
            ChartDataTransferUtil.addAll(sortNode, new Object[arrSortNode.size()]);
            Collections.copy(sortNode, arrSortNode);
            arrSortNode.sort((o1, o2) -> o2.getOrigin().compareTo(o1.getOrigin()));
            if (topN < Integer.MAX_VALUE) {
                WaterFallTransferImpl.collectTopNodeOrNegativeTopNode(arrSortNode, arrTopNode, topN, chart, bean);
            }
            ArrayList<AbstractNormalChartModel.Node> sortNegativeNode = new ArrayList<AbstractNormalChartModel.Node>(arrNegativeSortNode.size());
            if (!CollectionUtils.isEmpty(arrNegativeSortNode)) {
                ChartDataTransferUtil.addAll(sortNegativeNode, new Object[arrNegativeSortNode.size()]);
                Collections.copy(sortNegativeNode, arrNegativeSortNode);
                if (ShowNegativeWaterFallComboBoxEditor.getMax().equals(chart.chartShowNegativeWaterFall)) {
                    sortNegativeNode.sort((o1, o2) -> o1.getOrigin().compareTo(o2.getOrigin()));
                } else {
                    sortNegativeNode.sort((o1, o2) -> o2.getOrigin().compareTo(o1.getOrigin()));
                }
                if (negativeTopN < Integer.MAX_VALUE) {
                    WaterFallTransferImpl.collectTopNodeOrNegativeTopNode(sortNegativeNode, arrNegativeTopNode, negativeTopN, chart, bean);
                }
                if (topN < Integer.MAX_VALUE && negativeTopN < Integer.MAX_VALUE) {
                    arrTopOrNegativeTopNode.addAll(arrTopNode);
                    arrTopOrNegativeTopNode.addAll(arrNegativeTopNode);
                } else if (topN < Integer.MAX_VALUE) {
                    arrTopOrNegativeTopNode.addAll(arrTopNode);
                    arrTopOrNegativeTopNode.addAll(sortNegativeNode);
                } else if (negativeTopN < Integer.MAX_VALUE) {
                    arrTopOrNegativeTopNode.addAll(arrSortNode);
                    arrTopOrNegativeTopNode.addAll(arrNegativeTopNode);
                } else {
                    arrSortNode.addAll(sortNegativeNode);
                }
            } else {
                arrTopOrNegativeTopNode.addAll(arrTopNode);
            }
            if (topN < Integer.MAX_VALUE || negativeTopN < Integer.MAX_VALUE) {
                WaterFallTransferImpl.collectSeriesOrSerieTopTotal(series, arrTopOrNegativeTopNode, arrTopNodeTotal);
            } else {
                WaterFallTransferImpl.collectSeriesOrSerieTopTotal(series, arrSortNode, arrNodeTotal);
            }
            if (topN < Integer.MAX_VALUE || negativeTopN < Integer.MAX_VALUE) {
                ArrayList<AbstractNormalChartModel.Category> topCategories = new ArrayList<AbstractNormalChartModel.Category>(arrTopOrNegativeTopNode.size());
                ChartDataTransferUtil.addAll(topCategories, new Object[arrTopOrNegativeTopNode.size()]);
                for (int i = 0; i < arrTopOrNegativeTopNode.size(); ++i) {
                    if (i < arrTopNode.size() && i == topN || i - arrTopNode.size() == negativeTopN) {
                        AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
                        String otherLabel = LanguageManager.getLangMessage((String)"others", QingChart.class, (String)"\u5176\u5b83");
                        category.setLabel(otherLabel);
                        topCategories.set(i, category);
                    } else {
                        topCategories.set(i, categories.get(arrNode.indexOf(arrTopOrNegativeTopNode.get(i))));
                    }
                    if (((AbstractNormalChartModel.Node)arrTopOrNegativeTopNode.get(i)).getOrigin().compareTo(BigDecimal.ZERO) > 0) {
                        ((AbstractNormalChartModel.Category)topCategories.get(i)).setColor(colors.get(0));
                        continue;
                    }
                    ((AbstractNormalChartModel.Category)topCategories.get(i)).setColor(colors.get(1));
                }
                WaterFallTransferImpl.collectNodeSum(arrTopOrNegativeTopNode, chart, topCategories, colors, bean);
                chartModel.setCategories(topCategories);
            } else {
                ArrayList sortCategories = new ArrayList(categories.size());
                ChartDataTransferUtil.addAll(sortCategories, new Object[categories.size()]);
                Collections.copy(sortCategories, categories);
                for (int i = 0; i < arrSortNode.size(); ++i) {
                    categories.set(i, (AbstractNormalChartModel.Category)sortCategories.get(arrNode.indexOf(arrSortNode.get(i))));
                    if (((AbstractNormalChartModel.Node)arrSortNode.get(i)).getOrigin().compareTo(BigDecimal.ZERO) > 0) {
                        categories.get(i).setColor(colors.get(0));
                        continue;
                    }
                    categories.get(i).setColor(colors.get(1));
                }
                WaterFallTransferImpl.collectNodeSum(arrSortNode, chart, categories, colors, bean);
            }
        } else {
            for (AbstractNormalChartModel.INode iNode : arrNode) {
                arrSortNode.add((AbstractNormalChartModel.Node)iNode);
            }
            ArrayList sortCategories = new ArrayList(categories.size());
            ChartDataTransferUtil.addAll(sortCategories, new Object[categories.size()]);
            Collections.copy(sortCategories, categories);
            categories.sort((o1, o2) -> Collator.getInstance(Locale.CHINA).compare(o1.getLabel(), o2.getLabel()));
            ArrayList sortNode = new ArrayList(arrSortNode.size());
            ChartDataTransferUtil.addAll(sortNode, new Object[arrSortNode.size()]);
            Collections.copy(sortNode, arrSortNode);
            for (int i = 0; i < sortNode.size(); ++i) {
                sortNode.set(i, arrSortNode.get(categories.indexOf(sortCategories.get(i))));
                if (((AbstractNormalChartModel.Node)sortNode.get(i)).getOrigin().compareTo(BigDecimal.ZERO) > 0) {
                    categories.get(i).setColor(colors.get(0));
                    continue;
                }
                categories.get(i).setColor(colors.get(1));
            }
            arrSortNode = sortNode;
            WaterFallTransferImpl.collectSeriesOrSerieTopTotal(series, arrSortNode, arrNodeTotal);
            WaterFallTransferImpl.collectNodeSum(arrSortNode, chart, categories, colors, bean);
        }
        arrNode.clear();
        if (ShowFunnelSortByComboBoxEditor.getMeasure().equals(chart.funnelSortBy) && (topN < Integer.MAX_VALUE || negativeTopN < Integer.MAX_VALUE)) {
            arrNode.addAll(arrTopOrNegativeTopNode);
        } else {
            arrNode.addAll(arrSortNode);
        }
        return chartModel;
    }

    public static void collectSeriesOrSerieTopTotal(List<AbstractNormalChartModel.Series> series, List<AbstractNormalChartModel.Node> arrSortNode, List<AbstractNormalChartModel.INode> arrNodeTotal) {
        double value = 0.0;
        AbstractNormalChartModel.Series serieTotal = new AbstractNormalChartModel.Series();
        serieTotal.setName(series.get(0).getName());
        serieTotal.setSeriesFieldValueText(series.get(0).getSeriesFieldValue(), series.get(0).getSeriesFieldText());
        for (int k = 0; k < arrSortNode.size(); ++k) {
            if (k > 0) {
                value += Double.parseDouble(arrSortNode.get(k - 1).getValue());
            }
            AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
            node.setValue(String.valueOf(value));
            node.setText(String.valueOf(value));
            arrNodeTotal.add(node);
        }
        serieTotal.setColor(series.get(0).getColor());
        serieTotal.setNodes(arrNodeTotal);
        serieTotal.setAxisIndex(series.get(0).getAxisIndex());
        if (series.size() == 2) {
            series.remove(series.size() - 1);
        }
        series.add(serieTotal);
    }

    public static void collectTopNodeOrNegativeTopNode(List<AbstractNormalChartModel.Node> arrSortNode, List<AbstractNormalChartModel.Node> arrTopNode, int topN, Chart chart, AbstractFusionBean bean) {
        AbstractNormalChartModel.Node otherTopNode = null;
        String base = "0";
        for (int i = 0; i < arrSortNode.size(); ++i) {
            if (topN <= i) {
                if (otherTopNode == null) {
                    otherTopNode = arrSortNode.get(i);
                    arrTopNode.add(otherTopNode);
                }
                otherTopNode.setValue(String.valueOf(new BigDecimal(base).add(arrSortNode.get(i).getOrigin())));
                otherTopNode.setText(String.valueOf(new BigDecimal(base).add(arrSortNode.get(i).getOrigin())));
                WaterFallTransferImpl.formatNodeSumNumber(otherTopNode, chart, bean);
                base = otherTopNode.getValue();
                continue;
            }
            arrTopNode.add(arrSortNode.get(i));
        }
    }

    public static void collectNodeSum(List<AbstractNormalChartModel.Node> arrNode, Chart chart, List<AbstractNormalChartModel.Category> categories, List<String> colors, AbstractFusionBean bean) {
        if ("1".equals(chart.showSum)) {
            double base = 0.0;
            for (AbstractNormalChartModel.Node node : arrNode) {
                base += Double.parseDouble(node.getValue());
            }
            AbstractNormalChartModel.Node nodeSum = new AbstractNormalChartModel.Node();
            nodeSum.setText(String.valueOf(base));
            nodeSum.setValue(String.valueOf(base));
            WaterFallTransferImpl.formatNodeSumNumber(nodeSum, chart, bean);
            arrNode.add(nodeSum);
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            String sumLabel = CtrlEXTMessages.getMLS("sum", "\u603b\u8ba1");
            category.setLabel(sumLabel);
            category.setColor(colors.get(2));
            categories.add(category);
        }
    }

    protected static void formatNodeSumNumber(AbstractNormalChartModel.Node node, Chart chart, AbstractFusionBean bean) {
        if (node == null || node.getValue() == null) {
            return;
        }
        String formatXml = bean.getChartNumberFormat().getXmlValue();
        String text = NumberFormatTemplateEditor.applayPattern(node.getValue(), formatXml, chart.numberPrefix, chart.numberSuffix);
        node.setText(text);
    }

    public static List<AbstractNormalChartModel.INode> getSeriesOrigin(List<AbstractNormalChartModel.INode> arrNode) {
        if (CollectionUtils.isNotEmpty(arrNode)) {
            for (AbstractNormalChartModel.INode node : arrNode) {
                ((AbstractNormalChartModel.Node)node).setOrigin(new BigDecimal(((AbstractNormalChartModel.Node)node).getValue()));
            }
        }
        return arrNode;
    }
}

