/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.subrpt;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.cosmic.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.cosmic.ctrl.ext.immit.IRptRuntimeCallback;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.exec.ExtExecutor;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.exec.AbstractHyperLinkExec;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.IImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredImageResult;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.subrpt.SubReportEmbed;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.subrpt.SubReportSpreadContext;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SubReportGuiExecutor {
    private Book _book;
    private IExtRuntimeDataProvider _dataProvider;
    private IExtRuntimeDataProvider _subDataProvider;
    private Map _sysParams;
    private boolean _isSanpshot;
    private static ExtGuiExecutor _executor;
    public static final String ISSUBREPORT = "isSubReport";

    public SubReportGuiExecutor(IExtRuntimeDataProvider provider, Book book, boolean limit, Map sysParams) {
        this._book = book;
        this._dataProvider = provider;
        this._sysParams = sysParams;
    }

    public SubReportGuiExecutor(ExtGuiExecutor executor, Map sysParams) {
        _executor = executor;
        this._book = executor.getBook();
        this._dataProvider = executor.getDataProvider();
        this._sysParams = sysParams;
        this._isSanpshot = executor.isSnapShot();
    }

    public void exec() {
        if (this._isSanpshot) {
            this.execSnapshot();
            return;
        }
        if (this._sysParams == null || this._sysParams.isEmpty()) {
            this._sysParams = this._dataProvider.fetchSystemParameters();
        }
        int sheetCount = this._book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = this._book.getSheet(i);
            List<Cell> cells = sheet.getSubReportCells();
            if (cells == null || cells.isEmpty()) continue;
            for (Cell cell : cells) {
                ReportProperties fullname;
                SubReportInfo subReportInfo = cell.getSubReportInfo();
                if (subReportInfo == null) continue;
                Map<String, IParameter> params = subReportInfo.getParams();
                byte[] bookData = subReportInfo.getBookData();
                if (bookData == null) {
                    fullname = subReportInfo.getReportProps();
                    ExtProps ep = cell.getExtProps(false);
                    Object alias = ep.executeCalculableProps(fullname.getCalculableProps());
                    if (alias != null) {
                        fullname.setAlias(alias.toString());
                    }
                    this._subDataProvider = (IExtRuntimeDataProvider)this._dataProvider.clone(fullname);
                    ReportProperties properties = this._dataProvider.fetchCurrentReportProperties();
                    ExecutionContext eCtx = new ExecutionContext(null);
                    eCtx.registerDataSetCacheObject(ISSUBREPORT, Boolean.TRUE);
                    eCtx.registerDataSetCacheObject("hyperLinkSourceReportId", properties.getId() == null ? "null" : properties.getId());
                    bookData = this._subDataProvider.getTransitionTargetData(fullname, eCtx);
                    eCtx.unRegisterDataSetCacheObject("hyperLinkSourceReportId");
                }
                fullname = subReportInfo.getReportProps();
                boolean check = _executor.getDataProvider().checkExtReportExsit(fullname.getId());
                if (bookData == null && check) {
                    subReportInfo.setMsg("");
                    continue;
                }
                if (bookData == null) continue;
                ExtProps extProps = cell.getExtProps(false);
                subReportInfo.setBookData(bookData);
                extProps.executeParams(params);
                AbstractHyperLinkExec.executeParamsDefaultValue(this._subDataProvider, params, subReportInfo, subReportInfo.getBookData());
                Book subBook = this.exec(cell, bookData, params);
                if (subBook != null) {
                    SubReportGuiExecutor.addSubReportEmbed(cell, subBook);
                }
                subReportInfo.setBookData(bookData);
            }
        }
    }

    public Book exec(Cell cell, byte[] bookData, Map<String, IParameter> params) {
        if (bookData == null) {
            return null;
        }
        ReportProperties rptProps = cell.getSubReportInfo().getReportProps();
        if (this._subDataProvider == null) {
            this._subDataProvider = (IExtRuntimeDataProvider)this._dataProvider.clone(rptProps);
        }
        Book subBook = null;
        String reportId = rptProps.getId();
        IRptRuntimeCallback runtimeCallback = this._subDataProvider.getRptRuntimeCallback(reportId);
        try {
            subBook = MiscUtil.unpack(bookData);
        }
        catch (Exception e) {
            MiscUtil.handleFileCheckingException(e, null);
            if (MiscUtil.shouldLog()) {
                MiscUtil.log(e);
            }
            return null;
        }
        this.loadImageWithContext(subBook, runtimeCallback);
        ExecutionContext exeContext = subBook.getDataSetManager().getExecutionContext();
        exeContext.setRptRuntimeCallback(runtimeCallback);
        this._subDataProvider.fetchDataSetFilter(null, exeContext);
        Map factories = this._subDataProvider.fetchDataSetFactories(null, exeContext);
        params = ExtGuiExecutor.mergeMap(params, this._sysParams);
        ExtExecutor.exec(subBook, factories, params, null);
        cell.getSubReportInfo().setBook(subBook);
        SubReportGuiExecutor.noMutilLevelSubReport(subBook);
        return subBook;
    }

    private void loadImageWithContext(Book book, IRptRuntimeCallback callback) {
        for (int i = 0; i < book.getSheetCount(); ++i) {
            EmbedhLayer layer;
            Sheet sheet = book.getSheet(i);
            if (sheet == null || (layer = sheet.getEmbedments(false)) == null) continue;
            for (int j = 0; j < layer.size(); ++j) {
                IImageModel model;
                EmbedObject embedObject = layer.getEmbed(j);
                if (!(embedObject instanceof EmbedImage) || !((model = ((EmbedImage)embedObject).getModel()) instanceof ReferredImageModel)) continue;
                byte[] imageData = null;
                try {
                    imageData = model.getImageData();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (imageData != null && imageData.length != 0) continue;
                String embedUid = ((ReferredImageModel)model).getEmbedUid();
                String reportId = callback.getReportId();
                ReferredImageResult referredImageResult = callback.loadReferredImage(reportId, embedUid);
                if (referredImageResult == null) continue;
                ((ReferredImageModel)model).setImageData(referredImageResult.getImageData());
            }
        }
    }

    public void setBook() {
        int sheetCount = this._book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = this._book.getSheet(i);
            List<Cell> cells = sheet.getSubReportCells();
            if (cells == null || cells.isEmpty()) continue;
            for (Cell cell : cells) {
                SubReportInfo subReportInfo = cell.getSubReportInfo();
                if (subReportInfo.getBookData() == null && subReportInfo.getReportProps().getPath().contains(CtrlEXTMessages.getMLS("presetDirectory", "\u9884\u7f6e\u76ee\u5f55"))) {
                    subReportInfo.setMsg(CtrlEXTMessages.getMLS("noPermissionForPresetReport", "\u60a8\u6ca1\u6709\u8be5\u9884\u7f6e\u62a5\u8868\u7684\u6743\u9650\u3002"));
                    continue;
                }
                if (subReportInfo == null || subReportInfo.getBook() == null) continue;
                this.setBook(cell, subReportInfo.getBook());
            }
        }
    }

    private void setBook(Cell cell, Book subBook) {
        EmbedhLayer layer = cell.getSheet().getEmbedments(true);
        if (layer.size() > 0) {
            EmbedObject eObject = layer.getEmbed(layer.size() - 1);
            if (_executor != null && eObject instanceof SubReportEmbed) {
                SubReportEmbed subRptEmbed = (SubReportEmbed)eObject;
                SubReportSpreadContext subContext = (SubReportSpreadContext)((Object)subRptEmbed.getPhysicalUI());
                _executor.setBook(subContext, subBook, this._subDataProvider, this._isSanpshot);
            }
        }
    }

    public static void noMutilLevelSubReport(Book subBook) {
        List<Cell> cells = subBook.getSheet(0).getSubReportCells();
        if (cells != null && !cells.isEmpty()) {
            Iterator<Cell> iter = cells.iterator();
            while (iter.hasNext()) {
                iter.next().setValue(new Variant(CtrlEXTMessages.getMLS("subReportCannotEmbed", "\u5b50\u62a5\u8868\u4e0d\u80fd\u5d4c\u6709\u5b50\u62a5\u8868")));
            }
        }
    }

    public static void addSubReportEmbed(Cell cell, Book subBook) {
        SubReportEmbed subRptEmbed = new SubReportEmbed(cell);
        Rectangle rect = SubReportGuiExecutor.setSubRptEmbedBounds(subRptEmbed, cell);
        Sheet sheet = cell.getSheet();
        sheet.getEmbedments(true).addEmbed(subRptEmbed);
        if (_executor != null && subBook != null) {
            SubReportSpreadContext subContext = new SubReportSpreadContext(subBook, _executor, rect);
            subRptEmbed.setPhysicalUI(subContext);
        }
    }

    public static Rectangle setSubRptEmbedBounds(SubReportEmbed subRptEmbed, Cell cell) {
        CellBlock cellBlock = cell.getMerge(true);
        if (cellBlock == null) {
            int row = cell.getRow();
            int col = cell.getCol();
            cellBlock = CellBlock.getCellBlock(row, col, row, col);
        }
        Sheet sheet = cell.getSheet();
        int y = Sheet.getRowInterval(sheet, 0, cellBlock.getRow());
        int h = Sheet.getRowInterval(sheet, cellBlock.getRow(), cellBlock.getRow2() + 1);
        int x = Sheet.getColInterval(sheet, 0, cellBlock.getCol());
        int w = Sheet.getColInterval(sheet, cellBlock.getCol(), cellBlock.getCol2() + 1);
        Rectangle rect = new Rectangle(x, y, w - 1, h - 1);
        subRptEmbed.setBounds(rect);
        return rect;
    }

    private void execSnapshot() {
        int sheetCount = this._book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = this._book.getSheet(i);
            EmbedhLayer layer = sheet.getEmbedments(false);
            if (layer == null) continue;
            int size = layer.size();
            for (int j = 0; j < size; ++j) {
                EmbedObject eo = layer.getEmbed(j);
                if (!(eo instanceof SubReportEmbed)) continue;
                this.addSubReportEmbed((SubReportEmbed)eo);
            }
        }
    }

    private void addSubReportEmbed(SubReportEmbed subRptEmbed) {
        Book subBook = subRptEmbed.getSubReportInfo().getBook();
        if (_executor != null && subBook != null) {
            Rectangle rect = subRptEmbed.getBounds();
            SubReportSpreadContext subContext = new SubReportSpreadContext(subBook, _executor, rect);
            subRptEmbed.setPhysicalUI(subContext);
        }
    }

    public void setMainBook(Book book) {
        this._book = book;
    }
}

