/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.node;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprArray;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprConst;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprOperator;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.expr.TraceVariant;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlock3DNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.ConstNamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import java.util.Locale;

public class NamedObjectNode
implements Comparable,
IExprNode,
ICalculable {
    public static final NamedObjectNode True;
    public static final NamedObjectNode False;
    public static final NamedObjectNode Null;
    protected static final int Flag_NeedCalc = 1;
    protected static final int Flag_HasValue = 2;
    protected static final int Flag_Queued = 4;
    protected static final int Flag_Calculating = 8;
    protected static final int Flag_Hidden = 16;
    protected static final int Flag_DisableRefered = 32;
    private static final Expr _exprUndefined;
    private final String _name;
    private final String _upperName;
    private Expr _expr;
    private final Book _book;
    private Sheet _sheet;
    private Object _refs;
    private int _flags;
    protected Variant _var;
    private boolean isKPINameNode;
    private String numberFormat;

    public static Expr getUndefinedExpr() {
        return _exprUndefined;
    }

    public static NamedObjectNode createUndefinedNamedObject(String name, Book book, Sheet sheet) {
        return new NamedObjectNode(name, _exprUndefined, book, sheet);
    }

    public NamedObjectNode(String name, String refersTo, Book book, Sheet sheet) {
        this._book = book;
        this._sheet = sheet;
        this._name = name;
        this._upperName = this._name.toUpperCase(Locale.ENGLISH);
        this.setRefersTo(refersTo);
    }

    public NamedObjectNode(String name, Expr expr, Book book, Sheet sheet) {
        this._book = book;
        this._sheet = sheet;
        this._name = name;
        this._upperName = this._name.toUpperCase(Locale.ENGLISH);
        this._expr = expr;
        if (expr != null) {
            this.setFlag(1, true);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this._name).append("[");
        if (this.touchFlag(2)) {
            sb.append('V');
        }
        if (this.touchFlag(1)) {
            sb.append(",NC");
        }
        if (this.touchFlag(4)) {
            sb.append(",Q");
        }
        if (this.isUndefined()) {
            sb.append(",Un");
        }
        sb.append(']');
        return sb + " = " + this.getRefersTo() + (this._var == null ? "" : " " + this._var.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NamedObjectNode) {
            NamedObjectNode no = (NamedObjectNode)obj;
            return this._book == no._book && this._sheet == no._sheet && this._name.equals(no._name) && this.getRefersTo().equals(no.getRefersTo());
        }
        return false;
    }

    public String getName() {
        return this._name;
    }

    public String getUpperCaseName() {
        return this._upperName;
    }

    public String getFullName() {
        return this._sheet == null ? this._name : this._sheet.getSyntaxName() + '!' + this._name;
    }

    public String getRefersTo() {
        if (this._expr != null && !this._expr.isSyntaxError()) {
            return this._expr.decode(this._book.getDeps().getExprContext(), this);
        }
        return "";
    }

    @Override
    public Expr getExpr() {
        return this._expr;
    }

    @Override
    public void setExpr(Expr expr) {
        this.setFlag(1, true);
        this.setFlag(2, false);
        this._var = null;
        this._expr = expr;
    }

    public Object getRefs() {
        return this._refs;
    }

    public void setRefs(Object refs) {
        this._refs = refs;
    }

    public boolean isLocal() {
        return this._sheet != null;
    }

    public boolean isVisible() {
        return !this.touchFlag(16);
    }

    public boolean isDisableRefered() {
        return this.touchFlag(32);
    }

    public boolean isEmpty() {
        return !(this._expr != null && !this._expr.isSyntaxError() || this._var != null && !this._var.isNull() && !this._var.isError());
    }

    public void setSheet(Sheet sheet) {
        this._sheet = sheet;
    }

    public void setRefersTo(String refersTo) {
        this._expr = null;
        if (!StringUtil.isEmptyString((String)refersTo)) {
            this._expr = this._sheet == null ? this._book.getActiveSheet().getExpr(this, refersTo) : this._sheet.getExpr(this, refersTo);
            this.setFlag(1, true);
        } else {
            this.setFlag(1, false);
        }
    }

    public void setVisible(boolean bVisible) {
        this.setFlag(16, !bVisible);
    }

    public int compareTo(Object obj) {
        int cmp;
        if (obj instanceof ICalculable && (cmp = this.getCalculableType() - ((ICalculable)obj).getCalculableType()) != 0) {
            return cmp;
        }
        if (obj instanceof NamedObjectNode) {
            NamedObjectNode no = (NamedObjectNode)obj;
            cmp = this._upperName.compareTo(((NamedObjectNode)obj)._upperName);
            if (cmp == 0) {
                cmp = this._sheet == null ? (no._sheet == null ? 0 : -1) : this._sheet.compareTo(no._sheet);
            }
        } else {
            cmp = this._upperName.compareTo(obj.toString().toUpperCase(Locale.ENGLISH));
        }
        return cmp;
    }

    @Override
    public int getExprType() {
        return 8;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        Variant value;
        if (this._book != null) {
            this._book.setDependent(exprOwner, this);
            this._book.getDeps().calcReferTo(exprOwner, this);
        }
        if ((value = this.getValue()).isError(32768L)) {
            throw (SyntaxErrorException)value.getValue();
        }
        if (ctx.isTraceMode()) {
            value = new TraceVariant(value, ctx);
        }
        ctx.getCurrentExprStack().push(value);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        return this._sheet != exprOwner.getSheet() ? this.getFullName() : this._name;
    }

    public void queue() {
        this.setFlag(1, true);
        this._book.getDeps().queue(this, this._book.isAutoCalculate());
    }

    @Override
    public Sheet getSheet() {
        if (this._sheet == null) {
            return this._book != null ? this._book.getSheet(0) : null;
        }
        return this._sheet;
    }

    public Book getBook() {
        return this._book;
    }

    public Range getRefersToRange() {
        Range rg = null;
        SortedCellBlockArray sa = this.getRefersToBlocks();
        if (sa != null) {
            CellBlockNode node = (CellBlockNode)sa.get(0);
            boolean is3D = node instanceof CellBlock3DNode;
            Sheet sheet = node.getSheet();
            Sheet sheet2 = is3D ? ((CellBlock3DNode)node).getSheet2() : sheet;
            Sheet sh = null;
            Sheet sh2 = null;
            int size = sa.size();
            for (int i = 1; i < size; ++i) {
                node = (CellBlockNode)sa.get(i);
                sh = null;
                if (is3D) {
                    if (node instanceof CellBlock3DNode) {
                        CellBlock3DNode no3 = (CellBlock3DNode)node;
                        sh = no3.getSheet();
                        sh2 = no3.getSheet2();
                    }
                } else if (!(node instanceof CellBlock3DNode)) {
                    sh = sh2 = node.getSheet();
                }
                if (sh == sheet && sh2 == sheet2) continue;
                sa.clear();
                break;
            }
            if (!sa.isEmpty()) {
                rg = new Range(this._book, this._book.getSheetsArray(sheet, sheet2), sa.toArray());
            }
        }
        return rg;
    }

    private SortedCellBlockArray getRefersToBlocks() {
        SortedCellBlockArray sa = new SortedCellBlockArray();
        if (this._expr != _exprUndefined && this._expr != null) {
            IExprNode[] nodes = this._expr.getExprParams().getNodes();
            int nodesCount = nodes.length;
            if (nodesCount == 1) {
                IExprNode node = nodes[0];
                if (node instanceof CellBlockNode) {
                    sa.insert(node);
                }
            } else if (nodes[nodesCount - 1] instanceof ExprArray) {
                for (int i = 0; i < nodesCount - 1; ++i) {
                    IExprNode node = nodes[i];
                    if (!(node instanceof CellBlockNode)) {
                        if (node == ExprOperator.COMMA) continue;
                        return null;
                    }
                    sa.insert(node);
                }
            }
        }
        return sa.isEmpty() ? null : sa;
    }

    public boolean isRefersTo(SortedCellBlockArray blocks, Sheet sheet, Sheet sheet2) {
        SortedCellBlockArray sa = this.getRefersToBlocks();
        if (sa != null && sa.size() == blocks.size()) {
            int size = sa.size();
            for (int i = 0; i < size; ++i) {
                if (this.isEquals((CellBlockNode)sa.get(i), blocks.getBlock(i), sheet, sheet2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isEquals(CellBlockNode cb, CellBlock block, Sheet sheet, Sheet sheet2) {
        if (cb.getSheet() == sheet && block.equals(cb)) {
            if (sheet == sheet2) {
                return !(cb instanceof CellBlock3DNode);
            }
            if (cb instanceof CellBlock3DNode) {
                return ((CellBlock3DNode)cb).getSheet2() == sheet2;
            }
        }
        return false;
    }

    @Override
    public void updateExpr(boolean queue) {
        String formula = this.getRefersTo();
        if (!StringUtil.isEmptyString((String)formula)) {
            this.setExpr(this.getSheet().getExpr(this, formula));
            if (queue) {
                this.queue();
            }
        }
    }

    public void updateRefsExpr() {
        if (this._refs != null) {
            if (this._refs instanceof ICalculable) {
                ((ICalculable)this._refs).updateExpr(true);
            } else {
                SortedObjectArray list = (SortedObjectArray)this._refs;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    ((ICalculable)list.get(i)).updateExpr(true);
                }
            }
        }
    }

    public boolean isUndefined() {
        return this._expr == _exprUndefined;
    }

    public boolean isNullExpr() {
        return this._expr == null;
    }

    @Override
    public boolean isNeedRecalc() {
        return this.touchFlag(1);
    }

    @Override
    public void setNeedRecalc(boolean bRecalc) {
        this.setFlag(1, bRecalc);
    }

    @Override
    public boolean isCalculating() {
        return this.touchFlag(8);
    }

    @Override
    public void setCalculating(boolean bCalculating) {
        this.setFlag(8, bCalculating);
    }

    @Override
    public boolean isQueued() {
        return this.touchFlag(4);
    }

    @Override
    public void setQueued(boolean bQueued) {
        this.setFlag(4, bQueued);
    }

    @Override
    public boolean isIterate() {
        return false;
    }

    @Override
    public void setIterate(boolean bIterate) {
    }

    @Override
    public boolean calc(ExprContext ctx) {
        if (this._sheet == null || this._sheet.isEnableCalculation()) {
            if (this._expr == _exprUndefined) {
                Book book = this._sheet == null ? this._book : this._sheet.getBook();
                this._var = book.getBufferedVariant(new Variant(new SyntaxErrorException(131072L, this._upperName), 16));
            } else {
                this._var = this._expr.execute(ctx, this);
            }
        } else {
            this._var = Variant.nullVariant;
        }
        this.setFlag(2, true);
        this.setFlag(1, false);
        boolean pending = this._var.isPending();
        this.setFlag(1, pending);
        return !this._var.isPureCalcLast();
    }

    @Override
    public Variant getValue() {
        Variant var;
        if (this.touchFlag(2)) {
            var = this._var;
        } else if (this.touchFlag(1)) {
            this.calc(this._book.getDeps().getExprContext());
            var = this._var;
        } else {
            var = Variant.nullVariant;
        }
        return var;
    }

    public void setValue(Variant value) {
        this._var = value;
        this.setFlag(2, this._var != null);
        this.setFlag(1, false);
    }

    @Override
    public int getCalculableType() {
        return 3;
    }

    protected void setFlag(int flag, boolean set) {
        this._flags = set ? (this._flags |= flag) : (this._flags &= ~flag);
    }

    private boolean touchFlag(int flag) {
        return (this._flags & flag) != 0;
    }

    public void setKPINameNode(boolean isKPINameNode) {
        this.isKPINameNode = isKPINameNode;
    }

    public boolean isKPINameNode() {
        return this.isKPINameNode;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    static {
        IExprNode[] nodes = new IExprNode[]{ExprConst.BADID};
        _exprUndefined = Expr.getExpr(null, nodes, 8, 0, 1);
        True = new ConstNamedObjectNode("True", Expr.getExpr(null, new IExprNode[]{ExprConst.TRUE}, 2, 0, 1), null, null, Variant.trueVariant);
        False = new ConstNamedObjectNode("False", Expr.getExpr(null, new IExprNode[]{ExprConst.FALSE}, 2, 0, 1), null, null, Variant.falseVariant);
        Null = new ConstNamedObjectNode("Null", Expr.getExpr(null, new IExprNode[]{ExprConst.NULL}, 2, 0, 1), null, null, Variant.nullVariant);
    }
}

