/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.validate.util;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.util.TitleMessage;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.util.Validate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessagedValidate
extends Validate
implements Cloneable {
    public static String STOP_STYLE = "STOP_STYLE";
    public static String WARNING_STYLE = "WARNING_STYLE";
    public static String INFORMATION_STYLE = "INFORMATION_STYLE";
    private int _imeMode;
    private TitleMessage _errorMessage;
    private TitleMessage _inputMessage;
    private String _errorStyle;
    private String _regexString;
    private Pattern p;

    public String getErrorStyle() {
        return this._errorStyle;
    }

    public void setErrorStyle(String errorStyle) {
        this._errorStyle = errorStyle;
    }

    public int getImeMode() {
        return this._imeMode;
    }

    public void setImeMode(int imeMode) {
        this._imeMode = imeMode;
    }

    public String getErrorMessage() {
        if (this._errorMessage == null) {
            return "";
        }
        return this._errorMessage.getMessage();
    }

    public void setErrorMessage(String message) {
        if (this._errorMessage == null) {
            this._errorMessage = new TitleMessage();
        }
        this._errorMessage.setMessage(message);
    }

    public String getErrorTitle() {
        if (this._errorMessage == null) {
            return "";
        }
        return this._errorMessage.getTitle();
    }

    public void setErrorTitle(String title) {
        if (this._errorMessage == null) {
            this._errorMessage = new TitleMessage();
        }
        this._errorMessage.setTitle(title);
    }

    public boolean isErrorHide() {
        if (this._errorMessage == null) {
            return false;
        }
        return this._errorMessage.isHide();
    }

    public void setErrorHide(boolean hide) {
        if (this._errorMessage == null) {
            this._errorMessage = new TitleMessage();
        }
        this._errorMessage.setHide(hide);
    }

    public String getInputMessage() {
        if (this._inputMessage == null) {
            return "";
        }
        return this._inputMessage.getMessage();
    }

    public void setInputMessage(String message) {
        if (this._inputMessage == null) {
            this._inputMessage = new TitleMessage();
        }
        this._inputMessage.setMessage(message);
    }

    public String getInputTitle() {
        if (this._inputMessage == null) {
            return "";
        }
        return this._inputMessage.getTitle();
    }

    public void setInputTitle(String title) {
        if (this._inputMessage == null) {
            this._inputMessage = new TitleMessage();
        }
        this._inputMessage.setTitle(title);
    }

    public boolean isInputHide() {
        if (this._inputMessage == null) {
            return false;
        }
        return this._inputMessage.isHide();
    }

    public void setInputHide(boolean hide) {
        if (this._inputMessage == null) {
            this._inputMessage = new TitleMessage();
        }
        this._inputMessage.setHide(hide);
    }

    public void setRegexString(String regexString) {
        this.p = null;
        this._regexString = regexString;
    }

    public String getRegexString() {
        return this._regexString;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof MessagedValidate) {
            MessagedValidate vm = (MessagedValidate)o;
            return this._imeMode == vm._imeMode && this._errorStyle == vm._errorStyle && (this._inputMessage == null ? this._inputMessage == vm._inputMessage : this._inputMessage.equals(vm._inputMessage)) && (this._errorMessage == null ? this._errorMessage == vm._errorMessage : this._errorMessage.equals(vm._errorMessage)) && StringUtil.equals((String)this._regexString, (String)vm._regexString);
        }
        return false;
    }

    @Override
    public boolean isValidated(Sheet sheet, String formula) {
        boolean ret = super.isValidated(sheet, formula);
        if (ret) {
            try {
                if (this.p == null) {
                    this.p = Pattern.compile(this._regexString);
                }
                Matcher m = this.p.matcher(formula);
                return m.find();
            }
            catch (Exception ex) {
                ret = false;
            }
        }
        return ret;
    }

    public Object clone() {
        MessagedValidate ret = new MessagedValidate();
        ret._errorStyle = this._errorStyle;
        ret._imeMode = this._imeMode;
        ret._regexString = this._regexString;
        ret.p = this.p;
        if (this._errorMessage != null) {
            ret._errorMessage = new TitleMessage();
            ret._errorMessage.setHide(this._errorMessage.isHide());
            ret._errorMessage.setMessage(this._errorMessage.getMessage());
            ret._errorMessage.setTitle(this._errorMessage.getTitle());
        }
        if (this._inputMessage != null) {
            ret._inputMessage = new TitleMessage();
            ret._inputMessage.setHide(this._inputMessage.isHide());
            ret._inputMessage.setMessage(this._inputMessage.getMessage());
            ret._inputMessage.setTitle(this._inputMessage.getTitle());
        }
        return ret;
    }
}

