/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.util;

import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.Span;

public class SortedSpanArray
extends SortedObjectArray {
    private boolean _bMergeTouched;

    public static void main(String[] args) {
        Span s1 = new Span(2, 100);
        Span s2 = new Span(0, 0);
        SortedSpanArray ssa = new SortedSpanArray();
        ssa.restruct(s1);
        ssa.restruct(s2);
    }

    public SortedSpanArray(boolean mergeTouched) {
        this._bMergeTouched = mergeTouched;
    }

    public SortedSpanArray() {
        this(true);
    }

    public void offset(int delt) {
        if (this._count > 0) {
            for (int i = 0; i < this._count; ++i) {
                ((Span)this.get(i)).offset(delt);
            }
        }
    }

    public void restruct(Span span) {
        this.restruct(span.getStart(), span.getEnd());
    }

    public void restruct(int start, int end) {
        if (this._bMergeTouched) {
            int leftIndex = this.affectPosAtLeft(start);
            int rightIndex = this.affectPosAtRight(end);
            if (leftIndex < 0 || leftIndex > rightIndex) {
                Span span = new Span(start, end);
                this.insert(span);
                return;
            }
            Span lSpan = (Span)this.get(leftIndex);
            Span rSpan = (Span)this.get(rightIndex);
            Span span = new Span(Math.min(start, lSpan.getStart()), Math.max(end, rSpan.getEnd()));
            for (int index = rightIndex; index >= leftIndex; --index) {
                this.removeByPos(index);
            }
            this.insert(span);
            this.reduce();
        } else {
            int newEnd;
            int newStart;
            int leftIndex = this.searchRowCol(start);
            int rightIndex = this.searchRowCol(end);
            if (leftIndex >= 0) {
                newStart = ((Span)this.get(leftIndex)).getStart();
            } else {
                newStart = start;
                leftIndex = -(leftIndex + 1);
            }
            if (rightIndex >= 0) {
                newEnd = ((Span)this.get(rightIndex)).getEnd();
            } else {
                newEnd = end;
                rightIndex = -(rightIndex + 1) - 1;
            }
            Span span = new Span(newStart, newEnd);
            for (int index = rightIndex; index >= leftIndex; --index) {
                this.removeByPos(index);
            }
            this.insert(span);
            this.reduce();
        }
    }

    private int affectPosAtLeft(int port) {
        if (this.isEmpty()) {
            return -1;
        }
        int pos = this.searchRowCol(port);
        if (pos >= 0) {
            if (pos == 0) {
                return pos;
            }
            Span span = (Span)this.get(pos - 1);
            if (port > span.getEnd() + 1) {
                return pos;
            }
            return pos - 1;
        }
        int insertP = -pos - 1;
        if (insertP > 0) {
            Span span = (Span)this.get(insertP - 1);
            if (port > span.getEnd() + 1) {
                return insertP;
            }
            return insertP - 1;
        }
        return insertP;
    }

    private int affectPosAtRight(int port) {
        if (this.isEmpty()) {
            return -1;
        }
        int pos = this.searchRowCol(port);
        if (pos >= 0) {
            if (pos == this._count - 1) {
                return pos;
            }
            Span span = (Span)this.get(pos + 1);
            if (port < span.getStart() - 1) {
                return pos;
            }
            return pos + 1;
        }
        int insertP = -pos - 1;
        if (insertP < this._count) {
            Span span = (Span)this.get(insertP);
            if (port < span.getStart() - 1) {
                return insertP - 1;
            }
            return insertP;
        }
        return insertP - 1;
    }

    public int searchRowCol(int port) {
        if (this.isEmpty()) {
            return -1;
        }
        int low = 0;
        int high = this._count - 1;
        int mid = 0;
        while (low <= high) {
            mid = low + high >> 1;
            Span span = (Span)this.get(mid);
            int cmp = span.compareToPos(port);
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

