/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.util;

import com.kingdee.cosmic.ctrl.kds.model.util.AbstractIntMarkArray;
import com.kingdee.cosmic.ctrl.kds.model.util.IntMarkEntry;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class WeakIntMarkArray
extends AbstractIntMarkArray {
    private final ReferenceQueue _queue = new ReferenceQueue();

    @Override
    protected int getIndexLimit() {
        return 0x7FFFFFFE;
    }

    @Override
    public synchronized int size() {
        this.expungeStaleEntries();
        return super.size();
    }

    @Override
    public synchronized IntMarkEntry insert(IntMarkEntry e) {
        this.expungeStaleEntries();
        return super.insert(new WeakIntMarkEntry(e, this._queue));
    }

    @Override
    protected synchronized void append(IntMarkEntry e) {
        this.expungeStaleEntries();
        super.append(e);
    }

    public synchronized int reIntMark() {
        this.expungeStaleEntries();
        int intMark = 0;
        for (int i = 0; i < this._array.length; ++i) {
            IntMarkEntry im = this._array[i];
            if (im == null) continue;
            im.setIntMark(intMark++);
        }
        return intMark;
    }

    public void expungeStaleEntries() {
        Reference r;
        while ((r = this._queue.poll()) != null) {
            WeakIntMarkEntry entry = (WeakIntMarkEntry)r;
            this.remove(entry.getIntMark());
        }
    }

    private static class WeakIntMarkEntry
    extends WeakReference
    implements IntMarkEntry {
        private int _intMark;

        public WeakIntMarkEntry(IntMarkEntry obj, ReferenceQueue queue) {
            super(obj, queue);
            this._intMark = obj.getIntMark();
        }

        @Override
        public int getIntMark() {
            return this._intMark;
        }

        @Override
        public void setIntMark(int intMark) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            Object obj = this.get();
            return obj != null ? obj.toString() : "";
        }
    }
}

