/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.util.url;

import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.AbstractImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.StaticURLImageModel;
import com.kingdee.cosmic.ctrl.kds.model.util.IConstructURL;
import com.kingdee.cosmic.ctrl.kds.model.util.url.IImageGenerable;
import com.kingdee.cosmic.ctrl.kds.model.util.url.ImageURL;
import com.kingdee.cosmic.ctrl.kds.model.util.url.ImgLibProtocolEnum;
import com.kingdee.cosmic.ctrl.kds.model.util.url.ImgLibURL;
import com.kingdee.cosmic.ctrl.kds.model.util.url.UnknownImageURLProtocolException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public enum ImageProtocolEnum implements IImageGenerable,
IConstructURL
{
    RTP{

        @Override
        public StaticURLImageModel generate(ImageURL imageURL) {
            String url = imageURL.getURL();
            return new StaticURLImageModel(this.makeurl(url));
        }

        @Override
        public URL makeurl(String spec) {
            throw new UnknownImageURLProtocolException();
        }
    }
    ,
    IMGLIB{

        @Override
        public AbstractImageModel generate(ImageURL imageURL) throws MalformedURLException {
            ImgLibURL imgLibURL = new ImgLibURL(imageURL.getURL());
            String subProtocol = imgLibURL.getSubProtocol();
            ImgLibProtocolEnum imgLibProtocol = (subProtocol = subProtocol.toUpperCase(Locale.ENGLISH)).equals("PUBLIC") ? ImgLibProtocolEnum.COMMON : (subProtocol.equals("GALLERY/PUBLIC") ? ImgLibProtocolEnum.GALLERY_COMMON : (subProtocol.equals("GALLERY/USER") ? ImgLibProtocolEnum.GALLERY_USER : (subProtocol.equals("WEBSITE") ? ImgLibProtocolEnum.WEBSITE : ImgLibProtocolEnum.valueOf(subProtocol))));
            return imgLibProtocol.generate(imgLibURL);
        }

        @Override
        public URL makeurl(String spec) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    HTTP{

        @Override
        public StaticURLImageModel generate(ImageURL imageURL) throws MalformedURLException {
            String url = imageURL.getURL();
            return new StaticURLImageModel(this.makeurl(url));
        }

        @Override
        public URL makeurl(String spec) throws MalformedURLException {
            return new URL(spec);
        }
    }
    ,
    HTTPS{

        @Override
        public StaticURLImageModel generate(ImageURL imageURL) throws MalformedURLException {
            String url = imageURL.getURL();
            return new StaticURLImageModel(this.makeurl(url));
        }

        @Override
        public URL makeurl(String spec) throws MalformedURLException {
            return new URL(spec);
        }
    }
    ,
    FILE{

        @Override
        public StaticURLImageModel generate(ImageURL imageURL) throws MalformedURLException {
            String url = imageURL.getURL();
            return new StaticURLImageModel(this.makeurl(url));
        }

        @Override
        public URL makeurl(String spec) throws MalformedURLException {
            throw new UnknownImageURLProtocolException();
        }
    }
    ,
    DEFAULT{

        @Override
        public StaticURLImageModel generate(ImageURL imageURL) throws MalformedURLException {
            String url = imageURL.getURL();
            return new StaticURLImageModel(this.makeurl(url));
        }

        @Override
        public URL makeurl(String spec) throws MalformedURLException {
            return new URL(spec);
        }
    };

}

