/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.nio;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.Password;
import com.kingdee.cosmic.ctrl.common.util.ReflectUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.UnitConverter;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.cosmic.ctrl.kdf.excel.model.PrintSetupWrapper;
import com.kingdee.cosmic.ctrl.kdf.export.IExportObject;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.ISplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.cosmic.ctrl.kds.io.util.DiagonalHeaderImageUtil;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExcelFuncProvider;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprConst;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprMethod;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprUnknownMethod;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.PrintSetup;
import com.kingdee.cosmic.ctrl.kds.model.struct.Protection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetOption;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.UserObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.ViewSplitInfo;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.subrpt.SubReportEmbed;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.cosmic.ctrl.print.util.PrintSetupUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetFormatPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class BookDataWrapper
extends AbstractDataWrapper {
    private static final Logger logger = LogUtil.getPackageLogger(BookDataWrapper.class);
    private Book _book;
    private com.kingdee.cosmic.ctrl.kds.model.struct.Sheet currentSheet;
    private EmbedhLayer layer;
    private BufferedImage datas;
    private int colEnd;
    private int rowEnd;
    private int colStart;
    private int rowStart;
    private int[] hideColMarks;
    private int[] hideRowMarks;
    private List<Cell> diagonalHeaderCells = new ArrayList<Cell>();
    private static final short MAX_EXCEL_GROUP_LEVEL = 7;
    private static final int EMU_PER_PIXEL = 9525;

    public BookDataWrapper(Book book) {
        super(book.getSheetCount());
        this._book = book;
    }

    public ShareStyleAttributes SSAAt(int row, int col) {
        if (this._exportSelect) {
            row += this.rowStart;
            col += this.colStart;
        }
        Cell cell = this.currentSheet.getCell(row, col, false);
        CellBlock merge = this.currentSheet.getMergeBlock(row, col);
        if (merge == null && cell == null) {
            return Styles.getEmptySSA();
        }
        if (merge != null) {
            cell = this.currentSheet.getCell(merge.getRow(), merge.getCol(), false);
        }
        ShareStyleAttributes[] ssas = new ShareStyleAttributes[4];
        ssas[0] = cell.getDisplayStyle();
        Object ret = cell.getValue();
        if (ret instanceof Variant) {
            ret = ((Variant)ret).getValue();
        }
        if (ret instanceof IExportObject) {
            IExportObject eo = (IExportObject)ret;
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssas[0]);
            sa.setNumberFormat(eo.getFormatString());
            ssas[0] = this.currentSheet.getBook().getSSA(sa);
        }
        ssas[1] = this.currentSheet.getRowSSA(row);
        ssas[2] = this.currentSheet.getColSSA(col);
        ssas[3] = this.currentSheet.getSSA();
        ShareStyleAttributes ssa = Styles.mergeSSA((ShareStyleAttributes[])ssas);
        if (CtrlEXTMessages.getMLS("generalFormat2", "g/\u901a\u7528\u683c\u5f0f").equalsIgnoreCase(ssa.getNumberFormat())) {
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
            sa.put(StyleAttributes.NUMBER_FORMAT, null);
            ssa = Styles.getSSA((StyleAttributes)sa);
        }
        return ssa;
    }

    public int colCount() {
        return -1;
    }

    public int colWidthAt(int colNum) {
        if (this._exportSelect) {
            colNum += this.colStart;
        }
        return SheetBaseMath.getColWidth(this.currentSheet, colNum);
    }

    public void dataSourceMemeryCallback(int row, int col) {
    }

    public AbstractDataWrapper.EmbedObject getEmbedObject(int index) {
        int dx2;
        int dy2;
        int size;
        int n = size = this.layer == null ? 0 : this.layer.size();
        if (this.layer == null || index >= size) {
            KDSBook.KDSImage img = DiagonalHeaderImageUtil.translate(this.diagonalHeaderCells.get(index - size));
            return BookDataWrapper.getEmbedObject((byte[])img.getBinaryImage(), (int)0, (int)0, (int)0, (int)0, (int)img.getTop(), (int)img.getLeft(), (int)img.getBottom(), (int)img.getRight(), (int)this._currentSheetIndex);
        }
        EmbedObject eo = this.layer.getEmbed(index);
        Rectangle rect = eo.getBounds();
        try {
            if (eo instanceof FlashChart) {
                SwingUtilities.invokeAndWait(() -> {
                    this.datas = ((FlashChart)eo).exportToBufferedImage();
                });
            }
            if (eo instanceof QingChart) {
                SwingUtilities.invokeAndWait(() -> {
                    this.datas = ((QingChart)eo).exportToBufferedImage();
                });
            } else if (eo instanceof EChart) {
                SwingUtilities.invokeAndWait(() -> {
                    this.datas = ((EChart)eo).exportToBufferedImage();
                });
            } else if (eo instanceof SubReportEmbed) {
                SubReportEmbed subRptEmbed = (SubReportEmbed)eo;
                int width = subRptEmbed.getWidth();
                int height = subRptEmbed.getHeight();
                if (width <= 0 || height <= 0) {
                    return null;
                }
                this.datas = new BufferedImage(width, height, 2);
                Graphics2D g2d = (Graphics2D)this.datas.getGraphics();
                Image image = subRptEmbed.getImage();
                if (image != null) {
                    eo.paintData(g2d);
                    g2d.drawImage(image, 0, 0, image.getWidth(subRptEmbed), image.getHeight(subRptEmbed), subRptEmbed);
                }
                g2d.dispose();
            } else {
                int width = eo.getWidth();
                int height = eo.getHeight();
                if (width <= 0 || height <= 0) {
                    return null;
                }
                this.datas = new BufferedImage(width, height, 2);
                Graphics2D g2d = (Graphics2D)this.datas.getGraphics();
                eo.setBounds(0, 0, eo.getWidth(), eo.getHeight());
                eo.paintData(g2d);
                eo.setBounds(rect);
                g2d.dispose();
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.datas, "png", out);
        }
        catch (IOException | IllegalArgumentException ioe) {
            return null;
        }
        this.datas = null;
        Rectangle bounds = eo.getBounds();
        Point p = bounds.getLocation();
        int row1 = SheetBaseMath.rowAtPoint(this.currentSheet, p);
        int col1 = SheetBaseMath.colAtPoint(this.currentSheet, p);
        int rowPostion = SheetBaseMath.getRowY(this.currentSheet, row1);
        int colPosition = SheetBaseMath.getColX(this.currentSheet, col1);
        int dy1 = (int)(9525.0 * (60.0 * ((double)(p.y > rowPostion ? p.y - rowPostion : rowPostion - p.y) / (double)SheetBaseMath.getRowHeight(this.currentSheet, row1))));
        int dx1 = (int)(9525.0 * (100.0 * ((double)(p.x > colPosition ? p.x - colPosition : colPosition - p.x) / (double)SheetBaseMath.getColWidth(this.currentSheet, col1))));
        p.x += bounds.width;
        p.y += bounds.height;
        int row2 = SheetBaseMath.rowAtPoint(this.currentSheet, p);
        int col2 = SheetBaseMath.colAtPoint(this.currentSheet, p);
        int rowPostion2 = SheetBaseMath.getRowY(this.currentSheet, row2);
        int colPosition2 = SheetBaseMath.getColX(this.currentSheet, col2);
        if (row1 != row2 && col1 != col2) {
            dy2 = (int)(9525.0 * (60.0 * ((double)(p.y > rowPostion2 ? p.y - rowPostion2 : rowPostion2 - p.y) / (double)SheetBaseMath.getRowHeight(this.currentSheet, row2))));
            dx2 = (int)(9525.0 * (100.0 * ((double)(p.x > colPosition2 ? p.x - colPosition2 : colPosition2 - p.x) / (double)SheetBaseMath.getColWidth(this.currentSheet, col2))));
        } else {
            dy2 = (int)(9525.0 * (60.0 * (double)(p.y > rowPostion2 ? p.y - rowPostion2 : rowPostion2 - p.y)));
            dx2 = (int)(9525.0 * (100.0 * (double)(p.x > colPosition2 ? p.x - colPosition2 : colPosition2 - p.x)));
        }
        if (eo instanceof EmbedImage) {
            try {
                return BookDataWrapper.getEmbedObject((byte[])((EmbedImage)eo).getModel().getImageData(), (int)dx1, (int)dy1, (int)dx2, (int)dy2, (int)row1, (int)col1, (int)row2, (int)col2, (int)this._currentSheetIndex);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return BookDataWrapper.getEmbedObject((byte[])out.toByteArray(), (int)dx1, (int)dy1, (int)dx2, (int)dy2, (int)row1, (int)col1, (int)row2, (int)col2, (int)this._currentSheetIndex);
    }

    public int getEmbedObjectsCount() {
        int count = 0;
        if (this.layer != null) {
            count = this.layer.size();
        }
        Sheet.ICellsIterator iter = this.currentSheet.getCellsIterator(0, 0, 1048575, 65535, true, true);
        while (iter.hasNext()) {
            Cell cll = iter.next();
            if (cll.getDiagonalHeader() == null || !DiagonalHeaderImageUtil.isValidSplitRectInfo((ISplitRectInfo)cll.getDiagonalHeader(), cll)) continue;
            this.diagonalHeaderCells.add(cll);
            ++count;
        }
        return count;
    }

    protected String getFormula(int row, int col) {
        if (!this._exportFormula) {
            return null;
        }
        Cell cell = this.getFirstVisibleMergeCell(row, col);
        if (cell == null) {
            return null;
        }
        if (!cell.hasFormula()) {
            return null;
        }
        return cell.getFormula();
    }

    public AbstractDataWrapper.MergeBlock getMergeBlock(int rowNum, int colNum) {
        AbstractDataWrapper.MergeBlock mb;
        int i;
        if (!this._exportMergeBlocks) {
            return null;
        }
        Cell cell = this.getFirstVisibleMergeCell(rowNum, colNum);
        if (cell == null) {
            return null;
        }
        CellBlock cb = cell.getMerge(true);
        if (cb == null) {
            return null;
        }
        int top = cb.getRow();
        int bottom = cb.getRow2();
        int left = cb.getCol();
        int right = cb.getCol2();
        if (top == bottom && left == right) {
            return null;
        }
        int hideRowCount = 0;
        int hideColCount = 0;
        if (!this._exportHideRows) {
            for (i = top; i <= bottom; ++i) {
                if (this.hideRowMarks[i] != 1) continue;
                ++hideRowCount;
            }
        }
        if (!this._exportHideCols) {
            for (i = left; i <= right; ++i) {
                if (this.hideColMarks[i] != 1) continue;
                ++hideColCount;
            }
        }
        if ((mb = BookDataWrapper.getMergeBlock((int)rowNum, (int)colNum, (int)(bottom - top + rowNum - hideRowCount), (int)(right - left + colNum - hideColCount))).getRow2() == mb.getRow() && mb.getCol() == mb.getCol2()) {
            mb = null;
        } else {
            mb.setGroup(cell.getText());
        }
        return mb;
    }

    public boolean isBookProtected() {
        return this._book.getProtection().isProtected();
    }

    public boolean isColEnd(int colPosition) {
        if (this._exportSelect) {
            return colPosition > this.colEnd - this.colStart;
        }
        return colPosition > this.colEnd;
    }

    public boolean isCurrentSheetProtected() {
        return this._book.getProtection().isProtected();
    }

    public boolean isHideCol(int col) {
        if (this._exportHideCols) {
            return false;
        }
        SortedAttributeSpanArray colSpans = this.currentSheet.getColSpans();
        int index = colSpans.searchSpan(col);
        if (index < 0) {
            return false;
        }
        return !colSpans.getAttributeSpan(index).isVisible();
    }

    public boolean isHideRow(int row) {
        if (this._exportHideRows) {
            return false;
        }
        SortedAttributeSpanArray rowSpans = this.currentSheet.getRowSpans();
        int index = rowSpans.searchSpan(row);
        if (index < 0) {
            return false;
        }
        return !rowSpans.getAttributeSpan(index).isVisible();
    }

    public boolean isHideSheet(int index) {
        return this._book.getSheet(index).isHide();
    }

    public boolean isRowEnd(int rowPosition) {
        if (this._exportSelect) {
            return rowPosition > this.rowEnd - this.rowStart;
        }
        return rowPosition > this.rowEnd;
    }

    public int rowCount() {
        return -1;
    }

    public int rowHeightAt(int rowNum) {
        if (this._exportSelect) {
            rowNum += this.rowStart;
        }
        return SheetBaseMath.getRowHeight(this.currentSheet, rowNum);
    }

    public int sheetCount() {
        return this._book.getSheetCount();
    }

    public String sheetName(int index) {
        if (!this.isExportHideSheet() && this._book.getSheet(index).isHide()) {
            return null;
        }
        return this._book.getSheetName(index);
    }

    private boolean isExportHideSheet() {
        UserObject uo = this._book.getUserObject("EXPORT_HIDE_SHEETS");
        return uo == null || "true".equals(uo.getValue().toString());
    }

    public int getActiveSheetIndex() {
        return this._book.getActiveSheetIndex();
    }

    public int getFirstVisibleSheetIndex() {
        return this._book.getVisibleSheet(0).getSheetIndex();
    }

    public Object valueAt(int row, int col) {
        Cell cell = this.getFirstVisibleMergeCell(row, col);
        if (cell == null) {
            return null;
        }
        Object ret = null;
        boolean dispValue = false;
        ExtProps props = cell.getExtProps(false);
        if (props != null) {
            String text = cell.getText();
            Object value = cell.getValue().getValue();
            String format = cell.getStyle().getNumberFormat();
            SortedExtPropFormulasArray formulas = props.getFormulas(false);
            if (formulas != null && formulas.get(ExtConst.FORMULA_DISP_VALUE) != null) {
                dispValue = true;
                try {
                    if (value instanceof Number) {
                        if (format.lastIndexOf(37) != -1) {
                            NumberFormat nf = NumberFormat.getPercentInstance();
                            ret = Float.valueOf(nf.parse(text).floatValue());
                        } else if (format.startsWith("?")) {
                            int index = text.indexOf(47);
                            double result = Double.parseDouble(text.substring(0, index)) / Double.parseDouble(text.substring(index + 1));
                            ret = BigDecimal.valueOf(result);
                        } else if (format.startsWith("G/") || format.equalsIgnoreCase("0E00")) {
                            ret = new BigDecimal(text);
                        } else if (format.startsWith("yyyy")) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            ret = sdf.parse(text);
                        } else {
                            ret = new BigDecimal(text);
                        }
                    } else if (value instanceof Date || value instanceof Calendar) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        ret = sdf.parse(text);
                    } else if (value instanceof String) {
                        ret = text;
                    }
                }
                catch (Exception e) {
                    ret = text;
                }
            }
        }
        if (!dispValue) {
            ret = cell.getValue().getValue();
            if (ret == Variant.calcLast.getValue()) {
                ret = null;
            }
            if (ret instanceof Variant) {
                ret = ((Variant)ret).getValue();
            }
            if (ret instanceof IExportObject) {
                IExportObject eo = (IExportObject)ret;
                ret = eo.getContent();
            }
        }
        return ret;
    }

    private Cell getFirstVisibleMergeCell(int rowNum, int colNum) {
        int i;
        if (this._exportSelect) {
            rowNum += this.rowStart;
            colNum += this.colStart;
        }
        CellBlock cb = null;
        cb = this.currentSheet.getMergeBlock(rowNum, colNum);
        if (cb == null) {
            return this.currentSheet.getCell(rowNum, colNum, false);
        }
        int row = cb.getRow();
        int col = cb.getCol();
        int row2 = cb.getRow2();
        int col2 = cb.getCol2();
        if (!this._exportHideCols && this.hideColMarks[colNum] != 1) {
            for (i = col; i <= col2 && this.hideColMarks[i] == 1; ++i) {
                ++col;
            }
        }
        if (!this._exportHideRows && this.hideRowMarks[rowNum] != 1) {
            for (i = row; i <= row2 && this.hideRowMarks[i] == 1; ++i) {
                ++row;
            }
        }
        if (rowNum == row && colNum == col) {
            return this.currentSheet.getCell(cb.getRow(), cb.getCol(), false);
        }
        if (!this._exportMergeBlocks) {
            return this.currentSheet.getCell(cb.getRow(), cb.getCol(), false);
        }
        return null;
    }

    public short valueTypeAt(int row, int col) {
        Cell cell = this.getFirstVisibleMergeCell(row, col);
        if (cell == null) {
            return 3;
        }
        if (cell.hasFormula() && this._exportFormula && !StringUtil.isEmptyString((String)this.formulaAt(row, col))) {
            return 2;
        }
        Object value = this.valueAt(row, col);
        if (value == null) {
            return 3;
        }
        return BookDataWrapper.getValueType((Object)value);
    }

    public String textAt(int row, int col) {
        Cell cell = this.getFirstVisibleMergeCell(row, col);
        if (cell == null) {
            return null;
        }
        return cell.getText();
    }

    public void setCurrentSheetIndex(int currentSheetIndex) {
        int i;
        this._currentSheetIndex = currentSheetIndex;
        this.currentSheet = this._book.getSheet(this._currentSheetIndex);
        this.layer = this.currentSheet.getEmbedments(false);
        this.colEnd = this.currentSheet.getMaxColIndex();
        this.rowEnd = this.currentSheet.getMaxRowIndex();
        if (!this._exportHideRows) {
            this.hideRowMarks = new int[this.rowEnd + 1];
            for (i = 0; i <= this.rowEnd; ++i) {
                if (!this.isHideRow(i)) continue;
                this.hideRowMarks[i] = 1;
            }
        }
        if (!this._exportHideCols) {
            this.hideColMarks = new int[this.colEnd + 1];
            for (i = 0; i <= this.colEnd; ++i) {
                if (!this.isHideCol(i)) continue;
                this.hideColMarks[i] = 1;
            }
        }
        if (this._exportSelect) {
            Range range = this.currentSheet.getSelectionRange();
            CellBlock cb = range.getLastBlock();
            this.rowStart = cb.getRow();
            this.colStart = cb.getCol();
            this.rowEnd = cb.getRow2() > this.rowEnd ? this.rowEnd : cb.getRow2();
            this.colEnd = cb.getCol2() > this.colEnd ? this.colEnd : cb.getCol2();
            this.layer = null;
        }
    }

    public HyperLink hyperLinkAt(int row, int col) {
        Cell cell = this.getFirstVisibleMergeCell(row, col);
        return cell == null ? null : cell.getHyperLink();
    }

    public PrintSetupWrapper getPrintSetup(String sheetName) {
        SheetOption sheetOption = null;
        try {
            sheetOption = this._book.getSheetByName(sheetName).getSheetOption();
        }
        catch (SyntaxErrorException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        PrintSetupWrapper psw = new PrintSetupWrapper();
        if (sheetOption == null) {
            return psw;
        }
        PrintSetup printSetup = sheetOption.getPrintSetup(false);
        if (printSetup != null) {
            psw.setPrintAreas(printSetup.getPrintAreas());
        }
        return psw;
    }

    public Color getSheetTabColor(String sheetName) {
        SheetOption sheetOption = null;
        Color tabColor = null;
        try {
            sheetOption = this._book.getSheetByName(sheetName).getSheetOption();
            return sheetOption.getTabColor();
        }
        catch (SyntaxErrorException e) {
            logger.error((Object)"err", (Throwable)e);
            return tabColor;
        }
    }

    public boolean isExportGridLine() {
        SheetOption sheetOption = this.currentSheet.getSheetOption();
        return sheetOption.isShowHoriLines() && sheetOption.isShowVertLines();
    }

    public void setGroupRow(XSSFSheet sheet, XSSFRow xRow) {
        SortedAttributeSpanArray.AttributeSpan attrSpan;
        SortedAttributeSpanArray rowSpans = this.currentSheet.getRowSpans();
        if (rowSpans == null || rowSpans.isEmpty()) {
            return;
        }
        int spanPos = rowSpans.searchSpan(xRow.getRowNum());
        if (spanPos < 0) {
            return;
        }
        if (xRow.getHeight() <= 0) {
            xRow.setZeroHeight(true);
            xRow.setHeight((short)(StyleUtil.lomToPt((double)((float)UnitConverter.px2mm((int)this.currentSheet.getDefRowHeight()) * 10.0f)) * 20.0));
        }
        if ((attrSpan = rowSpans.getAttributeSpan(spanPos)).getOutlineGroupLevel() <= 7) {
            xRow.getCTRow().setOutlineLevel((short)attrSpan.getOutlineGroupLevel());
        } else {
            xRow.getCTRow().setOutlineLevel((short)7);
        }
    }

    public void setOutlineGroupDir(XSSFSheet sheet) {
        if (this.currentSheet.isAboveOfOutlineGroup()) {
            sheet.setRowSumsBelow(false);
        }
        if (this.currentSheet.isLeftToOutlineGroup()) {
            sheet.setRowSumsRight(false);
        }
    }

    public void addPrintSetup(Sheet xssfSheet) {
        PrintSetup printSetup = this.currentSheet.getSheetOption().getPrintSetup(false);
        org.apache.poi.ss.usermodel.PrintSetup ps = xssfSheet.getPrintSetup();
        if (printSetup != null) {
            this.addMargin(xssfSheet, printSetup, ps);
            short scale = (short)printSetup.getScale();
            if (scale < 10) {
                scale = 10;
            }
            if (scale > 400) {
                scale = 400;
            }
            ps.setScale(scale);
            this.addPaperInfo(xssfSheet, printSetup, ps);
            this.addHeaderAndFooter(xssfSheet, printSetup);
            this.addPrintAttr(xssfSheet, printSetup, ps);
            this.addPrintTitle(xssfSheet, printSetup);
        }
    }

    private void addPrintAttr(Sheet xssfSheet, PrintSetup printSetup, org.apache.poi.ss.usermodel.PrintSetup ps) {
        ps.setNoColor(printSetup.isBlackWhite());
        xssfSheet.setPrintGridlines(printSetup.hasGrid());
        ps.setLeftToRight(printSetup.isRowFirst());
        xssfSheet.setPrintRowAndColumnHeadings(printSetup.hasRowHead() || printSetup.hasColHead());
    }

    private void addPaperInfo(Sheet xssfSheet, PrintSetup printSetup, org.apache.poi.ss.usermodel.PrintSetup ps) {
        ps.setLandscape(printSetup.isLandScape());
        int centerHorizontal = printSetup.getCenterHorizontal();
        int centerVertical = printSetup.getCenterVertical();
        xssfSheet.setHorizontallyCenter(centerHorizontal == 1);
        xssfSheet.setVerticallyCenter(centerVertical == 1);
        ps.setPaperSize(this.transformPaperSizefromISOtoPOI(printSetup.getPagesizeIndex()));
    }

    private short transformPaperSizefromISOtoPOI(int paperSizeValue) {
        short paperSize;
        switch (paperSizeValue) {
            case 3: {
                paperSize = 8;
                break;
            }
            case 4: {
                paperSize = 9;
                break;
            }
            case 5: {
                paperSize = 11;
                break;
            }
            case 26: {
                paperSize = 12;
                break;
            }
            case 27: {
                paperSize = 13;
                break;
            }
            case 40: {
                paperSize = 1;
                break;
            }
            case 60: {
                paperSize = 20;
                break;
            }
            case 57: {
                paperSize = 37;
                break;
            }
            default: {
                paperSize = 9;
            }
        }
        return paperSize;
    }

    private void addHeaderAndFooter(Sheet xssfSheet, PrintSetup printSetup) {
        Header header = xssfSheet.getHeader();
        List headData = printSetup.getHeadData();
        if (headData != null && !headData.isEmpty()) {
            String[] headerData = this.configHeaderOrFooter(headData);
            header.setLeft(this.translateSpecailChar(headerData[0]));
            header.setCenter(this.translateSpecailChar(headerData[1]));
            header.setRight(this.translateSpecailChar(headerData[2]));
        }
        Footer footer = xssfSheet.getFooter();
        List footData = printSetup.getFootData();
        if (footData != null && !footData.isEmpty()) {
            String[] footerData = this.configHeaderOrFooter(footData);
            footer.setLeft(this.translateSpecailChar(footerData[0]));
            footer.setCenter(this.translateSpecailChar(footerData[1]));
            footer.setRight(this.translateSpecailChar(footerData[2]));
        }
    }

    private void addPrintTitle(Sheet xssfSheet, PrintSetup printSetup) {
        String topTitleRows;
        List topTitleBlock;
        String leftTitleColumns = printSetup.getLeftTitleColumns();
        List leftTitleBlock = PrintSetupUtil.parserBlock((String)leftTitleColumns);
        if (null != leftTitleBlock) {
            int size = leftTitleBlock.size();
            for (int k = 0; k < size; ++k) {
                ITableForPrint.IBlock block = (ITableForPrint.IBlock)leftTitleBlock.get(k);
                if (block == null) continue;
                CellRangeAddress cols = new CellRangeAddress(-1, -1, block.getCol(), block.getCol2());
                xssfSheet.setRepeatingColumns(cols);
            }
        }
        if (null != (topTitleBlock = PrintSetupUtil.parserBlock((String)(topTitleRows = printSetup.getTopTitleRows())))) {
            int size = topTitleBlock.size();
            for (int k = 0; k < size; ++k) {
                ITableForPrint.IBlock block = (ITableForPrint.IBlock)topTitleBlock.get(k);
                if (block == null) continue;
                CellRangeAddress rows = new CellRangeAddress(block.getRow(), block.getRow2(), -1, -1);
                xssfSheet.setRepeatingRows(rows);
            }
        }
    }

    private void addMargin(Sheet xssfSheet, PrintSetup printSetup, org.apache.poi.ss.usermodel.PrintSetup ps) {
        float bottomMargin = printSetup.getBottomMargin();
        float topMargin = printSetup.getTopMargin();
        float rightMargin = printSetup.getRightMargin();
        float leftMargin = printSetup.getLeftMargin();
        boolean autoFit = printSetup.isAutoFit();
        if (autoFit) {
            ps.setFitHeight((short)printSetup.getAutoFitHeight());
            ps.setFitWidth((short)printSetup.getAutoFitWidth());
            xssfSheet.setFitToPage(autoFit);
        } else {
            printSetup.setAutoFit(false);
            ps.setFitHeight((short)1);
            ps.setFitWidth((short)1);
        }
        xssfSheet.setMargin((short)3, (double)bottomMargin);
        xssfSheet.setMargin((short)2, (double)topMargin);
        xssfSheet.setMargin((short)1, (double)rightMargin);
        xssfSheet.setMargin((short)0, (double)leftMargin);
        float footAlign = printSetup.getFootMargin();
        float headAlign = printSetup.getHeadMargin();
        ps.setHeaderMargin((double)headAlign);
        ps.setFooterMargin((double)footAlign);
    }

    private String translateSpecailChar(String strIn) {
        if (!StringUtil.isEmptyString((String)strIn)) {
            strIn = strIn.replace("&[Page]", "&P");
            strIn = strIn.replace("&[PageCount]", "&N");
            strIn = strIn.replace("&[Date]", "&D");
            strIn = strIn.replace("&[Time]", "&T");
            strIn = strIn.replace("&L", "&L");
            strIn = strIn.replace("&C", "&C");
            strIn = strIn.replace("&R", "&R");
            strIn = strIn.replace("&", "&amp;");
        }
        return strIn;
    }

    private String[] configHeaderOrFooter(List data) {
        StringBuilder LeftBuffer = new StringBuilder();
        StringBuilder CenterBuffer = new StringBuilder();
        StringBuilder RightBuffer = new StringBuilder();
        ListIterator iterator = data.listIterator();
        while (iterator.hasNext()) {
            String originRowText = ((HeadFootRow)iterator.next()).toString();
            String[] Text2 = StringUtil.splitString((String)originRowText, (String)"&|");
            String[] Result = this.spliceHeaderOrFooter(Text2, iterator.previousIndex());
            LeftBuffer.append(Result[0]);
            CenterBuffer.append(Result[1]);
            RightBuffer.append(Result[2]);
        }
        StringBuilder allBuffer = new StringBuilder();
        allBuffer.append("&L").append((CharSequence)LeftBuffer).append("&C").append((CharSequence)CenterBuffer).append("&R").append((CharSequence)RightBuffer);
        return new String[]{allBuffer.toString()};
    }

    private String[] spliceHeaderOrFooter(String[] rowText, int rowIndex) {
        String newLine = rowIndex > 0 ? "\n" : "";
        StringBuilder left = new StringBuilder(newLine);
        StringBuilder center = new StringBuilder(newLine);
        StringBuilder right = new StringBuilder(newLine);
        int col = rowText.length;
        if (col != 0) {
            if (col == 1) {
                center.append(rowText[0]);
            } else if (col == 2) {
                left.append(rowText[0]);
                right.append(rowText[1]);
            } else if (col == 3) {
                left.append(rowText[0]);
                center.append(rowText[1]);
                right.append(rowText[2]);
            } else {
                left.append(rowText[0]);
                right.append(rowText[col - 1]);
                for (int i = 1; i <= col - 2; ++i) {
                    center.append(rowText[i]);
                }
            }
        }
        return new String[]{left.toString(), center.toString(), right.toString()};
    }

    public int getExportPageRowCount() {
        return Integer.MAX_VALUE;
    }

    public int getTopGroupColIndex() {
        return 0;
    }

    public String getCellValue(int row, int col) {
        String value = "";
        Cell cell = this.currentSheet.getCell(row, col, false);
        if (null != cell && null != cell.getValue()) {
            value = cell.getValue().toString();
        }
        return value;
    }

    public int getLastGroupColIndex() {
        return Integer.MAX_VALUE;
    }

    public String getPassWd() {
        Protection p = this.currentSheet.getSheetOption().getProtection(false);
        if (p != null && p.isProtected()) {
            return p.getEncryptedPassword();
        }
        return null;
    }

    public boolean isShowHoriLines() {
        return this.currentSheet.getSheetOption().isShowHoriLines();
    }

    public boolean isShowVertLines() {
        return this.currentSheet.getSheetOption().isShowVertLines();
    }

    public void addGroupInfo(Sheet sheet) {
        CTWorksheet ctWorksheet = AbstractDataWrapper.getCtWorksheet((Sheet)sheet);
        if (null != ctWorksheet) {
            SortedAttributeSpanArray rowSpans = this.currentSheet.getRowSpans();
            int maxGroupLevel = 0;
            for (int i = 0; i < rowSpans.size(); ++i) {
                SortedAttributeSpanArray.AttributeSpan attrSpanRow = rowSpans.getAttributeSpan(i);
                if (attrSpanRow.getOutlineGroupLevel() <= 0) continue;
                for (int j = attrSpanRow.getStart(); j < attrSpanRow.getEnd() + 1; ++j) {
                    SXSSFRow xrow = (SXSSFRow)sheet.getRow(j);
                    if (xrow == null) {
                        xrow = (SXSSFRow)sheet.createRow(j);
                    }
                    try {
                        Method m = xrow.getClass().getDeclaredMethod("setOutlineLevel", Integer.TYPE);
                        ReflectUtil.makeAccessible((Method)m);
                        m.invoke((Object)xrow, attrSpanRow.getOutlineGroupLevel());
                        maxGroupLevel = Math.max(maxGroupLevel, attrSpanRow.getOutlineGroupLevel());
                        CTSheetFormatPr pr = ctWorksheet.isSetSheetFormatPr() ? ctWorksheet.getSheetFormatPr() : ctWorksheet.addNewSheetFormatPr();
                        pr.setOutlineLevelRow((short)maxGroupLevel);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                }
            }
            CTCols ctCols = ctWorksheet.getColsArray(0);
            SortedAttributeSpanArray colSpans = this.currentSheet.getColSpans();
            for (int i = 0; i < colSpans.size(); ++i) {
                SortedAttributeSpanArray.AttributeSpan attrSpanCol = colSpans.getAttributeSpan(i);
                if (attrSpanCol.getOutlineGroupLevel() <= 0) continue;
                CTCol ctCol = (CTCol)CTCol.Factory.newInstance();
                ctCol.setMin((long)attrSpanCol.getStart() + 1L);
                ctCol.setMax((long)attrSpanCol.getEnd() + 1L);
                ctCol.setOutlineLevel((short)attrSpanCol.getOutlineGroupLevel());
                ctCols.getColList().add(ctCol);
            }
        }
    }

    public void addFreezeLine(Sheet xssfSheet) {
        ViewSplitInfo splitInfo = this.currentSheet.getSheetOption().getViewSplitInfo();
        if (!splitInfo.isFreezed()) {
            return;
        }
        int xSplit = splitInfo.getColSplit();
        int ySplit = splitInfo.getRowSplit();
        int topLeft_col = splitInfo.getFirstCol2();
        int topLeft_row = splitInfo.getFirstRow2();
        xssfSheet.createFreezePane(xSplit, ySplit, topLeft_col, topLeft_row);
    }

    public void addProtection(Sheet xssfSheet) {
        Protection pr;
        String passWd = this.getPassWd();
        if (null != passWd && null != (pr = this.currentSheet.getSheetOption().getProtection(false))) {
            xssfSheet.protectSheet(Password.getRealPassWord((String)passWd));
            CTWorksheet ctWorkbook = AbstractDataWrapper.getCtWorksheet((Sheet)xssfSheet);
            if (null == ctWorkbook) {
                return;
            }
            CTSheetProtection cp = ctWorkbook.isSetSheetProtection() ? ctWorkbook.getSheetProtection() : ctWorkbook.addNewSheetProtection();
            cp.setFormatRows(!pr.hasOperation(16));
            cp.setFormatColumns(!pr.hasOperation(8));
            cp.setFormatCells(!pr.hasOperation(4));
            cp.setSort(!pr.hasOperation(1024));
            cp.setDeleteRows(!pr.hasOperation(512));
            cp.setDeleteColumns(!pr.hasOperation(256));
            cp.setInsertHyperlinks(!pr.hasOperation(128));
            cp.setInsertRows(!pr.hasOperation(64));
            cp.setInsertColumns(!pr.hasOperation(32));
        }
    }

    public boolean isExcelFunction(String formula) {
        ObjectArray al;
        if (StringUtil.isEmptyString((String)formula)) {
            return false;
        }
        Expr expr = this.currentSheet.getExpr(null, formula);
        if (expr.hasMethod()) {
            if (expr.hasExternMethod() || expr.isExtensible() || expr.hasAbsMethod()) {
                return false;
            }
            IExprNode[] nodes = expr.getAllNodes();
            for (int i = 0; i < nodes.length; ++i) {
                IExprNode node = nodes[i];
                if (!(node instanceof ExprUnknownMethod) && (!(node instanceof ExprMethod) || ((ExprMethod)node).getMethod().getDeclaringClass().isAssignableFrom(ExcelFuncProvider.class))) continue;
                return false;
            }
        }
        if (expr.getParamExprs(al = new ObjectArray(), true) > 0) {
            int size = al.size();
            for (int ai = 0; ai < size; ++ai) {
                IExprNode[] nodes = ((Expr)al.get(ai)).getExprParams().getNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    Variant v;
                    IExprNode node = nodes[i];
                    if (node != NamedObjectNode.False && node != NamedObjectNode.True && node instanceof NamedObjectNode) {
                        return false;
                    }
                    if (!(node instanceof ExprConst) || (v = ((ExprConst)node).getValue()) == null || !v.isError()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public final String convertFormula(String formula, String cellValue, boolean showValue, boolean isNum) {
        boolean userDefine;
        boolean bl = userDefine = !this.isExcelFunction(formula);
        if (formula.charAt(0) == '=') {
            formula = formula.substring(1);
        }
        if (userDefine) {
            if (this._exportCustomFormulas) {
                cellValue = this.convertFormulaSpecialString(cellValue);
                int beginIndex = 0;
                int endIndex = 0;
                formula = this.convertFormulaSpecialString(formula);
                String convertedFormula = StringUtil.concateString((String)formula, (int)255, (String)"&");
                if (!showValue) {
                    beginIndex = 1;
                    endIndex = formula.length();
                    formula = "mid(" + convertedFormula + "&\"" + "_@_" + "\"&\"" + cellValue + "\"," + beginIndex + "," + endIndex + ")";
                } else {
                    beginIndex = 1 + formula.length() + "_@_".length();
                    endIndex = cellValue.length();
                    formula = "mid(" + convertedFormula + "&\"" + "_@_" + "\"&\"" + cellValue + "\"," + beginIndex + "," + endIndex + ")";
                    if (isNum) {
                        formula = "value(" + formula + ")";
                    }
                }
            } else {
                formula = "";
            }
        }
        return formula;
    }

    public final String formulaAt(int row, int col) {
        String formula = this.getFormula(row, col);
        Object cellValue = this.valueAt(row, col);
        if (formula == null) {
            return null;
        }
        return this.convertFormula(formula, null == cellValue ? "" : cellValue.toString(), this._showValue, cellValue instanceof Number || null == cellValue);
    }
}

