/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.print;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.kds.print.MultiPrintJobProvider;
import com.kingdee.cosmic.ctrl.kds.print.PrintBookTrans;
import com.kingdee.cosmic.ctrl.print.IConfigChangeListener;
import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.extend.IMultiPrintJobProvider;
import com.kingdee.cosmic.ctrl.print.extend.KDImagePrinter;
import com.kingdee.cosmic.ctrl.print.extend.MultiPrintJobManager;

public class PrintManager {
    MultiPrintJobManager printManager;
    MultiPrintJobProvider jobProvider;
    KDImagePrinter imagePrinter;

    public PrintManager(MultiPrintJobProvider jobProvider) {
        this.jobProvider = jobProvider;
        this.printManager = new MultiPrintJobManager((IMultiPrintJobProvider)jobProvider);
    }

    public MultiPrintJobManager getMultiPrintManager() {
        return this.printManager;
    }

    public KDImagePrinter getImagePrinter() {
        if (this.imagePrinter == null) {
            this.imagePrinter = new KDImagePrinter();
        }
        return this.imagePrinter;
    }

    public KDPrinter getPrinter() {
        return this.printManager.getPrinter();
    }

    public void pageDialog() {
        this.reloadPrintJob();
        this.printManager.pageDialog();
    }

    public void printPreview() {
        this.reloadPrintJob();
        this.printManager.printPreview();
        this.printManager.clear();
    }

    public int print() {
        return this.print(true);
    }

    public int print(boolean isClear) {
        this.reloadPrintJob();
        int ret = this.printManager.print();
        if (isClear) {
            this.printManager.clear();
        }
        return ret;
    }

    public void clear() {
        this.printManager.clear();
    }

    public void reloadPrintJob() {
        this.printManager.clear();
        PrintBookTrans.loadFromBook(this.printManager, this.jobProvider.getBook());
    }

    public void addConfigChangeListener(IConfigChangeListener lisener) {
        this.printManager.getPrinter().addConfigChangeListener(lisener);
    }

    public void createAllPrintJobs() {
        this.printManager.createAllPrintJobs();
    }

    public void setHeadFootUI(Class ui) {
        this.printManager.setHeadFootUI(ui);
    }

    public void printDirect() {
        this.printManager.printDirect();
    }

    public void fromXmlElement(IXmlElement tablesPrintConfigElement) {
        this.printManager.fromXmlElement(tablesPrintConfigElement);
    }
}

