/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IReportCurrencyCheck;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUtils;
import com.kingdee.eas.basedata.org.app.AbstractCompanyOrgUnitControllerBean;
import com.kingdee.eas.basedata.org.app.OrgAppUtils;
import com.kingdee.eas.basedata.org.app.cache.OrgCacheFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class CompanyOrgUnitControllerBean
extends AbstractCompanyOrgUnitControllerBean {
    private void updateParameter(Context ctx) throws BOSException, EASBizException {
        IParamControl pm = ParamControlFactory.getLocalInstance((Context)ctx);
        pm.paramReferenced("G001", null);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkInput(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        this.setAccountTable(ctx, model, pk);
        this.updateParameter(ctx);
        return pk;
    }

    void setAccountTable(Context ctx, IObjectValue model, IObjectPK pk) throws EASBizException, BOSException {
        if (((CompanyOrgUnitInfo)model).getAccountTable() != null) {
            IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
            iAccountView.addAccountByCompany(pk);
        }
    }

    private void _checkCompanyRef(Context ctx, CompanyOrgUnitInfo oldValue, CompanyOrgUnitInfo newValue) throws BOSException, EASBizException {
        boolean isRef = false;
        try {
            this._isReferenced(ctx, (IObjectPK)new ObjectUuidPK(oldValue.getId()));
        }
        catch (ObjectReferedException e) {
            isRef = true;
        }
        if (isRef) {
            if (oldValue.getBaseCurrency() == null && newValue.getBaseCurrency() != null || oldValue.getBaseCurrency() != null && newValue.getBaseCurrency() == null || oldValue.getBaseCurrency().getId() != null && newValue.getBaseCurrency().getId() != null && !oldValue.getBaseCurrency().getId().toString().equals(newValue.getBaseCurrency().getId().toString())) {
                throw new OrgException(OrgException.COMPANY_BASE_CURRENCY_ISREFERENCE);
            }
            if (oldValue.getAccountPeriodType() == null && newValue.getAccountPeriodType() != null || oldValue.getAccountPeriodType() != null && newValue.getAccountPeriodType() == null || oldValue.getAccountPeriodType().getId() != null && newValue.getAccountPeriodType().getId() != null && !oldValue.getAccountPeriodType().getId().toString().equals(newValue.getAccountPeriodType().getId().toString())) {
                throw new OrgException(OrgException.COMPANY_PERIODTYPE_ISREFFERENCE);
            }
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkInput(ctx, model);
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)model;
        CompanyOrgUnitInfo comInfo = this.getCompanyOrgUnitInfo(ctx, pk);
        this._checkCompanyRef(ctx, comInfo, info);
        super._update(ctx, pk, model);
        IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
        if (info.getAccountTable() != null && comInfo.getAccountTable() != null) {
            if (!comInfo.getAccountTable().getId().equals((Object)info.getAccountTable().getId())) {
                iAccountView.deleteByCompany(pk);
                iAccountView.addAccountByCompany(pk);
            }
        } else if (comInfo.getAccountTable() == null) {
            iAccountView.addAccountByCompany(pk);
        } else {
            iAccountView.deleteByCompany(pk);
        }
        if (!(!info.isIsGroup() || OrgUtils.objectEquals((Object)((Object)info.getReportConvertMode()), (Object)((Object)comInfo.getReportConvertMode())) && OrgUtils.objectEquals((Object)info.getReportCurrency(), (Object)comInfo.getReportCurrency()) && OrgUtils.objectEquals((Object)info.getReportExchangeTable(), (Object)comInfo.getReportExchangeTable()))) {
            this.updateChildren(ctx, info);
        }
    }

    private void updateChildren(Context ctx, CompanyOrgUnitInfo info) throws EASBizException, BOSException {
        OrgTreeInfo treeInfo = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectStringPK("00000000-0000-0000-0000-0000000000024F2827FD"));
        if (treeInfo == null) {
            return;
        }
        OrgStructureInfo structInfo = OrgStructureFactory.getLocalInstance((Context)ctx).getValue(treeInfo, (OrgUnitInfo)info);
        if (structInfo == null) {
            return;
        }
        Connection con = null;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            String sql = "SELECT FUnitID from T_ORG_Structure WHERE FTreeID='" + treeInfo.getId() + "'" + " and FLongNumber like '" + structInfo.getLongNumber() + "!" + "%'";
            String psql = "UPDATE T_ORG_COMPANY SET FReportCurrencyID=?,FReportExgTableID=?,FReportConvertMode=? WHERE FID=?";
            stmt = con.createStatement();
            pstmt = con.prepareStatement(psql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String unitID = rs.getString("FUnitID");
                this.fillBlank(pstmt, 1, (CoreBaseInfo)info.getReportCurrency());
                this.fillBlank(pstmt, 2, (CoreBaseInfo)info.getReportExchangeTable());
                pstmt.setInt(3, info.getReportConvertMode().getValue());
                pstmt.setString(4, unitID);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                SQLUtils.cleanup(pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
    }

    private void fillBlank(PreparedStatement pstmt, int index, CoreBaseInfo info) throws SQLException {
        if (info == null) {
            pstmt.setString(index, null);
        } else {
            pstmt.setString(index, info.getId().toString());
        }
    }

    void _checkInput(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkIsOneGroup(ctx, model);
        OrgAppUtils._checkNameDup((Context)ctx, (IObjectValue)model);
        OrgAppUtils._checkNumberDup((Context)ctx, (IObjectValue)model);
        CompanyOrgUnitInfo editData = (CompanyOrgUnitInfo)model;
        if (editData.getBaseCurrency() == null) {
            throw new OrgBlankException(OrgBlankException.BASE_CURRENCY_CAN_NOT_BLANK);
        }
        if (editData.getAccountPeriodType() == null) {
            throw new OrgBlankException(OrgBlankException.PERIOD_TYPE_CAN_NOT_BLANK);
        }
        if (editData.getAccountTable() == null) {
            throw new OrgBlankException(OrgBlankException.ACCOUNT_TABLE_CAN_NOT_BLANK);
        }
    }

    void _checkIsOneGroup(Context ctx, IObjectValue model) throws OrgException, EASBizException, BOSException {
        CompanyOrgUnitInfo unitInfo = (CompanyOrgUnitInfo)model;
        if (!unitInfo.isIsGroup()) {
            return;
        }
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isGroup", (Object)new Integer(1)));
        if (unitInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)unitInfo.getId(), CompareType.NOTEQUALS));
        }
        if (iCompany.exists(filterInfo)) {
            throw new OrgException(OrgException.ONLY_ONE_GROUP_BYCOMPANY);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.getCompanyOrgUnitInfo(ctx, pk).getAccountTable() != null) {
            IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
            iAccountView.deleteByCompany(pk);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected IObjectCollection _buildByRoot(Context ctx, String rootID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo root = this.getCompanyOrgUnitInfo(ctx, (IObjectPK)new ObjectUuidPK(rootID));
        String ln = root.getLongNumber();
        String oql = "select id,parent.id ,name,number where longnumber='" + ln + "' OR longNumber like '" + ln + "!%' order by longnumber";
        return this.getCompanyOrgUnitCollection(ctx, oql);
    }

    @Override
    protected IObjectCollection _getAdminOrgUnitCollection(Context ctx, String companyOrgUnitID) throws BOSException, EASBizException {
        IOrgUnitRelation iour = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection ouc = iour.getFromUnit(companyOrgUnitID, 1, 0);
        AdminOrgUnitCollection aouc = new AdminOrgUnitCollection();
        int n = ouc.size();
        for (int i = 0; i < n; ++i) {
            aouc.add((AdminOrgUnitInfo)ouc.get(i));
        }
        FullOrgUnitInfo foui = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitID));
        if (foui.isIsAdminOrgUnit()) {
            AdminOrgUnitInfo aoui = AdminOrgUnitFactory.getLocalInstance(ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitID));
            aouc.add(aoui);
        }
        this.addAdminOrgUnitByFindingDefaultDelegation(ctx, aouc, companyOrgUnitID);
        return aouc;
    }

    private void addAdminOrgUnitByFindingDefaultDelegation(Context ctx, AdminOrgUnitCollection aouc, String companyOrgUnitID) throws BOSException, EASBizException {
        FullOrgUnitInfo foui = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitID));
        this.findAdminOrgUnitAndAdd(ctx, aouc, foui);
    }

    private void findAdminOrgUnitAndAdd(Context ctx, AdminOrgUnitCollection aouc, FullOrgUnitInfo foui) throws BOSException, EASBizException {
        FullOrgUnitCollection subUnits = this.getChildren(ctx, foui);
        int n = subUnits.size();
        for (int i = 0; i < n; ++i) {
            FullOrgUnitInfo subUnit = subUnits.get(i);
            if (subUnit.isIsCompanyOrgUnit()) continue;
            if (subUnit.isIsAdminOrgUnit()) {
                boolean isDelegatingToCompanyOrgUnit;
                boolean bl = isDelegatingToCompanyOrgUnit = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(subUnit.getId().toString(), 0, 1).size() > 0;
                if (!isDelegatingToCompanyOrgUnit) {
                    AdminOrgUnitInfo aoui = AdminOrgUnitFactory.getLocalInstance(ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(subUnit.getId().toString()));
                    aouc.add(aoui);
                }
            }
            this.findAdminOrgUnitAndAdd(ctx, aouc, subUnit);
        }
    }

    private FullOrgUnitCollection getChildren(Context ctx, FullOrgUnitInfo foui) throws BOSException, EASBizException {
        String parentID = foui.getId().toString().trim();
        FullOrgUnitCollection fouc = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("where parent.id='" + parentID + "'");
        return fouc;
    }

    @Override
    protected IObjectCollection _getAdminOrgUnitCollectionWithOrgRangeFilter(Context ctx, String companyOrgUnitID) throws BOSException, EASBizException {
        AdminOrgUnitCollection aouc1 = (AdminOrgUnitCollection)this._getAdminOrgUnitCollection(ctx, companyOrgUnitID);
        OrgType ot = OrgType.Admin;
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)ot));
        IPermission ip = PermissionFactory.getLocalInstance((Context)ctx);
        HashMap hm = (HashMap)ip.getAuthorizedOrgs((IObjectPK)userPK, ot, (IObjectPK)treePK, null, null);
        AdminOrgUnitCollection aouc2 = new AdminOrgUnitCollection();
        AdminOrgUnitInfo oui = null;
        int n = aouc1.size();
        for (int i = 0; i < n; ++i) {
            oui = aouc1.get(i);
            if (!hm.containsKey(oui.getId().toString())) continue;
            aouc2.add(oui);
        }
        return aouc2;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (OrgCacheFactory.getOrgCache((Context)ctx).existsInOrgCache(ctx, pk.toString(), OrgType.Company)) {
            return OrgCacheFactory.getOrgCache((Context)ctx).getOrgUnitInfo(ctx, pk.toString(), OrgType.Company);
        }
        IObjectValue returnValue = super._getValue(ctx, pk);
        OrgCacheFactory.getOrgCache((Context)ctx).putOrgUnitInfo(ctx, pk.toString(), OrgType.Company, (OrgUnitInfo)returnValue);
        return returnValue;
    }

    @Override
    protected boolean _isCanModifyReportCurrency(Context ctx) throws BOSException, EASBizException {
        boolean isCanModify = true;
        try {
            String[] checks = RefCheckersDAO.getCheckers((Context)ctx, (String)"16FD9F90", IReportCurrencyCheck.class);
            if (checks != null && checks.length > 0) {
                IReportCurrencyCheck currencyCheck = null;
                for (int i = 0; i < checks.length && (isCanModify = (currencyCheck = (IReportCurrencyCheck)Class.forName(checks[i]).newInstance()).reportCurrencyCanSelect(ctx)); ++i) {
                }
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return isCanModify;
    }
}

