/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.basedata.org.OrgSpecialTablesRebuildFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgVersionMgrFacadeFactory;
import com.kingdee.eas.basedata.org.app.AbstractHROrgUnitControllerBean;
import com.kingdee.eas.basedata.org.app.cache.OrgCacheFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;

public class HROrgUnitControllerBean
extends AbstractHROrgUnitControllerBean {
    @Override
    protected IObjectCollection _getAdminOrgUnitCollection(Context ctx, String hrOrgUnitID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select \"A\".FID,\"A\".FNumber,\"A\".FName_L1,\"A\".FName_L2,").append("\"A\".FName_L3,\"A\".FLongNumber,\"A\".FLevel, \"A\".FSortCode ").append("from T_ORG_Admin \"A\" left join T_ORG_UnitRelation \"B\" ").append("on \"A\".FID=\"B\".FFromUnitID ").append("where \"A\".FIsSealUp = 0 and (\"B\".FToUnitID=? and FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5') ").append(" order by FLongNumber asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{hrOrgUnitID});
        AdminOrgUnitCollection adminCol = new AdminOrgUnitCollection();
        AdminOrgUnitInfo adminInfo = null;
        Locale l = ctx.getLocale();
        String namePosition = "FName_L2";
        if (l.toString().equalsIgnoreCase("l1")) {
            namePosition = "FName_L1";
        } else if (l.toString().equalsIgnoreCase("l2")) {
            namePosition = "FName_L2";
        } else if (l.toString().equalsIgnoreCase("l3")) {
            namePosition = "FName_L3";
        }
        try {
            while (rs.next()) {
                adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                adminInfo.setNumber(rs.getString("FNumber"));
                String tempName = rs.getString(namePosition);
                adminInfo.setName(tempName, l);
                adminInfo.setName(tempName);
                adminInfo.setLongNumber(rs.getString("FLongNumber"));
                adminInfo.setLevel(rs.getInt("FLevel"));
                adminInfo.setSortCode(rs.getString("FSortCode"));
                adminCol.add(adminInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminCol;
    }

    @Override
    protected IObjectCollection _getAdminOrgUnitCollectionWithOrgRangeFilter(Context ctx, String hrOrgUnitID) throws BOSException, EASBizException {
        AdminOrgUnitCollection aouc1 = (AdminOrgUnitCollection)this._getAdminOrgUnitCollection(ctx, hrOrgUnitID);
        OrgType ot = OrgType.Admin;
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)ot));
        IPermission ip = PermissionFactory.getLocalInstance((Context)ctx);
        HashMap hm = (HashMap)ip.getAuthorizedOrgs((IObjectPK)userPK, ot, (IObjectPK)treePK, null, null);
        AdminOrgUnitCollection aouc2 = new AdminOrgUnitCollection();
        AdminOrgUnitInfo oui = null;
        int n = aouc1.size();
        for (int i = 0; i < n; ++i) {
            oui = aouc1.get(i);
            if (!hm.containsKey(oui.getId().toString())) continue;
            aouc2.add(oui);
        }
        return aouc2;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (OrgCacheFactory.getOrgCache((Context)ctx).existsInOrgCache(ctx, pk.toString(), OrgType.HRO)) {
            return OrgCacheFactory.getOrgCache((Context)ctx).getOrgUnitInfo(ctx, pk.toString(), OrgType.HRO);
        }
        IObjectValue returnValue = super._getValue(ctx, pk);
        OrgCacheFactory.getOrgCache((Context)ctx).putOrgUnitInfo(ctx, pk.toString(), OrgType.HRO, (OrgUnitInfo)returnValue);
        return returnValue;
    }

    @Override
    protected void _addnewByAdmin(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isAdminOrgUnit", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isCostOrgUnit", (Object)new Integer(0)));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        FullOrgUnitCollection unitCol = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(viewInfo);
        if (unitCol.size() == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        String insertPartCostSql = "INSERT INTO T_ORG_OUPartCostCenter(FID, FUnitID, FCostCenterType, FIsBizUnit, FVersionNumber) VALUES (?, ?, ?, ?, ?)";
        String updateBaseUnitSql = "UPDATE T_ORG_BaseUnit SET FIsCostOrgUnit = 1, FPartCostCenterID = ? WHERE FID = ?";
        String insertStructSql = "INSERT INTO T_ORG_Structure (FID, FIsLeaf, FLevel, FLongNumber, FUnitID, FTreeID, FParentID, FIsValid, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String updateStructSql = "UPDATE T_ORG_Structure SET FIsLeaf = 0 WHERE FID = ?";
        conn = this.getConnection(ctx);
        String versionNumber = OrgVersionMgrFacadeFactory.getLocalInstance((Context)ctx).getCurrentVersionNumber();
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < unitCol.size(); ++i) {
            FullOrgUnitInfo unitInfo = unitCol.get(i);
            String unitID = unitInfo.getId().toString();
            OrgStructureInfo structAdminInfo = iStruct.getOrgStructureInfo("select *, parent.* where tree.id = '00000000-0000-0000-0000-0000000000034F2827FD' and unit.id = '" + unitID + "'");
            OrgStructureInfo parentStructAdminInfo = structAdminInfo.getParent();
            String parentUnitID = null;
            if (parentStructAdminInfo != null) {
                parentUnitID = parentStructAdminInfo.getUnit().getId().toString();
            }
            OrgStructureInfo parentStructCostInfo = null;
            if (parentUnitID != null) {
                while (!"00000000-0000-0000-0000-000000000000CCE7AED4".equals(parentUnitID) && !iStruct.exists("select id where tree.id = '00000000-0000-0000-0000-0000000000054F2827FD' and unit.id = '" + parentUnitID + "' and unit.partCostCenter.isBizUnit = 0")) {
                    structAdminInfo = iStruct.getOrgStructureInfo("select *, parent.* where tree.id = '00000000-0000-0000-0000-0000000000034F2827FD' and unit.id = '" + parentUnitID + "'");
                    parentStructAdminInfo = structAdminInfo.getParent();
                    parentUnitID = parentStructAdminInfo.getUnit().getId().toString();
                }
                parentStructCostInfo = iStruct.getOrgStructureInfo("select * where tree.id = '00000000-0000-0000-0000-0000000000054F2827FD' and unit.id = '" + parentUnitID + "'");
            }
            String newPartCostID = BOSUuid.create((String)"2EC9A165").toString();
            String newStructID = BOSUuid.create((String)"32B85C74").toString();
            try {
                pstmt = conn.prepareStatement(insertPartCostSql);
                pstmt.setString(1, newPartCostID);
                pstmt.setString(2, unitID);
                pstmt.setInt(3, 0);
                pstmt.setInt(4, structAdminInfo.isIsLeaf() ? 1 : 0);
                pstmt.setString(5, versionNumber);
                pstmt.executeUpdate();
                pstmt = conn.prepareStatement(updateBaseUnitSql);
                pstmt.setString(1, newPartCostID);
                pstmt.setString(2, unitID);
                pstmt.executeUpdate();
                pstmt = conn.prepareStatement(insertStructSql);
                pstmt.setString(1, newStructID);
                pstmt.setInt(2, 1);
                pstmt.setInt(3, parentStructCostInfo == null ? 1 : parentStructCostInfo.getLevel() + 1);
                String longNumber = null;
                longNumber = parentStructCostInfo != null ? parentStructCostInfo.getLongNumber() + "!" + unitInfo.getNumber() : unitInfo.getNumber();
                this.checkLongNumberLen(longNumber);
                pstmt.setString(4, longNumber);
                pstmt.setString(5, unitID);
                pstmt.setString(6, "00000000-0000-0000-0000-0000000000054F2827FD");
                pstmt.setString(7, parentStructCostInfo == null ? null : parentStructCostInfo.getId().toString());
                pstmt.setInt(8, 1);
                pstmt.setString(9, null);
                String displayName_L2 = null;
                displayName_L2 = parentStructCostInfo != null && parentStructCostInfo.getDisplayName(new Locale("L2")) != null ? parentStructCostInfo.getDisplayName(new Locale("L2")) + "_" + unitInfo.getName(new Locale("L2")) : unitInfo.getName(new Locale("L2"));
                pstmt.setString(10, this.limitDisplayNameLength(displayName_L2));
                String displayName_L3 = null;
                displayName_L3 = parentStructCostInfo != null && parentStructCostInfo.getDisplayName(new Locale("L3")) != null ? parentStructCostInfo.getDisplayName(new Locale("L3")) + "_" + unitInfo.getName(new Locale("L3")) : unitInfo.getName(new Locale("L3"));
                pstmt.setString(11, this.limitDisplayNameLength(displayName_L3));
                pstmt.executeUpdate();
                if (parentStructCostInfo == null) continue;
                pstmt = conn.prepareStatement(updateStructSql);
                pstmt.setString(1, parentStructCostInfo.getId().toString());
                pstmt.executeUpdate();
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException e) {}
                    pstmt = null;
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {}
                    conn = null;
                }
            }
        }
        OrgSpecialTablesRebuildFacadeFactory.getLocalInstance((Context)ctx).rebuildSpecialTables();
    }

    @Override
    protected boolean _isShowOrgFunction(Context ctx) throws BOSException, EASBizException {
        boolean flag = false;
        String rightCompareValue = "1";
        String sql = "select FValue from t_hr_hrinit where FKEY = 'IS_USE_EASHR_ORG_FUNCTION'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String value = rs.getString("FValue");
                if (StringUtils.isEmpty((String)value) || !"1".equals(value)) continue;
                flag = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return flag;
    }

    private String limitDisplayNameLength(String displayName) {
        if (displayName != null && displayName.length() > 200) {
            displayName = displayName.substring(0, 200);
        }
        return displayName;
    }

    private void checkLongNumberLen(String longNumber) throws EASBizException, BOSException {
        int len;
        int n = len = longNumber == null ? -1 : longNumber.length();
        if (len > 200) {
            throw new OrgException(OrgException.CHECKLONGNUMBERLEN);
        }
    }
}

