/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.di;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUPartCostCenterInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.app.di.BizOrgDIBase;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Locale;

public class CostCenterDI
extends BizOrgDIBase {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CoreBaseInfo createNewData(Hashtable hsData, Context ctx) throws Exception {
        String number = this.getFieldValue(hsData, "FNumber");
        String parent = this.getFieldValue(hsData, "FParentID");
        String isBizUnit = this.getFieldValue(hsData, "FIsBizUnit");
        String leader = this.getFieldValue(hsData, "FLeader");
        String costCenterType = this.getFieldValue(hsData, "FCostCenterType");
        this.checkRequeiredField(ctx, "FNumber", number);
        this.checkRequeiredField(ctx, "FParentID", parent);
        if (number.equals(parent)) {
            Locale currentLocale = ctx.getLocale();
            throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"ADD_BIZ_NUMBER_NOTEQ_PARENT", (Locale)currentLocale));
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)parent));
        filterInfo.getFilterItems().add(new FilterItemInfo("partCostCenter.isBizUnit", (Object)Boolean.TRUE));
        if (this.getBizInterface(ctx).exists(filterInfo)) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.basedata.orgext.ORGEXTAutoGenerateResource", (String)"2_CompanyDI", (Locale)ctx.getLocale()));
        }
        FullOrgUnitInfo unitInfo = this.getFullOrgUnitInfo4BizOrg(ctx, number);
        unitInfo.setIsCostOrgUnit(true);
        BizParentAndDelegateInfo pdInfo = this.getBizParentAndDelegationInfo(unitInfo);
        CostCenterOrgUnitInfo parentCostInfo = null;
        if (unitInfo.isIsProfitOrgUnit()) {
            ProfitCenterOrgUnitInfo parentProfitInfo = (ProfitCenterOrgUnitInfo)pdInfo.getParentOrg(OrgType.ProfitCenter);
            parentCostInfo = (CostCenterOrgUnitInfo)this.getBizOrgUnitInfo(ctx, OrgType.CostCenter, parent);
            if (!parentCostInfo.getId().toString().equals(parentProfitInfo.getId().toString())) {
                throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"PROFIT_PARENT_MUST_EQUAL_TO_COST_PARENT", (Locale)ctx.getLocale()));
            }
        }
        if (parentCostInfo == null) {
            pdInfo.setParentOrg(OrgType.CostCenter, (OrgUnitInfo)((CostCenterOrgUnitInfo)this.getBizOrgUnitInfo(ctx, OrgType.CostCenter, parent)));
        } else {
            pdInfo.setParentOrg(OrgType.CostCenter, parentCostInfo);
        }
        OUPartCostCenterInfo partCostCenterInfo = unitInfo.getPartCostCenter();
        if (partCostCenterInfo == null) {
            partCostCenterInfo = new OUPartCostCenterInfo();
            partCostCenterInfo.setUnit(unitInfo);
            unitInfo.setPartCostCenter(partCostCenterInfo);
        }
        if ("1".equalsIgnoreCase(isBizUnit) || "Y".equalsIgnoreCase(isBizUnit)) {
            partCostCenterInfo.setIsBizUnit(true);
        } else {
            partCostCenterInfo.setIsBizUnit(false);
        }
        if (leader != null && leader.length() != 0) {
            PersonInfo leadInfo = (PersonInfo)this.getCoreBaseInfo((ICoreBase)PersonFactory.getLocalInstance((Context)ctx), leader);
            if (leadInfo == null) {
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
                message.append(leader);
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"LEADER_NOT_EXISTED", (Locale)ctx.getLocale()));
                throw new Exception(message.toString());
            }
            partCostCenterInfo.setLeader(leadInfo);
        }
        if (costCenterType != null && costCenterType.length() != 0) {
            if ("0".equals(costCenterType)) {
                partCostCenterInfo.setCostCenterType(CostCenterType.DirectProdDept);
            } else if ("1".equals(costCenterType)) {
                partCostCenterInfo.setCostCenterType(CostCenterType.AssistantProdDept);
            } else if ("2".equals(costCenterType)) {
                partCostCenterInfo.setCostCenterType(CostCenterType.ManageDept);
            } else {
                if (!"3".equals(costCenterType)) throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"COSTCENTER_TYPE_NOT_CORRECT", (Locale)ctx.getLocale()));
                partCostCenterInfo.setCostCenterType(CostCenterType.SaleDept);
            }
        } else {
            partCostCenterInfo.setCostCenterType(CostCenterType.AssistantProdDept);
        }
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
        orgTypeHelper.addOrgType(OrgType.CostCenter);
        unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        return unitInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            Timestamp createTime;
            String leaderNumber;
            boolean isBizUnit;
            result.put("FNumber", rs.getString("number"));
            String parentNumber = rs.getString("parent.number");
            if (parentNumber != null) {
                result.put("FParentID", parentNumber);
            }
            if (isBizUnit = rs.getBoolean("isBizUnit")) {
                result.put("FIsBizUnit", "Y");
            }
            if ((leaderNumber = rs.getString("leader.number")) != null) {
                result.put("FLeader", leaderNumber);
            }
            int type = rs.getInt("costCenterType");
            result.put("FCostCenterType", new Integer(type).toString());
            String creatorNumber = rs.getString("creator.number");
            if (creatorNumber != null) {
                result.put("FCreatorNumber", creatorNumber);
            }
            if ((createTime = rs.getTimestamp("createTime")) != null) {
                result.put("FCreateTime", ExcelUtil.formatNationalTime((Context)ctx, (Object)createTime));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"DB_ACCESS_ERROR", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.org.app.CostCenterExportQuery";
    }
}

