/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper.orgtypeimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IOrgRangeIncludeSubOrg;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.AreaInfo;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.BizDataCheckInfo;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOUPartAdmin;
import com.kingdee.eas.basedata.org.IOrgDelegateFacade;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.JobSystemInfo;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartAdminCollection;
import com.kingdee.eas.basedata.org.OUPartAdminFactory;
import com.kingdee.eas.basedata.org.OUPartAdminInfo;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgDelegateFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitLayerInfo;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.app.OUPartReference;
import com.kingdee.eas.basedata.org.app.OrgDBUtils;
import com.kingdee.eas.basedata.org.app.OrgVersionServerUtils;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.IOrgQueryInfo;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.AbstractDefaultOrgTypeImpl;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.QueryAdminInfo;
import com.kingdee.eas.basedata.org.helper.BizOrgQueryParam;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgAppAdminImpl
extends AbstractDefaultOrgTypeImpl
implements IOrgAppHelper {
    private static Logger logger = Logger.getLogger((String)OrgAppAdminImpl.class.getName());

    public void updateOrgInfo(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo, String versionNumber, boolean isOrgStart) throws BOSException, EASBizException {
        if (!unitInfo.isIsAdminOrgUnit()) {
            IOUPartAdmin iPartAdmin = OUPartAdminFactory.getLocalInstance(ctx);
            if (iPartAdmin.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                OUPartReference.isAdminOrgUnitReferencedByAsstActTypeDefault((Context)ctx, (String)pk.toString());
                OUPartReference.isReferenced((Context)ctx, (String)new OUPartAdminInfo().getBOSType().toString(), (String)pk.toString());
                OUPartReference.isReferenced((Context)ctx, (String)new AdminOrgUnitInfo().getBOSType().toString(), (String)pk.toString());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
                iPartAdmin.delete(filter);
            }
            unitInfo.setPartAdmin(null);
            return;
        }
        OUPartAdminInfo partAdminInfo = unitInfo.getPartAdmin();
        partAdminInfo.setUnit(unitInfo);
        IOUPartAdmin iPartAdmin = OUPartAdminFactory.getLocalInstance(ctx);
        if (iPartAdmin.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
            if (partAdminInfo.getId() == null) {
                BOSUuid partID = iPartAdmin.getOUPartAdminInfo("Select id Where unit.id = '" + pk.toString() + "'").getId();
                partAdminInfo.setId(partID);
            }
            BizParentAndDelegateInfo pdInfo = (BizParentAndDelegateInfo)unitInfo.get("PDValueInfo");
            AdminOrgUnitInfo parentAdminUnit = (AdminOrgUnitInfo)pdInfo.getParentOrg(OrgType.Admin);
            if (!unitInfo.isIsCU() && parentAdminUnit != null) {
                IOrgStructure iStruct = OrgStructureFactory.getLocalInstance((Context)ctx);
                OrgStructureInfo structInfo = iStruct.getOrgStructureInfo("Select id,longNumber,unit.number, unit.name,unit.isCU,unit.partAdmin.id Where unit.id = '" + unitInfo.getId().toString() + "' and tree.id = '" + "00000000-0000-0000-0000-0000000000034F2827FD" + "'");
                IOUPartAdmin iOuPartAdmin = OUPartAdminFactory.getLocalInstance(ctx);
                String oql = "select * , controlUnit.id where id ='" + structInfo.getUnit().getPartAdmin().getId().toString() + "'";
                OUPartAdminInfo partAdminExtInfo = iOuPartAdmin.getOUPartAdminInfo(oql);
                String oldLongNumber = structInfo.getLongNumber();
                String oldControlUnitId = partAdminExtInfo.getControlUnit().getId().toString();
                String newControlUnitId = parentAdminUnit.getCU().getId().toString();
                OrgDBUtils.updateSubOrgCU((Context)ctx, (String)oldLongNumber, (String)oldControlUnitId, (String)newControlUnitId);
                partAdminInfo.setControlUnit(parentAdminUnit.getCU());
            }
            this.reSetPartAdminByIsIndependence(partAdminInfo);
            this.reSetPartAdminByIsJuridicalCompany(partAdminInfo);
            iPartAdmin.update((IObjectPK)new ObjectUuidPK(partAdminInfo.getId()), partAdminInfo);
            OrgStructureInfo structInfo = null;
            IOrgStructure iStruct = OrgStructureFactory.getLocalInstance((Context)ctx);
            if (!unitInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                structInfo = iStruct.getOrgStructureInfo("Select id,longNumber,isLeaf,unit.number, unit.name,unit.isCU,unit.partAdmin.id,parent.unit.id Where unit.id = '" + unitInfo.getId().toString() + "' and tree.id = '" + "00000000-0000-0000-0000-0000000000034F2827FD" + "'");
            }
            if (structInfo != null && !structInfo.getParent().getUnit().getId().toString().equals(parentAdminUnit.getId().toString())) {
                if (structInfo.isIsLeaf()) {
                    this.updateBizDataForAdmin(ctx, unitInfo.getId().toString(), parentAdminUnit.getId().toString());
                } else {
                    OrgStructureCollection structInfoTemp = iStruct.getOrgStructureCollection("Select unit.id Where ISLEAF = 1 AND LongNumber like '" + structInfo.getLongNumber() + "!%' " + " and tree.id='00000000-0000-0000-0000-0000000000034F2827FD' " + " ORDER BY LongNumber");
                    if (structInfoTemp.size() != 0 && structInfoTemp.get(0).getUnit().getId() != null) {
                        this.updateBizDataForAdmin(ctx, structInfoTemp.get(0).getUnit().getId().toString(), parentAdminUnit.getId().toString());
                    }
                }
            }
        } else {
            if (!unitInfo.isIsCU() && !currentCUInfo.isIsAdminOrgUnit()) {
                Object[] param = new Object[]{OrgType.Admin.getAlias(), OrgType.Admin.getAlias()};
                throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
            }
            if (unitInfo.isIsCU()) {
                CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                ctrlUnitInfo.setId(unitInfo.getId());
                partAdminInfo.setControlUnit(currentCUInfo);
            } else if (partAdminInfo.getControlUnit() == null) {
                partAdminInfo.setControlUnit(currentCUInfo);
            }
            partAdminInfo.setVersionNumber(versionNumber);
            this.reSetPartAdminByIsIndependence(partAdminInfo);
            this.reSetPartAdminByIsJuridicalCompany(partAdminInfo);
            iPartAdmin.addnew(partAdminInfo);
            unitInfo.setPartAdmin(partAdminInfo);
            BizParentAndDelegateInfo pdInfo = (BizParentAndDelegateInfo)unitInfo.get("PDValueInfo");
            AdminOrgUnitInfo parentAdminUnit = (AdminOrgUnitInfo)pdInfo.getParentOrg(OrgType.Admin);
            if (parentAdminUnit != null) {
                this.updateBizDataForAdmin(ctx, unitInfo.getId().toString(), parentAdminUnit.getId().toString());
            }
        }
    }

    private void reSetPartAdminByIsJuridicalCompany(OUPartAdminInfo partAdminInfo) throws BOSException, EASBizException {
        if (partAdminInfo != null && !partAdminInfo.isIsJuridicalCompany()) {
            partAdminInfo.setJuridicalPerson(null);
            partAdminInfo.setRegistType(null);
            partAdminInfo.setSetupDate(null);
            partAdminInfo.setEndupDate(null);
        }
    }

    private void reSetPartAdminByIsIndependence(OUPartAdminInfo partAdminInfo) {
        if (partAdminInfo != null && !partAdminInfo.isIsIndependence()) {
            partAdminInfo.setIndustry(null);
            partAdminInfo.setEconomicType(null);
            partAdminInfo.setRegisteredCapital(null);
            partAdminInfo.setRegisteredCode(null);
            partAdminInfo.setTaxNumber(null);
            partAdminInfo.setOrgCode(null);
        }
    }

    public void addNewInfo(Context ctx, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo) throws BOSException, EASBizException {
        String versionNumber = unitInfo.getVersionNumber();
        if (unitInfo.isIsAdminOrgUnit()) {
            if (!unitInfo.isIsCU() && !currentCUInfo.isIsAdminOrgUnit()) {
                Object[] param = new Object[]{OrgType.Admin.getAlias(), OrgType.Admin.getAlias()};
                throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
            }
            OUPartAdminInfo ouAdminInfo = unitInfo.getPartAdmin();
            ouAdminInfo.setUnit(unitInfo);
            ouAdminInfo.setVersionNumber(versionNumber);
            ouAdminInfo.setControlUnit(currentCUInfo);
            IOUPartAdmin iAdmin = OUPartAdminFactory.getLocalInstance(ctx);
            iAdmin.addnew(ouAdminInfo);
            unitInfo.setPartAdmin(ouAdminInfo);
            BizParentAndDelegateInfo pdInfo = (BizParentAndDelegateInfo)unitInfo.get("PDValueInfo");
            AdminOrgUnitInfo parentAdminUnit = (AdminOrgUnitInfo)pdInfo.getParentOrg(OrgType.Admin);
            if (parentAdminUnit != null) {
                this.updateBizDataForAdmin(ctx, unitInfo.getId().toString(), parentAdminUnit.getId().toString());
            }
        }
    }

    public void delOrgInfo(Context ctx, FullOrgUnitInfo deleteInfo) throws BOSException, EASBizException {
        if (deleteInfo.isIsAdminOrgUnit()) {
            INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
            if (iNOV.isBizChildrenExist(deleteInfo, "00000000-0000-0000-0000-0000000000034F2827FD")) {
                Object[] params = new String[]{OrgType.Admin.getAlias()};
                throw new OUException(OUException.EXISTCHILDREN_NOTDELETE, params);
            }
            ObjectStringPK pk = new ObjectStringPK(deleteInfo.getId().toString());
            OUPartReference.isAdminOrgUnitReferencedByAsstActTypeDefault((Context)ctx, (String)pk.toString());
            OUPartReference.isReferenced((Context)ctx, (String)"BCA8D47D", (String)pk.toString());
            OUPartReference.isReferenced((Context)ctx, (String)"6A6435BE", (String)pk.toString());
            IOUPartAdmin iAdmin = OUPartAdminFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iAdmin.delete(filter);
        }
    }

    public String[] getRebuildSql() {
        StringBuffer sb = new StringBuffer(800);
        sb.append("insert into T_ORG_Admin (\n").append("FID,\n").append("FName_L1,\n").append("FName_L2,\n").append("FName_L3,\n").append("FNumber,\n").append("FDescription_L1,\n").append("FDescription_L2,\n").append("FDescription_L3,\n").append("FSimpleName,\n").append("FIsGrouping,\n").append("FEffectDate,\n").append("FInvalidDate,\n").append("FIsFreeze,\n").append("FIsCompanyOrgUnit,\n").append("FIsAdminOrgUnit,\n").append("FIsSaleOrgUnit,\n").append("FIsPurchaseOrgUnit,\n").append("FIsStorageOrgUnit,\n").append("FIsProfitOrgUnit,\n").append("FIsCostOrgUnit,\n").append("FIsCU,\n").append("FIsUnion,\n").append("FIsHROrgUnit,\n").append("FCreatorID,\n").append("FCreateTime,\n").append("FLastUpdateUserID,\n").append("FLastUpdateTime,\n").append("FControlUnitID,\n").append("FIsLeaf,\n").append("FLevel,\n").append("FLongNumber,\n").append("FParentID,\n").append("FIsEntity,\n").append("FIsVirtual,\n").append("FPhoneNumber,\n").append("FLayerID,\n").append("FResponPositionID,\n").append("FAddressID,\n").append("FAreaID,\n").append("FPrincipalID,\n").append("FLayerTypeID,\n").append("FBaseDuty_L1,\n").append("FBaseDuty_L2,\n").append("FBaseDuty_L3,\n").append("FIndex,\n").append("FJobSystemID,\n").append("FAdminAddress_L1,\n").append("FAdminAddress_L2,\n").append("FAdminAddress_L3,\n").append("FZipCode,\n").append("FFax,\n").append("FIsSealUp,\n").append("FIsStart,\n").append("FIsOUSealUp ,\n").append("FDisplayName_L1,\n").append("FDisplayName_L2,\n").append("FDisplayName_L3,\n").append("FPropertySealUpDate, \n").append("FVersionNumber,\n").append("FCode,\n").append("FIsTransportOrgUnit,\n").append("FIsQualityOrgUnit,\n").append("FIndustryID,\n").append("FSortCode,\n").append("FEconomicType,\n").append("FRegisteredCapital,\n").append("FRegisteredCode,\n").append("FSetupDate,\n").append("FEndupDate,\n").append("FTaxNumber,\n").append("FOrgCode,\n").append("FIsChurchyard,\n").append("FJuridicalPersonID,\n").append("FIsJuridicalCompany,\n").append("FIsIndependence,\n").append("forgTypeStr,\n").append("FTerritory_L1,\n").append("FTerritory_L2,\n").append("FTerritory_L3,\n").append("FDelegateHRID,\n").append("FRegistTypeID,\n").append("FOrgPropertyID,\n").append("FEFFDT,\n").append("FLEFFDT,\n").append("FOrgFunctionID,\n").append("FReserveFieldFirst,\n").append("FReserveFieldSecond,\n").append("FReserveItemFirst,\n").append("FReserveItemSecond,\n").append("FHistoryRelateID,\n").append("fisstartshr,\n").append("FCompanyID,\n").append("FDepartmentID,\n").append("FOfficeID,\n").append("FLevelOneGroupID,\n").append("FLevelTwoGroupID,\n").append("FLevelFourGroupID,\n").append("FLevelFiveGroupID,\n").append("FLevelSixGroupID )\n").append("SELECT\n").append("ou.FID,\n").append("ou.FName_L1,\n").append("ou.FName_L2,\n").append("ou.FName_L3,\n").append("ou.FNumber,\n").append("ou.FDescription_L1,\n").append("ou.FDescription_L2,\n").append("ou.FDescription_L3,\n").append("ou.FSimpleName,\n").append("ou.FIsGrouping,\n").append("ou.FEffectDate,\n").append("ou.FInvalidDate,\n").append("ou.FIsFreeze,\n").append("ou.FIsCompanyOrgUnit,\n").append("ou.FIsAdminOrgUnit,\n").append("ou.FIsSaleOrgUnit,\n").append("ou.FIsPurchaseOrgUnit,\n").append("ou.FIsStorageOrgUnit,\n").append("ou.FIsProfitOrgUnit,\n").append("ou.FIsCostOrgUnit,\n").append("ou.FIsCU,\n").append("ou.FIsUnion,\n").append("ou.FIsHROrgUnit,\n").append("ou.FCreatorID,\n").append("ou.FCreateTime,\n").append("ou.FLastUpdateUserID,\n").append("ou.FLastUpdateTime,\n").append("adm.FControlUnitID,\n").append("stru.FIsLeaf,\n").append("stru.FLevel,\n").append("stru.FLongNumber,\n").append("stru1.FUnitId AS FParentID,\n").append("adm.FIsEntity,\n").append("adm.FIsVirtual,\n").append("adm.FPhoneNumber,\n").append("adm.FLayerID,\n").append("adm.FResponPositionID,\n").append("adm.FAddressID,\n").append("adm.FAreaID,\n").append("adm.FPrincipalID,\n").append("adm.FLayerTypeID,\n").append("adm.FBaseDuty_L1,\n").append("adm.FBaseDuty_L2,\n").append("adm.FBaseDuty_L3,\n").append("adm.FIndex,\n").append("adm.FJobSystemID,\n").append("adm.FAdminAddress_L1,\n").append("adm.FAdminAddress_L2,\n").append("adm.FAdminAddress_L3,\n").append("adm.FZipCode,\n").append("adm.FFax,\n").append("adm.FIsSealUp,\n").append("ou.FIsStart,\n").append("ou.FIsOUSealUp,\n").append("stru.FDisplayName_L1,\n").append("stru.FDisplayName_L2,\n").append("stru.FDisplayName_L3,\n").append("adm.FPropertySealUpDate,\n").append("ou.FVersionNumber,\n").append("ou.FCode,\n").append("ou.FIsTransportOrgUnit,\n").append("ou.FIsQualityOrgUnit,\n").append("adm.FIndustryID,\n").append("stru.FSortCode,\n").append("adm.FEconomicType,\n").append("adm.FRegisteredCapital,\n").append("adm.FRegisteredCode,\n").append("adm.FSetupDate,\n").append("adm.FEndupDate,\n").append("adm.FTaxNumber,\n").append("adm.FOrgCode,\n").append("adm.FIsChurchyard,\n").append("adm.FJuridicalPersonID,\n").append("adm.FIsJuridicalCompany,\n").append("adm.FIsIndependence,\n").append("ou.forgTypeStr,\n").append("adm.FTerritory_L1,\n").append("adm.FTerritory_L2,\n").append("adm.FTerritory_L3,\n").append("adm.FDelegateHRID,\n").append("adm.FRegistTypeID,\n").append("adm.FOrgPropertyID,\n").append("adm.FEFFDT,\n").append("adm.FLEFFDT,\n").append("adm.FOrgFunctionID,\n").append("adm.FReserveFieldFirst,\n").append("adm.FReserveFieldSecond,\n").append("adm.FReserveItemFirstID,\n").append("adm.FReserveItemSecond,\n").append("adm.FHistoryRelateID,\n").append("adm.fisstartshr,\n").append("adm.FCompanyID,\n").append("adm.FDepartmentID,\n").append("adm.FOfficeID,\n").append("adm.FLevelOneGroupID,\n").append("adm.FLevelTwoGroupID,\n").append("adm.FLevelFourGroupID,\n").append("adm.FLevelFiveGroupID,\n").append("adm.FLevelSixGroupID \n").append("FROM T_ORG_BaseUnit ou INNER JOIN\n").append("T_ORG_Structure stru ON ou.FID = stru.FUnitId LEFT OUTER JOIN\n").append("T_ORG_Structure stru1 ON stru.FParentID = stru1.FID INNER JOIN\n").append("T_ORG_OUPartAdmin adm ON ou.FID = adm.FUnitID\n").append("WHERE (stru.FTreeId = '00000000-0000-0000-0000-0000000000034F2827FD')\n");
        return new String[]{"delete from T_ORG_Admin", sb.toString()};
    }

    public boolean valideOrg(IObjectValue orgValue, BizOrgQueryParam queryParam) {
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)orgValue;
        if (queryParam == null) {
            return !adminInfo.isIsSealUp();
        }
        if ("ALL".equals(queryParam.getOrgOUSealType())) {
            return true;
        }
        if ("FALSE".equals(queryParam.getOrgOUSealType())) {
            return !adminInfo.isIsSealUp();
        }
        if ("TRUE".equals(queryParam.getOrgOUSealType())) {
            return adminInfo.isIsSealUp();
        }
        return true;
    }

    public OrgTypeSelfInfo getOrgTypeSelfInfo() {
        OrgTypeSelfInfo orgInfo = new OrgTypeSelfInfo();
        orgInfo.setTableName("t_org_oupartadmin");
        orgInfo.setTableNameAlias("ptadmin");
        orgInfo.setViewTableName("t_org_admin");
        orgInfo.setViewTableAlias("admin");
        orgInfo.setTableNameHis("t_org_oupartadmin_his");
        orgInfo.setViewTableNameHis("t_org_admin_his");
        orgInfo.setIOrgQueryInfo((IOrgQueryInfo)new QueryAdminInfo());
        orgInfo.setOuPartInfo((OUPartCoreBaseInfo)new OUPartAdminInfo());
        orgInfo.setOrgUnitViewInfo((OrgUnitInfo)new AdminOrgUnitInfo());
        orgInfo.setOrgViewBosType(new AdminOrgUnitInfo().getBOSType());
        orgInfo.setOrgTableBosType(new OUPartAdminInfo().getBOSType());
        orgInfo.setOrgType(OrgType.Admin);
        return orgInfo;
    }

    public String getSqlQueryOrgInfoByBizUnit(BizOrgQueryParam queryParam) {
        StringBuffer sourceSql = new StringBuffer("");
        int isBizUnit = -1;
        if ("TRUE".equals(queryParam.getIsVirtual())) {
            isBizUnit = 1;
        } else if ("FALSE".equals(queryParam.getIsVirtual())) {
            isBizUnit = 0;
        }
        if (isBizUnit != -1) {
            if (sourceSql.toString().indexOf("where") == -1) {
                sourceSql.append(" where fisvirtual =").append(isBizUnit);
            } else {
                sourceSql.append(" and fisvirtual =").append(isBizUnit);
            }
        }
        return sourceSql.toString();
    }

    protected OrgUnitInfo _getAdminOrgUnitVersionInfo(Context ctx, String versionNumber, BOSUuid id) throws BOSException, EASBizException {
        return this.getUnitVersionInfo(ctx, new VersionPK(versionNumber, id));
    }

    protected OrgUnitCollection _getAdminOrgUnitVersionCollection(Context ctx, String versionNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Admin_His WHERE FVersionNumber = '").append(versionNumber).append("'").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    protected OUPartAdminCollection _getOUPartAdminVersionCollection(Context ctx) throws BOSException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartAdmin_His").toString();
        try {
            OUPartAdminCollection partAdminVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            OUPartAdminCollection oUPartAdminCollection = partAdminVersionCol = OrgAppAdminImpl.createOUPartAdminVersionCollection(ctx, (ResultSet)rs);
            return oUPartAdminCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    private static AdminOrgUnitInfo createAdminOrgUnitVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String layerTypeId;
        String principalId;
        String areaId;
        String addressId;
        String responPositionId;
        AdminOrgUnitInfo adminVersionInfo = (AdminOrgUnitInfo)OrgVersionServerUtils.createOrgUnitVersionInfo((Context)ctx, (OrgUnitInfo)new AdminOrgUnitInfo(), (ResultSet)rs);
        String versionNumber = adminVersionInfo.getVersionNumber();
        adminVersionInfo.setIsEntity(rs.getBoolean("FIsEntity"));
        adminVersionInfo.setIsVirtual(rs.getBoolean("FIsVirtual"));
        adminVersionInfo.setPhoneNumber(rs.getString("FPhoneNumber"));
        String unitLayerId = rs.getString("FLayerID");
        if (unitLayerId != null && unitLayerId.trim().length() != 0) {
            OrgUnitLayerInfo unitLayerInfo = new OrgUnitLayerInfo();
            unitLayerInfo.setId(BOSUuid.read((String)unitLayerId));
            adminVersionInfo.setUnitLayer(unitLayerInfo);
        }
        if ((responPositionId = rs.getString("FResponPositionID")) != null && responPositionId.trim().length() != 0) {
            PositionInfo positionInfo = new PositionInfo();
            positionInfo.setId(BOSUuid.read((String)responPositionId));
            adminVersionInfo.setResponPosition(positionInfo);
        }
        if ((addressId = rs.getString("FAddressID")) != null && addressId.trim().length() != 0) {
            AddressInfo addressInfo = new AddressInfo();
            addressInfo.setId(BOSUuid.read((String)addressId));
            adminVersionInfo.setAddress(addressInfo);
        }
        if ((areaId = rs.getString("FAreaID")) != null && areaId.trim().length() != 0) {
            AreaInfo areaInfo = new AreaInfo();
            areaInfo.setId(BOSUuid.read((String)areaId));
            adminVersionInfo.setArea(areaInfo);
        }
        if ((principalId = rs.getString("FPrincipalID")) != null && principalId.trim().length() != 0) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)addressId));
            adminVersionInfo.setPrincipal(personInfo);
        }
        if ((layerTypeId = rs.getString("FLayerTypeID")) != null && layerTypeId.trim().length() != 0) {
            OrgUnitLayerTypeInfo layerTypeInfo = new OrgUnitLayerTypeInfo();
            layerTypeInfo.setId(BOSUuid.read((String)layerTypeId));
            adminVersionInfo.setUnitLayerType(layerTypeInfo);
        }
        LanguageCollection lc = OrgVersionServerUtils.getLanguageCollection((Context)ctx);
        String strBaseDuty = "FBaseDuty_";
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo langInfo = lc.get(i);
            String baseDuty = strBaseDuty + langInfo.getPostfix();
            adminVersionInfo.setBaseDuty(rs.getString(baseDuty), langInfo.getLocale());
        }
        String jobSystemId = rs.getString("FJobSystemID");
        if (jobSystemId != null && jobSystemId.trim().length() != 0) {
            JobSystemInfo jobSystemInfo = new JobSystemInfo();
            jobSystemInfo.setId(BOSUuid.read((String)jobSystemId));
            adminVersionInfo.setJobSystem(jobSystemInfo);
        }
        adminVersionInfo.setIndex(rs.getInt("FIndex"));
        String parentId = rs.getString("FParentID");
        if (parentId != null && parentId.trim().length() != 0) {
            AdminOrgUnitInfo parentVersionInfo = new AdminOrgUnitInfo();
            parentVersionInfo.setVersionNumber(versionNumber);
            parentVersionInfo.setId(BOSUuid.read((String)parentId));
            adminVersionInfo.setParent(parentVersionInfo);
        }
        String strAdminAddress = "FAdminAddress_";
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo langInfo = lc.get(i);
            String adminAddress = strAdminAddress + langInfo.getPostfix();
            adminVersionInfo.setAdminAddress(rs.getString(adminAddress), langInfo.getLocale());
        }
        adminVersionInfo.setZipCode(rs.getString("FZipCode"));
        adminVersionInfo.setOrgCode(rs.getString("FOrgCode"));
        adminVersionInfo.setFax(rs.getString("FFax"));
        adminVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        adminVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return adminVersionInfo;
    }

    public static OrgUnitCollection createAdminOrgUnitVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OrgUnitCollection adminVersionCol = new OrgUnitCollection();
        while (rs.next()) {
            AdminOrgUnitInfo adminVersionInfo = OrgAppAdminImpl.createAdminOrgUnitVersionInfo(ctx, rs);
            adminVersionCol.add((OrgUnitInfo)adminVersionInfo);
        }
        return adminVersionCol;
    }

    public static OUPartAdminCollection createOUPartAdminVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OUPartAdminCollection partAdminVersionCol = new OUPartAdminCollection();
        while (rs.next()) {
            OUPartAdminInfo partAdminVersionInfo = OrgAppAdminImpl.createOUPartAdminVersionInfo(ctx, rs);
            partAdminVersionCol.add(partAdminVersionInfo);
        }
        return partAdminVersionCol;
    }

    private static OUPartAdminInfo createOUPartAdminVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String layerTypeId;
        String principalId;
        String industryID;
        String areaId;
        String addressId;
        String responPositionId;
        String versionNumber = rs.getString("FVersionNumber");
        String id = rs.getString("FID");
        OUPartAdminInfo partAdminVersionInfo = new OUPartAdminInfo(versionNumber, BOSUuid.read((String)id));
        String unitId = rs.getString("FUnitID");
        if (unitId != null && unitId.trim().length() != 0) {
            FullOrgUnitInfo fullVersionInfo = new FullOrgUnitInfo(versionNumber, BOSUuid.read((String)unitId));
            partAdminVersionInfo.setUnit(fullVersionInfo);
        }
        partAdminVersionInfo.setIsEntity(rs.getBoolean("FIsEntity"));
        partAdminVersionInfo.setIsVirtual(rs.getBoolean("FIsVirtual"));
        partAdminVersionInfo.setPhoneNumber(rs.getString("FPhoneNumber"));
        String unitLayerId = rs.getString("FLayerID");
        if (unitLayerId != null && unitLayerId.trim().length() != 0) {
            partAdminVersionInfo.setUnitLayer((OrgUnitLayerInfo)OrgHelper.getVO((Context)ctx, (String)unitLayerId));
        }
        if ((responPositionId = rs.getString("FResponPositionID")) != null && responPositionId.trim().length() != 0) {
            partAdminVersionInfo.setResponPosition((PositionInfo)OrgHelper.getVO((Context)ctx, (String)responPositionId));
        }
        if ((addressId = rs.getString("FAddressID")) != null && addressId.trim().length() != 0) {
            AddressInfo addressInfo = new AddressInfo();
            addressInfo.setId(BOSUuid.read((String)addressId));
            partAdminVersionInfo.setAddress((AddressInfo)OrgHelper.getVO((Context)ctx, (String)addressId));
        }
        if ((areaId = rs.getString("FAreaID")) != null && areaId.trim().length() != 0) {
            AreaInfo areaInfo = new AreaInfo();
            areaInfo.setId(BOSUuid.read((String)areaId));
            partAdminVersionInfo.setArea((AreaInfo)OrgHelper.getVO((Context)ctx, (String)areaId));
        }
        if ((industryID = rs.getString("FIndustryID")) != null && industryID.trim().length() != 0) {
            partAdminVersionInfo.setIndustry((IndustryInfo)OrgHelper.getVO((Context)ctx, (String)industryID));
        }
        if ((principalId = rs.getString("FPrincipalID")) != null && principalId.trim().length() != 0) {
            partAdminVersionInfo.setPrincipal((PersonInfo)OrgHelper.getVO((Context)ctx, (String)principalId));
        }
        if ((layerTypeId = rs.getString("FLayerTypeID")) != null && layerTypeId.trim().length() != 0) {
            partAdminVersionInfo.setUnitLayerType((OrgUnitLayerTypeInfo)OrgHelper.getVO((Context)ctx, (String)layerTypeId));
        }
        LanguageCollection lc = OrgVersionServerUtils.getLanguageCollection((Context)ctx);
        String strBaseDuty = "FBaseDuty_";
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo langInfo = lc.get(i);
            String baseDuty = strBaseDuty + langInfo.getPostfix();
            partAdminVersionInfo.setBaseDuty(rs.getString(baseDuty), langInfo.getLocale());
        }
        String jobSystemId = rs.getString("FJobSystemID");
        if (jobSystemId != null && jobSystemId.trim().length() != 0) {
            partAdminVersionInfo.setJobSystem((JobSystemInfo)OrgHelper.getVO((Context)ctx, (String)jobSystemId));
        }
        partAdminVersionInfo.setIndex(rs.getInt("FIndex"));
        String strAdminAddress = "FAdminAddress_";
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo langInfo = lc.get(i);
            String adminAddress = strAdminAddress + langInfo.getPostfix();
            partAdminVersionInfo.setAdminAddress(rs.getString(adminAddress), langInfo.getLocale());
        }
        partAdminVersionInfo.setZipCode(rs.getString("FZipCode"));
        partAdminVersionInfo.setOrgCode(rs.getString("FOrgCode"));
        partAdminVersionInfo.setFax(rs.getString("FFax"));
        partAdminVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        partAdminVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return partAdminVersionInfo;
    }

    public List getInsertHisDataSql() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("INSERT INTO T_ORG_OUPartAdmin_His(FID,FUnitID,FIsEntity,FIsVirtual,FLayerID,FLayerTypeID,FPhoneNumber,FResponPositionID,FAddressID,FAreaID,FIndustryID,FPrincipalID,FBaseDuty_L1,FBaseDuty_L2,FBaseDuty_L3,FJobSystemID,FIndex,FAdminAddress_L1,FAdminAddress_L2,FAdminAddress_L3,FZipCode,FOrgCode,FFax,FIsSealUp, FPropertySealUpDate,FVersionNumber) SELECT FID,FUnitID,FIsEntity,FIsVirtual,FLayerID,FLayerTypeID,FPhoneNumber,FResponPositionID,FAddressID,FAreaID,FIndustryID,FPrincipalID,FBaseDuty_L1,FBaseDuty_L2,FBaseDuty_L3,FJobSystemID,FIndex,FAdminAddress_L1,FAdminAddress_L2,FAdminAddress_L3,FZipCode,FOrgCode,FFax,FIsSealUp, FPropertySealUpDate,FVersionNumber FROM T_ORG_OUPartAdmin");
        retList.add("INSERT INTO T_ORG_Admin_His(FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FIsEntity, FIsVirtual, FPhoneNumber, FLayerID, FResponPositionID, FAddressID,FAreaID, FIndustryID, FPrincipalID, FLayerTypeID, FBaseDuty_L1, FBaseDuty_L2, FBaseDuty_L3, FIndex, FJobSystemID, FAdminAddress_L1, FAdminAddress_L2, FAdminAddress_L3, FZipCode, FOrgCode, FFax, FIsSealUp, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr) SELECT FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FIsEntity, FIsVirtual, FPhoneNumber, FLayerID, FResponPositionID, FAddressID,FAreaID, FIndustryID, FPrincipalID, FLayerTypeID, FBaseDuty_L1, FBaseDuty_L2, FBaseDuty_L3, FIndex, FJobSystemID, FAdminAddress_L1, FAdminAddress_L2, FAdminAddress_L3, FZipCode, FOrgCode, FFax, FIsSealUp, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr FROM T_ORG_Admin");
        return retList;
    }

    public List getOrgVersioningUpdateStmts(String inValidateStr, String versionNumber) {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add(new StringBuffer().append("UPDATE T_ORG_Admin_His SET FInvalidDate = {ts'").append(inValidateStr).append("'}").append(" WHERE FVersionNumber = '").append(versionNumber).append("'").toString());
        return retList;
    }

    public OrgUnitInfo createOrgUnitVersionInfo(String versionNumber, String id) {
        return new AdminOrgUnitInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadSuperiorHisOrgUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
        if (fullVersionInfo.isIsAdminOrgUnit()) {
            AdminOrgUnitInfo adminVersionInfo = (AdminOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(fullVersionInfo.getVersionNumber(), fullVersionInfo.getId()));
            if (adminVersionInfo == null) {
                throw new OUException(OUException.NONE_ADMIN_SUPERIOR);
            }
            AdminOrgUnitInfo parentAdmin = adminVersionInfo.getParent();
            pdInfo.setParentOrg(OrgType.Admin, (OrgUnitInfo)((AdminOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(parentAdmin.getVersionNumber(), parentAdmin.getId()))));
        }
    }

    public CoreBaseInfo createOUPartOrgUnitVersionInfo(String versionNumber, String id) {
        return new OUPartAdminInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadOUPartVersion(Context ctx, FullOrgUnitInfo fullVersionInfo, ResultSet rs) throws BOSException, EASBizException, SQLException {
        String versionNumber = fullVersionInfo.getVersionNumber();
        String partAdminId = rs.getString("FPartAdminID");
        if (partAdminId != null && partAdminId.trim().length() != 0) {
            OUPartAdminInfo partAdminVersionInfo = new OUPartAdminInfo(versionNumber, BOSUuid.read((String)partAdminId));
            fullVersionInfo.setPartAdmin(partAdminVersionInfo);
        }
    }

    public OrgUnitInfo getUnitVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Admin_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OrgUnitInfo orgUnitInfo = null;
                return orgUnitInfo;
            }
            AdminOrgUnitInfo adminVersionInfo = OrgAppAdminImpl.createAdminOrgUnitVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with pk: " + pk);
            }
            AdminOrgUnitInfo adminOrgUnitInfo = adminVersionInfo;
            return adminOrgUnitInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, String versionNumber, String longNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        if (longNumber == null || longNumber.trim().length() == 0) {
            throw new BOSException("longNumber can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Admin_His WHERE FVersionNumber = '").append(versionNumber).append("'").append(" AND (FLongNumber = '").append(longNumber).append("'").append(" OR FLongNumber LIKE '").append(longNumber + "!%").append("')").append(" ORDER BY FLongNumber").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    private OrgUnitCollection getOrgUnitVersionCollectionBySql(Context ctx, String sql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            OrgUnitCollection adminVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            OrgUnitCollection orgUnitCollection = adminVersionCol = OrgAppAdminImpl.createAdminOrgUnitVersionCollection(ctx, (ResultSet)rs);
            return orgUnitCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public void updateStructure(Context ctx, FullOrgUnitInfo unit, boolean isUpdate) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance((Context)ctx);
        IOUPartAdmin iAdminExt = OUPartAdminFactory.getLocalInstance(ctx);
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance(ctx);
        BizParentAndDelegateInfo pdInfo = (BizParentAndDelegateInfo)unit.get("PDValueInfo");
        if (unit.isIsAdminOrgUnit()) {
            AdminOrgUnitInfo parentUnit = (AdminOrgUnitInfo)pdInfo.getParentOrg(OrgType.Admin);
            if (parentUnit == null && !unit.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                Object[] params = new String[]{OrgType.Admin.getAlias()};
                throw new OUException(OUException.MUST_INPUT_SUPERIOR, params);
            }
            OrgStructureInfo parentStructInfo = null;
            if (!unit.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                parentStructInfo = iStruct.getOrgStructureInfo("Select *, unit.number, unit.name Where unit.id = '" + parentUnit.getId().toString() + "' and tree.id = '" + "00000000-0000-0000-0000-0000000000034F2827FD" + "'");
            }
            OrgTreeInfo treeInfo = new OrgTreeInfo();
            treeInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000034F2827FD"));
            if (!isUpdate) {
                if (!unit.getPartAdmin().isIsVirtual() && parentUnit != null && parentUnit.isIsVirtual()) {
                    throw new OUException(OUException.CANT_ADD_NOT_VIRTUAL);
                }
                OrgStructureInfo structInfo = new OrgStructureInfo();
                structInfo.setUnit(unit);
                structInfo.setParent(parentStructInfo);
                structInfo.setTree(treeInfo);
                structInfo.setIsValid(true);
                iStruct.addnew((CoreBaseInfo)structInfo);
            } else if (!iStruct.exists("Select id Where unit.id = '" + unit.getId().toString() + "' and tree.id = '" + "00000000-0000-0000-0000-0000000000034F2827FD" + "'")) {
                OrgStructureInfo structInfo = new OrgStructureInfo();
                structInfo.setUnit(unit);
                structInfo.setParent(parentStructInfo);
                structInfo.setTree(treeInfo);
                structInfo.setIsValid(true);
                iStruct.addnew((CoreBaseInfo)structInfo);
            } else {
                OrgStructureInfo structInfo = iStruct.getOrgStructureInfo("Select *, unit.id, unit.isAdminOrgUnit, unit.number, unit.name Where unit.id = '" + unit.getId().toString() + "' and tree.id = '" + "00000000-0000-0000-0000-0000000000034F2827FD" + "'");
                if (!unit.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4") && OrgAppHelper.existBizSuperiorLoop((Context)ctx, (OrgStructureInfo)structInfo, (OrgStructureInfo)parentStructInfo)) {
                    Object[] params = new String[]{OrgType.Admin.getAlias()};
                    throw new OUException(OUException.ORG_SUPERIOR_LOOP, params);
                }
                if (unit.getPartAdmin().isIsVirtual()) {
                    if (!structInfo.isIsLeaf() && iAdminOrgUnit.exists("select id where longNumber like '" + structInfo.getLongNumber() + "!%'  and isVirtual = 0")) {
                        throw new OUException(OUException.CANT_UPDATE_VIRTUAL);
                    }
                } else if (structInfo.getParent() != null && iAdminExt.exists("select id where id = '" + structInfo.getParent().getId().toString() + "'  and isVirtual = 1")) {
                    throw new OUException(OUException.CANT_UPDATE_NOT_VIRTUAL);
                }
                structInfo.setParent(parentStructInfo);
                structInfo.setIsValid(true);
                ObjectUuidPK pk = new ObjectUuidPK(structInfo.getId());
                iStruct.update((IObjectPK)pk, (CoreBaseInfo)structInfo);
            }
        } else if (isUpdate) {
            Object[] params = new String[]{OrgType.Admin.getAlias()};
            if (OrgAppHelper.isBizChildrenExist((Context)ctx, (FullOrgUnitInfo)unit, (String)"00000000-0000-0000-0000-0000000000034F2827FD")) {
                throw new OUException(OUException.EXISTCHILDREN_NOTDELETE, params);
            }
            if (OrgAppHelper.isCUBizPropertyExistInOU((Context)ctx, (FullOrgUnitInfo)unit, (int)0)) {
                throw new OUException(OUException.EXISTINCU_NOTDELETE, params);
            }
            if (this.isDelegatedByOthers(ctx, unit, 0)) {
                throw new OUException(OUException.DELEGATEDBYOTHERS_NOTDELETE, params);
            }
            if (!unit.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unit.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)"00000000-0000-0000-0000-0000000000034F2827FD", CompareType.EQUALS));
                filter.setMaskString("#0 and #1");
                iStruct.delete(filter);
            } else {
                DbUtil.execute((Context)ctx, (String)"Update T_ORG_Structure set FIsValid = 0 where FUnitID = '00000000-0000-0000-0000-000000000000CCE7AED4' and FTreeID = '00000000-0000-0000-0000-0000000000034F2827FD'");
            }
            this.deleteSelfDelegate(ctx, unit, 0);
        }
    }

    private void deleteSelfDelegate(Context ctx, FullOrgUnitInfo unit, int orgTypeValue) throws BOSException, EASBizException {
        IOrgDelegateFacade iDelegateFacade = OrgDelegateFacadeFactory.getLocalInstance((Context)ctx);
        iDelegateFacade.deleteSelfDelegateOnType(unit.getId().toString(), orgTypeValue);
    }

    public void updateBizParent(Context ctx, String id, String parentId) throws BOSException, EASBizException {
        String oldLongNumber;
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance((Context)ctx);
        OrgStructureInfo structInfo = iStruct.getOrgStructureInfo("Select *, unit.number, unit.name,unit.isCU,unit.partAdmin.id Where unit.id = '" + id + "' and tree.id = '" + "00000000-0000-0000-0000-0000000000034F2827FD" + "'");
        OrgStructureInfo parentStructInfo = iStruct.getOrgStructureInfo("Select *, unit.number, unit.name , unit.partAdmin.id  Where unit.id = '" + parentId + "' and tree.id = '" + "00000000-0000-0000-0000-0000000000034F2827FD" + "'");
        IOUPartAdmin iOuPartAdmin = OUPartAdminFactory.getLocalInstance(ctx);
        String oql = "select * , controlUnit.id where id ='" + structInfo.getUnit().getPartAdmin().getId().toString() + "'";
        OUPartAdminInfo partAdminExtInfo = iOuPartAdmin.getOUPartAdminInfo(oql);
        String parentoql = "select * , controlUnit.id where id ='" + parentStructInfo.getUnit().getPartAdmin().getId().toString() + "'";
        OUPartAdminInfo parentPartAdminExtInfo = iOuPartAdmin.getOUPartAdminInfo(parentoql);
        if (OrgAppHelper.existBizSuperiorLoop((Context)ctx, (OrgStructureInfo)structInfo, (OrgStructureInfo)parentStructInfo)) {
            Object[] params = new String[]{OrgType.Admin.getAlias()};
            throw new OUException(OUException.ORG_SUPERIOR_LOOP, params);
        }
        if (!structInfo.getUnit().isIsCU()) {
            oldLongNumber = structInfo.getLongNumber();
            String oldControlUnitId = partAdminExtInfo.getControlUnit().getId().toString();
            String newControlUnitId = parentPartAdminExtInfo.getControlUnit().getId().toString();
            OrgDBUtils.updateSubOrgCU((Context)ctx, (String)oldLongNumber, (String)oldControlUnitId, (String)newControlUnitId);
        }
        oldLongNumber = structInfo.getLongNumber();
        structInfo.setParent(parentStructInfo);
        structInfo.setIsValid(true);
        ObjectUuidPK pk = new ObjectUuidPK(structInfo.getId());
        iStruct.update((IObjectPK)pk, (CoreBaseInfo)structInfo);
        BOSUuid adminID = null;
        if (structInfo != null && structInfo.getUnit() != null) {
            adminID = structInfo.getUnit().getId();
        }
        this.changeAdminOrgToOrgRange(ctx, adminID, parentStructInfo.getLongNumber() + "!" + structInfo.getUnit().getNumber(), oldLongNumber);
        if (structInfo.isIsLeaf()) {
            this.updateBizDataForAdmin(ctx, id, parentId);
        } else {
            OrgStructureCollection structInfoTemp = iStruct.getOrgStructureCollection("Select unit.id Where ISLEAF = 1 AND LongNumber like '" + structInfo.getLongNumber() + "!%' and tree.id = '" + "00000000-0000-0000-0000-0000000000034F2827FD" + "' ORDER BY LongNumber");
            if (structInfoTemp.size() != 0 && structInfoTemp.get(0).getUnit().getId() != null) {
                this.updateBizDataForAdmin(ctx, structInfoTemp.get(0).getUnit().getId().toString(), parentId);
            }
        }
    }

    private void changeAdminOrgToOrgRange(Context ctx, BOSUuid adminID, String newLongNumber, String oldLongNumber) throws BOSException, EASBizException {
        IOrgRangeIncludeSubOrg oris = OrgRangeIncludeSubOrgFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(adminID);
        adminInfo.setLongNumber(newLongNumber);
        oris.changeAdminOrgToOrgRange(adminInfo, oldLongNumber);
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, IObjectPK cuOrgPK, String versionNumber) throws BOSException, EASBizException {
        String tableName = this.getOrgTypeSelfInfo().getViewTableNameHis();
        String sql = "SELECT FID, FVersionNumber FROM " + tableName + " WHERE " + "FControlUnitID = '" + cuOrgPK + "' and forgTypeStr like '%" + this.getOrgTypeSelfInfo().getOrgType().getName() + "%' FVersionNumber = '" + versionNumber + "'";
        return this.getOrgUnitVersionCollectionBySql(ctx, sql);
    }

    private OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String selectSql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OUPartCoreBaseInfo oUPartCoreBaseInfo = null;
                return oUPartCoreBaseInfo;
            }
            OUPartAdminInfo partAdminVersionInfo = OrgAppAdminImpl.createOUPartAdminVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with sql: " + selectSql);
            }
            OUPartAdminInfo oUPartAdminInfo = partAdminVersionInfo;
            return oUPartAdminInfo;
        }
        catch (Exception e) {
            logger.error((Object)"sqlerror!", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartAdmin_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String version, String orgId) throws BOSException, EASBizException {
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartAdmin_His WHERE ").append("FVersionNumber = '").append(version).append("'").append(" AND FUNITID = '").append(orgId).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public void batchDelOrgInfo(Context ctx, FullOrgUnitCollection unitCol) throws BOSException, EASBizException {
        ArrayList<String> pkList = new ArrayList<String>();
        OrgTypeSelfInfo orgTypeInfo = this.getOrgTypeSelfInfo();
        for (int i = 0; i < unitCol.size(); ++i) {
            FullOrgUnitInfo unitInfo = unitCol.get(i);
            if (!unitInfo.isIsAdminOrgUnit()) {
                return;
            }
            Object[] params = new String[]{OrgType.Admin.getAlias(), OrgType.Admin.getAlias()};
            if (OrgAppHelper.isCUBizPropertyExistInOU((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)0)) {
                throw new OUException(OUException.EXISTINCU_NOTDELETE, params);
            }
            unitInfo.setIsAdminOrgUnit(false);
            pkList.add(unitInfo.getId().toString());
            ObjectStringPK pk = new ObjectStringPK(unitInfo.getId().toString());
            OUPartReference.delAdminOrgUnitReferencedByAsstActTypeDefault((Context)ctx, (String)pk.toString());
            IOUPartAdmin iAdmin = OUPartAdminFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iAdmin.delete(filter);
            unitInfo.setPartAdmin(null);
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
            orgTypeHelper.removeOrgType(OrgType.Admin);
            unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        }
        if (pkList.size() > 0) {
            OUPartReference.delReferenced((Context)ctx, (String)"BCA8D47D", pkList, (String)orgTypeInfo.getTableName());
            OUPartReference.delReferenced((Context)ctx, (String)"6A6435BE", pkList, (String)orgTypeInfo.getViewTableName());
        }
    }

    private boolean isDelegatedByOthers(Context ctx, FullOrgUnitInfo unit, int orgTypeValue) throws BOSException, EASBizException {
        IOrgDelegateFacade iDelegateFacade = OrgDelegateFacadeFactory.getLocalInstance((Context)ctx);
        return iDelegateFacade.isDelegatedByOthers(unit.getId().toString(), orgTypeValue);
    }

    public String getUpdateViewCUSql() {
        StringBuffer update = new StringBuffer(200);
        String viewTableName = this.getOrgTypeSelfInfo().getViewTableName();
        update.append("UPDATE ").append(viewTableName).append(" A SET FCONTROLUNITID=(SELECT FCONTROLUNITID FROM T_ORG_OUPARTADMIN ").append(" WHERE FUNITID=A.FID)");
        return update.toString();
    }

    private void updateBizDataForAdmin(Context ctx, String id, String parentId) throws BOSException {
        BizDataCheckInfo[] checkInfos = FullOrgUnitFactory.getLocalInstance((Context)ctx).hasBizRefrenceForAdmin(parentId);
        boolean isReference = false;
        for (int i = 0; i < checkInfos.length; ++i) {
            if (checkInfos[i] == null || !checkInfos[i].isRef()) continue;
            isReference = true;
        }
        if (isReference) {
            FullOrgUnitFactory.getLocalInstance((Context)ctx).updateBizDataForAdmin(id, parentId);
        }
    }
}

