/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper.orgtypeimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOUPartHR;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OUPartHRCollection;
import com.kingdee.eas.basedata.org.OUPartHRFactory;
import com.kingdee.eas.basedata.org.OUPartHRInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.app.OUPartReference;
import com.kingdee.eas.basedata.org.app.OrgVersionServerUtils;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgDBHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.AbstractDefaultOrgTypeImpl;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgAppHrImpl
extends AbstractDefaultOrgTypeImpl
implements IOrgAppHelper {
    private static Logger logger = Logger.getLogger((String)OrgAppHrImpl.class.getName());

    private boolean isHROBizUnitChanged(Context ctx, OUPartHRInfo newInfo) throws BOSException, EASBizException {
        if (newInfo.getId() == null) {
            return false;
        }
        IOUPartHR iPartHR = OUPartHRFactory.getLocalInstance(ctx);
        OUPartHRInfo oldInfo = iPartHR.getOUPartHRInfo((IObjectPK)new ObjectUuidPK(newInfo.getId()));
        return oldInfo.isIsBizUnit() ^ newInfo.isIsBizUnit();
    }

    public void updateOrgInfo(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo, String versionNumber, boolean isOrgStart) throws BOSException, EASBizException {
        if (unitInfo.get("hrOrgNotChanged") != null) {
            return;
        }
        if (unitInfo.isIsHROrgUnit()) {
            OUPartHRInfo partHRInfo = unitInfo.getPartHR();
            IHROrgUnit iHROrgUnit = HROrgUnitFactory.getLocalInstance(ctx);
            boolean bl = iHROrgUnit.isShowOrgFunction();
            if (bl && this.isHROBizUnitChanged(ctx, partHRInfo)) {
                if (partHRInfo.isIsBizUnit()) {
                    INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
                    if (iNOV.isBizChildrenExist(unitInfo, "00000000-0000-0000-0000-0000000000104F2827FD")) {
                        throw new OUException(OUException.HRO_BIZUNIT_CHILDREN);
                    }
                } else {
                    boolean isDelegatedByOthers = OrgDBHelper.isDelegatedByOthers((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)16);
                    if (isDelegatedByOthers) {
                        throw new OUException(OUException.HRO_BIZUNIT_DELEGATED);
                    }
                }
            }
            partHRInfo.setUnit(unitInfo);
            IOUPartHR iPartHR = OUPartHRFactory.getLocalInstance(ctx);
            if (iPartHR.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                if (partHRInfo.getId() == null) {
                    BOSUuid partID = iPartHR.getOUPartHRInfo("Select id Where unit.id = '" + pk.toString() + "'").getId();
                    partHRInfo.setId(partID);
                }
                iPartHR.update((IObjectPK)new ObjectUuidPK(partHRInfo.getId()), partHRInfo);
            } else {
                if (!unitInfo.isIsCU() && !currentCUInfo.isIsHROrgUnit()) {
                    Object[] param = new String[]{OrgType.HRO.getAlias(), OrgType.HRO.getAlias()};
                    throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
                }
                partHRInfo.setVersionNumber(versionNumber);
                iPartHR.addnew(partHRInfo);
                unitInfo.setPartHR(partHRInfo);
            }
        } else {
            IOUPartHR iPartHR = OUPartHRFactory.getLocalInstance(ctx);
            if (iPartHR.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                OUPartReference.isReferenced((Context)ctx, (String)new OUPartHRInfo().getBOSType().toString(), (String)pk.toString());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
                iPartHR.delete(filter);
            }
            unitInfo.setPartHR(null);
        }
    }

    public void addNewInfo(Context ctx, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo) throws BOSException, EASBizException {
        if (unitInfo.isIsHROrgUnit()) {
            if (!unitInfo.isIsCU() && !currentCUInfo.isIsHROrgUnit()) {
                Object[] param = new String[]{OrgType.HRO.getAlias(), OrgType.HRO.getAlias()};
                throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
            }
            OUPartHRInfo ouHRInfo = unitInfo.getPartHR();
            ouHRInfo.setUnit(unitInfo);
            ouHRInfo.setVersionNumber(unitInfo.getVersionNumber());
            IOUPartHR iHR = OUPartHRFactory.getLocalInstance(ctx);
            IObjectPK newPK = iHR.addnew(ouHRInfo);
            unitInfo.setPartHR(ouHRInfo);
        }
    }

    public void delOrgInfo(Context ctx, FullOrgUnitInfo deleteInfo) throws BOSException, EASBizException {
        if (deleteInfo.isIsHROrgUnit()) {
            ObjectStringPK pk = new ObjectStringPK(deleteInfo.getId().toString());
            OUPartReference.isReferenced((Context)ctx, (String)"714011A8", (String)pk.toString());
            OUPartReference.isReferenced((Context)ctx, (String)"58B332D9", (String)pk.toString());
            IOUPartHR iHR = OUPartHRFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iHR.delete(filter);
        }
    }

    public String[] getRebuildSql() {
        StringBuffer sb = new StringBuffer(800);
        sb.append("insert into T_ORG_HRO (\n").append("FID,\n").append("FName_L1,\n").append("FName_L2,\n").append("FName_L3,\n").append("FNumber,\n").append("FDescription_L1,\n").append("FDescription_L2,\n").append("FDescription_L3,\n").append("FSimpleName,\n").append("FIsGrouping,\n").append("FEffectDate,\n").append("FInvalidDate,\n").append("FIsFreeze,\n").append("FIsCompanyOrgUnit,\n").append("FIsAdminOrgUnit,\n").append("FIsSaleOrgUnit,\n").append("FIsPurchaseOrgUnit,\n").append("FIsStorageOrgUnit,\n").append("FIsProfitOrgUnit,\n").append("FIsCostOrgUnit,\n").append("FIsCU,\n").append("FIsUnion,\n").append("FIsHROrgUnit,\n").append("FCreatorID,\n").append("FCreateTime,\n").append("FLastUpdateUserID,\n").append("FLastUpdateTime,\n").append("FControlUnitID,\n").append("FParentID,\n").append("FIsLeaf,\n").append("FLevel,\n").append("FLongNumber,\n").append("FIsBizUnit,\n").append("FIsSealUp ,\n").append("FIsStart,\n").append("FIsOUSealUp,\n").append("FDisplayName_L1,\n").append("FDisplayName_L2,\n").append("FDisplayName_L3,\n").append("FPropertySealUpDate,\n").append("FVersionNumber,\n").append("FCode,\n").append("FIsTransportOrgUnit,\n").append("forgTypeStr,\n").append("FIsQualityOrgUnit)\n").append("SELECT\n").append("ou.FID,\n").append("ou.FName_L1,\n").append("ou.FName_L2,\n").append("ou.FName_L3,\n").append("ou.FNumber,\n").append("ou.FDescription_L1,\n").append("ou.FDescription_L2,\n").append("ou.FDescription_L3,\n").append("ou.FSimpleName,\n").append("ou.FIsGrouping,\n").append("ou.FEffectDate,\n").append("ou.FInvalidDate,\n").append("ou.FIsFreeze,\n").append("ou.FIsCompanyOrgUnit,\n").append("ou.FIsAdminOrgUnit,\n").append("ou.FIsSaleOrgUnit,\n").append("ou.FIsPurchaseOrgUnit,\n").append("ou.FIsStorageOrgUnit,\n").append("ou.FIsProfitOrgUnit,\n").append("ou.FIsCostOrgUnit,\n").append("ou.FIsCU,\n").append("ou.FIsUnion,\n").append("ou.FIsHROrgUnit,\n").append("ou.FCreatorID,\n").append("ou.FCreateTime,\n").append("ou.FLastUpdateUserID,\n").append("ou.FLastUpdateTime,\n").append("ou.FControlUnitID,\n").append("stru1.FUnitId AS FParentID,\n").append("stru.FIsLeaf,\n").append("stru.FLevel,\n").append("stru.FLongNumber,\n").append("hr.FIsBizUnit,\n").append("hr.FIsSealUp ,\n").append("ou.FIsStart,\n").append("ou.FIsOUSealUp,\n").append("stru.FDisplayName_L1,\n").append("stru.FDisplayName_L2,\n").append("stru.FDisplayName_L3,\n").append("hr.FPropertySealUpDate,\n").append("ou.FVersionNumber,\n").append("ou.FCode,\n").append("ou.FIsTransportOrgUnit,\n").append("ou.forgTypeStr,\n").append("ou.FIsQualityOrgUnit\n").append("FROM T_ORG_BaseUnit ou INNER JOIN\n").append("T_ORG_Structure stru ON ou.FID = stru.FUnitId LEFT OUTER JOIN\n").append("T_ORG_Structure stru1 ON stru.FParentID = stru1.FID INNER JOIN\n").append("T_ORG_OUPartHR hr ON ou.FID = hr.FUnitID\n").append("WHERE (stru.FTreeId = '00000000-0000-0000-0000-0000000000104F2827FD')\n");
        return new String[]{"delete from T_ORG_HRO", sb.toString()};
    }

    boolean valideOrg(IObjectValue orgValue) {
        HROrgUnitInfo hrInfo = (HROrgUnitInfo)orgValue;
        return !hrInfo.isIsSealUp() && hrInfo.isIsBizUnit();
    }

    public OrgTypeSelfInfo getOrgTypeSelfInfo() {
        OrgTypeSelfInfo orgInfo = new OrgTypeSelfInfo();
        orgInfo.setTableName("T_ORG_OUPartHR");
        orgInfo.setTableNameAlias("PartHR");
        orgInfo.setViewTableName("T_ORG_HRO");
        orgInfo.setViewTableAlias("HRO");
        orgInfo.setTableNameHis("T_ORG_OUPartHR_his");
        orgInfo.setViewTableNameHis("T_ORG_HRO_his");
        orgInfo.setOrgViewBosType(new HROrgUnitInfo().getBOSType());
        orgInfo.setOrgTableBosType(new OUPartHRInfo().getBOSType());
        orgInfo.setOuPartInfo((OUPartCoreBaseInfo)new OUPartHRInfo());
        orgInfo.setOrgUnitViewInfo((OrgUnitInfo)new HROrgUnitInfo());
        orgInfo.setOrgType(OrgType.HRO);
        return orgInfo;
    }

    protected OrgUnitCollection _getHROrgUnitVersionCollection(Context ctx, String versionNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_HRO_His WHERE FVersionNumber = '").append(versionNumber).append("'").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    protected OrgUnitCollection _getHROrgUnitVersionCollection(Context ctx, String versionNumber, String longNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        if (longNumber == null || longNumber.trim().length() == 0) {
            throw new BOSException("longNumber can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_HRO_His WHERE FVersionNumber = '").append(versionNumber).append("'").append(" AND (FLongNumber = '").append(longNumber).append("'").append(" OR FLongNumber LIKE '").append(longNumber + "!%").append("')").append(" ORDER BY FLongNumber").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    protected OUPartHRCollection _getOUPartHRVersionCollection(Context ctx) throws BOSException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartHR_His").toString();
        try {
            OUPartHRCollection partHRVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            OUPartHRCollection oUPartHRCollection = partHRVersionCol = OrgAppHrImpl.createOUPartHRVersionCollection(ctx, (ResultSet)rs);
            return oUPartHRCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public static OUPartHRCollection createOUPartHRVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OUPartHRCollection partHRVersionCol = new OUPartHRCollection();
        while (rs.next()) {
            OUPartHRInfo partHRVersionInfo = OrgAppHrImpl.createOUPartHRVersionInfo(ctx, rs);
            partHRVersionCol.add(partHRVersionInfo);
        }
        return partHRVersionCol;
    }

    public static OUPartHRInfo createOUPartHRVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String versionNumber = rs.getString("FVersionNumber");
        String id = rs.getString("FID");
        OUPartHRInfo partHRVersionInfo = new OUPartHRInfo(versionNumber, BOSUuid.read((String)id));
        String unitId = rs.getString("FUnitID");
        if (unitId != null && unitId.trim().length() != 0) {
            FullOrgUnitInfo fullVersionInfo = new FullOrgUnitInfo(versionNumber, BOSUuid.read((String)unitId));
            partHRVersionInfo.setUnit(fullVersionInfo);
        }
        partHRVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        partHRVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        partHRVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return partHRVersionInfo;
    }

    public static HROrgUnitInfo createHROrgUnitVersionInfo(Context ctx, ResultSet rs) throws Exception {
        HROrgUnitInfo hrVersionInfo = (HROrgUnitInfo)OrgVersionServerUtils.createOrgUnitVersionInfo((Context)ctx, (OrgUnitInfo)new HROrgUnitInfo(), (ResultSet)rs);
        String versionNumber = hrVersionInfo.getVersionNumber();
        String parentId = rs.getString("FParentID");
        if (parentId != null && parentId.trim().length() != 0) {
            HROrgUnitInfo parentVersionInfo = new HROrgUnitInfo(versionNumber, BOSUuid.read((String)parentId));
            hrVersionInfo.setParent(parentVersionInfo);
        }
        hrVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        hrVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        hrVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return hrVersionInfo;
    }

    public static OrgUnitCollection createHROrgUnitVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OrgUnitCollection hrVersionCol = new OrgUnitCollection();
        while (rs.next()) {
            HROrgUnitInfo hrVersionInfo = OrgAppHrImpl.createHROrgUnitVersionInfo(ctx, rs);
            hrVersionCol.add((OrgUnitInfo)hrVersionInfo);
        }
        return hrVersionCol;
    }

    public List getInsertHisDataSql() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("INSERT INTO T_ORG_OUPartHR_His(FID,FUnitID,FIsSealUp,FIsBizUnit, FPropertySealUpDate, FVersionNumber) SELECT FID,FUnitID,FIsSealUp,FIsBizUnit, FPropertySealUpDate, FVersionNumber FROM T_ORG_OUPartHR");
        retList.add("INSERT INTO T_ORG_HRO_His(FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FParentID, FIsLeaf, FLevel, FLongNumber, FIsBizUnit, FIsSealUp, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr) SELECT FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FParentID, FIsLeaf, FLevel, FLongNumber, FIsBizUnit, FIsSealUp, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr FROM T_ORG_HRO");
        return retList;
    }

    public List getOrgVersioningUpdateStmts(String inValidateStr, String versionNumber) {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add(new StringBuffer().append("UPDATE T_ORG_HRO_His SET FInvalidDate = {ts'").append(inValidateStr).append("'}").append(" WHERE FVersionNumber = '").append(versionNumber).append("'").toString());
        return retList;
    }

    public OrgUnitInfo createOrgUnitVersionInfo(String versionNumber, String id) {
        return new HROrgUnitInfo(versionNumber, BOSUuid.read((String)id));
    }

    public CoreBaseInfo createOUPartOrgUnitVersionInfo(String versionNumber, String id) {
        return new OUPartHRInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadSuperiorHisOrgUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
        if (fullVersionInfo.isIsHROrgUnit()) {
            HROrgUnitInfo hrVersionInfo = (HROrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(fullVersionInfo.getVersionNumber(), fullVersionInfo.getId()));
            if (hrVersionInfo == null) {
                throw new OUException(OUException.NONE_HR_SUPERIOR);
            }
            HROrgUnitInfo info = hrVersionInfo.getParent();
            pdInfo.setParentOrg(OrgType.HRO, (OrgUnitInfo)((HROrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(info.getVersionNumber(), info.getId()))));
        }
    }

    public void loadOUPartVersion(Context ctx, FullOrgUnitInfo fullVersionInfo, ResultSet rs) throws BOSException, EASBizException, SQLException {
        String versionNumber = fullVersionInfo.getVersionNumber();
        String partHRId = rs.getString("FPartHRID");
        if (partHRId != null && partHRId.trim().length() != 0) {
            OUPartHRInfo partHRVersionInfo = new OUPartHRInfo(versionNumber, BOSUuid.read((String)partHRId));
            fullVersionInfo.setPartHR(partHRVersionInfo);
        }
    }

    public OrgUnitInfo getUnitVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_HRO_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OrgUnitInfo orgUnitInfo = null;
                return orgUnitInfo;
            }
            HROrgUnitInfo hrVersionInfo = OrgAppHrImpl.createHROrgUnitVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with pk: " + pk);
            }
            HROrgUnitInfo hROrgUnitInfo = hrVersionInfo;
            return hROrgUnitInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, String versionNumber, String longNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        if (longNumber == null || longNumber.trim().length() == 0) {
            throw new BOSException("longNumber can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_HRO_His WHERE FVersionNumber = '").append(versionNumber).append("'").append(" AND (FLongNumber = '").append(longNumber).append("'").append(" OR FLongNumber LIKE '").append(longNumber + "!%").append("')").append(" ORDER BY FLongNumber").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    private OrgUnitCollection getOrgUnitVersionCollectionBySql(Context ctx, String sql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            OrgUnitCollection hrVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            OrgUnitCollection orgUnitCollection = hrVersionCol = OrgAppHrImpl.createHROrgUnitVersionCollection(ctx, (ResultSet)rs);
            return orgUnitCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, IObjectPK cuOrgPK, String versionNumber) throws BOSException, EASBizException {
        String tableName = this.getOrgTypeSelfInfo().getViewTableNameHis();
        String sql = "SELECT FID, FVersionNumber FROM " + tableName + " WHERE " + "FControlUnitID = '" + cuOrgPK + "' and forgTypeStr like '%" + this.getOrgTypeSelfInfo().getOrgType().getName() + "%' FVersionNumber = '" + versionNumber + "'";
        return this.getOrgUnitVersionCollectionBySql(ctx, sql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String selectSql) throws BOSException, EASBizException {
        if (selectSql == null) {
            throw new BOSException("selectSql can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OUPartCoreBaseInfo oUPartCoreBaseInfo = null;
                return oUPartCoreBaseInfo;
            }
            OUPartHRInfo partHRVersionInfo = OrgAppHrImpl.createOUPartHRVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with selectSql: " + selectSql);
            }
            OUPartHRInfo oUPartHRInfo = partHRVersionInfo;
            return oUPartHRInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartHR_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String version, String orgId) throws BOSException, EASBizException {
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartHR_His WHERE ").append("FVersionNumber = '").append(version).append("'").append(" AND FUNITID = '").append(orgId).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public void batchDelOrgInfo(Context ctx, FullOrgUnitCollection unitCol) throws BOSException, EASBizException {
        for (int i = 0; i < unitCol.size(); ++i) {
            FullOrgUnitInfo unitInfo = unitCol.get(i);
            if (!unitInfo.isIsHROrgUnit()) {
                return;
            }
            Object[] params = new String[]{OrgType.HRO.getAlias(), OrgType.HRO.getAlias()};
            if (OrgAppHelper.isCUBizPropertyExistInOU((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)16)) {
                throw new OUException(OUException.EXISTINCU_NOTDELETE, params);
            }
            unitInfo.setIsHROrgUnit(false);
            ObjectStringPK pk = new ObjectStringPK(unitInfo.getId().toString());
            OUPartReference.delReferenced((Context)ctx, (String)"714011A8", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getTableName());
            OUPartReference.delReferenced((Context)ctx, (String)"58B332D9", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getViewTableName());
            IOUPartHR iHR = OUPartHRFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iHR.delete(filter);
            unitInfo.setPartHR(null);
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
            orgTypeHelper.removeOrgType(OrgType.HRO);
            unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        }
    }
}

