/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper.orgtypeimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FIAccountRangeFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFIAccountRange;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOUPartProfitCenter;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OUPartProfitCenterCollection;
import com.kingdee.eas.basedata.org.OUPartProfitCenterFactory;
import com.kingdee.eas.basedata.org.OUPartProfitCenterInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.app.OUPartReference;
import com.kingdee.eas.basedata.org.app.OrgVersionServerUtils;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.AbstractDefaultOrgTypeImpl;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgAppProfitImpl
extends AbstractDefaultOrgTypeImpl
implements IOrgAppHelper {
    private static Logger logger = Logger.getLogger((String)OrgAppProfitImpl.class.getName());

    private boolean isProfitBizUnitChanged(Context ctx, OUPartProfitCenterInfo newInfo) throws BOSException, EASBizException {
        if (newInfo.getId() == null) {
            return false;
        }
        IOUPartProfitCenter iPartProfit = OUPartProfitCenterFactory.getLocalInstance(ctx);
        OUPartProfitCenterInfo oldInfo = iPartProfit.getOUPartProfitCenterInfo((IObjectPK)new ObjectUuidPK(newInfo.getId()));
        return oldInfo.isIsBizUnit() ^ newInfo.isIsBizUnit();
    }

    public void updateOrgInfo(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo, String versionNumber, boolean isOrgStart) throws BOSException, EASBizException {
        if (unitInfo.isIsProfitOrgUnit()) {
            IOUPartProfitCenter iPartProfit;
            INewOrgViewFacade iNOV;
            OUPartProfitCenterInfo partProfitInfo = unitInfo.getPartProfitCenter();
            if (this.isProfitBizUnitChanged(ctx, partProfitInfo) && partProfitInfo.isIsBizUnit() && (iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx)).isBizChildrenExist(unitInfo, "00000000-0000-0000-0000-0000000000044F2827FD")) {
                throw new OUException(OUException.PROFIT_BIZUNIT_CHILDREN);
            }
            partProfitInfo.setUnit(unitInfo);
            IFIAccountRange accountRange = FIAccountRangeFactory.getLocalInstance(ctx);
            CoreBaseCollection collection = (CoreBaseCollection)unitInfo.get("FIAccountRange");
            if (collection != null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("profitOrgUnitId.id", (Object)unitInfo.getId()));
                accountRange.delete(filter);
                accountRange.addnewBatchData(collection);
            }
            if ((iPartProfit = OUPartProfitCenterFactory.getLocalInstance(ctx)).exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                if (partProfitInfo.getId() == null) {
                    BOSUuid partID = iPartProfit.getOUPartProfitCenterInfo("Select id Where unit.id = '" + pk.toString() + "'").getId();
                    partProfitInfo.setId(partID);
                }
                iPartProfit.update((IObjectPK)new ObjectUuidPK(partProfitInfo.getId()), partProfitInfo);
            } else {
                if (!unitInfo.isIsCU() && !currentCUInfo.isIsProfitOrgUnit()) {
                    Object[] param = new Object[]{OrgType.ProfitCenter.getAlias(), OrgType.ProfitCenter.getAlias()};
                    throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
                }
                partProfitInfo.setVersionNumber(versionNumber);
                iPartProfit.addnew(partProfitInfo);
                unitInfo.setPartProfitCenter(partProfitInfo);
            }
        } else {
            IOUPartProfitCenter iPartProfit = OUPartProfitCenterFactory.getLocalInstance(ctx);
            if (iPartProfit.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                OUPartReference.isReferenced((Context)ctx, (String)new OUPartProfitCenterInfo().getBOSType().toString(), (String)pk.toString());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
                iPartProfit.delete(filter);
            }
            unitInfo.setPartProfitCenter(null);
        }
    }

    public void addNewInfo(Context ctx, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo) throws BOSException, EASBizException {
        if (unitInfo.isIsProfitOrgUnit()) {
            if (!unitInfo.isIsCU() && !currentCUInfo.isIsProfitOrgUnit()) {
                Object[] param = new Object[]{OrgType.ProfitCenter.getAlias(), OrgType.ProfitCenter.getAlias()};
                throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
            }
            OUPartProfitCenterInfo ouProfitInfo = unitInfo.getPartProfitCenter();
            ouProfitInfo.setUnit(unitInfo);
            ouProfitInfo.setVersionNumber(unitInfo.getVersionNumber());
            IOUPartProfitCenter iProfit = OUPartProfitCenterFactory.getLocalInstance(ctx);
            IObjectPK newPK = iProfit.addnew(ouProfitInfo);
            unitInfo.setPartProfitCenter(ouProfitInfo);
            CoreBaseCollection collection = (CoreBaseCollection)unitInfo.get("FIAccountRange");
            if (collection != null) {
                IFIAccountRange accountRange = FIAccountRangeFactory.getLocalInstance(ctx);
                accountRange.addnewBatchData(collection);
            }
        }
    }

    public void delOrgInfo(Context ctx, FullOrgUnitInfo deleteInfo) throws BOSException, EASBizException {
        if (deleteInfo.isIsProfitOrgUnit()) {
            INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
            if (iNOV.isBizChildrenExist(deleteInfo, "00000000-0000-0000-0000-0000000000044F2827FD")) {
                Object[] params = new String[]{OrgType.ProfitCenter.getAlias()};
                throw new OUException(OUException.EXISTCHILDREN_NOTDELETE, params);
            }
            ObjectStringPK pk = new ObjectStringPK(deleteInfo.getId().toString());
            OUPartReference.isReferenced((Context)ctx, (String)"6EF82F1C", (String)pk.toString());
            OUPartReference.isReferenced((Context)ctx, (String)"A70FCF6A", (String)pk.toString());
            IOUPartProfitCenter iProfit = OUPartProfitCenterFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iProfit.delete(filter);
        }
    }

    public String[] getRebuildSql() {
        StringBuffer sb = new StringBuffer(800);
        sb.append("insert into T_ORG_ProfitCenter (\n").append("FID,\n").append("FName_L1,\n").append("FName_L2,\n").append("FName_L3,\n").append("FNumber,\n").append("FDescription_L1,\n").append("FDescription_L2,\n").append("FDescription_L3,\n").append("FSimpleName,\n").append("FIsGrouping,\n").append("FEffectDate,\n").append("FInvalidDate,\n").append("FIsFreeze,\n").append("FIsCompanyOrgUnit,\n").append("FIsAdminOrgUnit,\n").append("FIsSaleOrgUnit,\n").append("FIsPurchaseOrgUnit,\n").append("FIsStorageOrgUnit,\n").append("FIsProfitOrgUnit,\n").append("FIsCostOrgUnit,\n").append("FIsCU,\n").append("FIsUnion,\n").append("FIsHROrgUnit,\n").append("FCreatorID,\n").append("FCreateTime,\n").append("FLastUpdateUserID,\n").append("FLastUpdateTime,\n").append("FControlUnitID,\n").append("FIsLeaf,\n").append("FLevel,\n").append("FLongNumber,\n").append("FParentID,\n").append("FLeader,\n").append("FAddressID,\n").append("FIsBizUnit,\n").append("FIsSealUp,\n").append("FIsStart,\n").append("FIsOUSealUp,\n").append("FDisplayName_L1,\n").append("FDisplayName_L2,\n").append("FDisplayName_L3,\n").append("FPropertySealUpDate,\n").append("FVersionNumber,\n").append("FCode,\n").append("FIsTransportOrgUnit,\n").append("forgTypeStr,\n").append("FBaseCurrencyID,\n").append("FPcAccountTableID,\n").append("FPcAccountPeriodID,\n").append("FIsQualityOrgUnit)\n").append("SELECT\n").append("ou.FID,\n").append("ou.FName_L1,\n").append("ou.FName_L2,\n").append("ou.FName_L3,\n").append("ou.FNumber,\n").append("ou.FDescription_L1,\n").append("ou.FDescription_L2,\n").append("ou.FDescription_L3,\n").append("ou.FSimpleName,\n").append("ou.FIsGrouping,\n").append("ou.FEffectDate,\n").append("ou.FInvalidDate,\n").append("ou.FIsFreeze,\n").append("ou.FIsCompanyOrgUnit,\n").append("ou.FIsAdminOrgUnit,\n").append("ou.FIsSaleOrgUnit,\n").append("ou.FIsPurchaseOrgUnit,\n").append("ou.FIsStorageOrgUnit,\n").append("ou.FIsProfitOrgUnit,\n").append("ou.FIsCostOrgUnit,\n").append("ou.FIsCU,\n").append("ou.FIsUnion,\n").append("ou.FIsHROrgUnit,\n").append("ou.FCreatorID,\n").append("ou.FCreateTime,\n").append("ou.FLastUpdateUserID,\n").append("ou.FLastUpdateTime,\n").append("ou.FControlUnitID,\n").append("stru.FIsLeaf,\n").append("stru.FLevel,\n").append("stru.FLongNumber,\n").append("stru1.FUnitId AS FParentID,\n").append("profit.FLeader,\n").append("profit.FAddressID,\n").append("profit.FIsBizUnit,\n").append("profit.FIsSealUp,\n").append("ou.FIsStart,\n").append("ou.FIsOUSealUp,\n").append("stru.FDisplayName_L1,\n").append("stru.FDisplayName_L2,\n").append("stru.FDisplayName_L3,\n").append("profit.FPropertySealUpDate,\n").append("ou.FVersionNumber,\n").append("ou.FCode,\n").append("ou.FIsTransportOrgUnit,\n").append("ou.forgTypeStr,\n").append("profit.FBaseCurrencyID,\n").append("profit.FPcAccountTableID,\n").append("profit.FPcAccountPeriodID,\n").append("ou.FIsQualityOrgUnit\n").append("FROM T_ORG_BaseUnit ou INNER JOIN\n").append("T_ORG_Structure stru ON ou.FID = stru.FUnitId LEFT OUTER JOIN\n").append("T_ORG_Structure stru1 ON stru.FParentID = stru1.FID INNER JOIN\n").append("T_ORG_OUPartProfitCenter profit ON ou.FID = profit.FUnitID\n").append("WHERE (stru.FTreeId = '00000000-0000-0000-0000-0000000000044F2827FD')\n");
        return new String[]{"delete from T_ORG_ProfitCenter", sb.toString()};
    }

    boolean valideOrg(IObjectValue orgValue) {
        ProfitCenterOrgUnitInfo profitInfo = (ProfitCenterOrgUnitInfo)orgValue;
        return !profitInfo.isIsSealUp() && profitInfo.isIsBizUnit();
    }

    public OrgTypeSelfInfo getOrgTypeSelfInfo() {
        OrgTypeSelfInfo orgInfo = new OrgTypeSelfInfo();
        orgInfo.setTableName("T_ORG_OUPartProfitCenter");
        orgInfo.setTableNameAlias("PtProfit");
        orgInfo.setViewTableName("T_ORG_ProfitCenter");
        orgInfo.setViewTableAlias("Profit");
        orgInfo.setTableNameHis("T_ORG_OUPartProfitCenter_his");
        orgInfo.setViewTableNameHis("T_ORG_ProfitCenter_his");
        orgInfo.setOrgViewBosType(new ProfitCenterOrgUnitInfo().getBOSType());
        orgInfo.setOrgTableBosType(new OUPartProfitCenterInfo().getBOSType());
        orgInfo.setOuPartInfo((OUPartCoreBaseInfo)new OUPartProfitCenterInfo());
        orgInfo.setOrgUnitViewInfo((OrgUnitInfo)new ProfitCenterOrgUnitInfo());
        orgInfo.setOrgType(OrgType.ProfitCenter);
        return orgInfo;
    }

    protected OrgUnitCollection _getProfitCenterOrgUnitVersionCollection(Context ctx, String versionNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_ProfitCenter_His WHERE FVersionNumber = '").append(versionNumber).append("'").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    protected OUPartProfitCenterCollection _getOUPartProfitCenterVersionCollection(Context ctx) throws BOSException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartProfitCenter_His").toString();
        try {
            OUPartProfitCenterCollection partProfitCenterVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            OUPartProfitCenterCollection oUPartProfitCenterCollection = partProfitCenterVersionCol = OrgAppProfitImpl.createOUPartProfitCenterVersionCollection(ctx, (ResultSet)rs);
            return oUPartProfitCenterCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public static OUPartProfitCenterInfo createOUPartProfitCenterVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String addressId;
        String leaderId;
        String versionNumber = rs.getString("FVersionNumber");
        String id = rs.getString("FID");
        OUPartProfitCenterInfo partProfitCenterVersionInfo = new OUPartProfitCenterInfo(versionNumber, BOSUuid.read((String)id));
        String unitId = rs.getString("FUnitID");
        if (unitId != null && unitId.trim().length() != 0) {
            FullOrgUnitInfo fullVersionInfo = new FullOrgUnitInfo(versionNumber, BOSUuid.read((String)unitId));
            partProfitCenterVersionInfo.setUnit(fullVersionInfo);
        }
        if ((leaderId = rs.getString("FLeader")) != null && leaderId.trim().length() != 0) {
            partProfitCenterVersionInfo.setLeader((PersonInfo)OrgHelper.getVO((Context)ctx, (String)leaderId));
        }
        if ((addressId = rs.getString("FAddressID")) != null && addressId.trim().length() != 0) {
            partProfitCenterVersionInfo.setAdress((AddressInfo)OrgHelper.getVO((Context)ctx, (String)addressId));
        }
        partProfitCenterVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        partProfitCenterVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        partProfitCenterVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return partProfitCenterVersionInfo;
    }

    public static OUPartProfitCenterCollection createOUPartProfitCenterVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OUPartProfitCenterCollection partProfitCenterVersionCol = new OUPartProfitCenterCollection();
        while (rs.next()) {
            OUPartProfitCenterInfo partProfitCenterVersionInfo = OrgAppProfitImpl.createOUPartProfitCenterVersionInfo(ctx, rs);
            partProfitCenterVersionCol.add(partProfitCenterVersionInfo);
        }
        return partProfitCenterVersionCol;
    }

    public static ProfitCenterOrgUnitInfo createProfitCenterOrgUnitVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String parentId;
        String addressId;
        ProfitCenterOrgUnitInfo profitCenterVersionInfo = (ProfitCenterOrgUnitInfo)OrgVersionServerUtils.createOrgUnitVersionInfo((Context)ctx, (OrgUnitInfo)new ProfitCenterOrgUnitInfo(), (ResultSet)rs);
        String versionNumber = profitCenterVersionInfo.getVersionNumber();
        String leaderId = rs.getString("FLeader");
        if (leaderId != null && leaderId.trim().length() != 0) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)leaderId));
            profitCenterVersionInfo.setLeader(personInfo);
        }
        if ((addressId = rs.getString("FAddressID")) != null && addressId.trim().length() != 0) {
            AddressInfo addressInfo = new AddressInfo();
            addressInfo.setId(BOSUuid.read((String)addressId));
            profitCenterVersionInfo.setAddress(addressInfo);
        }
        if ((parentId = rs.getString("FParentID")) != null && parentId.trim().length() != 0) {
            ProfitCenterOrgUnitInfo parentVersionInfo = new ProfitCenterOrgUnitInfo(versionNumber, BOSUuid.read((String)parentId));
            profitCenterVersionInfo.setParent(parentVersionInfo);
        }
        profitCenterVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        profitCenterVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        profitCenterVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return profitCenterVersionInfo;
    }

    public static OrgUnitCollection createProfitCenterOrgUnitVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OrgUnitCollection profitCenterVersionCol = new OrgUnitCollection();
        while (rs.next()) {
            ProfitCenterOrgUnitInfo profitCenterVersionInfo = OrgAppProfitImpl.createProfitCenterOrgUnitVersionInfo(ctx, rs);
            profitCenterVersionCol.add((OrgUnitInfo)profitCenterVersionInfo);
        }
        return profitCenterVersionCol;
    }

    public List getInsertHisDataSql() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("INSERT INTO T_ORG_OUPartProfitCenter_His(FID,FUnitID,FAddressID,FLeader,FIsSealUp,FIsBizUnit, FPropertySealUpDate,FVersionNumber) SELECT FID,FUnitID,FAddressID,FLeader,FIsSealUp,FIsBizUnit, FPropertySealUpDate,FVersionNumber FROM T_ORG_OUPartProfitCenter");
        retList.add("INSERT INTO T_ORG_ProfitCenter_His(FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FLeader, FAddressID, FIsBizUnit, FIsSealUp, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr) SELECT FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FLeader, FAddressID, FIsBizUnit, FIsSealUp, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr FROM T_ORG_ProfitCenter");
        return retList;
    }

    public List getOrgVersioningUpdateStmts(String inValidateStr, String versionNumber) {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add(new StringBuffer().append("UPDATE T_ORG_ProfitCenter_His SET FInvalidDate = {ts'").append(inValidateStr).append("'}").append(" WHERE FVersionNumber = '").append(versionNumber).append("'").toString());
        return retList;
    }

    public OrgUnitInfo createOrgUnitVersionInfo(String versionNumber, String id) {
        return new ProfitCenterOrgUnitInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadSuperiorHisOrgUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
        if (fullVersionInfo.isIsProfitOrgUnit()) {
            ProfitCenterOrgUnitInfo profitVersionInfo = (ProfitCenterOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(fullVersionInfo.getVersionNumber(), fullVersionInfo.getId()));
            if (profitVersionInfo == null) {
                throw new OUException(OUException.NONE_PROFIT_SUPERIOR);
            }
            ProfitCenterOrgUnitInfo info = profitVersionInfo.getParent();
            pdInfo.setParentOrg(OrgType.ProfitCenter, (OrgUnitInfo)((ProfitCenterOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(info.getVersionNumber(), info.getId()))));
        }
    }

    public CoreBaseInfo createOUPartOrgUnitVersionInfo(String versionNumber, String id) {
        return new OUPartProfitCenterInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadOUPartVersion(Context ctx, FullOrgUnitInfo fullVersionInfo, ResultSet rs) throws BOSException, EASBizException, SQLException {
        String versionNumber = fullVersionInfo.getVersionNumber();
        String partProfitCenterId = rs.getString("FPartProfitCenterID");
        if (partProfitCenterId != null && partProfitCenterId.trim().length() != 0) {
            OUPartProfitCenterInfo partProfitCenterVersionInfo = new OUPartProfitCenterInfo(versionNumber, BOSUuid.read((String)partProfitCenterId));
            fullVersionInfo.setPartProfitCenter(partProfitCenterVersionInfo);
        }
    }

    public OrgUnitInfo getUnitVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_ProfitCenter_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OrgUnitInfo orgUnitInfo = null;
                return orgUnitInfo;
            }
            ProfitCenterOrgUnitInfo profitCenterVersionInfo = OrgAppProfitImpl.createProfitCenterOrgUnitVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with pk: " + pk);
            }
            ProfitCenterOrgUnitInfo profitCenterOrgUnitInfo = profitCenterVersionInfo;
            return profitCenterOrgUnitInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, String versionNumber, String longNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        if (longNumber == null || longNumber.trim().length() == 0) {
            throw new BOSException("longNumber can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_ProfitCenter_His WHERE FVersionNumber = '").append(versionNumber).append("'").append(" AND (FLongNumber = '").append(longNumber).append("'").append(" OR FLongNumber LIKE '").append(longNumber + "!%").append("')").append(" ORDER BY FLongNumber").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    private OrgUnitCollection getOrgUnitVersionCollectionBySql(Context ctx, String sql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            OrgUnitCollection orgUnitCollection = OrgAppProfitImpl.createProfitCenterOrgUnitVersionCollection(ctx, (ResultSet)rs);
            return orgUnitCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, IObjectPK cuOrgPK, String versionNumber) throws BOSException, EASBizException {
        String tableName = this.getOrgTypeSelfInfo().getViewTableNameHis();
        String sql = "SELECT FID, FVersionNumber FROM " + tableName + " WHERE " + "FControlUnitID = '" + cuOrgPK + "' and forgTypeStr like '%" + this.getOrgTypeSelfInfo().getOrgType().getName() + "%' FVersionNumber = '" + versionNumber + "'";
        return this.getOrgUnitVersionCollectionBySql(ctx, sql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String selectSql) throws BOSException, EASBizException {
        if (selectSql == null) {
            throw new BOSException("selectSql can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OUPartCoreBaseInfo oUPartCoreBaseInfo = null;
                return oUPartCoreBaseInfo;
            }
            OUPartProfitCenterInfo partProfitCenterVersionInfo = OrgAppProfitImpl.createOUPartProfitCenterVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with selectSql: " + selectSql);
            }
            OUPartProfitCenterInfo oUPartProfitCenterInfo = partProfitCenterVersionInfo;
            return oUPartProfitCenterInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartProfitCenter_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String version, String orgId) throws BOSException, EASBizException {
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartProfitCenter_His WHERE ").append("FVersionNumber = '").append(version).append("'").append(" AND FUNITID = '").append(orgId).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public void batchDelOrgInfo(Context ctx, FullOrgUnitCollection unitCol) throws BOSException, EASBizException {
        for (int i = 0; i < unitCol.size(); ++i) {
            FullOrgUnitInfo unitInfo = unitCol.get(i);
            if (!unitInfo.isIsProfitOrgUnit()) {
                return;
            }
            Object[] params = new String[]{OrgType.ProfitCenter.getAlias(), OrgType.ProfitCenter.getAlias()};
            if (OrgAppHelper.isCUBizPropertyExistInOU((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)6)) {
                throw new OUException(OUException.EXISTINCU_NOTDELETE, params);
            }
            unitInfo.setIsProfitOrgUnit(false);
            ObjectStringPK pk = new ObjectStringPK(unitInfo.getId().toString());
            OUPartReference.delReferenced((Context)ctx, (String)"6EF82F1C", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getTableName());
            OUPartReference.delReferenced((Context)ctx, (String)"A70FCF6A", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getViewTableName());
            IOUPartProfitCenter iProfit = OUPartProfitCenterFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iProfit.delete(filter);
            unitInfo.setPartProfitCenter(null);
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
            orgTypeHelper.removeOrgType(OrgType.ProfitCenter);
            unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        }
    }
}

