/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper.orgtypeimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOUPartUnionGroup;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OUPartUnionGroupCollection;
import com.kingdee.eas.basedata.org.OUPartUnionGroupFactory;
import com.kingdee.eas.basedata.org.OUPartUnionGroupInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.UnionGroupOrgUnitCollection;
import com.kingdee.eas.basedata.org.UnionGroupOrgUnitInfo;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.app.OUPartReference;
import com.kingdee.eas.basedata.org.app.OrgVersionServerUtils;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.IOrgQueryInfo;
import com.kingdee.eas.basedata.org.app.helper.OrgDBHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.AbstractDefaultOrgTypeImpl;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.QueryUnionGroupInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgAppUnionGroupImpl
extends AbstractDefaultOrgTypeImpl
implements IOrgAppHelper {
    private static Logger logger = Logger.getLogger((String)OrgAppUnionGroupImpl.class.getName());

    public static UnionGroupOrgUnitCollection createUnionGroupOrgUnitVersionCollection(Context ctx, ResultSet rs) throws Exception {
        UnionGroupOrgUnitCollection unionGroupVersionCol = new UnionGroupOrgUnitCollection();
        while (rs.next()) {
            UnionGroupOrgUnitInfo unionGroupVersionInfo = OrgAppUnionGroupImpl.createUnionGroupOrgUnitVersionInfo(ctx, rs);
            unionGroupVersionCol.add(unionGroupVersionInfo);
        }
        return unionGroupVersionCol;
    }

    public static UnionGroupOrgUnitInfo createUnionGroupOrgUnitVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String stockControlCompanyId;
        UnionGroupOrgUnitInfo unionGroupVersionInfo = (UnionGroupOrgUnitInfo)OrgVersionServerUtils.createOrgUnitVersionInfo((Context)ctx, (OrgUnitInfo)new UnionGroupOrgUnitInfo(), (ResultSet)rs);
        String versionNumber = unionGroupVersionInfo.getVersionNumber();
        String parentId = rs.getString("FParentID");
        if (parentId != null && parentId.trim().length() != 0) {
            UnionGroupOrgUnitInfo parentVersionInfo = new UnionGroupOrgUnitInfo(versionNumber, BOSUuid.read((String)parentId));
            unionGroupVersionInfo.setParent(parentVersionInfo);
        }
        if ((stockControlCompanyId = rs.getString("FStockControlCompanyID")) != null && stockControlCompanyId.trim().length() != 0) {
            CompanyOrgUnitInfo stockCompanyInfo = new CompanyOrgUnitInfo(versionNumber, BOSUuid.read((String)stockControlCompanyId));
            unionGroupVersionInfo.setStockControlCompany(stockCompanyInfo);
        }
        return unionGroupVersionInfo;
    }

    public static OUPartUnionGroupInfo createOUPartUnionGroupVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String stockControlCompanyId;
        String versionNumber = rs.getString("FVersionNumber");
        String id = rs.getString("FID");
        OUPartUnionGroupInfo partUnionGroupVersionInfo = new OUPartUnionGroupInfo(versionNumber, BOSUuid.read((String)id));
        String unitId = rs.getString("FUnitID");
        if (unitId != null && unitId.trim().length() != 0) {
            FullOrgUnitInfo fullVersionInfo = new FullOrgUnitInfo(versionNumber, BOSUuid.read((String)unitId));
            partUnionGroupVersionInfo.setUnit(fullVersionInfo);
        }
        if ((stockControlCompanyId = rs.getString("FStockControlCompanyID")) != null && stockControlCompanyId.trim().length() != 0) {
            CompanyOrgUnitInfo stockCompanyInfo = new CompanyOrgUnitInfo(versionNumber, BOSUuid.read((String)stockControlCompanyId));
            partUnionGroupVersionInfo.setStockControlCompany(stockCompanyInfo);
        }
        return partUnionGroupVersionInfo;
    }

    public static OUPartUnionGroupCollection createOUPartUnionGroupVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OUPartUnionGroupCollection partUnionGroupVersionCol = new OUPartUnionGroupCollection();
        while (rs.next()) {
            OUPartUnionGroupInfo partUnionGroupVersionInfo = OrgAppUnionGroupImpl.createOUPartUnionGroupVersionInfo(ctx, rs);
            partUnionGroupVersionCol.add(partUnionGroupVersionInfo);
        }
        return partUnionGroupVersionCol;
    }

    public List getInsertHisDataSql() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("INSERT INTO T_ORG_OUPartUnionGroup_His(FID,FUnitID,FStockControlCompanyID,FVersionNumber) SELECT FID,FUnitID,FStockControlCompanyID,FVersionNumber FROM T_ORG_OUPartUnionGroup");
        retList.add("INSERT INTO T_ORG_UnionGroup_His(FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FStockControlCompanyID, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr) SELECT FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FStockControlCompanyID, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr FROM T_ORG_UnionGroup");
        return retList;
    }

    public List getOrgVersioningUpdateStmts(String inValidateStr, String versionNumber) {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add(new StringBuffer().append("UPDATE T_ORG_UnionGroup_His SET FInvalidDate = {ts'").append(inValidateStr).append("'}").append(" WHERE FVersionNumber = '").append(versionNumber).append("'").toString());
        return retList;
    }

    public OrgUnitInfo createOrgUnitVersionInfo(String versionNumber, String id) {
        return new UnionGroupOrgUnitInfo(versionNumber, BOSUuid.read((String)id));
    }

    protected UnionGroupOrgUnitCollection _getUnionGroupOrgUnitVersionCollection(Context ctx) throws BOSException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_UnionGroup_His").toString();
        try {
            UnionGroupOrgUnitCollection unionGroupVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            UnionGroupOrgUnitCollection unionGroupOrgUnitCollection = unionGroupVersionCol = OrgAppUnionGroupImpl.createUnionGroupOrgUnitVersionCollection(ctx, (ResultSet)rs);
            return unionGroupOrgUnitCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    protected OUPartUnionGroupCollection _getOUPartUnionGroupVersionCollection(Context ctx) throws BOSException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartUnionGroup_His").toString();
        try {
            OUPartUnionGroupCollection partUnionGroupVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            OUPartUnionGroupCollection oUPartUnionGroupCollection = partUnionGroupVersionCol = OrgAppUnionGroupImpl.createOUPartUnionGroupVersionCollection(ctx, (ResultSet)rs);
            return oUPartUnionGroupCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public void loadSuperiorHisOrgUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
    }

    public OrgTypeSelfInfo getOrgTypeSelfInfo() {
        OrgTypeSelfInfo orgInfo = new OrgTypeSelfInfo();
        orgInfo.setTableName("T_ORG_OUPartUnionGroup");
        orgInfo.setTableName("T_ORG_OUPartUnionGroup");
        orgInfo.setTableNameAlias("PtUnion");
        orgInfo.setViewTableName("T_ORG_UnionGroup");
        orgInfo.setViewTableAlias("Union");
        orgInfo.setOrgViewBosType(new UnionGroupOrgUnitInfo().getBOSType());
        orgInfo.setOrgTableBosType(new OUPartUnionGroupInfo().getBOSType());
        orgInfo.setOuPartInfo((OUPartCoreBaseInfo)new OUPartUnionGroupInfo());
        orgInfo.setOrgUnitViewInfo((OrgUnitInfo)new UnionGroupOrgUnitInfo());
        orgInfo.setIOrgQueryInfo((IOrgQueryInfo)new QueryUnionGroupInfo());
        orgInfo.setOrgType(OrgType.UnionDebt);
        return orgInfo;
    }

    private void checkStockControlCompany(Context ctx, String treeID, String unionGroupID, String comID) throws BOSException, EASBizException {
        OrgDBHelper.checkStockControlCompany((Context)ctx, (String)treeID, (String)unionGroupID, (String)comID);
    }

    private void checkNumberInUnionTree(Context ctx, boolean isNew, String unitId, String number, String treeId) throws BOSException, EASBizException {
        OrgDBHelper.checkNumberInUnionTree((Context)ctx, (boolean)isNew, (String)unitId, (String)number, (String)treeId);
    }

    public void addNewInfo(Context ctx, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo) throws BOSException, EASBizException {
        if (unitInfo.isIsUnion()) {
            String versionNumber = unitInfo.getVersionNumber();
            if (unitInfo.get("OrgTreeInfo") != null) {
                this.checkNumberInUnionTree(ctx, true, unitInfo.getId() == null ? null : unitInfo.getId().toString(), unitInfo.getNumber(), ((OrgTreeInfo)unitInfo.get("OrgTreeInfo")).getId().toString());
                IOrgStructure iStruct = OrgStructureFactory.getLocalInstance((Context)ctx);
                OrgStructureInfo structInfo = new OrgStructureInfo();
                if (unitInfo.get("ParentNode") != null) {
                    OrgStructureInfo structParent = (OrgStructureInfo)unitInfo.get("ParentNode");
                    structInfo.setParent(structParent);
                    FullOrgUnitInfo unitParent = structParent.getUnit();
                    unitInfo.setParent(unitParent);
                } else {
                    OrgStructureCollection structInfos = iStruct.getOrgStructureCollection("Select * Where parent is null and tree.id = '" + ((OrgTreeInfo)unitInfo.get("OrgTreeInfo")).getId().toString() + "'");
                    if (structInfos.size() != 0) {
                        throw new OUException(OUException.SAME_TREE_MUST_ONEPARENT);
                    }
                }
                structInfo.setUnit(unitInfo);
                structInfo.setTree((OrgTreeInfo)unitInfo.get("OrgTreeInfo"));
                IObjectPK pkGroup = iStruct.addnew((CoreBaseInfo)structInfo);
                OUPartUnionGroupInfo ouUnionGroupInfo = unitInfo.getPartUnionGroup();
                if (ouUnionGroupInfo.getStockControlCompany() != null) {
                    this.checkStockControlCompany(ctx, ((OrgTreeInfo)unitInfo.get("OrgTreeInfo")).getId().toString(), null, ouUnionGroupInfo.getStockControlCompany().getId().toString());
                }
                ouUnionGroupInfo.setUnit(unitInfo);
                ouUnionGroupInfo.setVersionNumber(versionNumber);
                IOUPartUnionGroup iUnionGroup = OUPartUnionGroupFactory.getLocalInstance(ctx);
                IObjectPK oupartGroupPK = iUnionGroup.addnew(ouUnionGroupInfo);
                ouUnionGroupInfo.setId(BOSUuid.read((String)oupartGroupPK.toString()));
                unitInfo.setPartUnionGroup(ouUnionGroupInfo);
                if (ouUnionGroupInfo.getStockControlCompany() != null) {
                    OrgStructureInfo sccInfo = new OrgStructureInfo();
                    OrgStructureInfo sccParent = iStruct.getOrgStructureInfo(pkGroup);
                    sccInfo.setParent(sccParent);
                    sccInfo.setTree((OrgTreeInfo)unitInfo.get("OrgTreeInfo"));
                    sccInfo.setUnit(ouUnionGroupInfo.getStockControlCompany().castToFullOrgUnitInfo());
                    sccInfo.setIsValid(true);
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)sccInfo.getTree().getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)sccInfo.getUnit().getId().toString()));
                    filter.setMaskString("#0 and #1");
                    if (!iStruct.exists(filter)) {
                        iStruct.addnew((CoreBaseInfo)sccInfo);
                    }
                }
            } else {
                throw new OUException(OUException.MUET_SELECT_UNIONTREE);
            }
        }
    }

    public void delOrgInfo(Context ctx, FullOrgUnitInfo deleteInfo) throws BOSException, EASBizException {
        IOUPartUnionGroup iUnionGroup = OUPartUnionGroupFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        String deleteInfoId = deleteInfo.getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)deleteInfoId));
        OUPartReference.isReferenced((Context)ctx, (String)"F3C0FFAE", (String)deleteInfoId);
        OUPartReference.isReferenced((Context)ctx, (String)"8A016913", (String)deleteInfoId);
        iUnionGroup.delete(filter);
    }

    public String[] getRebuildSql() {
        StringBuffer sb = new StringBuffer(800);
        sb.append("insert into T_ORG_UnionGroup (\n").append("FID,\n").append("FName_L1,\n").append("FName_L2,\n").append("FName_L3,\n").append("FNumber,\n").append("FDescription_L1,\n").append("FDescription_L2,\n").append("FDescription_L3,\n").append("FSimpleName,\n").append("FIsGrouping,\n").append("FEffectDate,\n").append("FInvalidDate,\n").append("FIsFreeze,\n").append("FIsCompanyOrgUnit,\n").append("FIsAdminOrgUnit,\n").append("FIsSaleOrgUnit,\n").append("FIsPurchaseOrgUnit,\n").append("FIsStorageOrgUnit,\n").append("FIsProfitOrgUnit,\n").append("FIsCostOrgUnit,\n").append("FIsCU,\n").append("FIsUnion,\n").append("FIsHROrgUnit,\n").append("FCreatorID,\n").append("FCreateTime,\n").append("FLastUpdateUserID,\n").append("FLastUpdateTime,\n").append("FControlUnitID,\n").append("FIsLeaf,\n").append("FLevel,\n").append("FLongNumber,\n").append("FParentID,\n").append("FStockControlCompanyID,\n").append("FIsStart,\n").append("FIsOUSealUp,\n").append("FDisplayName_L1,\n").append("FDisplayName_L2,\n").append("FDisplayName_L3,\n").append("FVersionNumber,\n").append("FCode,\n").append("FIsTransportOrgUnit,\n").append("FIsQualityOrgUnit)\n").append("SELECT\n").append("ou.FID,\n").append("ou.FName_L1,\n").append("ou.FName_L2,\n").append("ou.FName_L3,\n").append("ou.FNumber,\n").append("ou.FDescription_L1,\n").append("ou.FDescription_L2,\n").append("ou.FDescription_L3,\n").append("ou.FSimpleName,\n").append("ou.FIsGrouping,\n").append("ou.FEffectDate,\n").append("ou.FInvalidDate,\n").append("ou.FIsFreeze,\n").append("ou.FIsCompanyOrgUnit,\n").append("ou.FIsAdminOrgUnit,\n").append("ou.FIsSaleOrgUnit,\n").append("ou.FIsPurchaseOrgUnit,\n").append("ou.FIsStorageOrgUnit,\n").append("ou.FIsProfitOrgUnit,\n").append("ou.FIsCostOrgUnit,\n").append("ou.FIsCU,\n").append("ou.FIsUnion,\n").append("ou.FIsHROrgUnit,\n").append("ou.FCreatorID,\n").append("ou.FCreateTime,\n").append("ou.FLastUpdateUserID,\n").append("ou.FLastUpdateTime,\n").append("ou.FControlUnitID,\n").append("stru.FIsLeaf,\n").append("stru.FLevel,\n").append("stru.FLongNumber,\n").append("stru1.FUnitId AS FParentID,\n").append("ugroup.FStockControlCompanyID,\n").append("ou.FIsStart,\n").append("ou.FIsOUSealUp,\n").append("stru.FDisplayName_L1,\n").append("stru.FDisplayName_L2,\n").append("stru.FDisplayName_L3,\n").append("ou.FVersionNumber,\n").append("ou.FCode,\n").append("ou.FIsTransportOrgUnit,\n").append("ou.FIsQualityOrgUnit\n").append("FROM T_ORG_BaseUnit ou INNER JOIN\n").append("T_ORG_Structure stru ON ou.FID = stru.FUnitId LEFT OUTER JOIN\n").append("T_ORG_Structure stru1 ON stru.FParentID = stru1.FID INNER JOIN\n").append("T_ORG_OUPartUnionGroup ugroup ON ou.FID = ugroup.FUnitID\n");
        return new String[]{"delete from T_ORG_UnionGroup", sb.toString()};
    }

    public void loadOUPartVersion(Context ctx, FullOrgUnitInfo fullVersionInfo, ResultSet rs) throws BOSException, EASBizException, SQLException {
        String versionNumber = fullVersionInfo.getVersionNumber();
        String partUnionGroupId = rs.getString("FPartUnionGroupID");
        if (partUnionGroupId != null && partUnionGroupId.trim().length() != 0) {
            OUPartUnionGroupInfo partUnionGroupVersionInfo = new OUPartUnionGroupInfo(versionNumber, BOSUuid.read((String)partUnionGroupId));
            fullVersionInfo.setPartUnionGroup(partUnionGroupVersionInfo);
        }
    }

    public void updateOrgInfo(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo, String versionNumber, boolean isOrgStart) throws BOSException, EASBizException {
        OUPartUnionGroupInfo ouUnionGroupInfo;
        if (unitInfo.get("OrgTreeInfo") != null) {
            OrgDBHelper.checkNumberInUnionTree((Context)ctx, (boolean)false, (String)(unitInfo.getId() == null ? null : unitInfo.getId().toString()), (String)unitInfo.getNumber(), (String)((OrgTreeInfo)unitInfo.get("OrgTreeInfo")).getId().toString());
        }
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance((Context)ctx);
        OrgStructureInfo structInfo = null;
        if (unitInfo.get("ParentNode") != null) {
            structInfo = (OrgStructureInfo)unitInfo.get("ParentNode");
            structInfo.setUnit(unitInfo);
            iStruct.update((IObjectPK)new ObjectUuidPK(structInfo.getId()), (CoreBaseInfo)structInfo);
        }
        if ((ouUnionGroupInfo = unitInfo.getPartUnionGroup()) == null) {
            logger.info((Object)" ouUnionGroupInfo is null");
            return;
        }
        if (ouUnionGroupInfo.getStockControlCompany() != null) {
            OrgDBHelper.checkStockControlCompany((Context)ctx, (String)((OrgTreeInfo)unitInfo.get("OrgTreeInfo")).getId().toString(), (String)unitInfo.getId().toString(), (String)ouUnionGroupInfo.getStockControlCompany().getId().toString());
        }
        ouUnionGroupInfo.setUnit(unitInfo);
        IOUPartUnionGroup iUnionGroup = OUPartUnionGroupFactory.getLocalInstance(ctx);
        iUnionGroup.update((IObjectPK)new ObjectUuidPK(ouUnionGroupInfo.getId()), ouUnionGroupInfo);
        if (ouUnionGroupInfo.getStockControlCompany() != null) {
            OrgStructureInfo sccInfo = new OrgStructureInfo();
            sccInfo.setParent(structInfo);
            sccInfo.setTree((OrgTreeInfo)unitInfo.get("OrgTreeInfo"));
            sccInfo.setUnit(ouUnionGroupInfo.getStockControlCompany().castToFullOrgUnitInfo());
            sccInfo.setIsValid(true);
            FilterInfo fil = new FilterInfo();
            fil.getFilterItems().add(new FilterItemInfo("tree.id", (Object)sccInfo.getTree().getId().toString()));
            fil.getFilterItems().add(new FilterItemInfo("unit.id", (Object)sccInfo.getUnit().getId().toString()));
            fil.setMaskString("#0 and #1");
            if (!iStruct.exists(fil)) {
                iStruct.addnew((CoreBaseInfo)sccInfo);
            }
        }
    }

    public CoreBaseInfo createOUPartOrgUnitVersionInfo(String versionNumber, String id) {
        return null;
    }

    public OrgUnitInfo getUnitVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_UnionGroup_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OrgUnitInfo orgUnitInfo = null;
                return orgUnitInfo;
            }
            UnionGroupOrgUnitInfo unionGroupVersionInfo = OrgAppUnionGroupImpl.createUnionGroupOrgUnitVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with pk: " + pk);
            }
            UnionGroupOrgUnitInfo unionGroupOrgUnitInfo = unionGroupVersionInfo;
            return unionGroupOrgUnitInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, String versionNumber, String longNumber) throws BOSException, EASBizException {
        return null;
    }

    private OrgUnitCollection getOrgUnitVersionCollectionBySql(Context ctx, String sql) throws BOSException, EASBizException {
        return null;
    }

    public Map getLeftJoinSimpleFiledDefaultByList() {
        HashMap<String, String> filedList = new HashMap<String, String>();
        filedList.put("versionNumber", String.class.getName());
        return filedList;
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, IObjectPK cuOrgPK, String versionNumber) throws BOSException, EASBizException {
        String tableName = this.getOrgTypeSelfInfo().getViewTableNameHis();
        String sql = "SELECT FID, FVersionNumber FROM " + tableName + " WHERE " + "FControlUnitID = '" + cuOrgPK + "' and forgTypeStr like '%" + this.getOrgTypeSelfInfo().getOrgType().getName() + "%' FVersionNumber = '" + versionNumber + "'";
        return this.getOrgUnitVersionCollectionBySql(ctx, sql);
    }

    private OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String selectSql) throws BOSException, EASBizException {
        if (selectSql == null) {
            throw new BOSException("selectSql can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OUPartCoreBaseInfo oUPartCoreBaseInfo = null;
                return oUPartCoreBaseInfo;
            }
            OUPartUnionGroupInfo partUnionGrouplVersionInfo = OrgAppUnionGroupImpl.createOUPartUnionGroupVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with selectSql: " + selectSql);
            }
            OUPartUnionGroupInfo oUPartUnionGroupInfo = partUnionGrouplVersionInfo;
            return oUPartUnionGroupInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartUnionGroup_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String version, String orgId) throws BOSException, EASBizException {
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartUnionGroup_His WHERE ").append("FVersionNumber = '").append(version).append("'").append(" AND FUNITID = '").append(orgId).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getErrDataList(Context ctx) throws BOSException, EASBizException {
        int bsPos;
        int i;
        String[][] baseUnitArray;
        Map mBaseUnitIdPos;
        ArrayList<String> errDataList = new ArrayList<String>();
        String viewTableName = this.getOrgTypeSelfInfo().getViewTableName();
        String ouPartTableName = this.getOrgTypeSelfInfo().getTableName();
        String sqlOupart = "select fid,funitid,fversionnumber from " + ouPartTableName;
        String sqlView = "select fid,fparentid,fisleaf,flevel,fnumber,flongnumber,fversionnumber ,fisgrouping,fisunion,forgtypestr from " + viewTableName;
        String sqlTree = "select fid,fnumber,fisversioned from t_org_tree where ftype = 8";
        HashMap mTreeIdPos = new HashMap();
        String[][] treeArray = this.getFieldArray(ctx, sqlTree, mTreeIdPos);
        int IFid_TR = 0;
        boolean IFnumber_TR = true;
        int IFisVersioned_TR = 2;
        String treeIds = StringUtil.arrayToString((Object[])treeArray[IFid_TR], (String)"','");
        String sqlStructure = "select  fid,fparentid,fisleaf,flevel,flongnumber,funitid from t_org_structure where ftreeid in ('" + treeIds + "')";
        String sqlBaseUnit = "select  fid,fParentId,fIsleaf,fLevel,fNumber,fLongnumber,fVersionNumber from t_org_baseunit";
        if (!this.lock.isLocked()) {
            this.lock.lock();
            try {
                if (this.orgDataCheckerHelper.getmBaseUnitIdPos() == null) {
                    mBaseUnitIdPos = new HashMap();
                    baseUnitArray = this.getFieldArray(ctx, sqlBaseUnit, mBaseUnitIdPos);
                    this.orgDataCheckerHelper.setmBaseUnitIdPos(mBaseUnitIdPos);
                    this.orgDataCheckerHelper.setBaseUnitArray(baseUnitArray);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        mBaseUnitIdPos = null;
        baseUnitArray = null;
        boolean IFid_BU = false;
        boolean IFparentId_BU = true;
        int IFisleaf_BU = 2;
        int IFlevel_BU = 3;
        int IFnumber_BU = 4;
        int IFlongnumber_BU = 5;
        int IFversionNumber_BU = 6;
        mBaseUnitIdPos = this.orgDataCheckerHelper.getmBaseUnitIdPos();
        baseUnitArray = this.orgDataCheckerHelper.getBaseUnitArray();
        HashMap mStructureIdPos = new HashMap();
        String[][] structureArray = this.getFieldArray(ctx, sqlStructure, mStructureIdPos);
        boolean IFid_ST = false;
        int IFparentId_ST = 1;
        int IFisleaf_ST = 2;
        int IFlevel_ST = 3;
        int IFlongnumber_ST = 4;
        int IFunitid_ST = 5;
        HashMap<String, Integer> mStructureUnitIdPos = new HashMap<String, Integer>();
        int size = structureArray[0].length;
        for (int i2 = 0; i2 < size; ++i2) {
            mStructureUnitIdPos.put(structureArray[IFunitid_ST][i2], i2);
        }
        this.orgDataCheckerHelper.setmStructureIdPos(mStructureIdPos);
        this.orgDataCheckerHelper.setStructureArray(structureArray);
        this.orgDataCheckerHelper.setmStructureUnitIdPos(mStructureUnitIdPos);
        HashMap mOuPartIdPos = new HashMap();
        String[][] oupartArray = this.getFieldArray(ctx, sqlOupart, mOuPartIdPos);
        int IFid_OUP = 0;
        int IFunitId_OUP = 1;
        int IFversionNumber_OUP = 2;
        this.orgDataCheckerHelper.setmOuPartIdPos(mOuPartIdPos);
        this.orgDataCheckerHelper.setOupartArray(oupartArray);
        HashMap mViewIdPos = new HashMap();
        String[][] viewArray = this.getFieldArray(ctx, sqlView, mViewIdPos);
        int IFid_VI = 0;
        int IFparentId_VI = 1;
        int IFisleaf_VI = 2;
        int IFlevel_VI = 3;
        int IFnumber_VI = 4;
        int IFlongnumber_VI = 5;
        int IFversionNumber_VI = 6;
        this.orgDataCheckerHelper.setmViewIdPos(mViewIdPos);
        this.orgDataCheckerHelper.setViewArray(viewArray);
        int size2 = oupartArray.length;
        for (i = 0; i < size2; ++i) {
            if (mBaseUnitIdPos.get(this.getTbFieldbyIndex(ouPartTableName, "funitid", i)) == null) {
                this.addErrData(errDataList, ouPartTableName, oupartArray[IFid_OUP][i], "funitid=" + oupartArray[IFunitId_OUP][i], "funitid\u5e76\u6ca1\u6709\u5bf9\u5e94\u7684t_org_baseunit\u6570\u636e");
                continue;
            }
            bsPos = (Integer)mBaseUnitIdPos.get(oupartArray[IFunitId_OUP][i]);
            if (oupartArray[IFversionNumber_OUP][i].equals(baseUnitArray[IFversionNumber_BU][bsPos])) continue;
            this.addErrData(errDataList, ouPartTableName, oupartArray[IFid_OUP][i], "fversionNumber=" + oupartArray[IFversionNumber_OUP][i], "\u4e0et_org_baseunit\u7684\u7248\u672c\u53f7\u4e0d\u4e00\u81f4");
        }
        size2 = viewArray.length;
        for (i = 0; i < size2; ++i) {
            if (mBaseUnitIdPos.get(viewArray[IFid_VI][i]) == null) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fid=" + viewArray[IFid_VI][i], "t_org_baseunit\u6ca1\u6709\u8be5ID\u7684\u7ec4\u7ec7\u6570\u636e");
                continue;
            }
            if (mStructureUnitIdPos.get(viewArray[IFid_VI][i]) == null) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fid=" + viewArray[IFid_VI][i], "t_org_structure\u6ca1\u6709\u8be5\u7ec4\u7ec7\u4e1a\u52a1\u89c6\u56fe\u6570\u636e");
                continue;
            }
            bsPos = (Integer)mBaseUnitIdPos.get(viewArray[IFid_VI][i]);
            if (!viewArray[IFversionNumber_VI][i].equals(baseUnitArray[IFversionNumber_BU][bsPos])) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fversionNumber=" + viewArray[IFversionNumber_VI][i], "\u4e0et_org_baseunit\u7684\u7248\u672c\u53f7\u4e0d\u4e00\u81f4");
                continue;
            }
            int stPos = (Integer)mStructureUnitIdPos.get(viewArray[IFid_VI][i]);
            if (viewArray[IFparentId_VI][i] != null && structureArray[IFparentId_ST][stPos] != null) {
                if (mStructureUnitIdPos.get(structureArray[IFparentId_ST][stPos]) == null) {
                    this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fparentid=" + viewArray[IFparentId_VI][i], "\u4e0et_org_structure\u5bf9\u5e94\u8bb0\u5f55\u7684parentID\u4e0d\u4e00\u81f4");
                    continue;
                }
                int stParPos = (Integer)mStructureUnitIdPos.get(structureArray[IFparentId_ST][stPos]);
                if (!structureArray[IFunitid_ST][stParPos].equals(viewArray[IFparentId_VI][i])) {
                    this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fparentid=" + viewArray[IFparentId_VI][i], "\u4e0et_org_structure\u5bf9\u5e94\u8bb0\u5f55\u7684parentID\u4e0d\u4e00\u81f4");
                    continue;
                }
            } else if (viewArray[IFparentId_VI][i] != null || structureArray[IFparentId_ST][stPos] != null) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fparentid=" + viewArray[IFparentId_VI][i], "\u4e0et_org_structure\u5bf9\u5e94\u8bb0\u5f55\u7684parentID\u4e0d\u4e00\u81f4");
                continue;
            }
            if (!viewArray[IFisleaf_VI][i].equals(structureArray[IFisleaf_ST][stPos])) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fisleaf=" + viewArray[IFisleaf_VI][i], "\u4e0et_org_structure\u5bf9\u5e94\u8bb0\u5f55\u7684isleaf\u4e0d\u4e00\u81f4");
                continue;
            }
            if (!viewArray[IFlevel_VI][i].equals(structureArray[IFlevel_ST][stPos])) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "flevel=" + viewArray[IFlevel_VI][i], "\u4e0et_org_structure\u5bf9\u5e94\u8bb0\u5f55\u7684level\u4e0d\u4e00\u81f4");
                continue;
            }
            if (!viewArray[IFnumber_VI][i].equals(baseUnitArray[IFnumber_BU][bsPos])) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fnumber=" + viewArray[IFnumber_VI][i], "\u4e0et_org_baseunit\u5bf9\u5e94\u8bb0\u5f55\u7684number\u4e0d\u4e00\u81f4");
                continue;
            }
            if (!viewArray[IFlongnumber_VI][i].equals(structureArray[IFlongnumber_ST][stPos])) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "flongnumber=" + viewArray[IFlongnumber_VI][i], "\u4e0et_org_structure\u5bf9\u5e94\u8bb0\u5f55\u7684longnumber\u4e0d\u4e00\u81f4");
                continue;
            }
            if (!"1".equalsIgnoreCase(this.getTbFieldbyIndex(viewTableName, "fisgrouping", i))) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fisgrouping=" + this.getTbFieldbyIndex(viewTableName, "fisgrouping", i), "\u5408\u5e76\u8303\u56f4\u5185\u90e8\u7684\u5408\u5e76\u5355\u5143\u7ec4fisgrouping\u5b57\u6bb5\u5fc5\u987b\u662f1");
                continue;
            }
            if (!"1".equalsIgnoreCase(this.getTbFieldbyIndex(viewTableName, "fisunion", i))) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fisunion=" + this.getTbFieldbyIndex(viewTableName, "fisunion", i), "\u5408\u5e76\u8303\u56f4\u5185\u90e8\u7684\u5408\u5e76\u5355\u5143\u7ec4fisunion\u5b57\u6bb5\u5fc5\u987b\u662f1");
                continue;
            }
            if (";;UnionDebt;".equalsIgnoreCase(this.getTbFieldbyIndex(viewTableName, "forgtypestr", i))) continue;
            this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "forgtypestr=" + this.getTbFieldbyIndex(viewTableName, "forgtypestr", i), "\u5408\u5e76\u8303\u56f4\u5185\u90e8\u7684\u5408\u5e76\u5355\u5143\u7ec4forgtypestr\u5b57\u6bb5\u5fc5\u987b\u662f';;UnionDebt;'");
        }
        return errDataList;
    }

    public OrgStructureInfo getOrgStructureInfo(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        if (unitInfo == null) {
            throw new BOSException("unit can't be null");
        }
        OrgStructureInfo stureInfo = new OrgStructureInfo();
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unitInfo.getId()));
        viewInfo.setFilter(filterInfo);
        OrgStructureCollection structureCol = iStruct.getOrgStructureCollection(viewInfo);
        if (structureCol != null && structureCol.size() > 0) {
            stureInfo = structureCol.get(0);
        }
        return stureInfo;
    }
}

